/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ConformanceConfig;
import com.google.javascript.jscomp.ConformanceRules;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Requirement;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.HashMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.protobuf.Descriptors;
import com.google.javascript.jscomp.jarjar.com.google.protobuf.TextFormat;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

@GwtIncompatible(value="com.google.javascript.jscomp.jarjar.com.google.protobuf")
public final class CheckConformance
implements NodeTraversal.Callback,
CompilerPass {
    static final DiagnosticType CONFORMANCE_ERROR = DiagnosticType.error("JSC_CONFORMANCE_ERROR", "Violation: {0}{1}{2}");
    static final DiagnosticType CONFORMANCE_VIOLATION = DiagnosticType.warning("JSC_CONFORMANCE_VIOLATION", "Violation: {0}{1}{2}");
    static final DiagnosticType CONFORMANCE_POSSIBLE_VIOLATION = DiagnosticType.warning("JSC_CONFORMANCE_POSSIBLE_VIOLATION", "Possible violation: {0}{1}{2}");
    static final DiagnosticType INVALID_REQUIREMENT_SPEC = DiagnosticType.error("JSC_INVALID_REQUIREMENT_SPEC", "Invalid requirement. Reason: {0}\nRequirement spec:\n{1}");
    private final AbstractCompiler compiler;
    private final ImmutableList<Category> categories;
    private static final ImmutableSet<String> EXTENDABLE_FIELDS = ImmutableSet.of("config_file", "extends", "only_apply_to", "only_apply_to_regexp", "whitelist", "whitelist_regexp", new String[]{"allowlist", "allowlist_regexp", "value"});

    CheckConformance(AbstractCompiler compiler, ImmutableList<ConformanceConfig> configs) {
        this.compiler = compiler;
        this.categories = CheckConformance.initRules(compiler, configs);
    }

    @Override
    public void process(Node externs, Node root) {
        if (!this.categories.isEmpty()) {
            NodeTraversal.traverseRoots(this.compiler, this, externs, root);
        }
    }

    @Override
    public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return !n.isScript() || !t.getInput().getSourceFile().isExtern();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        for (int c = this.categories.size() - 1; c >= 0; --c) {
            Category category = (Category)this.categories.get(c);
            if (!category.precondition.shouldCheck(n)) continue;
            for (int r = category.rules.size() - 1; r >= 0; --r) {
                ((Rule)category.rules.get(r)).check(t, n);
            }
        }
    }

    private static ImmutableList<Category> initRules(AbstractCompiler compiler, ImmutableList<ConformanceConfig> configs) {
        HashMultimap builder = HashMultimap.create();
        List<Requirement> requirements = CheckConformance.mergeRequirements(compiler, configs);
        for (Requirement requirement : requirements) {
            Rule rule = CheckConformance.initRule(compiler, requirement);
            if (rule == null) continue;
            builder.put(rule.getPrecondition(), rule);
        }
        return builder.asMap().entrySet().stream().map(e -> new Category((Precondition)e.getKey(), ImmutableList.copyOf((Collection)e.getValue()))).collect(ImmutableList.toImmutableList());
    }

    static List<Requirement> mergeRequirements(AbstractCompiler compiler, List<ConformanceConfig> configs) {
        ArrayList<Requirement.Builder> builders = new ArrayList<Requirement.Builder>();
        HashMap<String, Requirement.Builder> extendable = new HashMap<String, Requirement.Builder>();
        for (ConformanceConfig config : configs) {
            for (Requirement requirement : config.getRequirementList()) {
                Requirement.Builder builder = requirement.toBuilder();
                if (requirement.hasRuleId()) {
                    if (requirement.getRuleId().isEmpty()) {
                        CheckConformance.reportInvalidRequirement(compiler, requirement, "empty rule_id");
                        continue;
                    }
                    if (extendable.containsKey(requirement.getRuleId())) {
                        CheckConformance.reportInvalidRequirement(compiler, requirement, "two requirements with the same rule_id: " + requirement.getRuleId());
                        continue;
                    }
                    extendable.put(requirement.getRuleId(), builder);
                }
                if (requirement.hasExtends()) continue;
                builders.add(builder);
            }
        }
        for (ConformanceConfig config : configs) {
            for (Requirement requirement : config.getRequirementList()) {
                if (!requirement.hasExtends()) continue;
                Requirement.Builder existing = (Requirement.Builder)extendable.get(requirement.getExtends());
                if (existing == null) {
                    CheckConformance.reportInvalidRequirement(compiler, requirement, "no requirement with rule_id: " + requirement.getExtends());
                    continue;
                }
                for (Descriptors.FieldDescriptor field : requirement.getAllFields().keySet()) {
                    if (EXTENDABLE_FIELDS.contains(field.getName())) continue;
                    CheckConformance.reportInvalidRequirement(compiler, requirement, "extending rules allow only " + EXTENDABLE_FIELDS);
                }
                if (requirement.getValueCount() > 0 && !existing.getAllowExtendingValue()) {
                    CheckConformance.reportInvalidRequirement(compiler, requirement, "extending rule may not specify 'value' if base rule does not allow it");
                }
                existing.addAllWhitelist(requirement.getWhitelistList()).addAllWhitelistRegexp(requirement.getWhitelistRegexpList()).addAllAllowlist(requirement.getAllowlistList()).addAllAllowlistRegexp(requirement.getAllowlistRegexpList()).addAllOnlyApplyTo(requirement.getOnlyApplyToList()).addAllOnlyApplyToRegexp(requirement.getOnlyApplyToRegexpList()).addAllWhitelistEntry(requirement.getWhitelistEntryList()).addAllAllowlistEntry(requirement.getAllowlistEntryList()).addAllValue(requirement.getValueList()).addAllConfigFile(requirement.getConfigFileList());
            }
        }
        ArrayList<Requirement> requirements = new ArrayList<Requirement>(builders.size());
        for (Requirement.Builder builder : builders) {
            CheckConformance.removeDuplicates(builder);
            requirements.add(builder.build());
        }
        return requirements;
    }

    private static void removeDuplicates(Requirement.Builder requirement) {
        ImmutableSet<String> list1 = ImmutableSet.copyOf(requirement.getWhitelistList());
        requirement.clearWhitelist().addAllWhitelist(list1);
        ImmutableSet<String> allowlist = ImmutableSet.copyOf(requirement.getAllowlistList());
        requirement.clearAllowlist().addAllAllowlist(allowlist);
        ImmutableSet<String> list2 = ImmutableSet.copyOf(requirement.getWhitelistRegexpList());
        requirement.clearWhitelistRegexp().addAllWhitelistRegexp(list2);
        ImmutableSet<String> allowlistRegexp = ImmutableSet.copyOf(requirement.getAllowlistRegexpList());
        requirement.clearAllowlistRegexp().addAllAllowlistRegexp(allowlistRegexp);
        ImmutableSet<String> list3 = ImmutableSet.copyOf(requirement.getOnlyApplyToList());
        requirement.clearOnlyApplyTo().addAllOnlyApplyTo(list3);
        ImmutableSet<String> list4 = ImmutableSet.copyOf(requirement.getOnlyApplyToRegexpList());
        requirement.clearOnlyApplyToRegexp().addAllOnlyApplyToRegexp(list4);
    }

    private static Rule initRule(AbstractCompiler compiler, Requirement requirement) {
        try {
            switch (requirement.getType()) {
                case CUSTOM: {
                    return new ConformanceRules.CustomRuleProxy(compiler, requirement);
                }
                case NO_OP: {
                    return new ConformanceRules.NoOp(compiler, requirement);
                }
                case BANNED_CODE_PATTERN: {
                    return new ConformanceRules.BannedCodePattern(compiler, requirement);
                }
                case BANNED_DEPENDENCY: {
                    return new ConformanceRules.BannedDependency(compiler, requirement);
                }
                case BANNED_DEPENDENCY_REGEX: {
                    return new ConformanceRules.BannedDependencyRegex(compiler, requirement);
                }
                case BANNED_ENHANCE: {
                    return new ConformanceRules.BannedEnhance(compiler, requirement);
                }
                case BANNED_NAME: 
                case BANNED_NAME_CALL: {
                    return new ConformanceRules.BannedName(compiler, requirement);
                }
                case BANNED_PROPERTY: 
                case BANNED_PROPERTY_READ: 
                case BANNED_PROPERTY_WRITE: 
                case BANNED_PROPERTY_NON_CONSTANT_WRITE: 
                case BANNED_PROPERTY_CALL: {
                    return new ConformanceRules.BannedProperty(compiler, requirement);
                }
                case RESTRICTED_NAME_CALL: {
                    return new ConformanceRules.RestrictedNameCall(compiler, requirement);
                }
                case RESTRICTED_METHOD_CALL: {
                    return new ConformanceRules.RestrictedMethodCall(compiler, requirement);
                }
                case RESTRICTED_PROPERTY_WRITE: {
                    return new ConformanceRules.RestrictedPropertyWrite(compiler, requirement);
                }
            }
            CheckConformance.reportInvalidRequirement(compiler, requirement, "unknown requirement type");
            return null;
        }
        catch (InvalidRequirementSpec e) {
            CheckConformance.reportInvalidRequirement(compiler, requirement, e.getMessage());
            return null;
        }
    }

    private static void reportInvalidRequirement(AbstractCompiler compiler, Requirement requirement, String reason) {
        compiler.report(JSError.make(INVALID_REQUIREMENT_SPEC, reason, TextFormat.printToString(requirement)));
    }

    public static class InvalidRequirementSpec
    extends Exception {
        InvalidRequirementSpec(String message) {
            super(message);
        }

        InvalidRequirementSpec(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static final class Category {
        final Precondition precondition;
        final ImmutableList<Rule> rules;

        Category(Precondition precondition, ImmutableList<Rule> rules) {
            this.precondition = precondition;
            this.rules = rules;
        }
    }

    public static interface Precondition {
        public static final Precondition CHECK_ALL = new Precondition(){

            @Override
            public boolean shouldCheck(Node n) {
                return true;
            }
        };

        public boolean shouldCheck(Node var1);
    }

    public static interface Rule {
        @Nullable
        default public Precondition getPrecondition() {
            return Precondition.CHECK_ALL;
        }

        public void check(NodeTraversal var1, Node var2);
    }
}

