/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSDocInfoPrinter;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class CheckMissingOverrideTypes
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private static final String PLACEHOLDER_OBJ_PARAM_NAME = "objectParam";
    private static final String JSDOC_FILE_NAME = "<testFile>";
    private static final String NON_NULLABLE_OBJECT_TYPE = "!Object";
    public static final DiagnosticType OVERRIDE_WITHOUT_ALL_TYPES = DiagnosticType.error("JSC_OVERRIDE_WITHOUT_ALL_TYPES", "must have param and return types specified. Here is the replacement JSDoc for this function or property \n{0}");

    public CheckMissingOverrideTypes(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case GETPROP: {
                this.visitPropDeclaration(n);
                break;
            }
            case FUNCTION: {
                this.visitFunction(n);
                break;
            }
            case MEMBER_FUNCTION_DEF: 
            case GETTER_DEF: 
            case SETTER_DEF: {
                break;
            }
        }
    }

    @Nullable
    private JSDocInfo getOverrideJSDoc(Node n) {
        JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(n);
        return jsDoc != null && jsDoc.isOverride() ? jsDoc : null;
    }

    private void visitPropDeclaration(Node n) {
        JSDocInfo jsDoc = this.getOverrideJSDoc(n);
        if (jsDoc == null || jsDoc.containsTypeDeclaration()) {
            return;
        }
        Node func = NodeUtil.getEnclosingFunction(n);
        if (func != null) {
            return;
        }
        Node owner = n.getFirstChild();
        if (!owner.isThis()) {
            return;
        }
        ObjectType ownerType = ObjectType.cast(owner.getJSType());
        if (ownerType == null) {
            return;
        }
        JSType propType = ownerType.getPropertyType(n.getString());
        if (propType == null) {
            return;
        }
        JSDocInfo.Builder builder = JSDocInfo.Builder.maybeCopyFrom(jsDoc);
        builder.recordType(new JSTypeExpression(CheckMissingOverrideTypes.typeToTypeAst(propType), JSDOC_FILE_NAME));
        this.reportMissingOverrideTypes(n, builder.build());
    }

    private void visitFunction(Node function) {
        FunctionType fnType;
        JSDocInfo jsDoc = this.getOverrideJSDoc(function);
        if (jsDoc == null) {
            return;
        }
        FunctionType functionType = fnType = function.getJSType() != null ? function.getJSType().toMaybeFunctionType() : null;
        if (fnType == null) {
            return;
        }
        boolean missingParam = this.hasMissingParams(function, jsDoc);
        boolean missingReturn = this.hasMissingReturn(function, jsDoc);
        if (missingParam || missingReturn) {
            JSDocInfo completeJSDocInfo = this.createCompleteJSDocInfoForFunction(function, missingParam, missingReturn, jsDoc);
            this.reportMissingOverrideTypes(function, completeJSDocInfo);
        }
    }

    private boolean hasMissingParams(Node function, JSDocInfo jsDoc) {
        if (jsDoc.getType() != null) {
            return false;
        }
        int jsDocParamCount = jsDoc.getParameterCount();
        if (jsDocParamCount == 0) {
            return this.hasMissingInlineParams(function);
        }
        Node paramList = NodeUtil.getFunctionParameters(function);
        return !paramList.hasXChildren(jsDocParamCount);
    }

    private boolean hasMissingInlineParams(Node function) {
        Node paramList = NodeUtil.getFunctionParameters(function);
        for (Node param = paramList.getFirstChild(); param != null; param = param.getNext()) {
            JSDocInfo jsDoc;
            JSDocInfo jSDocInfo = jsDoc = param.isDefaultValue() ? param.getFirstChild().getJSDocInfo() : param.getJSDocInfo();
            if (jsDoc != null) continue;
            return true;
        }
        return false;
    }

    private boolean hasMissingReturn(Node function, JSDocInfo jsDoc) {
        if (jsDoc.hasType() || jsDoc.isConstructor() || jsDoc.isInterface() || jsDoc.hasReturnType()) {
            return false;
        }
        if (NodeUtil.isEs6Constructor(function)) {
            return false;
        }
        if (function.getFirstChild().getJSDocInfo() != null) {
            return false;
        }
        FunctionType fnType = function.getJSType().toMaybeFunctionType();
        JSType returnType = fnType.getReturnType();
        return !returnType.isVoidType();
    }

    public void reportMissingOverrideTypes(Node node, JSDocInfo completeJSDocInfo) {
        this.compiler.report(JSError.make(node, OVERRIDE_WITHOUT_ALL_TYPES, new JSDocInfoPrinter(false, true).print(completeJSDocInfo)));
    }

    private JSDocInfo createCompleteJSDocInfoForFunction(Node fnNode, boolean missingParam, boolean missingReturn, JSDocInfo jsDocInfo) {
        Preconditions.checkArgument(jsDocInfo == null || jsDocInfo.isOverride(), jsDocInfo);
        JSDocInfo.Builder builder = JSDocInfo.Builder.maybeCopyFrom(jsDocInfo);
        FunctionType fnType = fnNode.getJSType().toMaybeFunctionType();
        if (missingParam) {
            this.recordMissingParamAnnotations(fnNode, jsDocInfo, fnType, builder);
        }
        if (missingReturn) {
            this.recordMissingReturnAnnotation(fnNode, fnType, builder);
        }
        return builder.build();
    }

    private void recordMissingParamAnnotations(Node fnNode, JSDocInfo jsDoc, FunctionType fnType, JSDocInfo.Builder builder) {
        Preconditions.checkState(fnNode.isFunction(), fnNode);
        Set<String> jsDocParamNames = jsDoc.getParameterNames();
        List<String> astParamNames = CheckMissingOverrideTypes.getFunctionParamNamesOrPlaceholder(fnNode);
        ImmutableList<FunctionType.Parameter> fnTypeParams = fnType.getParameters();
        for (int paramIndex = 0; paramIndex < astParamNames.size(); ++paramIndex) {
            String astName = astParamNames.get(paramIndex);
            if (jsDocParamNames.contains(astName)) continue;
            FunctionType.Parameter fnTypeParam = (FunctionType.Parameter)fnTypeParams.get(paramIndex);
            JSType paramType = fnTypeParam.getJSType();
            if (fnTypeParam.isOptional()) {
                paramType = paramType.restrictByNotUndefined();
            }
            Node paramTypeAst = CheckMissingOverrideTypes.typeToTypeAst(paramType);
            if (fnTypeParam.isOptional()) {
                paramTypeAst = new Node(Token.EQUALS, paramTypeAst);
            }
            builder.recordParameter(astName, new JSTypeExpression(paramTypeAst, JSDOC_FILE_NAME));
        }
    }

    private void recordMissingReturnAnnotation(Node fnNode, FunctionType fnType, JSDocInfo.Builder builder) {
        Preconditions.checkState(fnNode.isFunction(), fnNode);
        builder.recordReturnType(new JSTypeExpression(CheckMissingOverrideTypes.typeToTypeAst(fnType.getReturnType()), JSDOC_FILE_NAME));
    }

    private static boolean omitExplicitNullability(JSType type) {
        return type.isBooleanValueType() || type.isNumberValueType() || type.isStringValueType() || type.isAllType() || type.isUnknownType() || type.isOnlyBigInt() || type.isNullType() || type.isSymbolValueType() || type.isVoidType() || type.isTemplateType();
    }

    private static Node typeToTypeAst(JSType type) {
        return JsDocInfoParser.parseTypeString(CheckMissingOverrideTypes.typeToAnnotationString(type));
    }

    private static String typeToAnnotationString(JSType type) {
        if (CheckMissingOverrideTypes.omitExplicitNullability(type)) {
            return type.toString();
        }
        if (type.isLiteralObject() && type.toMaybeObjectType().getOwnPropertyNames().isEmpty()) {
            return NON_NULLABLE_OBJECT_TYPE;
        }
        if (type.hasDisplayName()) {
            String explicitNullability = type.isNullable() ? "?" : "!";
            return explicitNullability + type.getDisplayName();
        }
        if (type.isUnionType()) {
            JSType alternate;
            ImmutableList<JSType> alternates = type.toMaybeUnionType().getAlternates();
            if (alternates.size() == 2 && alternates.stream().anyMatch(JSType::isNullType) && !CheckMissingOverrideTypes.omitExplicitNullability(alternate = type.restrictByNotNull()) && alternate.hasDisplayName()) {
                return "?" + alternate.getDisplayName();
            }
            TreeSet<String> sortedNames = new TreeSet<String>();
            for (JSType child : alternates) {
                sortedNames.add(CheckMissingOverrideTypes.typeToAnnotationString(child));
            }
            return "(" + String.join((CharSequence)"|", sortedNames) + ")";
        }
        return type.toAnnotationString(JSType.Nullability.EXPLICIT);
    }

    private static List<String> getFunctionParamNamesOrPlaceholder(Node fnNode) {
        Preconditions.checkArgument(fnNode.isFunction(), fnNode);
        Node paramList = fnNode.getSecondChild();
        ArrayList<String> paramNames = new ArrayList<String>();
        for (Node param = paramList.getFirstChild(); param != null; param = param.getNext()) {
            Node paramName;
            Node node = paramName = param.isDefaultValue() || param.isRest() ? param.getFirstChild() : param;
            if (paramName.isObjectPattern() || paramName.isArrayPattern()) {
                paramNames.add(PLACEHOLDER_OBJ_PARAM_NAME);
                continue;
            }
            Preconditions.checkState(paramName.isName(), param);
            paramNames.add(paramName.getString());
        }
        return paramNames;
    }
}

