/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.regex.RegExpTree;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

class CheckRegExp
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType REGEXP_REFERENCE = DiagnosticType.warning("JSC_REGEXP_REFERENCE", "References to the global RegExp object prevents optimization of regular expressions.");
    static final DiagnosticType MALFORMED_REGEXP = DiagnosticType.warning("JSC_MALFORMED_REGEXP", "Malformed Regular Expression: {0}");
    private static final ImmutableSet<String> REGEXP_PROPERTY_SKIPLIST = ImmutableSet.of("$1", "$2", "$3", "$4", "$5", "$6", new String[]{"$7", "$8", "$9", "$_", "$input", "input", "lastMatch", "lastParen", "leftContext", "rightContext", "global", "ignoreCase", "lastIndex", "multiline", "source"});
    private final AbstractCompiler compiler;
    private final boolean reportErrors;
    private boolean globalRegExpPropertiesUsed = false;

    public boolean isGlobalRegExpPropertiesUsed() {
        return this.globalRegExpPropertiesUsed;
    }

    public CheckRegExp(AbstractCompiler compiler, boolean reportErrors) {
        this.compiler = compiler;
        this.reportErrors = reportErrors;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (NodeUtil.isReferenceName(n)) {
            String name = n.getString();
            if (name.equals("RegExp") && t.getScope().getVar(name) == null) {
                boolean first;
                Token parentType = parent.getToken();
                boolean bl = first = n == parent.getFirstChild();
                if (!(parentType == Token.NEW && first || parentType == Token.CALL && first || parentType == Token.INSTANCEOF && !first || parentType == Token.EQ || parentType == Token.NE || parentType == Token.SHEQ || parentType == Token.SHNE || parentType == Token.CASE || parentType == Token.GETPROP && first && !REGEXP_PROPERTY_SKIPLIST.contains(parent.getString()))) {
                    if (this.reportErrors) {
                        t.report(n, REGEXP_REFERENCE, new String[0]);
                    }
                    this.globalRegExpPropertiesUsed = true;
                }
            }
        } else if (this.reportErrors && n.isRegExp()) {
            String pattern = n.getFirstChild().getString();
            String flags = n.hasTwoChildren() ? n.getLastChild().getString() : "";
            try {
                RegExpTree.parseRegExp(pattern, flags);
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException ex) {
                t.report(n, MALFORMED_REGEXP, ex.getMessage());
            }
        }
    }
}

