/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Joiner;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ClosureRewriteClass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType GOOG_CLASS_TARGET_INVALID = DiagnosticType.error("JSC_GOOG_CLASS_TARGET_INVALID", "Unsupported class definition expression.");
    static final DiagnosticType GOOG_CLASS_SUPER_CLASS_NOT_VALID = DiagnosticType.error("JSC_GOOG_CLASS_SUPER_CLASS_NOT_VALID", "The super class must be null or a valid name reference");
    static final DiagnosticType GOOG_CLASS_DESCRIPTOR_NOT_VALID = DiagnosticType.error("JSC_GOOG_CLASS_DESCRIPTOR_NOT_VALID", "The class must be defined by an object literal");
    static final DiagnosticType GOOG_CLASS_CONSTRUCTOR_MISSING = DiagnosticType.error("JSC_GOOG_CLASS_CONSTRUCTOR_MISSING", "The 'constructor' property is missing for the class definition");
    static final DiagnosticType GOOG_CLASS_CONSTRUCTOR_NOT_VALID = DiagnosticType.error("JSC_GOOG_CLASS_CONSTRUCTOR_NOT_VALID", "The 'constructor' expression must be a function literal");
    static final DiagnosticType GOOG_CLASS_CONSTRUCTOR_ON_INTERFACE = DiagnosticType.error("JSC_GOOG_CLASS_CONSTRUCTOR_ON_INTERFACE", "An interface definition should not have a 'constructor' property");
    static final DiagnosticType GOOG_CLASS_STATICS_NOT_VALID = DiagnosticType.error("JSC_GOOG_CLASS_STATICS_NOT_VALID", "The class 'statics' property must be an object or function literal");
    static final DiagnosticType GOOG_CLASS_UNEXPECTED_PARAMS = DiagnosticType.error("JSC_GOOG_CLASS_UNEXPECTED_PARAMS", "Too many arguments to goog.defineClass.");
    static final DiagnosticType GOOG_CLASS_ES6_COMPUTED_PROP_NAMES_NOT_SUPPORTED = DiagnosticType.error("JSC_GOOG_CLASS_ES6_COMPUTED_PROP_NAMES_NOT_SUPPORTED", "Computed property names not supported in goog.defineClass.");
    static final DiagnosticType GOOG_CLASS_ES6_ARROW_FUNCTION_NOT_SUPPORTED = DiagnosticType.error("JSC_GOOG_CLASS_ES6_ARROW_FUNCTION_NOT_SUPPORTED", "Arrow functions not supported in goog.defineClass. Object literal method definition may be an alternative.");
    static final DiagnosticType GOOG_CLASS_NG_INJECT_ON_CLASS = DiagnosticType.warning("JSC_GOOG_CLASS_NG_INJECT_ON_CLASS", "@ngInject should be declared on the constructor, not on the class.");
    private final AbstractCompiler compiler;
    static final String VIRTUAL_FILE = "<ClosureRewriteClass.java>";

    public ClosureRewriteClass(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isCall() && ClosureRewriteClass.isGoogDefineClass(n) && !this.validateUsage(n)) {
            this.compiler.report(JSError.make(n, GOOG_CLASS_TARGET_INVALID, new String[0]));
        }
        this.maybeRewriteClassDefinition(t, n);
    }

    private boolean validateUsage(Node n) {
        Node parent = n.getParent();
        switch (parent.getToken()) {
            case NAME: {
                return true;
            }
            case ASSIGN: {
                return n == parent.getLastChild() && parent.getParent().isExprResult();
            }
            case STRING_KEY: {
                return this.isContainedInGoogDefineClass(parent);
            }
        }
        return false;
    }

    private boolean isContainedInGoogDefineClass(Node n) {
        while (n != null) {
            if ((n = n.getParent()).isCall()) {
                if (!ClosureRewriteClass.isGoogDefineClass(n)) continue;
                return true;
            }
            if (n.isObjectLit() || n.isStringKey()) continue;
            break;
        }
        return false;
    }

    private void maybeRewriteClassDefinition(NodeTraversal t, Node n) {
        if (NodeUtil.isNameDeclaration(n)) {
            Node target = n.getFirstChild();
            Node value = target.getFirstChild();
            this.maybeRewriteClassDefinition(t, n, target, value);
        } else if (NodeUtil.isExprAssign(n)) {
            Node assign = n.getFirstChild();
            Node target = assign.getFirstChild();
            Node value = assign.getLastChild();
            this.maybeRewriteClassDefinition(t, n, target, value);
        }
    }

    private void maybeRewriteClassDefinition(NodeTraversal t, Node n, Node target, Node value) {
        if (ClosureRewriteClass.isGoogDefineClass(value)) {
            ClassDefinition def;
            if (!target.isQualifiedName()) {
                this.compiler.report(JSError.make(n, GOOG_CLASS_TARGET_INVALID, new String[0]));
            }
            if ((def = this.extractClassDefinition(target, value)) != null) {
                value.detach();
                target.detach();
                this.rewriteGoogDefineClass(t, n, def);
            }
        }
    }

    private ClassDefinition extractClassDefinition(Node targetName, Node callNode) {
        Node description;
        JSDocInfo classInfo = NodeUtil.getBestJSDocInfo(targetName);
        Node superClass = NodeUtil.getArgumentForCallOrNew(callNode, 0);
        if (superClass == null || !superClass.isNull() && !superClass.isQualifiedName() && !NodeUtil.isCallTo(superClass, "goog.module.get")) {
            this.compiler.report(JSError.make(callNode, GOOG_CLASS_SUPER_CLASS_NOT_VALID, new String[0]));
            return null;
        }
        if (NodeUtil.isNullOrUndefined(superClass) || superClass.matchesName("Object")) {
            superClass = null;
        }
        if (!this.validateObjLit(description = NodeUtil.getArgumentForCallOrNew(callNode, 1), callNode)) {
            return null;
        }
        int paramCount = callNode.getChildCount() - 1;
        if (paramCount > 2) {
            this.compiler.report(JSError.make(callNode, GOOG_CLASS_UNEXPECTED_PARAMS, new String[0]));
            return null;
        }
        Node constructor = ClosureRewriteClass.extractProperty(description, "constructor");
        if (classInfo != null && classInfo.isInterface()) {
            if (constructor != null) {
                this.compiler.report(JSError.make(description, GOOG_CLASS_CONSTRUCTOR_ON_INTERFACE, new String[0]));
                return null;
            }
        } else {
            if (constructor == null) {
                this.compiler.report(JSError.make(description, GOOG_CLASS_CONSTRUCTOR_MISSING, new String[0]));
                return null;
            }
            if (!constructor.isFunction()) {
                this.compiler.report(JSError.make(constructor, GOOG_CLASS_CONSTRUCTOR_NOT_VALID, new String[0]));
            }
        }
        if (constructor == null) {
            constructor = IR.function(IR.name("").srcref(callNode), IR.paramList(new Node[0]).srcref(callNode), IR.block().srcref(callNode));
            constructor.srcref(callNode);
            this.compiler.reportChangeToChangeScope(constructor);
        }
        JSDocInfo info = NodeUtil.getBestJSDocInfo(constructor);
        Node classModifier = null;
        Node statics = null;
        Node staticsProp = ClosureRewriteClass.extractProperty(description, "statics");
        if (staticsProp != null) {
            if (staticsProp.isObjectLit()) {
                if (!this.validateObjLit(staticsProp, staticsProp.getParent())) {
                    return null;
                }
                statics = staticsProp;
            } else if (staticsProp.isFunction()) {
                classModifier = staticsProp;
            } else {
                this.compiler.report(JSError.make(staticsProp, GOOG_CLASS_STATICS_NOT_VALID, new String[0]));
                return null;
            }
        }
        if (statics == null) {
            statics = IR.objectlit(new Node[0]);
        }
        ClosureRewriteClass.maybeDetach(constructor.getParent());
        ClosureRewriteClass.maybeDetach(statics.getParent());
        if (classModifier != null) {
            ClosureRewriteClass.maybeDetach(classModifier.getParent());
        }
        return new ClassDefinition(targetName, classInfo, ClosureRewriteClass.maybeDetach(superClass), new MemberDefinition(info, null, ClosureRewriteClass.maybeDetach(constructor)), ClosureRewriteClass.objectLitToList(ClosureRewriteClass.maybeDetach(statics)), ClosureRewriteClass.objectLitToList(description), ClosureRewriteClass.maybeDetach(classModifier));
    }

    private static Node maybeDetach(Node node) {
        if (node != null && node.hasParent()) {
            node.detach();
        }
        return node;
    }

    private boolean validateObjLit(Node objlit, Node parent) {
        if (objlit == null || !objlit.isObjectLit()) {
            this.reportErrorOnContext(parent);
            return false;
        }
        for (Node key = objlit.getFirstChild(); key != null; key = key.getNext()) {
            if (key.isMemberFunctionDef()) continue;
            if (key.isComputedProp()) {
                this.compiler.report(JSError.make(objlit, GOOG_CLASS_ES6_COMPUTED_PROP_NAMES_NOT_SUPPORTED, new String[0]));
                return false;
            }
            if (key.isStringKey() && key.getFirstChild().isArrowFunction()) {
                this.compiler.report(JSError.make(objlit, GOOG_CLASS_ES6_ARROW_FUNCTION_NOT_SUPPORTED, new String[0]));
                return false;
            }
            if (key.isStringKey() && !key.isQuotedString()) continue;
            this.reportErrorOnContext(parent);
            return false;
        }
        return true;
    }

    private void reportErrorOnContext(Node parent) {
        if (parent.isStringKey()) {
            this.compiler.report(JSError.make(parent, GOOG_CLASS_STATICS_NOT_VALID, new String[0]));
        } else {
            Preconditions.checkState(parent.isCall());
            this.compiler.report(JSError.make(parent, GOOG_CLASS_DESCRIPTOR_NOT_VALID, new String[0]));
        }
    }

    private static Node extractProperty(Node objlit, String keyName) {
        for (Node keyNode = objlit.getFirstChild(); keyNode != null; keyNode = keyNode.getNext()) {
            if (!keyNode.getString().equals(keyName)) continue;
            return keyNode.getFirstChild();
        }
        return null;
    }

    private static List<MemberDefinition> objectLitToList(Node objlit) {
        ArrayList<MemberDefinition> result = new ArrayList<MemberDefinition>();
        for (Node keyNode = objlit.getFirstChild(); keyNode != null; keyNode = keyNode.getNext()) {
            Node name = keyNode;
            if (keyNode.isMemberFunctionDef()) {
                name = keyNode.getFirstFirstChild().cloneNode();
                name.setString(keyNode.getString());
            }
            result.add(new MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), name, keyNode.removeFirstChild()));
        }
        objlit.detachChildren();
        return result;
    }

    private void rewriteGoogDefineClass(NodeTraversal t, Node exprRoot, ClassDefinition cls) {
        JSDocInfo mergedClassInfo;
        Node block = IR.block();
        cls.constructor.value.setJSDocInfo(null);
        if (NodeUtil.isNameDeclaration(exprRoot)) {
            Node decl = IR.declaration(cls.name.cloneTree(), cls.constructor.value, exprRoot.getToken()).srcref(exprRoot);
            mergedClassInfo = this.mergeJsDocFor(cls, decl, !exprRoot.getParent().isModuleBody());
            decl.setJSDocInfo(mergedClassInfo);
            block.addChildToBack(decl);
        } else {
            Iterator<MemberDefinition> assign = IR.assign(cls.name.cloneTree(), cls.constructor.value).srcref(exprRoot).setJSDocInfo(cls.constructor.info);
            mergedClassInfo = this.mergeJsDocFor(cls, exprRoot.getOnlyChild(), true);
            ((Node)((Object)assign)).setJSDocInfo(mergedClassInfo);
            Node expr = IR.exprResult((Node)((Object)assign)).srcref(exprRoot);
            block.addChildToBack(expr);
        }
        if (cls.superClass != null) {
            block.addChildToBack(ClosureRewriteClass.fixupSrcref(IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "goog.inherits").srcrefTree(cls.superClass), cls.name.cloneTree(), cls.superClass.cloneTree()).srcref(cls.superClass))));
        }
        for (MemberDefinition def : cls.staticProps) {
            if (!def.value.isCast()) {
                def.value.setJSDocInfo(null);
            }
            block.addChildToBack(ClosureRewriteClass.fixupSrcref(IR.exprResult(ClosureRewriteClass.fixupSrcref(IR.assign(IR.getprop(cls.name.cloneTree(), def.name.getString()).srcref(def.name), def.value)).setJSDocInfo(def.info))));
            this.maybeRewriteClassDefinition(t, block.getLastChild());
        }
        for (MemberDefinition def : cls.props) {
            def.value.setJSDocInfo(null);
            Node exprResult = IR.exprResult(IR.assign(NodeUtil.newQName(this.compiler, cls.name.getQualifiedName() + ".prototype." + def.name.getString()), def.value).setJSDocInfo(def.info));
            exprResult.srcrefTreeIfMissing(def.name);
            exprResult.setLength(def.value.getSourceOffset() + def.value.getLength() - def.name.getSourceOffset());
            block.addChildToBack(exprResult);
            this.maybeRewriteClassDefinition(t, block.getLastChild());
        }
        if (cls.classModifier != null) {
            Node argList = cls.classModifier.getSecondChild();
            Node arg = argList.getFirstChild();
            String argName = arg.getString();
            NodeTraversal.builder().setCompiler(this.compiler).setCallback((unused, n, parent) -> {
                if (n.isName() && n.getString().equals(argName)) {
                    Node newName = cls.name.cloneTree();
                    n.replaceWith(newName);
                    this.compiler.reportChangeToEnclosingScope(newName);
                }
            }).traverse(cls.classModifier.getLastChild());
            block.addChildToBack(IR.exprResult(ClosureRewriteClass.fixupFreeCall(IR.call(cls.classModifier, cls.name.cloneTree()).srcref(cls.classModifier))).srcref(cls.classModifier));
        }
        Node parent2 = exprRoot.getParent();
        Node stmts = block.removeChildren();
        parent2.addChildrenAfter(stmts, exprRoot);
        exprRoot.detach();
        t.reportCodeChange();
    }

    private static Node fixupSrcref(Node node) {
        node.srcref(node.getFirstChild());
        return node;
    }

    private static Node fixupFreeCall(Node call) {
        Preconditions.checkState(call.isCall());
        call.putBooleanProp(Node.FREE_CALL, true);
        return call;
    }

    static boolean isGoogDefineClass(Node value) {
        if (value != null && value.isCall()) {
            return value.getFirstChild().matchesQualifiedName("goog.defineClass");
        }
        return false;
    }

    private JSTypeExpression getSuperclassFor(Node superNode) {
        String superName;
        if (superNode.isQualifiedName()) {
            superName = superNode.getQualifiedName();
        } else {
            Preconditions.checkState(NodeUtil.isCallTo(superNode, "goog.module.get"));
            superName = superNode.getLastChild().getString();
        }
        return new JSTypeExpression(new Node(Token.BANG, IR.string(superName)).srcrefTree(superNode), VIRTUAL_FILE);
    }

    private JSDocInfo mergeJsDocFor(ClassDefinition cls, Node associatedNode, boolean includeConstructorExport) {
        boolean isInterface;
        JSDocInfo.Visibility visibility;
        String blockDescription;
        JSDocInfo.Builder mergedInfo;
        JSDocInfo classInfo = cls.classInfo != null ? cls.classInfo : JSDocInfo.builder().parseDocumentation().build(true);
        JSDocInfo ctorInfo = cls.constructor.info != null ? cls.constructor.info : JSDocInfo.builder().parseDocumentation().build(true);
        Node superNode = cls.superClass;
        JSDocInfo.Builder builder = mergedInfo = cls.constructor.info != null ? JSDocInfo.Builder.copyFrom(ctorInfo) : JSDocInfo.builder().parseDocumentation();
        if (!includeConstructorExport && ctorInfo.isExport()) {
            mergedInfo.removeExport();
        }
        if (!(blockDescription = Joiner.on("\n").skipNulls().join(classInfo.getBlockDescription(), ctorInfo.getBlockDescription(), new Object[0])).isEmpty()) {
            mergedInfo.recordBlockDescription(blockDescription);
        }
        HashSet<String> suppressions = new HashSet<String>();
        suppressions.addAll(classInfo.getSuppressions());
        suppressions.addAll(ctorInfo.getSuppressions());
        if (!suppressions.isEmpty()) {
            mergedInfo.recordSuppressions(suppressions);
        }
        if (classInfo.isDeprecated()) {
            mergedInfo.recordDeprecated();
        }
        String deprecationReason = null;
        if (classInfo.getDeprecationReason() != null) {
            deprecationReason = classInfo.getDeprecationReason();
            mergedInfo.recordDeprecationReason(deprecationReason);
        }
        if ((visibility = classInfo.getVisibility()) != null && visibility != JSDocInfo.Visibility.INHERITED) {
            mergedInfo.recordVisibility(classInfo.getVisibility());
        }
        if (classInfo.isAbstract()) {
            mergedInfo.recordAbstract();
        }
        if (classInfo.isConstant()) {
            mergedInfo.recordConstancy();
        }
        if (classInfo.isExport()) {
            mergedInfo.recordExport();
        }
        if (classInfo.isNgInject()) {
            this.compiler.report(JSError.make(associatedNode, GOOG_CLASS_NG_INJECT_ON_CLASS, new String[0]));
            mergedInfo.recordNgInject(true);
        }
        if (classInfo.makesUnrestricted() || ctorInfo.makesUnrestricted()) {
            mergedInfo.recordUnrestricted();
        } else if (classInfo.makesDicts() || ctorInfo.makesDicts()) {
            mergedInfo.recordDict();
        } else {
            mergedInfo.recordStruct();
        }
        boolean bl = isInterface = classInfo.isInterface() || ctorInfo.isInterface();
        if (isInterface) {
            if (classInfo.usesImplicitMatch() || ctorInfo.usesImplicitMatch()) {
                mergedInfo.recordImplicitMatch();
            } else {
                mergedInfo.recordInterface();
            }
            List<JSTypeExpression> extendedInterfaces = null;
            if (classInfo.getExtendedInterfacesCount() > 0) {
                extendedInterfaces = classInfo.getExtendedInterfaces();
            } else if (ctorInfo.getExtendedInterfacesCount() == 0 && superNode != null) {
                extendedInterfaces = ImmutableList.of(this.getSuperclassFor(superNode));
            }
            if (extendedInterfaces != null) {
                for (JSTypeExpression extend : extendedInterfaces) {
                    mergedInfo.recordExtendedInterface(extend);
                }
            }
        } else {
            mergedInfo.recordConstructor();
            if (classInfo.getBaseType() != null) {
                mergedInfo.recordBaseType(classInfo.getBaseType());
            } else if (superNode != null) {
                JSTypeExpression baseType = this.getSuperclassFor(superNode);
                mergedInfo.recordBaseType(baseType);
            }
            List<JSTypeExpression> interfaces = classInfo.getImplementedInterfaces();
            for (JSTypeExpression implemented : interfaces) {
                mergedInfo.recordImplementedInterface(implemented);
            }
        }
        ImmutableMap<String, JSTypeExpression> classTemplates = classInfo.getTemplateTypes();
        ImmutableMap<String, JSTypeExpression> ctorTemplates = ctorInfo.getTemplateTypes();
        for (Map.Entry entry : classTemplates.entrySet()) {
            mergedInfo.recordTemplateTypeName((String)entry.getKey(), (JSTypeExpression)entry.getValue());
        }
        for (Map.Entry entry : ctorTemplates.entrySet()) {
            mergedInfo.recordTemplateTypeName((String)entry.getKey(), (JSTypeExpression)entry.getValue());
        }
        return mergedInfo.build();
    }

    private static final class ClassDefinition {
        final Node name;
        final JSDocInfo classInfo;
        final Node superClass;
        final MemberDefinition constructor;
        final List<MemberDefinition> staticProps;
        final List<MemberDefinition> props;
        final Node classModifier;

        ClassDefinition(Node name, JSDocInfo classInfo, Node superClass, MemberDefinition constructor, List<MemberDefinition> staticProps, List<MemberDefinition> props, Node classModifier) {
            this.name = name;
            this.classInfo = classInfo;
            this.superClass = superClass;
            this.constructor = constructor;
            this.staticProps = staticProps;
            this.props = props;
            this.classModifier = classModifier;
        }
    }

    private static class MemberDefinition {
        final JSDocInfo info;
        final Node name;
        final Node value;

        MemberDefinition(JSDocInfo info, Node name, Node value) {
            this.info = info;
            this.name = name;
            this.value = value;
        }
    }
}

