/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.LiveVariablesAnalysis;
import com.google.javascript.jscomp.MemoizedScopeCreator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.GraphColoring;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.LinkedUndirectedGraph;
import com.google.javascript.jscomp.graph.UndiGraph;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Joiner;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

class CoalesceVariableNames
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;
    private final MemoizedScopeCreator scopeCreator;
    private final Deque<GraphColoring<Var, Void>> colorings;
    private final Deque<LiveVariablesAnalysis> liveAnalyses;
    private final boolean usePseudoNames;
    private final AstFactory astFactory;
    private LiveVariablesAnalysis liveness;
    private final Comparator<Var> coloringTieBreaker = Comparator.comparingInt(arg -> this.liveness.getVarIndex(arg.getName()));
    private final Deque<Boolean> shouldOptimizeScopeStack = new ArrayDeque<Boolean>();

    CoalesceVariableNames(AbstractCompiler compiler, boolean usePseudoNames) {
        Preconditions.checkState(compiler.getLifeCycleStage().isNormalized());
        this.compiler = compiler;
        this.colorings = new ArrayDeque<GraphColoring<Var, Void>>();
        this.liveAnalyses = new ArrayDeque<LiveVariablesAnalysis>();
        this.usePseudoNames = usePseudoNames;
        this.astFactory = compiler.createAstFactory();
        this.scopeCreator = new MemoizedScopeCreator(new SyntacticScopeCreator(compiler));
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkNotNull(externs);
        Preconditions.checkNotNull(root);
        NodeTraversal.builder().setCompiler(this.compiler).setCallback(this).setScopeCreator(this.scopeCreator).traverse(root);
        this.compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.RAW);
    }

    private static NodeUtil.AllVarsDeclaredInFunction shouldOptimizeScope(NodeTraversal t) {
        NodeUtil.AllVarsDeclaredInFunction allVarsDeclaredInFunction;
        if (t.getScopeRoot().isFunction() && 100 > (allVarsDeclaredInFunction = NodeUtil.getAllVarsDeclaredInFunction(t.getCompiler(), t.getScopeCreator(), t.getScope())).getAllVariablesInOrder().size()) {
            return allVarsDeclaredInFunction;
        }
        return null;
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Node enclosingFunction;
        NodeUtil.AllVarsDeclaredInFunction allVarsDeclaredInFunction = CoalesceVariableNames.shouldOptimizeScope(t);
        if (allVarsDeclaredInFunction == null) {
            this.shouldOptimizeScopeStack.push(false);
            return;
        }
        this.shouldOptimizeScopeStack.push(true);
        Scope scope = t.getScope();
        Preconditions.checkState(scope.isFunctionScope(), scope);
        ControlFlowGraph<Node> cfg = t.getControlFlowGraph();
        this.liveness = new LiveVariablesAnalysis(cfg, scope, null, this.compiler, this.scopeCreator, allVarsDeclaredInFunction);
        if (FeatureSet.ES3.contains(this.compiler.getOptions().getOutputFeatureSet()) && NodeUtil.getFunctionParameters(enclosingFunction = scope.getRootNode()).hasTwoChildren()) {
            this.liveness.markAllParametersEscaped();
        }
        this.liveness.analyze();
        this.liveAnalyses.push(this.liveness);
        UndiGraph<Var, Void> interferenceGraph = this.computeVariableNamesInterferenceGraph(cfg, this.liveness.getEscapedLocals());
        GraphColoring.GreedyGraphColoring<Var, Void> coloring = new GraphColoring.GreedyGraphColoring<Var, Void>(interferenceGraph, this.coloringTieBreaker);
        ((GraphColoring)coloring).color();
        this.colorings.push(coloring);
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (!this.shouldOptimizeScopeStack.pop().booleanValue()) {
            return;
        }
        this.colorings.pop();
        this.liveAnalyses.pop();
        this.liveness = this.liveAnalyses.peek();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.colorings.isEmpty() || !n.isName() || parent.isFunction()) {
            return;
        }
        Var var = this.liveness.getAllVariables().get(n.getString());
        GraphNode<Var, Void> vNode = this.colorings.peek().getGraph().getNode(var);
        if (vNode == null) {
            return;
        }
        Var coalescedVar = this.colorings.peek().getPartitionSuperNode(var);
        if (!this.usePseudoNames) {
            if (vNode.getValue().equals(coalescedVar)) {
                return;
            }
            n.setString(coalescedVar.getName());
            this.compiler.reportChangeToEnclosingScope(n);
            if (NodeUtil.isNameDeclaration(parent) || NodeUtil.getEnclosingType(n, Token.DESTRUCTURING_LHS) != null && NodeUtil.isLhsByDestructuring(n)) {
                this.makeDeclarationVar(coalescedVar);
                CoalesceVariableNames.removeVarDeclaration(n);
            }
        } else {
            TreeSet<String> allMergedNames = new TreeSet<String>();
            for (Var iVar : this.liveness.getAllVariablesInOrder()) {
                if (this.colorings.peek().getGraph().getNode(iVar) == null || !coalescedVar.equals(this.colorings.peek().getPartitionSuperNode(iVar))) continue;
                allMergedNames.add(iVar.getName());
            }
            if (allMergedNames.size() == 1) {
                return;
            }
            String pseudoName = Joiner.on("_").join(allMergedNames);
            while (t.getScope().hasSlot(pseudoName)) {
                pseudoName = pseudoName + "$";
            }
            n.setString(pseudoName);
            this.compiler.reportChangeToEnclosingScope(n);
            if (!vNode.getValue().equals(coalescedVar) && (NodeUtil.isNameDeclaration(parent) || NodeUtil.getEnclosingType(n, Token.DESTRUCTURING_LHS) != null && NodeUtil.isLhsByDestructuring(n))) {
                this.makeDeclarationVar(coalescedVar);
                CoalesceVariableNames.removeVarDeclaration(n);
            }
        }
    }

    private UndiGraph<Var, Void> computeVariableNamesInterferenceGraph(ControlFlowGraph<Node> cfg, Set<? extends Var> escaped) {
        LinkedUndirectedGraph<Var, Void> interferenceGraph = LinkedUndirectedGraph.create();
        Var[] orderedVariables = this.liveness.getAllVariablesInOrder().toArray(new Var[0]);
        BitSet interferenceGraphNodes = new BitSet();
        BitSet[] interferenceBitSet = new BitSet[orderedVariables.length];
        Arrays.setAll(interferenceBitSet, i -> new BitSet());
        int vIndex = -1;
        for (Var v : orderedVariables) {
            ++vIndex;
            if (escaped.contains(v) || v.getParentNode().isFunction() || v.getParentNode().isClass() || this.isInMultipleLvalueDecl(v)) continue;
            ((Graph)interferenceGraph).createNode(v);
            interferenceGraphNodes.set(vIndex);
        }
        for (DiGraph.DiGraphNode diGraphNode : cfg.getNodes()) {
            if (cfg.isImplicitReturn(diGraphNode)) continue;
            DataFlowAnalysis.LinearFlowState state = (DataFlowAnalysis.LinearFlowState)diGraphNode.getAnnotation();
            LiveVariablesAnalysis.LiveVariableLattice livein = (LiveVariablesAnalysis.LiveVariableLattice)state.getIn();
            int i2 = livein.nextSetBit(0);
            while (i2 >= 0) {
                int j = livein.nextSetBit(i2);
                while (j >= 0) {
                    interferenceBitSet[i2].set(j);
                    j = livein.nextSetBit(j + 1);
                }
                i2 = livein.nextSetBit(i2 + 1);
            }
            LiveVariablesAnalysis.LiveVariableLattice liveout = (LiveVariablesAnalysis.LiveVariableLattice)state.getOut();
            int i3 = liveout.nextSetBit(0);
            while (i3 >= 0) {
                int j = liveout.nextSetBit(i3);
                while (j >= 0) {
                    interferenceBitSet[i3].set(j);
                    j = liveout.nextSetBit(j + 1);
                }
                i3 = liveout.nextSetBit(i3 + 1);
            }
            LiveRangeChecker liveRangeChecker = new LiveRangeChecker((Node)diGraphNode.getValue(), orderedVariables, state);
            liveRangeChecker.check((Node)diGraphNode.getValue());
            liveRangeChecker.setCrossingVariables(interferenceBitSet);
        }
        int v1Index = -1;
        for (Var v1 : orderedVariables) {
            ++v1Index;
            int v2Index = -1;
            for (Var v2 : orderedVariables) {
                if (v1Index > ++v2Index || !interferenceGraphNodes.get(v1Index) || !interferenceGraphNodes.get(v2Index) || (!v1.isParam() || !v2.isParam()) && !interferenceBitSet[v1Index].get(v2Index)) continue;
                interferenceGraph.connectIfNotFound(v1, null, v2);
            }
        }
        return interferenceGraph;
    }

    private boolean isInMultipleLvalueDecl(Var v) {
        Token declarationType = v.declarationType();
        switch (declarationType) {
            case LET: 
            case CONST: 
            case VAR: {
                Node nameDecl = NodeUtil.getEnclosingNode(v.getNode(), NodeUtil::isNameDeclaration);
                return NodeUtil.findLhsNodesInNode(nameDecl).size() > 1;
            }
        }
        return false;
    }

    private static void removeVarDeclaration(Node name) {
        Node var = NodeUtil.getEnclosingNode(name, NodeUtil::isNameDeclaration);
        Node parent = var.getParent();
        if (var.getFirstChild().isDestructuringLhs()) {
            Node destructuringLhs = var.getFirstChild();
            Node pattern = destructuringLhs.removeFirstChild();
            if (NodeUtil.isEnhancedFor(parent)) {
                var.replaceWith(pattern);
            } else {
                Node rvalue = var.getFirstFirstChild().detach();
                var.replaceWith(NodeUtil.newExpr(IR.assign(pattern, rvalue).srcref(var)));
            }
        } else if (NodeUtil.isEnhancedFor(parent)) {
            var.replaceWith(name.detach());
        } else {
            Preconditions.checkState(var.hasOneChild() && var.getFirstChild() == name, var);
            if (name.hasChildren()) {
                Node value = name.removeFirstChild();
                name.detach();
                Node assign = IR.assign(name, value).srcref(name);
                if (!parent.isVanillaFor()) {
                    assign = NodeUtil.newExpr(assign);
                }
                var.replaceWith(assign);
            } else {
                NodeUtil.removeChild(parent, var);
            }
        }
    }

    private void makeDeclarationVar(Var coalescedName) {
        if (coalescedName.isConst() || coalescedName.isLet()) {
            Node nameNode = Preconditions.checkNotNull(coalescedName.getNameNode(), coalescedName);
            if (CoalesceVariableNames.isUninitializedLetNameInLoopBody(nameNode)) {
                Node undefinedValue = this.astFactory.createUndefinedValue().srcrefTree(nameNode);
                nameNode.addChildToFront(undefinedValue);
            }
            Node declNode = NodeUtil.getEnclosingNode(nameNode.getParent(), NodeUtil::isNameDeclaration);
            declNode.setToken(Token.VAR);
        }
    }

    private static boolean isUninitializedLetNameInLoopBody(Node nameNode) {
        Preconditions.checkState(nameNode.isName(), nameNode);
        Node letNode = nameNode.getParent();
        if (!letNode.isLet()) {
            return false;
        }
        if (nameNode.hasOneChild()) {
            return false;
        }
        Node letParent = letNode.getParent();
        if (NodeUtil.isLoopStructure(letParent)) {
            return false;
        }
        return NodeUtil.isWithinLoop(letParent);
    }

    private static class LiveRangeChecker {
        private final Node root;
        private final DataFlowAnalysis.LinearFlowState<LiveVariablesAnalysis.LiveVariableLattice> state;
        private final Var[] orderedVariables;
        private final List<Integer> isAssignToList = new ArrayList<Integer>();
        private final List<Integer> isReadFromList = new ArrayList<Integer>();

        LiveRangeChecker(Node root, Var[] orderedVariables, DataFlowAnalysis.LinearFlowState<LiveVariablesAnalysis.LiveVariableLattice> state) {
            this.root = root;
            this.orderedVariables = orderedVariables;
            this.state = state;
        }

        void check(Node n) {
            if (n == this.root || !ControlFlowGraph.isEnteringNewCfgNode(n)) {
                if (n.isDestructuringLhs() && n.hasTwoChildren() || n.isAssign() && n.getFirstChild().isDestructuringPattern() || n.isDefaultValue()) {
                    this.check(n.getSecondChild());
                    this.check(n.getFirstChild());
                } else {
                    for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                        this.check(c);
                    }
                }
                if (LiveRangeChecker.shouldVisit(n)) {
                    this.visit(n, n.getParent());
                }
            }
        }

        void visit(Node n, Node parent) {
            int iVar;
            for (iVar = 0; iVar < this.orderedVariables.length; ++iVar) {
                if (!LiveRangeChecker.isAssignTo(this.orderedVariables[iVar], n, parent)) continue;
                this.isAssignToList.add(iVar);
            }
            if (!this.isAssignToList.isEmpty()) {
                for (iVar = 0; iVar < this.orderedVariables.length; ++iVar) {
                    boolean varOutLive = this.state.getOut().isLive(iVar);
                    if (!varOutLive && !LiveRangeChecker.isReadFrom(this.orderedVariables[iVar], n)) continue;
                    this.isReadFromList.add(iVar);
                }
            }
        }

        void setCrossingVariables(BitSet[] interferenceBitSet) {
            for (Integer iWrittenVar : this.isAssignToList) {
                for (Integer iReadVar : this.isReadFromList) {
                    interferenceBitSet[iWrittenVar].set(iReadVar);
                    interferenceBitSet[iReadVar].set(iWrittenVar);
                }
            }
        }

        public static boolean shouldVisit(Node n) {
            return n.isName() || n.hasChildren() && n.getFirstChild().isName();
        }

        static boolean isAssignTo(Var var, Node n, Node parent) {
            if (n.isName()) {
                if (parent.isParamList()) {
                    return var.getName().equals(n.getString());
                }
                if (NodeUtil.isNameDeclaration(parent) && n.hasChildren()) {
                    return var.getName().equals(n.getString());
                }
                if (NodeUtil.isLhsByDestructuring(n)) {
                    return var.getName().equals(n.getString());
                }
            } else if (NodeUtil.isAssignmentOp(n)) {
                Node name = n.getFirstChild();
                return name.isName() && var.getName().equals(name.getString());
            }
            return false;
        }

        static boolean isReadFrom(Var var, Node name) {
            return name.isName() && var.getName().equals(name.getString()) && !NodeUtil.isNameDeclOrSimpleAssignLhs(name, name.getParent());
        }
    }
}

