/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.Node;

class CollapseAnonymousFunctions
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;

    public CollapseAnonymousFunctions(AbstractCompiler compiler) {
        Preconditions.checkArgument(compiler.getLifeCycleStage().isNormalized());
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (!(n.isVar() || n.isLet() || n.isConst())) {
            return;
        }
        Node grandparent = parent.getParent();
        if (!(parent.isScript() || grandparent != null && grandparent.isFunction() && parent.isBlock())) {
            return;
        }
        Node name = n.getOnlyChild();
        if (!name.isName()) {
            return;
        }
        Node value = name.getFirstChild();
        if (value != null && value.isFunction() && !value.isArrowFunction() && !this.isRecursiveFunction(value)) {
            Node fnName = value.getFirstChild();
            fnName.setString(name.getString());
            NodeUtil.copyNameAnnotations(name, fnName);
            value.detach();
            n.replaceWith(value);
            if (!t.inGlobalScope() && NodeUtil.isHoistedFunctionDeclaration(value)) {
                parent.addChildToFront(value.detach());
            }
            this.compiler.reportChangeToChangeScope(value);
            t.reportCodeChange();
        }
    }

    private boolean isRecursiveFunction(Node function) {
        Node name = function.getFirstChild();
        if (name.getString().isEmpty()) {
            return false;
        }
        Node args = name.getNext();
        Node body = args.getNext();
        return this.containsName(body, name.getString());
    }

    private boolean containsName(Node n, String name) {
        if (n.isName() && n.getString().equals(name)) {
            return true;
        }
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!this.containsName(child, name)) continue;
            return true;
        }
        return false;
    }
}

