/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.debugging.sourcemap.SourceMapConsumerV3;
import com.google.debugging.sourcemap.proto.Mapping;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AccessorSummary;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerExecutor;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerOptionsPreprocessor;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ComposeWarningsGuard;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DefaultPassConfig;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroupWarningsGuard;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DotFormatter;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.FindModuleDependencies;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.IdGenerator;
import com.google.javascript.jscomp.IndexProvider;
import com.google.javascript.jscomp.J2clSuppressWarningsGuard;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.JSChunkGraph;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.LocaleDataPasses;
import com.google.javascript.jscomp.LoggerErrorManager;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.ModuleIdentifier;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PerformanceTracker;
import com.google.javascript.jscomp.PhaseOptimizer;
import com.google.javascript.jscomp.Platform;
import com.google.javascript.jscomp.PrebuildAst;
import com.google.javascript.jscomp.PrebuildDependencyInfo;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.PrintStreamErrorReportGenerator;
import com.google.javascript.jscomp.RecentChange;
import com.google.javascript.jscomp.ReferenceCollector;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.RewriteJsonToModule;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.SortingErrorManager;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceFileMapping;
import com.google.javascript.jscomp.SourceInformationAnnotator;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.SourceMapInput;
import com.google.javascript.jscomp.SourceMapResolver;
import com.google.javascript.jscomp.SuppressDocWarningsGuard;
import com.google.javascript.jscomp.SymbolTable;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.ThreadSafeDelegatingErrorManager;
import com.google.javascript.jscomp.Timeline;
import com.google.javascript.jscomp.Tracer;
import com.google.javascript.jscomp.TransformAMDToCJSModule;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.UniqueIdSupplier;
import com.google.javascript.jscomp.ValidityCheck;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.jscomp.deps.BrowserModuleResolver;
import com.google.javascript.jscomp.deps.BrowserWithTransformedPrefixesModuleResolver;
import com.google.javascript.jscomp.deps.JsFileRegexParser;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.deps.NodeModuleResolver;
import com.google.javascript.jscomp.deps.SortedDependencies;
import com.google.javascript.jscomp.deps.WebpackModuleResolver;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.jscomp.instrumentation.CoverageInstrumentationPass;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Joiner;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Optional;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Splitter;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Strings;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Supplier;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableCollection;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableListMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.LinkedHashMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Sets;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Streams;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.jscomp.resources.ResourceLoader;
import com.google.javascript.jscomp.serialization.ColorPool;
import com.google.javascript.jscomp.serialization.SerializeTypedAstPass;
import com.google.javascript.jscomp.serialization.TypedAstDeserializer;
import com.google.javascript.jscomp.type.ChainableReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.ClosureReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.SemanticReverseAbstractInterpreter;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Compiler
extends AbstractCompiler
implements ErrorHandler,
SourceFileMapping {
    static final DiagnosticType MODULE_DEPENDENCY_ERROR = DiagnosticType.error("JSC_MODULE_DEPENDENCY_ERROR", "Bad dependency: {0} -> {1}. Modules must be listed in dependency order.");
    static final DiagnosticType MISSING_ENTRY_ERROR = DiagnosticType.error("JSC_MISSING_ENTRY_ERROR", "required entry point \"{0}\" never provided");
    static final DiagnosticType MISSING_MODULE_ERROR = DiagnosticType.error("JSC_MISSING_MODULE_ERROR", "unknown module \"{0}\" specified in entry point spec");
    private CompilerOptions options = null;
    private PassConfig passes = null;
    private final ArrayList<CompilerInput> externs = new ArrayList();
    private JSChunkGraph moduleGraph;
    private ModuleLoader moduleLoader;
    private final Map<String, CompilerInput.ModuleType> moduleTypesByName;
    private ErrorManager errorManager;
    private WarningsGuard warningsGuard;
    private final LinkedHashSet<String> injectedLibraries = new LinkedHashSet();
    private Node lastInjectedLibrary;
    private Node externsRoot;
    private Node jsRoot;
    private Node externAndJsRoot;
    private String lastJsSource = null;
    private FeatureSet featureSet;
    private final Map<InputId, CompilerInput> inputsById = new ConcurrentHashMap<InputId, CompilerInput>();
    private final Map<String, Node> scriptNodeByFilename = new ConcurrentHashMap<String, Node>();
    private ImmutableMap<String, String> inputPathByWebpackId;
    private AbstractCompiler.LocaleData localeDataValueMap;
    private StaticScope transpilationNamespace;
    private final ConcurrentHashMap<String, SourceFile> sourceMapOriginalSources = new ConcurrentHashMap();
    ConcurrentHashMap<String, SourceMapInput> inputSourceMaps = new ConcurrentHashMap();
    private Map<String, List<Comment>> commentsPerFile = new ConcurrentHashMap<String, List<Comment>>();
    private SourceMap sourceMap;
    private String externExports = null;
    private UniqueIdSupplier uniqueIdSupplier = new UniqueIdSupplier();
    private int uniqueNameId = 0;
    private boolean hasRegExpGlobalReferences = true;
    private boolean runJ2clPasses = false;
    CodingConvention defaultCodingConvention = new ClosureCodingConvention();
    private JSTypeRegistry typeRegistry;
    private ColorRegistry colorRegistry;
    private volatile Config parserConfig = null;
    private volatile Config externsParserConfig = null;
    private ReverseAbstractInterpreter abstractInterpreter;
    private TypeValidator typeValidator;
    private PhaseOptimizer phaseOptimizer = null;
    public PerformanceTracker tracker;
    private ImmutableMap<String, java.util.function.Supplier<Node>> runtimeLibraryTypedAsts;
    private Set<String> forwardDeclaredTypes = new HashSet<String>();
    private boolean typeCheckingHasRun = false;
    private final ErrorReporter oldErrorReporter = RhinoErrorReporter.forOldRhino(this);
    public static final DiagnosticType OPTIMIZE_LOOP_ERROR = DiagnosticType.error("JSC_OPTIMIZE_LOOP_ERROR", "Exceeded max number of optimization iterations: {0}");
    public static final DiagnosticType MOTION_ITERATIONS_ERROR = DiagnosticType.error("JSC_MOTION_ITERATIONS_ERROR", "Exceeded max number of code motion iterations: {0}");
    private final CompilerExecutor compilerExecutor = this.createCompilerExecutor();
    public static final Logger logger = Logger.getLogger("com.google.javascript.jscomp");
    private final PrintStream outStream;
    private volatile double progress = 0.0;
    private String lastPassName;
    private ImmutableSet<String> externProperties = null;
    private AccessorSummary accessorSummary = null;
    private static final Joiner pathJoiner = Joiner.on(Platform.getFileSeperator());
    private int changeStamp = 1;
    private final Timeline<Node> changeTimeline = new Timeline();
    private final Timeline<Node> deleteTimeline = new Timeline();
    private final ResolvedSourceMap resolvedSourceMap = new ResolvedSourceMap();
    private ImmutableMap<SourceFile, java.util.function.Supplier<Node>> typedAstFilesystem;
    private static final DiagnosticType EMPTY_MODULE_LIST_ERROR = DiagnosticType.error("JSC_EMPTY_MODULE_LIST_ERROR", "At least one module must be provided");
    private static final DiagnosticType EMPTY_ROOT_MODULE_ERROR = DiagnosticType.error("JSC_EMPTY_ROOT_MODULE_ERROR", "Root module ''{0}'' must contain at least one source code input");
    static final DiagnosticType DUPLICATE_INPUT = DiagnosticType.error("JSC_DUPLICATE_INPUT", "Duplicate input: {0}");
    static final DiagnosticType DUPLICATE_EXTERN_INPUT = DiagnosticType.error("JSC_DUPLICATE_EXTERN_INPUT", "Duplicate extern input: {0}");
    private final PassFactory validityCheck = PassFactory.builder().setName("validityCheck").setRunInFixedPointLoop(true).setInternalFactory(ValidityCheck::new).setFeatureSetForChecks().build();
    private TypedScopeCreator typedScopeCreator;
    private TypedScope topScope = null;
    private static final InputId SYNTHETIC_CODE_INPUT_ID = new InputId(" [synthetic:input] ");
    @VisibleForTesting
    final SourceFile SYNTHETIC_EXTERNS_FILE = SourceFile.fromCode(" [synthetic:externs] ", "");
    @Nullable
    private CompilerInput syntheticExternsInput;
    protected final RecentChange recentChange = new RecentChange();
    private final List<CodeChangeHandler> codeChangeHandlers = new ArrayList<CodeChangeHandler>();
    private final Map<Class<?>, IndexProvider<?>> indexProvidersByType = new LinkedHashMap();
    private IdGenerator crossModuleIdGenerator = new IdGenerator();
    private Map<String, Integer> cssNames = null;
    private VariableMap variableMap = null;
    private VariableMap propertyMap = null;
    private VariableMap stringMap = null;
    private VariableMap instrumentationMapping = null;
    private String idGeneratorMap = null;
    private final Set<String> exportedNames = new LinkedHashSet<String>();
    private ModuleMetadataMap moduleMetadataMap;
    private ModuleMap moduleMap;

    public Compiler() {
        this((PrintStream)null);
    }

    public Compiler(PrintStream outStream) {
        this.addChangeHandler(this.recentChange);
        this.outStream = outStream;
        this.moduleTypesByName = new HashMap<String, CompilerInput.ModuleType>();
    }

    public Compiler(ErrorManager errorManager) {
        this();
        this.setErrorManager(errorManager);
    }

    public void setErrorManager(ErrorManager errorManager) {
        Preconditions.checkNotNull(errorManager, "the error manager cannot be null");
        this.errorManager = new ThreadSafeDelegatingErrorManager(errorManager);
    }

    private MessageFormatter createMessageFormatter() {
        boolean colorize = this.options.shouldColorizeErrorOutput();
        return this.options.errorFormat.toFormatter(this, colorize);
    }

    public void initOptions(CompilerOptions options) {
        this.options = options;
        this.setFeatureSet(options.getLanguageIn().toFeatureSet());
        if (this.errorManager == null) {
            if (this.outStream == null) {
                this.setErrorManager(new LoggerErrorManager(this.createMessageFormatter(), logger));
            } else {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                builder.add(new PrintStreamErrorReportGenerator(this.createMessageFormatter(), this.outStream, options.summaryDetailLevel));
                builder.addAll(options.getExtraReportGenerators());
                this.setErrorManager(new SortingErrorManager((Set<SortingErrorManager.ErrorReportGenerator>)((Object)builder.build())));
            }
        }
        this.moduleLoader = ModuleLoader.EMPTY;
        this.reconcileOptionsWithGuards();
        if (!options.isTypecheckingEnabled()) {
            options.setUseTypesForLocalOptimization(false);
            options.setUseTypesForOptimization(false);
        }
        if (options.assumeForwardDeclaredForMissingTypes) {
            this.forwardDeclaredTypes = new AbstractSet<String>(){

                @Override
                public boolean contains(Object o) {
                    return true;
                }

                @Override
                public boolean add(String e) {
                    return false;
                }

                @Override
                public Iterator<String> iterator() {
                    return Collections.emptyIterator();
                }

                @Override
                public int size() {
                    return 0;
                }
            };
        }
        this.initWarningsGuard(options.getWarningsGuard());
        if (this.isDebugLoggingEnabled()) {
            options.setPrintConfig(true);
        }
        if (options.isCheckingMissingOverrideTypes()) {
            options.setParseJsDocDocumentation(Config.JsDocParsing.INCLUDE_ALL_COMMENTS);
        }
    }

    public void printConfig() {
        if (this.isDebugLoggingEnabled()) {
            this.logToFile("externs.log", this.externs::toString);
            this.logToFile("inputs.json", () -> Iterables.toString(this.moduleGraph.getAllInputs()));
            this.logToFile("options.log", () -> this.options.toString());
            this.logToFile("warningsGuard.log", () -> this.warningsGuard.toString());
        } else {
            PrintStream err = System.err;
            err.println("==== Externs ====");
            err.println(this.externs);
            err.println("==== Inputs ====");
            err.println(Iterables.toString(this.moduleGraph.getAllInputs()));
            err.println("==== CompilerOptions ====");
            err.println(this.options);
            err.println("==== WarningsGuard ====");
            err.println(this.warningsGuard);
        }
    }

    private void logToFile(String logFileName, java.util.function.Supplier<String> logStringSupplier) {
        try (LogFile log = this.createOrReopenLog(this.getClass(), logFileName, new String[0]);){
            log.log(logStringSupplier);
        }
    }

    private void initWarningsGuard(WarningsGuard warningsGuard) {
        ImmutableList.Builder guards = ImmutableList.builder();
        ((ImmutableList.Builder)((ImmutableList.Builder)guards.add(new J2clSuppressWarningsGuard())).add(new SuppressDocWarningsGuard(this, DiagnosticGroups.getRegisteredGroups()))).add(warningsGuard);
        if (this.options != null && this.options.shouldSkipUnsupportedPasses()) {
            guards.add(new DiagnosticGroupWarningsGuard(DiagnosticGroups.FEATURES_NOT_SUPPORTED_BY_PASS, CheckLevel.WARNING));
        }
        this.warningsGuard = new ComposeWarningsGuard((List<WarningsGuard>)((Object)guards.build()));
    }

    protected void reconcileOptionsWithGuards() {
        if (this.options.enables(DiagnosticGroups.CHECK_TYPES)) {
            this.options.checkTypes = true;
        } else if (this.options.disables(DiagnosticGroups.CHECK_TYPES)) {
            this.options.checkTypes = false;
        } else if (!this.options.checkTypes) {
            this.options.setWarningLevel(DiagnosticGroup.forType(RhinoErrorReporter.TYPE_PARSE_ERROR), CheckLevel.OFF);
        }
        if (!this.options.checkTypes) {
            this.options.setWarningLevel(DiagnosticGroups.BOUNDED_GENERICS, CheckLevel.OFF);
        }
        if (!this.options.checkSymbols && !this.options.enables(DiagnosticGroups.CHECK_VARIABLES)) {
            this.options.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.OFF);
        }
        if (this.options.skipNonTranspilationPasses && !this.options.enables(DiagnosticGroups.CHECK_VARIABLES)) {
            this.options.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.OFF);
        }
        if (this.options.skipNonTranspilationPasses && !this.options.enables(DiagnosticGroups.MISSING_PROVIDE)) {
            this.options.setWarningLevel(DiagnosticGroups.MISSING_PROVIDE, CheckLevel.OFF);
        }
    }

    @Override
    @Nullable
    java.util.function.Supplier<Node> getTypedAstDeserializer(SourceFile file) {
        if (this.typedAstFilesystem == null) {
            return null;
        }
        java.util.function.Supplier<Node> ast = this.typedAstFilesystem.get(file);
        Preconditions.checkState(ast != null || file.equals(this.SYNTHETIC_EXTERNS_FILE), "TypedAST filesystem initialized, but missing requested file: %s", (Object)file);
        return ast;
    }

    @GwtIncompatible
    public final void initWithTypedAstFilesystem(List<SourceFile> externs, List<SourceFile> sources, CompilerOptions options, InputStream typedAstListStream) {
        ImmutableCollection files = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(externs)).addAll(sources)).build();
        this.initTypedAstFilesystem((ImmutableList<SourceFile>)files, typedAstListStream, options);
        this.init(externs, sources, options);
    }

    @GwtIncompatible
    public void initModulesWithTypedAstFilesystem(List<SourceFile> externs, List<JSChunk> modules, CompilerOptions options, InputStream typedAstListStream) {
        ImmutableList.Builder filesBuilder = ImmutableList.builder();
        filesBuilder.addAll(externs);
        for (JSChunk chunk : modules) {
            for (CompilerInput input : chunk.getInputs()) {
                filesBuilder.add(input.getSourceFile());
            }
        }
        ImmutableCollection files = filesBuilder.build();
        this.initTypedAstFilesystem((ImmutableList<SourceFile>)files, typedAstListStream, options);
        this.initModules(externs, modules, options);
    }

    @GwtIncompatible
    private void initTypedAstFilesystem(ImmutableList<SourceFile> existingSourceFiles, InputStream typedAstListStream, CompilerOptions options) {
        Preconditions.checkState(this.typedAstFilesystem == null);
        options.setMergedPrecompiledLibraries(true);
        this.setLifeCycleStage(AbstractCompiler.LifeCycleStage.COLORS_AND_SIMPLIFIED_JSDOC);
        boolean deserializeTypes = options.requiresTypesForOptimization();
        TypedAstDeserializer.DeserializedAst astData = TypedAstDeserializer.deserializeFullAst(this, this.SYNTHETIC_EXTERNS_FILE, existingSourceFiles, typedAstListStream, deserializeTypes);
        this.typedAstFilesystem = astData.getFilesystem();
        this.externProperties = astData.getExternProperties();
        this.colorRegistry = astData.getColorRegistry().orNull();
    }

    @Override
    @GwtIncompatible
    public void initRuntimeLibraryTypedAsts(Optional<ColorPool.Builder> colorPoolBuilder) {
        Preconditions.checkState(this.runtimeLibraryTypedAsts == null);
        String path = String.join((CharSequence)"", "/runtime_libs.typedast");
        TypedAstDeserializer.DeserializedAst astData = TypedAstDeserializer.deserializeRuntimeLibraries(this, this.SYNTHETIC_EXTERNS_FILE, colorPoolBuilder, Compiler.class.getResourceAsStream(path));
        LinkedHashMap<String, java.util.function.Supplier> runtimeLibraryTypedAsts = new LinkedHashMap<String, java.util.function.Supplier>();
        for (Map.Entry library : astData.getFilesystem().entrySet()) {
            runtimeLibraryTypedAsts.computeIfAbsent(((SourceFile)library.getKey()).getName(), f -> (java.util.function.Supplier)library.getValue());
        }
        this.runtimeLibraryTypedAsts = ImmutableMap.copyOf(runtimeLibraryTypedAsts);
    }

    public final void init(List<SourceFile> externs, List<SourceFile> sources, CompilerOptions options) {
        JSChunk module = new JSChunk("$strong$");
        for (SourceFile source : sources) {
            module.add(new CompilerInput(source, false));
        }
        ArrayList<JSChunk> modules = new ArrayList<JSChunk>(1);
        modules.add(module);
        this.initModules(externs, modules, options);
        this.addFilesToSourceMap(sources);
    }

    public void initModules(List<SourceFile> externs, List<JSChunk> modules, CompilerOptions options) {
        this.initOptions(options);
        this.checkFirstModule(modules);
        this.externs.clear();
        for (SourceFile file : externs) {
            this.externs.add(new CompilerInput(file, true));
        }
        try {
            this.moduleGraph = new JSChunkGraph(modules);
        }
        catch (JSChunkGraph.ChunkDependenceException e) {
            this.report(JSError.make(MODULE_DEPENDENCY_ERROR, e.getChunk().getName(), e.getDependentChunk().getName()));
            return;
        }
        this.fillEmptyModules(this.getModules());
        this.commentsPerFile = new ConcurrentHashMap<String, List<Comment>>(this.moduleGraph.getInputCount());
        this.initBasedOnOptions();
        this.initInputsByIdMap();
        this.initAST();
        try (LogFile moduleGraphLog = this.createOrReopenLog(this.getClass(), "chunk_graph.dot", new String[0]);){
            moduleGraphLog.log(DotFormatter.toDot(this.moduleGraph.toGraphvizGraph()));
        }
    }

    public void initBasedOnOptions() {
        this.inputSourceMaps.putAll(this.options.inputSourceMaps);
        if (this.options.sourceMapOutputPath != null) {
            this.sourceMap = this.options.sourceMapFormat.getInstance();
            this.sourceMap.setPrefixMappings(this.options.sourceMapLocationMappings);
            if (this.options.applyInputSourceMaps) {
                this.sourceMap.setSourceFileMapping(this);
                if (this.options.sourceMapIncludeSourcesContent) {
                    for (SourceMapInput inputSourceMap : this.inputSourceMaps.values()) {
                        this.addSourceMapSourceFiles(inputSourceMap);
                    }
                }
            }
        }
    }

    private void checkFirstModule(List<JSChunk> modules) {
        if (modules.isEmpty()) {
            this.report(JSError.make(EMPTY_MODULE_LIST_ERROR, new String[0]));
        } else if (modules.get(0).getInputs().isEmpty() && modules.size() > 1) {
            this.report(JSError.make(EMPTY_ROOT_MODULE_ERROR, modules.get(0).getName()));
        }
    }

    public static String joinPathParts(String ... pathParts) {
        return pathJoiner.join(pathParts);
    }

    private void fillEmptyModules(Iterable<JSChunk> modules) {
        for (JSChunk module : modules) {
            if (module.getName().equals("$weak$") || !module.getInputs().isEmpty()) continue;
            CompilerInput input = new CompilerInput(SourceFile.fromCode(Compiler.createFillFileName(module.getName()), ""));
            input.setCompiler(this);
            module.add(input);
        }
    }

    public void rebuildInputsFromModules() {
        this.initInputsByIdMap();
    }

    void initInputsByIdMap() {
        this.inputsById.clear();
        for (CompilerInput input : this.externs) {
            CompilerInput previous = this.putCompilerInput(input);
            if (previous == null) continue;
            this.report(JSError.make(DUPLICATE_EXTERN_INPUT, input.getName()));
        }
        boolean hasZone = false;
        for (CompilerInput input : this.moduleGraph.getAllInputs()) {
            CompilerInput previous;
            if (input.getName().endsWith("packages/zone.js/lib/zone.closure.js")) {
                hasZone = true;
            }
            if ((previous = this.putCompilerInput(input)) == null) continue;
            this.report(JSError.make(DUPLICATE_INPUT, input.getName()));
        }
        if (hasZone && !this.options.allowsZoneJsWithAsyncFunctionsInOutput() && this.options.getOutputFeatureSet().contains(FeatureSet.Feature.ASYNC_FUNCTIONS)) {
            throw new UnsupportedOperationException("ZoneJS is incompatible with language level ES2017 or higher (See go/ngissue/31730)\nPlease set `--language_out=ECMASCRIPT_2016` (or older) in your flags.");
        }
    }

    private void initAST() {
        this.jsRoot = IR.root(new Node[0]);
        this.externsRoot = IR.root(new Node[0]);
        this.externAndJsRoot = IR.root(this.externsRoot, this.jsRoot);
        if (this.typedAstFilesystem != null) {
            this.getSynthesizedExternsInput();
        }
    }

    public Result compile(SourceFile extern, SourceFile input, CompilerOptions options) {
        return this.compile(ImmutableList.of(extern), ImmutableList.of(input), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result compile(List<SourceFile> externs, List<SourceFile> inputs, CompilerOptions options) {
        Preconditions.checkState(this.jsRoot == null);
        try {
            this.init(externs, inputs, options);
            if (options.printConfig) {
                this.printConfig();
            }
            if (!this.hasErrors()) {
                this.parseForCompilation();
            }
            if (!this.hasErrors()) {
                if (options.getInstrumentForCoverageOnly()) {
                    this.instrumentForCoverage();
                } else {
                    this.stage1Passes();
                    if (!this.hasErrors()) {
                        this.stage2Passes();
                        if (!this.hasErrors()) {
                            this.stage3Passes();
                        }
                    }
                }
                this.performPostCompilationTasks();
            }
        }
        finally {
            this.generateReport();
        }
        return this.getResult();
    }

    public void generateReport() {
        Tracer t = this.newTracer("generateReport");
        this.errorManager.generateReport();
        this.stopTracer(t, "generateReport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result compileModules(List<SourceFile> externs, List<JSChunk> modules, CompilerOptions options) {
        Preconditions.checkState(this.jsRoot == null);
        try {
            this.initModules(externs, modules, options);
            if (options.printConfig) {
                this.printConfig();
            }
            if (!this.hasErrors()) {
                this.parseForCompilation();
            }
            if (!this.hasErrors()) {
                if (options.getInstrumentForCoverageOnly()) {
                    this.instrumentForCoverage();
                } else {
                    this.stage1Passes();
                    if (!this.hasErrors()) {
                        this.stage2Passes();
                        if (!this.hasErrors()) {
                            this.stage3Passes();
                        }
                    }
                }
                this.performPostCompilationTasks();
            }
        }
        finally {
            this.generateReport();
        }
        return this.getResult();
    }

    public void stage1Passes() {
        Preconditions.checkState(this.moduleGraph != null, "No inputs. Did you call init() or initModules()?");
        Preconditions.checkState(!this.hasErrors());
        Preconditions.checkState(!this.options.getInstrumentForCoverageOnly());
        this.runInCompilerThread(() -> {
            this.performChecks();
            return null;
        });
    }

    public void stage2Passes() {
        Preconditions.checkState(this.moduleGraph != null, "No inputs. Did you call init() or initModules()?");
        Preconditions.checkState(!this.hasErrors());
        Preconditions.checkState(!this.options.getInstrumentForCoverageOnly());
        JSChunk weakModule = this.moduleGraph.getChunkByName("$weak$");
        if (weakModule != null) {
            for (CompilerInput i : this.moduleGraph.getAllInputs()) {
                if (!i.getSourceFile().isWeak()) continue;
                Preconditions.checkState(i.getChunk() == weakModule, "Expected all weak files to be in the weak module.");
            }
        }
        this.runInCompilerThread(() -> {
            if (this.options.shouldOptimize()) {
                this.performTranspilationAndOptimizations();
            }
            return null;
        });
    }

    public void stage3Passes() {
        Preconditions.checkState(this.moduleGraph != null, "No inputs. Did you call init() or initModules()?");
        Preconditions.checkState(!this.hasErrors());
        Preconditions.checkState(!this.options.getInstrumentForCoverageOnly());
        this.runInCompilerThread(() -> {
            if (this.options.shouldOptimize()) {
                this.performFinalizations();
            }
            return null;
        });
    }

    public void disableThreads() {
        this.compilerExecutor.disableThreads();
    }

    public void setTimeout(int timeout) {
        this.compilerExecutor.setTimeout(timeout);
    }

    <T> T runInCompilerThread(Callable<T> callable) {
        return this.compilerExecutor.runInCompilerThread(callable, this.options != null && this.options.getTracerMode().isOn());
    }

    private void performChecks() {
        if (this.options.skipNonTranspilationPasses) {
            this.whitespaceOnlyPasses();
            if (this.options.needsTranspilationFrom(this.options.getLanguageIn().toFeatureSet())) {
                this.transpileAndDontCheck();
            }
        } else {
            this.check();
        }
    }

    public void performPostCompilationTasks() {
        this.runInCompilerThread(() -> {
            this.performPostCompilationTasksInternal();
            return null;
        });
    }

    private void performPostCompilationTasksInternal() {
        if (this.options.devMode == CompilerOptions.DevMode.START_AND_END) {
            this.runValidityCheck();
        }
        this.setProgress(1.0, "recordFunctionInformation");
        if (this.tracker != null) {
            if (this.options.getTracerOutput() == null) {
                this.tracker.outputTracerReport(this.outStream);
            } else {
                try (PrintStream out = new PrintStream(Files.newOutputStream(this.options.getTracerOutput(), new OpenOption[0]));){
                    this.tracker.outputTracerReport(out);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void instrumentForCoverage() {
        Preconditions.checkState(this.moduleGraph != null, "No inputs. Did you call init() or initModules()?");
        Preconditions.checkState(!this.hasErrors());
        this.runInCompilerThread(() -> {
            Preconditions.checkState(this.options.getInstrumentForCoverageOnly());
            Preconditions.checkState(!this.hasErrors());
            if (this.options.getInstrumentForCoverageOption() != CompilerOptions.InstrumentOption.NONE) {
                this.instrumentForCoverageInternal(this.options.getInstrumentForCoverageOption());
            }
            return null;
        });
    }

    private void instrumentForCoverageInternal(CompilerOptions.InstrumentOption instrumentForCoverageOption) {
        Tracer tracer = this.newTracer("instrumentationPass");
        this.process(new CoverageInstrumentationPass(this, CoverageInstrumentationPass.CoverageReach.ALL, instrumentForCoverageOption, this.options.getProductionInstrumentationArrayName()));
        this.stopTracer(tracer, "instrumentationPass");
    }

    public void parseForCompilation() {
        this.runInCompilerThread(() -> {
            this.parseForCompilationInternal();
            return null;
        });
    }

    private void parseForCompilationInternal() {
        this.setProgress(0.0, null);
        CompilerOptionsPreprocessor.preprocess(this.options);
        this.maybeSetTracker();
        this.parseInputs();
        this.setProgress(0.15, "parse");
    }

    public void parse() {
        this.parseInputs();
    }

    public Node parse(SourceFile file) {
        this.initCompilerOptionsIfTesting();
        logger.finest("Parsing: " + file.getName());
        return new JsAst(file).getAstRoot(this);
    }

    PassConfig getPassConfig() {
        if (this.passes == null) {
            this.passes = this.createPassConfigInternal();
        }
        return this.passes;
    }

    protected PassConfig createPassConfigInternal() {
        return new DefaultPassConfig(this.options);
    }

    public void setPassConfig(PassConfig passes) {
        Preconditions.checkNotNull(passes);
        Preconditions.checkState(this.passes == null, "setPassConfig was already called");
        this.passes = passes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whitespaceOnlyPasses() {
        this.runCustomPasses(CustomPassExecutionTime.BEFORE_CHECKS);
        Tracer t = this.newTracer("runWhitespaceOnlyPasses");
        try {
            for (PassFactory pf : this.getPassConfig().getWhitespaceOnlyPasses()) {
                pf.create(this).process(this.externsRoot, this.jsRoot);
            }
        }
        finally {
            this.stopTracer(t, "runWhitespaceOnlyPasses");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transpileAndDontCheck() {
        Tracer t = this.newTracer("runTranspileOnlyPasses");
        try {
            for (PassFactory pf : this.getPassConfig().getTranspileOnlyPasses()) {
                if (this.hasErrors()) {
                    return;
                }
                pf.create(this).process(this.externsRoot, this.jsRoot);
            }
        }
        finally {
            this.stopTracer(t, "runTranspileOnlyPasses");
        }
    }

    private PhaseOptimizer createPhaseOptimizer() {
        PhaseOptimizer phaseOptimizer = new PhaseOptimizer(this, this.tracker);
        if (this.options.devMode == CompilerOptions.DevMode.EVERY_PASS) {
            phaseOptimizer.setValidityCheck(this.validityCheck);
        }
        if (this.options.getCheckDeterminism()) {
            phaseOptimizer.setPrintAstHashcodes(true);
        }
        return phaseOptimizer;
    }

    void check() {
        this.runCustomPasses(CustomPassExecutionTime.BEFORE_CHECKS);
        this.phaseOptimizer = this.createPhaseOptimizer().withProgress(new PhaseOptimizer.ProgressRange(this.getProgress(), 1.0));
        this.phaseOptimizer.consume(this.getPassConfig().getChecks());
        this.phaseOptimizer.process(this.externsRoot, this.jsRoot);
        if (this.hasErrors()) {
            return;
        }
        this.runCustomPasses(CustomPassExecutionTime.BEFORE_OPTIMIZATIONS);
        this.phaseOptimizer = null;
    }

    @Override
    void setExternExports(String externExports) {
        this.externExports = externExports;
    }

    @Override
    void process(CompilerPass p) {
        p.process(this.externsRoot, this.jsRoot);
    }

    private void runValidityCheck() {
        this.validityCheck.create(this).process(this.externsRoot, this.jsRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCustomPasses(CustomPassExecutionTime executionTime) {
        if (this.options.customPasses != null) {
            Tracer t = this.newTracer("runCustomPasses");
            try {
                for (CompilerPass p : this.options.customPasses.get(executionTime)) {
                    this.process(p);
                }
            }
            finally {
                this.stopTracer(t, "runCustomPasses");
            }
        }
    }

    @Override
    final void beforePass(String passName) {
        super.beforePass(passName);
    }

    @Override
    final void afterPass(String passName) {
        super.afterPass(passName);
        this.maybePrintSourceAfterEachPass(passName);
    }

    private void maybePrintSourceAfterEachPass(String passName) {
        if (!this.options.printSourceAfterEachPass) {
            return;
        }
        String currentJsSource = this.getCurrentJsSource();
        if (currentJsSource.equals(this.lastJsSource)) {
            return;
        }
        if (this.isDebugLoggingEnabled()) {
            try (LogFile log = this.createOrReopenIndexedLog(this.getClass(), "source_after_pass", passName);){
                log.log(currentJsSource);
            }
        } else {
            System.err.println();
            System.err.println("// " + passName + " yields:");
            System.err.println("// ************************************");
            System.err.println(currentJsSource);
            System.err.println("// ************************************");
        }
        this.lastJsSource = currentJsSource;
    }

    final String getCurrentJsSource() {
        this.resetAndIntitializeSourceMap();
        List<String> fileNameRegexList = this.options.filesToPrintAfterEachPassRegexList;
        List<String> moduleNameRegexList = this.options.chunksToPrintAfterEachPassRegexList;
        LinkedHashSet<String> qnameSet = new LinkedHashSet<String>(this.options.qnameUsesToPrintAfterEachPassList);
        StringBuilder builder = new StringBuilder();
        if (fileNameRegexList.isEmpty() && moduleNameRegexList.isEmpty() && qnameSet.isEmpty()) {
            return this.toSource();
        }
        if (!fileNameRegexList.isEmpty()) {
            Preconditions.checkNotNull(this.externsRoot);
            Preconditions.checkNotNull(this.jsRoot);
            for (Node r : ImmutableList.of(this.externsRoot, this.jsRoot)) {
                block1: for (Node fileNode = r.getFirstChild(); fileNode != null; fileNode = fileNode.getNext()) {
                    String fileName = fileNode.getSourceFileName();
                    for (String regex : fileNameRegexList) {
                        if (!fileName.matches(regex)) continue;
                        String source = "// " + fileName + "\n" + this.toSource(fileNode);
                        builder.append(source);
                        continue block1;
                    }
                }
            }
            if (builder.length() == 0) {
                builder.append("// No files matched any of: ").append(fileNameRegexList);
            }
        }
        if (!moduleNameRegexList.isEmpty()) {
            block3: for (JSChunk jsModule : this.getModules()) {
                for (String regex : moduleNameRegexList) {
                    if (!jsModule.getName().matches(regex)) continue;
                    String source = "// module '" + jsModule.getName() + "'\n" + this.toSource(jsModule);
                    builder.append(source);
                    continue block3;
                }
            }
            if (builder.length() == 0) {
                throw new RuntimeException("No modules matched any of: " + moduleNameRegexList);
            }
        }
        if (!qnameSet.isEmpty()) {
            LinkedHashMultimap originalToNewQNameMap = LinkedHashMultimap.create();
            Stream<Node> statementStream = this.getTopLevelStatements(this.jsRoot).filter(statement -> NodeUtil.has(statement, n -> {
                Preconditions.checkNotNull(n);
                if (!n.isQualifiedName()) {
                    return false;
                }
                String qname = n.getQualifiedName();
                if (qnameSet.contains(qname)) {
                    return true;
                }
                String originalQname = n.getOriginalQualifiedName();
                if (originalQname != null && qnameSet.contains(originalQname)) {
                    originalToNewQNameMap.put(originalQname, qname);
                    return true;
                }
                return false;
            }, node -> true));
            builder.append("//\n");
            builder.append("// closure-compiler: Printing all of the top-level statements\n");
            builder.append("// that contain references to these qualified names.\n");
            builder.append("//\n");
            for (String qname : qnameSet) {
                builder.append(SimpleFormat.format("// '%s'\n", qname));
                for (String newName : originalToNewQNameMap.get(qname)) {
                    builder.append(SimpleFormat.format("// '%s' (originally '%s')\n", newName, qname));
                }
            }
            builder.append("//\n");
            statementStream.forEach(statement -> builder.append(SimpleFormat.format("// %s\n", statement.getLocation())).append(this.toSource((Node)statement)).append("\n"));
        }
        return builder.toString();
    }

    private Stream<Node> getTopLevelStatements(Node root) {
        final Stream.Builder builder = Stream.builder();
        NodeTraversal.traverse(this, root, new NodeTraversal.AbstractPreOrderCallback(){

            @Override
            public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
                if (NodeUtil.isStatement(n)) {
                    builder.add(n);
                    return false;
                }
                return true;
            }
        });
        return builder.build();
    }

    @Override
    @Nullable
    public final Node getScriptNode(String filename) {
        return this.scriptNodeByFilename.get(Preconditions.checkNotNull(filename));
    }

    Tracer newTracer(String passName) {
        String comment = passName + (this.recentChange.hasCodeChanged() ? " on recently changed AST" : "");
        if (this.options.getTracerMode().isOn() && this.tracker != null) {
            this.tracker.recordPassStart(passName, true);
        }
        return new Tracer("Compiler", comment);
    }

    void stopTracer(Tracer t, String passName) {
        long result = t.stop();
        if (this.options.getTracerMode().isOn() && this.tracker != null) {
            this.tracker.recordPassStop(passName, result);
        }
    }

    public Result getResult() {
        HashSet<SourceFile> transpiledFiles = new HashSet<SourceFile>();
        if (this.jsRoot != null) {
            for (Node scriptNode = this.jsRoot.getFirstChild(); scriptNode != null; scriptNode = scriptNode.getNext()) {
                if (!scriptNode.getBooleanProp(Node.TRANSPILED)) continue;
                transpiledFiles.add(this.getSourceFileByName(scriptNode.getSourceFileName()));
            }
        }
        return new Result(this.getErrors(), this.getWarnings(), this.variableMap, this.propertyMap, null, this.stringMap, this.instrumentationMapping, this.sourceMap, this.externExports, this.cssNames, this.idGeneratorMap, transpiledFiles);
    }

    public ImmutableList<JSError> getErrors() {
        return this.errorManager == null ? ImmutableList.of() : this.errorManager.getErrors();
    }

    public ImmutableList<JSError> getWarnings() {
        return this.errorManager == null ? ImmutableList.of() : this.errorManager.getWarnings();
    }

    @Override
    public Node getRoot() {
        return this.externAndJsRoot;
    }

    @Override
    FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    @Override
    void setFeatureSet(FeatureSet fs) {
        this.featureSet = fs;
    }

    @Override
    UniqueIdSupplier getUniqueIdSupplier() {
        return this.uniqueIdSupplier;
    }

    @Deprecated
    private int nextUniqueNameId() {
        return this.uniqueNameId++;
    }

    @Deprecated
    @VisibleForTesting
    void resetUniqueNameId() {
        this.uniqueNameId = 0;
    }

    @Override
    @Deprecated
    Supplier<String> getUniqueNameIdSupplier() {
        return () -> String.valueOf(this.nextUniqueNameId());
    }

    @Override
    boolean areNodesEqualForInlining(Node n1, Node n2) {
        if (this.options.shouldAmbiguateProperties() || this.options.shouldDisambiguateProperties()) {
            return n1.isEquivalentToTyped(n2);
        }
        return n1.isEquivalentTo(n2);
    }

    @Override
    public CompilerInput getInput(InputId id) {
        if (id == null) {
            return null;
        }
        return this.inputsById.get(id);
    }

    private CompilerInput putCompilerInput(CompilerInput input) {
        input.setCompiler(this);
        return this.inputsById.put(input.getInputId(), input);
    }

    @Override
    @Nullable
    JSChunkGraph getModuleGraph() {
        return this.moduleGraph;
    }

    @Nullable
    public Iterable<JSChunk> getModules() {
        return this.moduleGraph != null ? this.moduleGraph.getAllChunks() : null;
    }

    @Override
    public void clearJSTypeRegistry() {
        this.typeRegistry = null;
        this.typeValidator = null;
        this.abstractInterpreter = null;
    }

    @Override
    public boolean isTypeRegistryCleared() {
        return this.typeCheckingHasRun && this.typeRegistry == null;
    }

    @Override
    public JSTypeRegistry getTypeRegistry() {
        if (this.typeRegistry == null) {
            Preconditions.checkState(!this.hasTypeCheckingRun(), "Attempted to re-initialize JSTypeRegistry after it had been cleared");
            this.typeRegistry = new JSTypeRegistry(this.oldErrorReporter, this.forwardDeclaredTypes);
        }
        return this.typeRegistry;
    }

    @Override
    public ColorRegistry getColorRegistry() {
        return Preconditions.checkNotNull(this.colorRegistry, "Color registry has not been initialized yet");
    }

    @Override
    public void setColorRegistry(ColorRegistry colorRegistry) {
        Preconditions.checkState(this.runtimeLibraryTypedAsts != null);
        this.colorRegistry = colorRegistry;
    }

    @Override
    public void forwardDeclareType(String typeName) {
        this.forwardDeclaredTypes.add(typeName);
    }

    @Override
    void setTypeCheckingHasRun(boolean hasRun) {
        this.typeCheckingHasRun = hasRun;
    }

    @Override
    public boolean hasTypeCheckingRun() {
        return this.typeCheckingHasRun;
    }

    @Override
    public boolean hasOptimizationColors() {
        return this.colorRegistry != null;
    }

    @Override
    public ScopeCreator getTypedScopeCreator() {
        if (this.typedScopeCreator == null) {
            Preconditions.checkState(!this.hasTypeCheckingRun(), "Attempted to re-initialize TypedScopeCreator after it had been cleared");
            this.typedScopeCreator = new TypedScopeCreator(this);
        }
        return this.typedScopeCreator;
    }

    @Override
    void clearTypedScopeCreator() {
        this.typedScopeCreator = null;
    }

    DefaultPassConfig ensureDefaultPassConfig() {
        PassConfig passes = this.getPassConfig().getBasePassConfig();
        Preconditions.checkState(passes instanceof DefaultPassConfig, "PassConfigs must eventually delegate to the DefaultPassConfig");
        return (DefaultPassConfig)passes;
    }

    public SymbolTable buildKnownSymbolTable() {
        SymbolTable symbolTable = new SymbolTable(this, this.getTypeRegistry());
        if (this.typedScopeCreator != null) {
            symbolTable.addScopes(this.typedScopeCreator.getAllMemoizedScopes());
            symbolTable.addSymbolsFrom(this.typedScopeCreator);
        } else {
            symbolTable.findScopes(this.externsRoot, this.jsRoot);
        }
        GlobalNamespace globalNamespace = new GlobalNamespace(this, this.externsRoot, this.jsRoot);
        symbolTable.addSymbolsFrom(globalNamespace);
        ReferenceCollector refCollector = new ReferenceCollector(this, ReferenceCollector.DO_NOTHING_BEHAVIOR, new SyntacticScopeCreator(this));
        refCollector.process(this.getRoot());
        symbolTable.addSymbolsFrom(refCollector);
        PreprocessorSymbolTable preprocessorSymbolTable = this.ensureDefaultPassConfig().getPreprocessorSymbolTable();
        if (preprocessorSymbolTable != null) {
            symbolTable.addSymbolsFrom(preprocessorSymbolTable);
        }
        symbolTable.flattenGoogModuleExports();
        symbolTable.fillNamespaceReferences();
        symbolTable.fillPropertyScopes();
        symbolTable.fillThisReferences(this.externsRoot, this.jsRoot);
        symbolTable.fillPropertySymbols(this.externsRoot, this.jsRoot);
        symbolTable.fillSuperReferences(this.externsRoot, this.jsRoot);
        symbolTable.fillJSDocInfo(this.externsRoot, this.jsRoot);
        symbolTable.fillSymbolVisibility(this.externsRoot, this.jsRoot);
        symbolTable.fillGoogProvideModuleRequires(this.externsRoot, this.jsRoot);
        symbolTable.removeGeneratedSymbols();
        return symbolTable;
    }

    @Override
    public TypedScope getTopScope() {
        return this.topScope;
    }

    @Override
    void setTopScope(TypedScope x) {
        Preconditions.checkState(x == null || x.getParent() == null, x);
        this.topScope = x;
    }

    @Override
    public ReverseAbstractInterpreter getReverseAbstractInterpreter() {
        if (this.abstractInterpreter == null) {
            ChainableReverseAbstractInterpreter interpreter = new SemanticReverseAbstractInterpreter(this.getTypeRegistry());
            if (this.options.closurePass) {
                interpreter = new ClosureReverseAbstractInterpreter(this.getTypeRegistry()).append(interpreter).getFirst();
            }
            this.abstractInterpreter = interpreter;
        }
        return this.abstractInterpreter;
    }

    @Override
    TypeValidator getTypeValidator() {
        if (this.typeValidator == null) {
            Preconditions.checkState(!this.hasTypeCheckingRun(), "Attempted to re-initialize TypeValidator after it had been cleared");
            this.typeValidator = new TypeValidator(this);
        }
        return this.typeValidator;
    }

    @Override
    public Iterable<TypeMismatch> getTypeMismatches() {
        if (this.typeCheckingHasRun) {
            return this.getTypeValidator().getMismatches();
        }
        throw new RuntimeException("Can't ask for type mismatches before type checking.");
    }

    @Override
    StaticScope getTranspilationNamespace() {
        if (this.transpilationNamespace == null) {
            Preconditions.checkState(!this.getLifeCycleStage().isNormalized(), "cannot init transpilation namespace after optimizations phase, or information may be lost");
            GlobalNamespace gn = new GlobalNamespace(this, this.getExternsRoot(), this.getJsRoot());
            gn.setShouldTraverseScriptPredicate(script -> script.isFromExterns() || script.isFirstChildOf(this.getJsRoot()));
            gn.getNameForest();
            this.transpilationNamespace = gn;
        }
        return this.transpilationNamespace;
    }

    public void maybeSetTracker() {
        if (!this.options.getTracerMode().isOn()) {
            return;
        }
        this.tracker = new PerformanceTracker(this.externsRoot, this.jsRoot, this.options.getTracerMode());
        this.addChangeHandler(this.tracker.getCodeChangeHandler());
    }

    void initializeModuleLoader() {
        ModuleLoader.ModuleResolverFactory moduleResolverFactory = null;
        switch (this.options.getModuleResolutionMode()) {
            case BROWSER: {
                moduleResolverFactory = BrowserModuleResolver.FACTORY;
                break;
            }
            case NODE: {
                moduleResolverFactory = new NodeModuleResolver.Factory(this.processJsonInputs(this.moduleGraph.getAllInputs()));
                break;
            }
            case WEBPACK: {
                moduleResolverFactory = new WebpackModuleResolver.Factory(this.inputPathByWebpackId);
                break;
            }
            case BROWSER_WITH_TRANSFORMED_PREFIXES: {
                moduleResolverFactory = new BrowserWithTransformedPrefixesModuleResolver.Factory(this.options.getBrowserResolverPrefixReplacements());
            }
        }
        this.moduleLoader = ModuleLoader.builder().setModuleRoots(this.options.moduleRoots).setInputs(this.moduleGraph.getAllInputs()).setFactory(moduleResolverFactory).setPathResolver(ModuleLoader.PathResolver.RELATIVE).setPathEscaper(this.options.getPathEscaper()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node parseInputs() {
        boolean devMode = this.options.devMode != CompilerOptions.DevMode.OFF;
        this.externsRoot.detachChildren();
        this.jsRoot.detachChildren();
        this.scriptNodeByFilename.clear();
        Tracer tracer = this.newTracer("parseInputs");
        this.beforePass("parseInputs");
        try {
            Object object;
            if (this.options.numParallelThreads > 1) {
                new PrebuildAst(this, this.options.numParallelThreads).prebuild(this.externs);
            }
            for (CompilerInput compilerInput : this.externs) {
                Node node = Preconditions.checkNotNull(compilerInput.getAstRoot(this));
                if (this.hasErrors()) {
                    Node node2 = null;
                    return node2;
                }
                this.externsRoot.addChildToBack(node);
                this.scriptNodeByFilename.put(compilerInput.getSourceFile().getName(), node);
            }
            if (this.options.transformAMDToCJSModules) {
                this.processAMDModules(this.moduleGraph.getAllInputs());
            }
            if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES) || this.options.getProcessCommonJSModules()) {
                this.initializeModuleLoader();
            } else {
                this.moduleLoader = ModuleLoader.EMPTY;
            }
            if (this.options.getDependencyOptions().needsManagement()) {
                this.findModulesFromEntryPoints(this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES), this.options.getProcessCommonJSModules());
            } else if (this.options.needsTranspilationFrom(FeatureSet.ES2015_MODULES) || this.options.getProcessCommonJSModules()) {
                if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
                    this.parsePotentialModules(this.moduleGraph.getAllInputs());
                }
                HashMap<String, CompilerInput> inputModuleIdentifiers = new HashMap<String, CompilerInput>();
                for (CompilerInput compilerInput : this.moduleGraph.getAllInputs()) {
                    if (!compilerInput.getKnownProvides().isEmpty()) continue;
                    ModuleLoader.ModulePath modPath = this.moduleLoader.resolve(compilerInput.getSourceFile().getName());
                    inputModuleIdentifiers.put(modPath.toModuleName(), compilerInput);
                }
                HashMap<String, CompilerInput> hashMap = new HashMap<String, CompilerInput>();
                for (CompilerInput input2 : this.moduleGraph.getAllInputs()) {
                    for (String require : input2.getKnownRequiredSymbols()) {
                        if (!inputModuleIdentifiers.containsKey(require) || hashMap.containsKey(require)) continue;
                        hashMap.put(require, (CompilerInput)inputModuleIdentifiers.get(require));
                    }
                }
                for (CompilerInput input : hashMap.values()) {
                    input.setJsModuleType(CompilerInput.ModuleType.IMPORTED_SCRIPT);
                }
            }
            if (this.moduleLoader != null) {
                this.moduleLoader.setErrorHandler(this);
            }
            this.orderInputs();
            if (this.hasErrors()) {
                object = null;
                return object;
            }
            if (this.options.numParallelThreads > 1) {
                new PrebuildAst(this, this.options.numParallelThreads).prebuild(this.moduleGraph.getAllInputs());
            }
            for (CompilerInput compilerInput : this.moduleGraph.getAllInputs()) {
                Node node = Preconditions.checkNotNull(compilerInput.getAstRoot(this));
                if (devMode) {
                    this.runValidityCheck();
                    if (this.hasErrors()) {
                        CompilerInput input;
                        input = null;
                        return input;
                    }
                }
                if (this.options.sourceMapOutputPath != null || this.options.isExternExportsEnabled() || this.options.externExportsPath != null || !this.options.replaceStringsFunctionDescriptions.isEmpty()) {
                    SourceInformationAnnotator sia = CompilerOptions.DevMode.OFF.equals((Object)this.options.devMode) ? SourceInformationAnnotator.create() : SourceInformationAnnotator.createWithAnnotationChecks(compilerInput.getName());
                    NodeTraversal.traverse(this, node, sia);
                }
                if (NodeUtil.isFromTypeSummary(node)) {
                    compilerInput.setIsExtern();
                    this.externsRoot.addChildToBack(node);
                } else {
                    this.jsRoot.addChildToBack(node);
                }
                this.scriptNodeByFilename.put(compilerInput.getSourceFile().getName(), node);
            }
            if (this.hasErrors()) {
                object = null;
                return object;
            }
            object = this.externAndJsRoot;
            return object;
        }
        finally {
            this.afterPass("parseInputs");
            this.stopTracer(tracer, "parseInputs");
            if (this.typedAstFilesystem != null) {
                this.typedAstFilesystem = ImmutableMap.of(this.SYNTHETIC_EXTERNS_FILE, this.typedAstFilesystem.get(this.SYNTHETIC_EXTERNS_FILE));
            }
        }
    }

    void orderInputsWithLargeStack() {
        this.runInCompilerThread(() -> {
            Tracer tracer = this.newTracer("orderInputsWithLargeStack");
            try {
                this.orderInputs();
            }
            finally {
                this.stopTracer(tracer, "orderInputsWithLargeStack");
            }
            return null;
        });
    }

    void orderInputs() {
        this.maybeDoThreadedParsing();
        ImmutableList<CompilerInput> originalInputs = ImmutableList.copyOf(this.moduleGraph.getAllInputs());
        this.markExterns(originalInputs);
        boolean staleInputs = false;
        if (this.options.getDependencyOptions().needsManagement()) {
            for (CompilerInput input : this.moduleGraph.getAllInputs()) {
                for (String provide : input.getProvides()) {
                    this.forwardDeclareType(provide);
                }
            }
            try {
                this.moduleGraph.manageDependencies(this, this.options.getDependencyOptions());
                staleInputs = true;
            }
            catch (SortedDependencies.MissingProvideException e) {
                this.report(JSError.make(MISSING_ENTRY_ERROR, e.getMessage()));
            }
            catch (JSChunkGraph.MissingChunkException e) {
                this.report(JSError.make(MISSING_MODULE_ERROR, e.getMessage()));
            }
        }
        this.hoistExterns(originalInputs);
        this.fillEmptyModules(this.getModules());
        this.hoistNoCompileFiles();
        if (staleInputs) {
            this.repartitionInputs();
        }
    }

    private void findModulesFromEntryPoints(boolean supportEs6Modules, boolean supportCommonJSModules) {
        this.maybeDoThreadedParsing();
        ArrayList<CompilerInput> entryPoints = new ArrayList<CompilerInput>();
        HashMap<String, CompilerInput> inputsByProvide = new HashMap<String, CompilerInput>();
        HashMap<String, CompilerInput> inputsByIdentifier = new HashMap<String, CompilerInput>();
        for (CompilerInput input : this.moduleGraph.getAllInputs()) {
            Iterable<String> provides = Iterables.filter(input.getProvides(), p -> !p.startsWith("module$"));
            if (!this.options.getDependencyOptions().shouldDropMoochers() && Iterables.isEmpty(provides)) {
                entryPoints.add(input);
            }
            inputsByIdentifier.put(ModuleIdentifier.forFile(input.getPath().toString()).toString(), input);
            for (String provide : provides) {
                inputsByProvide.put(provide, input);
            }
        }
        for (ModuleIdentifier moduleIdentifier : this.options.getDependencyOptions().getEntryPoints()) {
            CompilerInput input = (CompilerInput)inputsByProvide.get(moduleIdentifier.toString());
            if (input == null) {
                input = (CompilerInput)inputsByIdentifier.get(moduleIdentifier.toString());
            }
            if (input == null) continue;
            entryPoints.add(input);
        }
        HashSet<CompilerInput> workingInputSet = Sets.newHashSet(this.moduleGraph.getAllInputs());
        for (CompilerInput entryPoint : entryPoints) {
            this.findModulesFromInput(entryPoint, false, workingInputSet, inputsByIdentifier, inputsByProvide, supportEs6Modules, supportCommonJSModules);
        }
    }

    private void findModulesFromInput(CompilerInput input, boolean wasImportedByModule, Set<CompilerInput> inputs, Map<String, CompilerInput> inputsByIdentifier, Map<String, CompilerInput> inputsByProvide, boolean supportEs6Modules, boolean supportCommonJSModules) {
        if (!inputs.remove(input)) {
            if (wasImportedByModule && input.getJsModuleType() == CompilerInput.ModuleType.NONE) {
                input.setJsModuleType(CompilerInput.ModuleType.IMPORTED_SCRIPT);
            }
            return;
        }
        FindModuleDependencies findDeps = new FindModuleDependencies(this, supportEs6Modules, supportCommonJSModules, this.inputPathByWebpackId);
        findDeps.process(Preconditions.checkNotNull(input.getAstRoot(this)));
        if (wasImportedByModule && input.getJsModuleType() == CompilerInput.ModuleType.NONE) {
            input.setJsModuleType(CompilerInput.ModuleType.IMPORTED_SCRIPT);
        }
        this.moduleTypesByName.put(input.getPath().toModuleName(), input.getJsModuleType());
        Iterable<String> allDeps = Iterables.concat(input.getRequiredSymbols(), input.getDynamicRequires(), input.getTypeRequires());
        for (String requiredNamespace : allDeps) {
            CompilerInput requiredInput = null;
            boolean requiredByModuleImport = false;
            if (inputsByProvide.containsKey(requiredNamespace)) {
                requiredInput = inputsByProvide.get(requiredNamespace);
            } else if (inputsByIdentifier.containsKey(requiredNamespace)) {
                requiredByModuleImport = true;
                requiredInput = inputsByIdentifier.get(requiredNamespace);
            }
            if (requiredInput == null) continue;
            this.findModulesFromInput(requiredInput, requiredByModuleImport, inputs, inputsByIdentifier, inputsByProvide, supportEs6Modules, supportCommonJSModules);
        }
    }

    void hoistExterns(ImmutableList<CompilerInput> originalInputs) {
        boolean staleInputs = false;
        for (CompilerInput input : originalInputs) {
            if (!this.hoistIfExtern(input)) continue;
            staleInputs = true;
        }
        if (staleInputs) {
            this.repartitionInputs();
        }
    }

    private boolean hoistIfExtern(CompilerInput input) {
        if (input.getHasExternsAnnotation()) {
            Node root = input.getAstRoot(this);
            this.externsRoot.addChildToBack(root);
            this.scriptNodeByFilename.put(input.getSourceFile().getName(), root);
            JSChunk module = input.getChunk();
            if (module != null) {
                module.remove(input);
            }
            this.externs.add(input);
            return true;
        }
        return false;
    }

    private void markExterns(ImmutableList<CompilerInput> originalInputs) {
        for (CompilerInput input : originalInputs) {
            if (!input.getHasExternsAnnotation()) continue;
            input.setIsExtern();
        }
    }

    void hoistNoCompileFiles() {
        boolean staleInputs = false;
        this.maybeDoThreadedParsing();
        for (CompilerInput input : ImmutableList.copyOf(this.moduleGraph.getAllInputs())) {
            if (!input.getHasNoCompileAnnotation()) continue;
            input.getChunk().remove(input);
            staleInputs = true;
        }
        if (staleInputs) {
            this.repartitionInputs();
        }
    }

    private void maybeDoThreadedParsing() {
        if (this.options.numParallelThreads > 1) {
            new PrebuildDependencyInfo(this.options.numParallelThreads).prebuild(this.moduleGraph.getAllInputs());
        }
    }

    private void repartitionInputs() {
        this.fillEmptyModules(this.getModules());
        this.rebuildInputsFromModules();
    }

    Map<String, String> processJsonInputs(Iterable<CompilerInput> inputsToProcess) {
        RewriteJsonToModule rewriteJson = new RewriteJsonToModule(this);
        for (CompilerInput input : inputsToProcess) {
            if (!input.getSourceFile().getName().endsWith(".json")) continue;
            input.setCompiler(this);
            try {
                input.getSourceFile().setCodeDeprecated("(" + input.getSourceFile().getCode() + ")");
            }
            catch (IOException e) {
                continue;
            }
            Node root = Preconditions.checkNotNull(input.getAstRoot(this));
            input.setJsModuleType(CompilerInput.ModuleType.JSON);
            rewriteJson.process(null, root);
        }
        return rewriteJson.getPackageJsonMainEntries();
    }

    private List<CompilerInput> parsePotentialModules(Iterable<CompilerInput> inputsToProcess) {
        ArrayList<CompilerInput> filteredInputs = new ArrayList<CompilerInput>();
        for (CompilerInput input : inputsToProcess) {
            if (this.options.getDependencyOptions().shouldPrune() && JsFileRegexParser.isSupported() && !"es6".equals(input.getLoadFlags().get("module"))) continue;
            filteredInputs.add(input);
        }
        if (this.options.numParallelThreads > 1) {
            new PrebuildAst(this, this.options.numParallelThreads).prebuild(filteredInputs);
        }
        for (CompilerInput input : filteredInputs) {
            input.setCompiler(this);
            input.getRequires();
            input.setJsModuleType(CompilerInput.ModuleType.ES6);
        }
        return filteredInputs;
    }

    void processAMDModules(Iterable<CompilerInput> inputs) {
        for (CompilerInput input : inputs) {
            input.setCompiler(this);
            Node root = Preconditions.checkNotNull(input.getAstRoot(this));
            new TransformAMDToCJSModule(this).process(null, root);
        }
    }

    protected CompilerOptions newCompilerOptions() {
        return new CompilerOptions();
    }

    void initCompilerOptionsIfTesting() {
        if (this.options == null) {
            this.initOptions(this.newCompilerOptions());
        }
    }

    @Override
    public Node parseSyntheticCode(String fileName, String js) {
        this.initCompilerOptionsIfTesting();
        SourceFile source = SourceFile.fromCode(" [synthetic:" + fileName + "] ", js);
        this.addFilesToSourceMap(ImmutableList.of(source));
        return this.parseCodeHelper(source);
    }

    @Override
    @VisibleForTesting
    Node parseTestCode(String js) {
        this.initCompilerOptionsIfTesting();
        this.initBasedOnOptions();
        return this.parseCodeHelper(SourceFile.fromCode("[testcode]", js));
    }

    @Override
    @VisibleForTesting
    Node parseTestCode(ImmutableList<String> code) {
        this.initCompilerOptionsIfTesting();
        this.initBasedOnOptions();
        return this.parseCodeHelper(Streams.mapWithIndex(code.stream(), (value, index) -> SourceFile.fromCode("testcode" + index, value)).collect(Collectors.toList()));
    }

    private Node parseCodeHelper(SourceFile src) {
        CompilerInput input = new CompilerInput(src);
        this.putCompilerInput(input);
        Node root = input.getAstRoot(this);
        this.scriptNodeByFilename.put(input.getSourceFile().getName(), root);
        return Preconditions.checkNotNull(root);
    }

    private Node parseCodeHelper(List<SourceFile> srcs) {
        Node root = IR.root(new Node[0]);
        for (SourceFile src : srcs) {
            root.addChildToBack(this.parseCodeHelper(src));
        }
        return root;
    }

    @Override
    ErrorReporter getDefaultErrorReporter() {
        return this.oldErrorReporter;
    }

    @Override
    public String toSource() {
        return this.runInCompilerThread(() -> {
            Tracer tracer = this.newTracer("toSource");
            try {
                CodeBuilder cb = new CodeBuilder();
                if (this.jsRoot != null) {
                    Node scriptNode;
                    int i = 0;
                    if (this.options.shouldPrintExterns()) {
                        for (scriptNode = this.externsRoot.getFirstChild(); scriptNode != null; scriptNode = scriptNode.getNext()) {
                            this.toSource(cb, i++, scriptNode);
                        }
                    }
                    for (scriptNode = this.jsRoot.getFirstChild(); scriptNode != null; scriptNode = scriptNode.getNext()) {
                        this.toSource(cb, i++, scriptNode);
                    }
                }
                String string = cb.toString();
                return string;
            }
            finally {
                this.stopTracer(tracer, "toSource");
            }
        });
    }

    public String toSource(JSChunk module) {
        return this.runInCompilerThread(() -> {
            List<CompilerInput> inputs = module.getInputs();
            int numInputs = inputs.size();
            if (numInputs == 0) {
                return "";
            }
            CodeBuilder cb = new CodeBuilder();
            for (int i = 0; i < numInputs; ++i) {
                Node scriptNode = inputs.get(i).getAstRoot(this);
                if (scriptNode == null) {
                    throw new IllegalArgumentException("Bad module: " + module.getName());
                }
                this.toSource(cb, i, scriptNode);
            }
            return cb.toString();
        });
    }

    public void toSource(CodeBuilder cb, int inputSeqNum, Node root) {
        this.runInCompilerThread(() -> {
            String code;
            String license;
            if (this.options.printInputDelimiter) {
                if (cb.getLength() > 0 && !cb.endsWith("\n")) {
                    cb.append("\n");
                }
                Preconditions.checkState(root.isScript());
                String delimiter = this.options.inputDelimiter;
                String inputName = root.getInputId().getIdName();
                String sourceName = root.getSourceFileName();
                Preconditions.checkState(sourceName != null);
                Preconditions.checkState(!sourceName.isEmpty());
                delimiter = delimiter.replace("%name%", Matcher.quoteReplacement(inputName)).replace("%num%", String.valueOf(inputSeqNum)).replace("%n%", "\n");
                cb.append(delimiter).append("\n");
            }
            if (root.getJSDocInfo() != null && (license = root.getJSDocInfo().getLicense()) != null && cb.addLicense(license)) {
                cb.append("/*\n").append(license).append("*/\n");
            }
            if (this.options.sourceMapOutputPath != null) {
                this.sourceMap.setStartingPosition(cb.getLineIndex(), cb.getColumnIndex());
            }
            if (!(code = this.toSource(root, this.sourceMap, inputSeqNum == 0)).isEmpty()) {
                boolean hasSemiColon;
                cb.append(code);
                int length = code.length();
                char lastChar = code.charAt(length - 1);
                char secondLastChar = length >= 2 ? code.charAt(length - 2) : (char)'\u0000';
                boolean bl = hasSemiColon = lastChar == ';' || lastChar == '\n' && secondLastChar == ';';
                if (!hasSemiColon) {
                    cb.append(";");
                }
            }
            return null;
        });
    }

    @Override
    public String toSource(Node n) {
        this.initCompilerOptionsIfTesting();
        return this.toSource(n, null, true);
    }

    private String toSource(Node n, SourceMap sourceMap, boolean firstOutput) {
        CodePrinter.Builder builder = new CodePrinter.Builder(n);
        builder.setCompilerOptions(this.options);
        builder.setSourceMap(sourceMap);
        builder.setTagAsTypeSummary(this.options.shouldGenerateTypedExterns());
        builder.setTagAsStrict(firstOutput && this.options.shouldEmitUseStrict());
        return builder.build();
    }

    public String[] toSourceArray() {
        return this.runInCompilerThread(() -> {
            Tracer tracer = this.newTracer("toSourceArray");
            try {
                int numInputs = this.moduleGraph.getInputCount();
                String[] sources = new String[numInputs];
                CodeBuilder cb = new CodeBuilder();
                int i = 0;
                for (CompilerInput input : this.moduleGraph.getAllInputs()) {
                    Node scriptNode = input.getAstRoot(this);
                    cb.reset();
                    this.toSource(cb, i, scriptNode);
                    sources[i] = cb.toString();
                    ++i;
                }
                String[] stringArray = sources;
                return stringArray;
            }
            finally {
                this.stopTracer(tracer, "toSourceArray");
            }
        });
    }

    public String[] toSourceArray(JSChunk module) {
        return this.runInCompilerThread(() -> {
            List<CompilerInput> inputs = module.getInputs();
            int numInputs = inputs.size();
            if (numInputs == 0) {
                return new String[0];
            }
            String[] sources = new String[numInputs];
            CodeBuilder cb = new CodeBuilder();
            for (int i = 0; i < numInputs; ++i) {
                Node scriptNode = inputs.get(i).getAstRoot(this);
                if (scriptNode == null) {
                    throw new IllegalArgumentException("Bad module input: " + inputs.get(i).getName());
                }
                cb.reset();
                this.toSource(cb, i, scriptNode);
                sources[i] = cb.toString();
            }
            return sources;
        });
    }

    void performTranspilationAndOptimizations() {
        Preconditions.checkState(this.options.shouldOptimize());
        List<PassFactory> optimizations = this.getPassConfig().getOptimizations();
        if (optimizations.isEmpty()) {
            return;
        }
        this.phaseOptimizer = this.createPhaseOptimizer();
        this.phaseOptimizer.consume(optimizations);
        this.phaseOptimizer.process(this.externsRoot, this.jsRoot);
        this.phaseOptimizer = null;
    }

    void performFinalizations() {
        List<PassFactory> finalizations = this.getPassConfig().getFinalizations();
        if (finalizations.isEmpty()) {
            return;
        }
        this.phaseOptimizer = this.createPhaseOptimizer();
        this.phaseOptimizer.consume(finalizations);
        this.phaseOptimizer.process(this.externsRoot, this.jsRoot);
        this.phaseOptimizer = null;
    }

    @Override
    void setCssRenamingMap(CssRenamingMap map) {
        this.options.cssRenamingMap = map;
    }

    @Override
    CssRenamingMap getCssRenamingMap() {
        return this.options.cssRenamingMap;
    }

    ControlFlowGraph<Node> computeCFG() {
        logger.fine("Computing Control Flow Graph");
        Tracer tracer = this.newTracer("computeCFG");
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this, true, false);
        this.process(cfa);
        this.stopTracer(tracer, "computeCFG");
        return cfa.getCfg();
    }

    @Override
    void addChangeHandler(CodeChangeHandler handler) {
        this.codeChangeHandlers.add(handler);
    }

    @Override
    void removeChangeHandler(CodeChangeHandler handler) {
        this.codeChangeHandlers.remove(handler);
    }

    @Override
    void addIndexProvider(IndexProvider<?> indexProvider) {
        Class<?> type = indexProvider.getType();
        if (this.indexProvidersByType.put(type, indexProvider) != null) {
            throw new IllegalStateException("A provider is already registered for index of type " + type.getSimpleName());
        }
    }

    @Override
    <T> T getIndex(Class<T> key) {
        IndexProvider<?> indexProvider = this.indexProvidersByType.get(key);
        if (indexProvider == null) {
            return null;
        }
        return (T)indexProvider.get();
    }

    protected Node getExternsRoot() {
        return this.externsRoot;
    }

    @Override
    protected Node getJsRoot() {
        return this.jsRoot;
    }

    @VisibleForTesting
    void setPhaseOptimizer(PhaseOptimizer po) {
        this.phaseOptimizer = po;
    }

    @Override
    public int getChangeStamp() {
        return this.changeStamp;
    }

    @Override
    List<Node> getChangedScopeNodesForPass(String passName) {
        List<Node> changedScopeNodes = this.changeTimeline.getSince(passName);
        this.changeTimeline.mark(passName);
        return changedScopeNodes;
    }

    @Override
    List<Node> getDeletedScopeNodesForPass(String passName) {
        List<Node> deletedScopeNodes = this.deleteTimeline.getSince(passName);
        this.deleteTimeline.mark(passName);
        return deletedScopeNodes;
    }

    @Override
    public void incrementChangeStamp() {
        ++this.changeStamp;
    }

    private Node getChangeScopeForNode(Node n) {
        if (n.isScript()) {
            return n;
        }
        Node enclosingScopeNode = NodeUtil.getEnclosingChangeScopeRoot(n.getParent());
        if (enclosingScopeNode == null) {
            throw new IllegalStateException("An enclosing scope is required for change reports but node " + n + " doesn't have one.");
        }
        return enclosingScopeNode;
    }

    private void recordChange(Node n) {
        if (n.isDeleted()) {
            return;
        }
        n.setChangeTime(this.changeStamp);
        ++this.changeStamp;
        this.changeTimeline.add(n);
    }

    @Override
    boolean hasScopeChanged(Node n) {
        if (this.phaseOptimizer == null) {
            return true;
        }
        return this.phaseOptimizer.hasScopeChanged(n);
    }

    @Override
    public void reportChangeToChangeScope(Node changeScopeRoot) {
        Preconditions.checkState(changeScopeRoot.isScript() || changeScopeRoot.isFunction());
        this.recordChange(changeScopeRoot);
        this.notifyChangeHandlers();
    }

    @Override
    public void reportFunctionDeleted(Node n) {
        Preconditions.checkState(n.isFunction());
        n.setDeleted(true);
        this.changeTimeline.remove(n);
        this.deleteTimeline.add(n);
    }

    @Override
    public void reportChangeToEnclosingScope(Node n) {
        this.recordChange(this.getChangeScopeForNode(n));
        this.notifyChangeHandlers();
    }

    private void notifyChangeHandlers() {
        for (CodeChangeHandler handler : this.codeChangeHandlers) {
            handler.reportChange();
        }
    }

    @Override
    public CodingConvention getCodingConvention() {
        CodingConvention convention = this.options.getCodingConvention();
        convention = convention != null ? convention : this.defaultCodingConvention;
        return convention;
    }

    private Config.LanguageMode getParserConfigLanguageMode(CompilerOptions.LanguageMode languageMode) {
        switch (languageMode) {
            case ECMASCRIPT3: {
                return Config.LanguageMode.ECMASCRIPT3;
            }
            case ECMASCRIPT5: 
            case ECMASCRIPT5_STRICT: {
                return Config.LanguageMode.ECMASCRIPT5;
            }
            case ECMASCRIPT_2015: {
                return Config.LanguageMode.ECMASCRIPT_2015;
            }
            case ECMASCRIPT_2016: {
                return Config.LanguageMode.ECMASCRIPT_2016;
            }
            case ECMASCRIPT_2017: {
                return Config.LanguageMode.ECMASCRIPT_2017;
            }
            case ECMASCRIPT_2018: {
                return Config.LanguageMode.ECMASCRIPT_2018;
            }
            case ECMASCRIPT_2019: {
                return Config.LanguageMode.ECMASCRIPT_2019;
            }
            case ECMASCRIPT_2020: {
                return Config.LanguageMode.ECMASCRIPT_2020;
            }
            case ECMASCRIPT_2021: {
                return Config.LanguageMode.ECMASCRIPT_2021;
            }
            case UNSUPPORTED: {
                return Config.LanguageMode.UNSUPPORTED;
            }
            case ECMASCRIPT_NEXT: {
                return Config.LanguageMode.ES_NEXT;
            }
            case ECMASCRIPT_NEXT_IN: {
                return Config.LanguageMode.ES_NEXT_IN;
            }
        }
        throw new IllegalStateException("Unexpected language mode: " + (Object)((Object)this.options.getLanguageIn()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Config getParserConfig(AbstractCompiler.ConfigContext context) {
        if (this.parserConfig == null || this.externsParserConfig == null) {
            Compiler compiler = this;
            synchronized (compiler) {
                if (this.parserConfig == null) {
                    Config.LanguageMode configLanguageMode = this.getParserConfigLanguageMode(this.options.getLanguageIn());
                    Config.StrictMode strictMode = this.options.expectStrictModeInput() ? Config.StrictMode.STRICT : Config.StrictMode.SLOPPY;
                    this.parserConfig = this.createConfig(configLanguageMode, strictMode);
                    this.externsParserConfig = configLanguageMode.equals((Object)Config.LanguageMode.ECMASCRIPT3) ? this.createConfig(Config.LanguageMode.ECMASCRIPT5, strictMode) : this.parserConfig;
                }
            }
        }
        if (context == AbstractCompiler.ConfigContext.EXTERNS) {
            return this.externsParserConfig;
        }
        return this.parserConfig;
    }

    protected Config createConfig(Config.LanguageMode mode, Config.StrictMode strictMode) {
        return ParserRunner.createConfig(mode, this.options.isParseJsDocDocumentation(), this.options.canContinueAfterErrors() ? Config.RunMode.KEEP_GOING : Config.RunMode.STOP_AFTER_ERROR, this.options.extraAnnotationNames, this.options.parseInlineSourceMaps, strictMode);
    }

    public DiagnosticGroups getDiagnosticGroups() {
        return new DiagnosticGroups();
    }

    @Override
    public void report(JSError error) {
        CheckLevel newLevel;
        CheckLevel level = error.getDefaultLevel();
        if (this.warningsGuard != null && (newLevel = this.warningsGuard.level(error)) != null) {
            level = newLevel;
        }
        if (level.isOn()) {
            this.initCompilerOptionsIfTesting();
            if (this.getOptions().errorHandler != null) {
                this.getOptions().errorHandler.report(level, error);
            }
            this.errorManager.report(level, error);
        }
    }

    @Override
    public void report(CheckLevel ignoredLevel, JSError error) {
        this.report(error);
    }

    @Override
    public CheckLevel getErrorLevel(JSError error) {
        Preconditions.checkNotNull(this.options);
        return this.warningsGuard.level(error);
    }

    @Override
    void throwInternalError(String message, Throwable cause) {
        throw new RuntimeException("INTERNAL COMPILER ERROR.\nPlease report this problem.\n\n" + message, cause);
    }

    public int getErrorCount() {
        return this.errorManager.getErrorCount();
    }

    public int getWarningCount() {
        return this.errorManager.getWarningCount();
    }

    @Override
    boolean hasHaltingErrors() {
        return !this.getOptions().canContinueAfterErrors() && this.errorManager.hasHaltingErrors();
    }

    public boolean hasErrors() {
        return this.hasHaltingErrors();
    }

    @Override
    SourceFile getSourceFileByName(String sourceName) {
        if (sourceName != null) {
            CompilerInput input = this.inputsById.get(new InputId(sourceName));
            if (input != null) {
                return input.getSourceFile();
            }
            return this.sourceMapOriginalSources.get(sourceName);
        }
        return null;
    }

    public CharSequence getSourceFileContentByName(String sourceName) {
        SourceFile file = this.getSourceFileByName(sourceName);
        Preconditions.checkNotNull(file);
        try {
            return file.getCode();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void addInputSourceMap(String sourceFileName, SourceMapInput inputSourceMap) {
        this.inputSourceMaps.put(sourceFileName, inputSourceMap);
        if (this.options.sourceMapIncludeSourcesContent && this.sourceMap != null) {
            this.addSourceMapSourceFiles(inputSourceMap);
        }
    }

    private synchronized void addSourceMapSourceFiles(SourceMapInput inputSourceMap) {
        SourceMapConsumerV3 consumer = inputSourceMap.getSourceMap(this.errorManager);
        if (consumer == null) {
            return;
        }
        Collection<String> sourcesContent = consumer.getOriginalSourcesContent();
        if (sourcesContent == null) {
            return;
        }
        Iterator<String> content = sourcesContent.iterator();
        Iterator<String> sources = consumer.getOriginalSources().iterator();
        while (sources.hasNext() && content.hasNext()) {
            String code = content.next();
            SourceFile source = SourceMapResolver.getRelativePath(inputSourceMap.getOriginalPath(), sources.next());
            if (source == null) continue;
            this.sourceMap.addSourceFile(source.getName(), code);
        }
        if (sources.hasNext() || content.hasNext()) {
            throw new RuntimeException("Source map's \"sources\" and \"sourcesContent\" lengths do not match.");
        }
    }

    @Override
    @Nullable
    public Mapping.OriginalMapping getSourceMapping(String sourceName, int lineNumber, int columnNumber) {
        String relativePath;
        if (sourceName == null) {
            return null;
        }
        SourceMapInput sourceMap = this.inputSourceMaps.get(sourceName);
        if (sourceMap == null) {
            return null;
        }
        SourceMapConsumerV3 consumer = sourceMap.getSourceMap(this.errorManager);
        if (consumer == null) {
            return null;
        }
        Mapping.OriginalMapping result = consumer.getMappingForLine(lineNumber, columnNumber + 1);
        if (result == null) {
            return null;
        }
        String sourceMapOriginalPath = sourceMap.getOriginalPath();
        String resultOriginalPath = result.getOriginalFile();
        if (sourceMapOriginalPath.equals(this.resolvedSourceMap.originalPath) && resultOriginalPath.equals(this.resolvedSourceMap.sourceMapPath)) {
            relativePath = this.resolvedSourceMap.relativePath;
        } else {
            relativePath = Compiler.resolveSibling(sourceMapOriginalPath, resultOriginalPath);
            SourceFile source = this.getSourceFileByName(relativePath);
            if (source == null && !Strings.isNullOrEmpty(resultOriginalPath) && (source = SourceMapResolver.getRelativePath(sourceMap.getOriginalPath(), result.getOriginalFile())) != null) {
                this.sourceMapOriginalSources.putIfAbsent(relativePath, source);
            }
            this.resolvedSourceMap.originalPath = sourceMapOriginalPath;
            this.resolvedSourceMap.sourceMapPath = resultOriginalPath;
            this.resolvedSourceMap.relativePath = relativePath;
        }
        return result.toBuilder().setOriginalFile(relativePath).setColumnPosition(result.getColumnPosition() - 1).build();
    }

    @Override
    public String getSourceLine(String sourceName, int lineNumber) {
        if (lineNumber < 1) {
            return null;
        }
        SourceFile input = this.getSourceFileByName(sourceName);
        if (input != null) {
            return input.getLine(lineNumber);
        }
        return null;
    }

    @Override
    public Region getSourceLines(String sourceName, int lineNumber, int length) {
        if (lineNumber < 1) {
            return null;
        }
        SourceFile input = this.getSourceFileByName(sourceName);
        if (input != null) {
            return input.getLines(lineNumber, length);
        }
        return null;
    }

    @Override
    public Region getSourceRegion(String sourceName, int lineNumber) {
        if (lineNumber < 1) {
            return null;
        }
        SourceFile input = this.getSourceFileByName(sourceName);
        if (input != null) {
            return input.getRegion(lineNumber);
        }
        return null;
    }

    @Override
    protected Node getNodeForCodeInsertion(@Nullable JSChunk module) {
        if (this.inputsById.containsKey(SYNTHETIC_CODE_INPUT_ID)) {
            return this.inputsById.get(SYNTHETIC_CODE_INPUT_ID).getAstRoot(this);
        }
        if (module == null) {
            if (this.moduleGraph == null || Iterables.isEmpty(this.moduleGraph.getAllInputs())) {
                throw new IllegalStateException("No inputs");
            }
            CompilerInput firstInput = Iterables.getFirst(this.moduleGraph.getAllInputs(), null);
            return firstInput.getAstRoot(this);
        }
        List<CompilerInput> moduleInputs = module.getInputs();
        if (!moduleInputs.isEmpty()) {
            return Compiler.checkNotModule(moduleInputs.get(0).getAstRoot(this), "Cannot insert code into a module", new Object[0]);
        }
        throw new IllegalStateException("Root module has no inputs");
    }

    public SourceMap getSourceMap() {
        return this.sourceMap;
    }

    @Override
    public void setVariableMap(VariableMap variableMap) {
        this.variableMap = variableMap;
    }

    VariableMap getVariableMap() {
        return this.variableMap;
    }

    @Override
    public void setPropertyMap(VariableMap propertyMap) {
        this.propertyMap = propertyMap;
    }

    VariableMap getPropertyMap() {
        return this.propertyMap;
    }

    @Override
    public void setStringMap(VariableMap stringMap) {
        this.stringMap = stringMap;
    }

    @Override
    public void setCssNames(Map<String, Integer> cssNames) {
        this.cssNames = cssNames;
    }

    @Override
    public void setIdGeneratorMap(String serializedIdMappings) {
        this.idGeneratorMap = serializedIdMappings;
    }

    @Override
    public IdGenerator getCrossModuleIdGenerator() {
        return this.crossModuleIdGenerator;
    }

    @Override
    public void setAnonymousFunctionNameMap(VariableMap functionMap) {
    }

    VariableMap getStringMap() {
        return this.stringMap;
    }

    @Override
    public void setInstrumentationMapping(VariableMap instrumentationMapping) {
        this.instrumentationMapping = instrumentationMapping;
    }

    public VariableMap getInstrumentationMapping() {
        return this.instrumentationMapping;
    }

    @Override
    public void addExportedNames(Set<String> exportedNames) {
        this.exportedNames.addAll(exportedNames);
    }

    @Override
    public Set<String> getExportedNames() {
        return this.exportedNames;
    }

    @Override
    public CompilerOptions getOptions() {
        return this.options;
    }

    public static void setLoggingLevel(Level level) {
        logger.setLevel(level);
    }

    public String getAstDotGraph() throws IOException {
        if (this.jsRoot != null) {
            ControlFlowAnalysis cfa = new ControlFlowAnalysis(this, true, false);
            cfa.process(null, this.jsRoot);
            return DotFormatter.toDot(this.jsRoot, cfa.getCfg());
        }
        return "";
    }

    @Override
    public ErrorManager getErrorManager() {
        if (this.options == null) {
            this.initOptions(new CompilerOptions());
        }
        return this.errorManager;
    }

    @Override
    Iterable<CompilerInput> getInputsInOrder() {
        return this.moduleGraph.getAllInputs();
    }

    @Override
    int getNumberOfInputs() {
        return this.moduleGraph != null ? this.moduleGraph.getInputCount() : 1;
    }

    public Map<InputId, CompilerInput> getInputsById() {
        return Collections.unmodifiableMap(this.inputsById);
    }

    List<CompilerInput> getExternsInOrder() {
        return Collections.unmodifiableList(this.externs);
    }

    @VisibleForTesting
    List<CompilerInput> getInputsForTesting() {
        return this.moduleGraph != null ? ImmutableList.copyOf(this.moduleGraph.getAllInputs()) : null;
    }

    @VisibleForTesting
    List<CompilerInput> getExternsForTesting() {
        return this.externs;
    }

    @Override
    boolean hasRegExpGlobalReferences() {
        return this.hasRegExpGlobalReferences;
    }

    @Override
    void setHasRegExpGlobalReferences(boolean references) {
        this.hasRegExpGlobalReferences = references;
    }

    @Override
    void setRunJ2clPasses(boolean runJ2clPasses) {
        this.runJ2clPasses = runJ2clPasses;
    }

    @Override
    boolean runJ2clPasses() {
        return this.runJ2clPasses;
    }

    @Override
    CompilerInput getSynthesizedExternsInput() {
        if (this.syntheticExternsInput != null) {
            return this.syntheticExternsInput;
        }
        CompilerInput input = new CompilerInput(this.SYNTHETIC_EXTERNS_FILE, true);
        Node root = Preconditions.checkNotNull(input.getAstRoot(this));
        this.putCompilerInput(input);
        this.syntheticExternsInput = input;
        this.externsRoot.addChildToFront(root);
        this.externs.add(0, input);
        this.scriptNodeByFilename.put(input.getSourceFile().getName(), root);
        return input;
    }

    @Override
    InputId getSyntheticCodeInputId() {
        return SYNTHETIC_CODE_INPUT_ID;
    }

    @Override
    void initializeSyntheticCodeInput() {
        Preconditions.checkState(!this.inputsById.containsKey(SYNTHETIC_CODE_INPUT_ID), "Already initialized synthetic input");
        JsAst ast = new JsAst(SourceFile.fromCode(SYNTHETIC_CODE_INPUT_ID.getIdName(), ""));
        if (this.inputsById.containsKey(ast.getInputId())) {
            throw new IllegalStateException("Conflicting synthetic id name");
        }
        CompilerInput input = new CompilerInput(ast, false);
        this.jsRoot.addChildToFront(Preconditions.checkNotNull(ast.getAstRoot(this)));
        JSChunk firstModule = Iterables.getFirst(this.getModules(), null);
        if (firstModule.getName().equals("$strong$")) {
            firstModule.add(input);
        }
        input.setModule(firstModule);
        this.putCompilerInput(input);
        this.commentsPerFile.put(SYNTHETIC_CODE_INPUT_ID.getIdName(), ImmutableList.of());
        this.reportChangeToChangeScope(ast.getAstRoot(this));
    }

    @Override
    void removeSyntheticCodeInput() {
        this.removeSyntheticCodeInput(false);
    }

    @Override
    void mergeSyntheticCodeInput() {
        this.removeSyntheticCodeInput(true);
    }

    @Override
    void setLocaleSubstitutionData(AbstractCompiler.LocaleData localeDataValueMap) {
        this.localeDataValueMap = localeDataValueMap;
    }

    @Override
    AbstractCompiler.LocaleData getLocaleSubstitutionData() {
        return this.localeDataValueMap;
    }

    private void removeSyntheticCodeInput(boolean mergeContentIntoFirstInput) {
        Preconditions.checkState(this.inputsById.containsKey(SYNTHETIC_CODE_INPUT_ID), "Never initialized the synthetic input");
        CompilerInput input = this.inputsById.get(SYNTHETIC_CODE_INPUT_ID);
        Node astRoot = input.getAstRoot(this);
        Preconditions.checkState(astRoot.isFirstChildOf(this.jsRoot));
        Preconditions.checkState(SYNTHETIC_CODE_INPUT_ID.equals(input.getInputId()));
        if (mergeContentIntoFirstInput && astRoot.hasChildren()) {
            Node next = astRoot.getNext();
            Preconditions.checkNotNull(next, "Must provide at least one source");
            Compiler.checkNotModule(next, "Cannot remove synthetic code input until modules are rewritten: %s", next);
            next.addChildrenToFront(astRoot.removeChildren());
            this.reportChangeToChangeScope(next);
        }
        astRoot.detach();
        this.reportChangeToChangeScope(astRoot);
        astRoot.setDeleted(true);
        NodeUtil.markFunctionsDeleted(astRoot, this);
        input.getChunk().remove(input);
        this.inputsById.remove(input.getInputId());
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    String getLastPassName() {
        return this.lastPassName;
    }

    @Override
    void setProgress(double newProgress, String passName) {
        this.lastPassName = passName;
        this.progress = Math.min(newProgress, 1.0);
    }

    @Override
    void setExternProperties(ImmutableSet<String> externProperties) {
        this.externProperties = externProperties;
    }

    @Override
    public ImmutableSet<String> getExternProperties() {
        return this.externProperties;
    }

    @Override
    AccessorSummary getAccessorSummary() {
        return this.accessorSummary;
    }

    @Override
    public void setAccessorSummary(AccessorSummary summary) {
        this.accessorSummary = Preconditions.checkNotNull(summary);
    }

    @Override
    protected Node ensureLibraryInjected(String resourceName, boolean force) {
        Node ast;
        boolean shouldInject;
        boolean bl = shouldInject = force || !this.options.skipNonTranspilationPasses && !this.options.preventLibraryInjection;
        if (this.injectedLibraries.contains(resourceName) || !shouldInject) {
            return this.lastInjectedLibrary;
        }
        Preconditions.checkState(!this.getLifeCycleStage().isNormalized(), "runtime library injected after normalization");
        String path = String.join((CharSequence)"", "src/com/google/javascript/jscomp/js/", resourceName, ".js");
        if (this.getLifeCycleStage().hasColorAndSimplifiedJSDoc()) {
            Preconditions.checkNotNull(this.runtimeLibraryTypedAsts, "Must call initRuntimeLibraryTypedAsts before calling ensureLibraryInjected during optimizations");
            ast = this.runtimeLibraryTypedAsts.get(path).get();
        } else {
            Preconditions.checkState(!this.hasTypeCheckingRun(), "runtime library injected after type checking but before optimization colors");
            String originalCode = ResourceLoader.loadTextResource(Compiler.class, "js/" + resourceName + ".js");
            SourceFile source = SourceFile.fromCode(path, originalCode);
            this.addFilesToSourceMap(ImmutableList.of(source));
            ast = this.parseCodeHelper(source);
        }
        Node node = ast.getFirstChild();
        while (node != null && node.isExprResult() && node.getFirstChild().isStringLit()) {
            String directive = node.getFirstChild().getString();
            List<String> words = Splitter.on(' ').limit(2).splitToList(directive);
            switch (words.get(0)) {
                case "use": {
                    break;
                }
                case "require": {
                    this.ensureLibraryInjected(words.get(1), force);
                    break;
                }
                default: {
                    throw new RuntimeException("Bad directive: " + directive);
                }
            }
            node.detach();
            node = ast.getFirstChild();
        }
        Node lastChild = ast.getLastChild();
        for (Node child = ast.getFirstChild(); child != null; child = child.getNext()) {
            NodeUtil.markNewScopesChanged(child, this);
        }
        Node firstChild = ast.removeChildren();
        if (firstChild == null) {
            return this.lastInjectedLibrary;
        }
        Node parent = this.getNodeForCodeInsertion(null);
        if (this.lastInjectedLibrary == null) {
            parent.addChildrenToFront(firstChild);
        } else {
            parent.addChildrenAfter(firstChild, this.lastInjectedLibrary);
        }
        this.lastInjectedLibrary = lastChild;
        this.injectedLibraries.add(resourceName);
        this.reportChangeToEnclosingScope(parent);
        return lastChild;
    }

    @Override
    void addComments(String filename, List<Comment> comments) {
        if (!this.getOptions().preservesDetailedSourceInfo()) {
            throw new UnsupportedOperationException("addComments may only be called in IDE mode.");
        }
        this.commentsPerFile.put(filename, comments);
    }

    @Override
    public List<Comment> getComments(String filename) {
        if (!this.getOptions().preservesDetailedSourceInfo()) {
            throw new UnsupportedOperationException("getComments may only be called in IDE mode.");
        }
        return this.commentsPerFile.get(filename);
    }

    @Override
    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    private synchronized void addFilesToSourceMap(Iterable<SourceFile> files) {
        if (this.getOptions().sourceMapIncludeSourcesContent && this.getSourceMap() != null) {
            for (SourceFile file : files) {
                try {
                    this.getSourceMap().addSourceFile(file.getName(), file.getCode());
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot read code of a source map's source file.", e);
                }
            }
        }
    }

    public void initWebpackMap(ImmutableMap<String, String> inputPathByWebpackId) {
        this.inputPathByWebpackId = inputPathByWebpackId;
    }

    protected CompilerExecutor createCompilerExecutor() {
        return new CompilerExecutor();
    }

    protected CompilerExecutor getCompilerExecutor() {
        return this.compilerExecutor;
    }

    private static final ImmutableListMultimap<JSChunk, InputId> mapJSModulesToInputIds(Iterable<JSChunk> jsModules) {
        ImmutableListMultimap.Builder jsmoduleToInputId = ImmutableListMultimap.builder();
        for (JSChunk jsModule : jsModules) {
            jsmoduleToInputId.putAll((Object)jsModule, (Iterable)jsModule.getInputs().stream().map(CompilerInput::getInputId).collect(ImmutableList.toImmutableList()));
        }
        return jsmoduleToInputId.build();
    }

    @GwtIncompatible(value="ObjectOutputStream")
    public void saveState(OutputStream outputStream) throws IOException {
        this.runInCompilerThread(() -> {
            Tracer tracer = this.newTracer("serializeCompilerState");
            new ObjectOutputStream(outputStream).writeObject(new CompilerState(this));
            this.stopTracer(tracer, "serializeCompilerState");
            tracer = this.newTracer("serializeTypedAst");
            LocaleDataPasses.addLocaleDataToAST(this, this.getLocaleSubstitutionData());
            SerializeTypedAstPass.createFromOutputStream(this, outputStream).process(this.externsRoot, this.jsRoot);
            this.stopTracer(tracer, "serializeTypedAst");
            return null;
        });
    }

    @GwtIncompatible(value="ClassNotFoundException")
    public void restoreState(InputStream inputStream) throws IOException, ClassNotFoundException {
        this.initWarningsGuard(this.options.getWarningsGuard());
        this.maybeSetTracker();
        this.runInCompilerThread(() -> {
            Tracer tracer = this.newTracer("deserializeCompilerState");
            logger.fine("Deserializing the CompilerState");
            try {
                this.deserializeCompilerState(inputStream);
                Object var3_3 = null;
                return var3_3;
            }
            finally {
                logger.fine("Finished deserializing CompilerState");
                this.stopTracer(tracer, "deserializeCompilerState");
            }
        });
        if (this.tracker != null) {
            this.tracker.updateAfterDeserialize(this.jsRoot);
        }
    }

    @GwtIncompatible(value="ObjectInputStream")
    private void deserializeCompilerState(InputStream inputStream) throws IOException, ClassNotFoundException {
        CompilerState compilerState = (CompilerState)new ObjectInputStream(inputStream).readObject();
        Preconditions.checkNotNull(this.moduleGraph, "Did you forget to call .init or .initModules before restoreState?");
        ImmutableMap.Builder<String, SourceFile> externFilesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<String, SourceFile> codeFilesBuilder = ImmutableMap.builder();
        ImmutableList.Builder allInputFiles = ImmutableList.builder();
        for (CompilerInput input : this.moduleGraph.getAllInputs()) {
            allInputFiles.add(input.getSourceFile());
            codeFilesBuilder.put(input.getInputId().getIdName(), input.getSourceFile());
        }
        for (CompilerInput extern : this.externs) {
            allInputFiles.add(extern.getSourceFile());
            externFilesBuilder.put(extern.getInputId().getIdName(), extern.getSourceFile());
        }
        TypedAstDeserializer.DeserializedAst deserializedAst = TypedAstDeserializer.deserializeFullAst(this, this.SYNTHETIC_EXTERNS_FILE, (ImmutableList<SourceFile>)allInputFiles.build(), inputStream, compilerState.typeCheckingHasRun);
        this.featureSet = compilerState.featureSet;
        this.scriptNodeByFilename.clear();
        this.typeCheckingHasRun = compilerState.typeCheckingHasRun;
        this.injectedLibraries.clear();
        this.injectedLibraries.addAll(compilerState.injectedLibraries);
        this.hasRegExpGlobalReferences = compilerState.hasRegExpGlobalReferences;
        AbstractCompiler.LifeCycleStage stage = compilerState.lifeCycleStage == AbstractCompiler.LifeCycleStage.RAW ? AbstractCompiler.LifeCycleStage.COLORS_AND_SIMPLIFIED_JSDOC : compilerState.lifeCycleStage;
        this.setLifeCycleStage(stage);
        this.moduleGraph = compilerState.moduleGraph;
        this.uniqueNameId = compilerState.uniqueNameId;
        this.uniqueIdSupplier = compilerState.uniqueIdSupplier;
        this.exportedNames.clear();
        this.exportedNames.addAll(compilerState.exportedNames);
        this.cssNames = compilerState.cssNames;
        this.variableMap = null;
        this.propertyMap = null;
        this.stringMap = compilerState.stringMap;
        this.idGeneratorMap = compilerState.idGeneratorMap;
        this.crossModuleIdGenerator = compilerState.crossModuleIdGenerator;
        this.runJ2clPasses = compilerState.runJ2clPasses;
        this.inputSourceMaps = compilerState.inputSourceMaps;
        this.changeStamp = compilerState.changeStamp;
        this.accessorSummary = compilerState.accessorSummary;
        this.externProperties = deserializedAst.getExternProperties();
        this.externAndJsRoot = IR.root(IR.root(new Node[0]), IR.root(new Node[0]));
        this.externsRoot = this.externAndJsRoot.getFirstChild();
        this.jsRoot = this.externAndJsRoot.getLastChild();
        this.inputsById.clear();
        this.externs.clear();
        this.colorRegistry = deserializedAst.getColorRegistry().orNull();
        this.typedAstFilesystem = deserializedAst.getFilesystem();
        ImmutableMap externFiles = externFilesBuilder.buildOrThrow();
        ImmutableMap codeFiles = codeFilesBuilder.buildOrThrow();
        for (InputId extern : compilerState.externs) {
            if (extern.getIdName().equals(this.SYNTHETIC_EXTERNS_FILE.getName())) {
                this.getSynthesizedExternsInput();
                continue;
            }
            SourceFile externFile = (SourceFile)externFiles.get(extern.getIdName());
            if (externFile == null) {
                externFile = Preconditions.checkNotNull((SourceFile)codeFiles.get(extern.getIdName()), "Missing %s", (Object)extern);
            }
            CompilerInput input = new CompilerInput(externFile, true);
            Node script = input.getAstRoot(this);
            this.externsRoot.addChildToBack(script);
            this.inputsById.put(script.getInputId(), input);
            this.scriptNodeByFilename.put(externFile.getName(), script);
            this.externs.add(input);
        }
        for (JSChunk deserializedModule : this.getModules()) {
            for (InputId inputId : compilerState.moduleToInputList.get(deserializedModule)) {
                SourceFile src = Preconditions.checkNotNull((SourceFile)codeFiles.get(inputId.getIdName()), "Missing %s", (Object)inputId);
                CompilerInput input = new CompilerInput(src);
                Node script = input.getAstRoot(this);
                this.jsRoot.addChildToBack(script);
                this.scriptNodeByFilename.put(src.getName(), script);
                this.putCompilerInput(input);
                deserializedModule.add(input);
            }
        }
        this.typedAstFilesystem = null;
        this.setLocaleSubstitutionData(LocaleDataPasses.reconstituteLocaleDataFromAST(this));
        this.lastInjectedLibrary = compilerState.lastInjectedLibraryIndexInFirstScript != -1 ? this.jsRoot.getFirstChild().getChildAtIndex(compilerState.lastInjectedLibraryIndexInFirstScript) : null;
    }

    @Override
    @Nullable
    CompilerInput.ModuleType getModuleTypeByName(String moduleName) {
        return this.moduleTypesByName.get(moduleName);
    }

    @Override
    public ModuleMetadataMap getModuleMetadataMap() {
        return this.moduleMetadataMap;
    }

    @Override
    public void setModuleMetadataMap(ModuleMetadataMap moduleMetadataMap) {
        this.moduleMetadataMap = moduleMetadataMap;
    }

    @Override
    public ModuleMap getModuleMap() {
        return this.moduleMap;
    }

    @Override
    public void setModuleMap(ModuleMap moduleMap) {
        this.moduleMap = moduleMap;
    }

    private static String resolveSibling(String fromPath, String toPath) {
        if (toPath.startsWith("/")) {
            return toPath;
        }
        ArrayList<String> fromPathParts = new ArrayList<String>(Arrays.asList(fromPath.split("/")));
        ArrayList<String> toPathParts = new ArrayList<String>(Arrays.asList(toPath.split("/")));
        if (!fromPathParts.isEmpty()) {
            fromPathParts.remove(fromPathParts.size() - 1);
        }
        while (!fromPathParts.isEmpty() && !toPathParts.isEmpty()) {
            if (((String)toPathParts.get(0)).equals(".")) {
                toPathParts.remove(0);
                continue;
            }
            if (!((String)toPathParts.get(0)).equals("..")) break;
            toPathParts.remove(0);
            fromPathParts.remove(fromPathParts.size() - 1);
        }
        fromPathParts.addAll(toPathParts);
        return String.join((CharSequence)"/", fromPathParts);
    }

    public void resetAndIntitializeSourceMap() {
        if (this.sourceMap == null) {
            return;
        }
        this.sourceMap.reset();
        if (this.options.sourceMapIncludeSourcesContent) {
            Iterable<JSChunk> allModules;
            if (this.options.applyInputSourceMaps) {
                for (SourceMapInput inputSourceMap : this.inputSourceMaps.values()) {
                    this.addSourceMapSourceFiles(inputSourceMap);
                }
            }
            if ((allModules = this.getModules()) != null) {
                ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
                for (JSChunk module : allModules) {
                    for (CompilerInput input : module.getInputs()) {
                        sourceFiles.add(input.getSourceFile());
                    }
                }
                this.addFilesToSourceMap(sourceFiles);
            }
        }
    }

    private static Node checkNotModule(Node script, String msg, Object ... args) {
        Preconditions.checkArgument(script.isScript(), script);
        if (!script.hasOneChild()) {
            return script;
        }
        Preconditions.checkState(!script.getFirstChild().isModuleBody(), msg, args);
        return script;
    }

    private static class CompilerState
    implements Serializable {
        private final FeatureSet featureSet;
        private final boolean typeCheckingHasRun;
        private final boolean hasRegExpGlobalReferences;
        private final AbstractCompiler.LifeCycleStage lifeCycleStage;
        private final JSChunkGraph moduleGraph;
        private final int uniqueNameId;
        private final UniqueIdSupplier uniqueIdSupplier;
        private final Set<String> exportedNames;
        private final Map<String, Integer> cssNames;
        private final String idGeneratorMap;
        private final IdGenerator crossModuleIdGenerator;
        private final boolean runJ2clPasses;
        private final ConcurrentHashMap<String, SourceMapInput> inputSourceMaps;
        private final int changeStamp;
        private final ImmutableList<InputId> externs;
        private final ImmutableListMultimap<JSChunk, InputId> moduleToInputList;
        private final LinkedHashSet<String> injectedLibraries;
        private final int lastInjectedLibraryIndexInFirstScript;
        private final AccessorSummary accessorSummary;
        private final VariableMap stringMap;

        CompilerState(Compiler compiler) {
            this.featureSet = Preconditions.checkNotNull(compiler.featureSet);
            this.typeCheckingHasRun = compiler.typeCheckingHasRun;
            this.hasRegExpGlobalReferences = compiler.hasRegExpGlobalReferences;
            this.lifeCycleStage = compiler.getLifeCycleStage();
            this.moduleGraph = compiler.moduleGraph;
            this.uniqueNameId = compiler.uniqueNameId;
            this.uniqueIdSupplier = compiler.uniqueIdSupplier;
            this.exportedNames = compiler.exportedNames;
            this.cssNames = compiler.cssNames;
            this.idGeneratorMap = compiler.idGeneratorMap;
            this.crossModuleIdGenerator = compiler.crossModuleIdGenerator;
            this.runJ2clPasses = compiler.runJ2clPasses;
            this.inputSourceMaps = compiler.inputSourceMaps;
            this.changeStamp = compiler.changeStamp;
            this.externs = compiler.externs.stream().map(CompilerInput::getInputId).collect(ImmutableList.toImmutableList());
            this.moduleToInputList = Compiler.mapJSModulesToInputIds(compiler.moduleGraph.getAllChunks());
            this.injectedLibraries = compiler.injectedLibraries;
            this.lastInjectedLibraryIndexInFirstScript = compiler.lastInjectedLibrary != null ? compiler.jsRoot.getFirstChild().getIndexOfChild(compiler.lastInjectedLibrary) : -1;
            this.accessorSummary = compiler.accessorSummary;
            this.stringMap = compiler.getStringMap();
        }
    }

    public static class CodeBuilder {
        private final StringBuilder sb = new StringBuilder();
        private int lineCount = 0;
        private int colCount = 0;
        private final Set<String> uniqueLicenses = new HashSet<String>();

        void reset() {
            this.sb.setLength(0);
        }

        CodeBuilder append(String str) {
            int index;
            this.sb.append(str);
            int lastIndex = index = -1;
            while ((index = str.indexOf(10, index + 1)) >= 0) {
                ++this.lineCount;
                lastIndex = index;
            }
            this.colCount = lastIndex == -1 ? (this.colCount += str.length()) : str.length() - (lastIndex + 1);
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }

        public int getLength() {
            return this.sb.length();
        }

        int getLineIndex() {
            return this.lineCount;
        }

        int getColumnIndex() {
            return this.colCount;
        }

        boolean endsWith(String suffix) {
            return this.sb.length() > suffix.length() && suffix.equals(this.sb.substring(this.sb.length() - suffix.length()));
        }

        boolean addLicense(String license) {
            return this.uniqueLicenses.add(license);
        }
    }

    private static class ResolvedSourceMap {
        public String originalPath;
        public String sourceMapPath;
        public String relativePath;

        private ResolvedSourceMap() {
        }
    }

    public static class ExternalSourceLoader {
        public SourceFile loadSource(String filename) {
            throw new RuntimeException("Cannot load without a valid loader.");
        }
    }
}

