/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Joiner;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public final class ComposeWarningsGuard
extends WarningsGuard {
    private static final long serialVersionUID = 1L;
    private final Map<WarningsGuard, Integer> orderOfAddition = new HashMap<WarningsGuard, Integer>();
    private int numberOfAdds = 0;
    private final Comparator<WarningsGuard> guardComparator = new GuardComparator(this.orderOfAddition);
    private boolean demoteErrors = false;
    private final TreeSet<WarningsGuard> guards = new TreeSet<WarningsGuard>(this.guardComparator);

    public ComposeWarningsGuard(List<WarningsGuard> guards) {
        this.addGuards(guards);
    }

    public ComposeWarningsGuard(WarningsGuard ... guards) {
        this(ImmutableList.copyOf(guards));
    }

    void addGuard(WarningsGuard guard) {
        if (guard instanceof ComposeWarningsGuard) {
            ComposeWarningsGuard composeGuard = (ComposeWarningsGuard)guard;
            if (composeGuard.demoteErrors) {
                this.demoteErrors = composeGuard.demoteErrors;
            }
            this.addGuards(new ArrayList<WarningsGuard>(composeGuard.guards.descendingSet()));
        } else {
            ++this.numberOfAdds;
            this.orderOfAddition.put(guard, this.numberOfAdds);
            this.guards.remove(guard);
            this.guards.add(guard);
        }
    }

    private void addGuards(Iterable<WarningsGuard> guards) {
        for (WarningsGuard guard : guards) {
            this.addGuard(guard);
        }
    }

    @Override
    @Nullable
    public CheckLevel level(JSError error) {
        for (WarningsGuard guard : this.guards) {
            CheckLevel newLevel = guard.level(error);
            if (newLevel == null) continue;
            if (this.demoteErrors && newLevel == CheckLevel.ERROR) {
                return CheckLevel.WARNING;
            }
            return newLevel;
        }
        return null;
    }

    @Override
    public Tri mustRunChecks(DiagnosticGroup group) {
        boolean enable = this.enables(group);
        boolean disable = this.disables(group);
        Preconditions.checkState(!enable || !disable, "%s applied to %s", (Object)this, (Object)group);
        if (enable) {
            return Tri.TRUE;
        }
        if (disable) {
            return Tri.FALSE;
        }
        return Tri.UNKNOWN;
    }

    private boolean disables(DiagnosticGroup group) {
        block4: for (DiagnosticType type : group.getTypes()) {
            DiagnosticGroup singleton = DiagnosticGroup.forType(type);
            for (WarningsGuard guard : this.guards) {
                switch (guard.mustRunChecks(singleton)) {
                    case TRUE: {
                        return false;
                    }
                    case FALSE: {
                        continue block4;
                    }
                }
            }
            return false;
        }
        return true;
    }

    private boolean enables(DiagnosticGroup group) {
        for (WarningsGuard guard : this.guards) {
            switch (guard.mustRunChecks(group)) {
                case TRUE: {
                    return true;
                }
                case FALSE: {
                    return false;
                }
            }
        }
        return false;
    }

    SortedSet<WarningsGuard> getGuards() {
        return Collections.unmodifiableSortedSet(this.guards);
    }

    public String toString() {
        return Joiner.on(", ").join(this.guards);
    }

    private static class GuardComparator
    implements Comparator<WarningsGuard>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<WarningsGuard, Integer> orderOfAddition;

        private GuardComparator(Map<WarningsGuard, Integer> orderOfAddition) {
            this.orderOfAddition = orderOfAddition;
        }

        @Override
        public int compare(WarningsGuard a, WarningsGuard b) {
            int priorityDiff = a.getPriority() - b.getPriority();
            if (priorityDiff != 0) {
                return priorityDiff;
            }
            return this.orderOfAddition.get(b) - this.orderOfAddition.get(a);
        }
    }
}

