/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckConformance;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.ConformanceConfig;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Requirement;
import com.google.javascript.jscomp.ThreadSafeDelegatingErrorManager;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Optional;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.rhino.Node;

@GwtIncompatible(value="Conformance")
public class ConformanceAllowlister {
    private ConformanceAllowlister() {
    }

    public static ImmutableSet<String> getViolatingPaths(Compiler compiler, Node externs, Node ast, Requirement requirement) {
        return ConformanceAllowlister.getConformanceErrors(compiler, externs, ast, requirement).stream().map(JSError::getSourceName).collect(ImmutableSet.toImmutableSet());
    }

    public static ImmutableSet<Node> getViolatingNodes(Compiler compiler, Node externs, Node ast, Requirement requirement) {
        return ConformanceAllowlister.getConformanceErrors(compiler, externs, ast, requirement).stream().map(JSError::getNode).collect(ImmutableSet.toImmutableSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImmutableList<JSError> getConformanceErrors(Compiler compiler, Node externs, Node ast, Requirement requirement) {
        Requirement cleanedRequirement = requirement.toBuilder().clearWhitelist().clearAllowlist().clearWhitelistRegexp().clearAllowlistRegexp().clearWhitelistEntry().clearAllowlistEntry().setSeverity(Requirement.Severity.ERROR).build();
        ConformanceConfig cleanedConfig = ConformanceConfig.newBuilder().addRequirement(cleanedRequirement).build();
        ErrorManager oldErrorManager = compiler.getErrorManager();
        final ImmutableList.Builder errors = ImmutableList.builder();
        try {
            compiler.setErrorManager(new ThreadSafeDelegatingErrorManager(oldErrorManager){

                @Override
                public synchronized boolean shouldReportConformanceViolation(Requirement requirement, Optional<Requirement.WhitelistEntry> whitelistEntry, JSError diagnostic) {
                    errors.add(diagnostic);
                    return false;
                }
            });
            CheckConformance check = new CheckConformance(compiler, ImmutableList.of(cleanedConfig));
            check.process(externs, ast);
        }
        finally {
            compiler.setErrorManager(oldErrorManager);
        }
        return errors.build();
    }
}

