/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class DefaultExterns {
    private static final ImmutableList<String> BUILTIN_LANG_EXTERNS = ImmutableList.of("es3.js", "es5.js", "es6.js", "es6_collections.js");
    private static final ImmutableList<String> BROWSER_EXTERN_DEP_ORDER = ImmutableList.of("intl.js", "w3c_event.js", "w3c_event3.js", "gecko_event.js", "ie_event.js", "webkit_event.js", "w3c_device_sensor_event.js", "w3c_dom1.js", "w3c_dom2.js", "w3c_dom3.js", "w3c_dom4.js", "gecko_dom.js", new String[]{"ie_dom.js", "webkit_dom.js", "w3c_css.js", "gecko_css.js", "ie_css.js", "webkit_css.js", "w3c_touch_event.js", "webstorage.js", "whatwg_console.js", "nonstandard_console.js", "w3c_rtc.js"});

    private DefaultExterns() {
    }

    public static List<SourceFile> prepareExterns(CompilerOptions.Environment env, Map<String, SourceFile> externs) {
        ArrayList<SourceFile> out = new ArrayList<SourceFile>();
        for (String key : BUILTIN_LANG_EXTERNS) {
            Preconditions.checkState(externs.containsKey(key), "Externs must contain builtin: %s", (Object)key);
            out.add(externs.remove(key));
        }
        if (env == CompilerOptions.Environment.BROWSER) {
            for (String key : BROWSER_EXTERN_DEP_ORDER) {
                Preconditions.checkState(externs.containsKey(key), "Externs must contain builtin for env %s: %s", (Object)env, (Object)key);
                out.add(externs.remove(key));
            }
            out.addAll(externs.values());
        }
        return out;
    }
}

