/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Supplier;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;

public final class DestructuredTarget {
    private final JSTypeRegistry registry;
    @Nullable
    private final Node objectPatternKey;
    @Nullable
    private final Node node;
    private final Supplier<JSType> patternTypeSupplier;
    @Nullable
    private final Node defaultValue;
    private final boolean isRest;
    private final Node pattern;

    private DestructuredTarget(Node pattern, Node node, @Nullable Node defaultValue, @Nullable Node objectPatternKey, JSTypeRegistry registry, Supplier<JSType> patternTypeSupplier, boolean isRest) {
        this.pattern = pattern;
        this.node = node;
        this.objectPatternKey = objectPatternKey;
        this.registry = registry;
        this.patternTypeSupplier = patternTypeSupplier;
        this.isRest = isRest;
        this.defaultValue = defaultValue;
    }

    @Nullable
    public Node getComputedProperty() {
        return this.hasComputedProperty() ? this.objectPatternKey : null;
    }

    public boolean hasComputedProperty() {
        return this.objectPatternKey != null && this.objectPatternKey.isComputedProp();
    }

    public boolean hasStringKey() {
        return this.objectPatternKey != null && this.objectPatternKey.isStringKey();
    }

    @Nullable
    public Node getStringKey() {
        return this.hasStringKey() ? this.objectPatternKey : null;
    }

    @Nullable
    public Node getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public Node getNode() {
        return this.node;
    }

    static DestructuredTarget createTarget(JSTypeRegistry registry, JSType destructuringPatternType, Node destructuringChild) {
        return DestructuredTarget.createTarget(registry, () -> destructuringPatternType, destructuringChild);
    }

    static DestructuredTarget createTarget(JSTypeRegistry registry, Supplier<JSType> destructuringPatternType, Node destructuringChild) {
        Preconditions.checkArgument(destructuringChild.getParent().isDestructuringPattern(), destructuringChild);
        Builder builder = new Builder(registry, destructuringChild.getParent(), destructuringPatternType);
        switch (destructuringChild.getToken()) {
            case STRING_KEY: {
                builder.setObjectPatternKey(destructuringChild);
                Node value = destructuringChild.getFirstChild();
                if (value.isDefaultValue()) {
                    builder.setNode(value.getFirstChild());
                    builder.setDefaultValue(value.getSecondChild());
                    break;
                }
                builder.setNode(value);
                break;
            }
            case COMPUTED_PROP: {
                builder.setObjectPatternKey(destructuringChild);
                Node value = destructuringChild.getSecondChild();
                if (value.isDefaultValue()) {
                    builder.setNode(value.getFirstChild());
                    builder.setDefaultValue(value.getSecondChild());
                    break;
                }
                builder.setNode(value);
                break;
            }
            case OBJECT_PATTERN: 
            case ARRAY_PATTERN: 
            case NAME: 
            case GETELEM: 
            case GETPROP: {
                builder.setNode(destructuringChild);
                break;
            }
            case DEFAULT_VALUE: {
                builder.setNode(destructuringChild.getFirstChild());
                builder.setDefaultValue(destructuringChild.getSecondChild());
                break;
            }
            case ITER_REST: 
            case OBJECT_REST: {
                builder.setNode(destructuringChild.getFirstChild());
                builder.setIsRest(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected child of destructuring pattern " + destructuringChild);
            }
        }
        return builder.build();
    }

    public static ImmutableList<DestructuredTarget> createAllNonEmptyTargetsInPattern(JSTypeRegistry registry, JSType patternType, Node pattern) {
        return DestructuredTarget.createAllNonEmptyTargetsInPattern(registry, () -> patternType, pattern);
    }

    public static ImmutableList<DestructuredTarget> createAllNonEmptyTargetsInPattern(JSTypeRegistry registry, Supplier<JSType> patternType, Node pattern) {
        Preconditions.checkArgument(pattern.isDestructuringPattern(), pattern);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Node child = pattern.getFirstChild(); child != null; child = child.getNext()) {
            if (child.isEmpty()) continue;
            builder.add(DestructuredTarget.createTarget(registry, patternType, child));
        }
        return builder.build();
    }

    JSType inferTypeWithoutUsingDefaultValue() {
        if (this.pattern.isObjectPattern()) {
            return this.inferObjectPatternKeyType();
        }
        return this.inferArrayPatternTargetType();
    }

    JSType inferType() {
        JSType inferredType = this.inferTypeWithoutUsingDefaultValue();
        if (!inferredType.isUnknownType() && this.hasDefaultValue()) {
            JSType defaultValueType = this.getDefaultValue().getJSType();
            if (defaultValueType == null) {
                defaultValueType = this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            return this.registry.createUnionType(inferredType.restrictByNotUndefined(), defaultValueType);
        }
        return inferredType;
    }

    private JSType inferObjectPatternKeyType() {
        JSType patternType = this.patternTypeSupplier.get();
        if (this.isRest) {
            return this.registry.getNativeType(JSTypeNative.OBJECT_TYPE);
        }
        if (patternType == null || patternType.isUnknownType()) {
            return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        switch (this.objectPatternKey.getToken()) {
            case STRING_KEY: {
                JSType propertyType = patternType.findPropertyType(this.objectPatternKey.getString());
                return propertyType != null ? propertyType : this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            case COMPUTED_PROP: {
                return patternType != null ? patternType.getTemplateTypeMap().getResolvedTemplateType(this.registry.getObjectElementKey()) : this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
        }
        throw new IllegalStateException("Unexpected key " + this.objectPatternKey);
    }

    private JSType inferArrayPatternTargetType() {
        JSType patternType = this.patternTypeSupplier.get();
        JSType templateTypeOfIterable = patternType.getTemplateTypeMap().getResolvedTemplateType(this.registry.getIterableTemplate());
        if (this.isRest) {
            return this.registry.createTemplatizedType(this.registry.getNativeObjectType(JSTypeNative.ARRAY_TYPE), templateTypeOfIterable);
        }
        return templateTypeOfIterable;
    }

    private static class Builder {
        private final JSTypeRegistry registry;
        private final Supplier<JSType> patternTypeSupplier;
        private final Node pattern;
        private Node node;
        @Nullable
        private Node defaultValue = null;
        @Nullable
        private Node objectPatternKey = null;
        private boolean isRest = false;

        Builder(JSTypeRegistry registry, Node pattern, Supplier<JSType> patternTypeSupplier) {
            this.registry = registry;
            this.patternTypeSupplier = patternTypeSupplier;
            this.pattern = pattern;
        }

        Builder setNode(Node node) {
            this.node = node;
            return this;
        }

        Builder setDefaultValue(Node defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        Builder setObjectPatternKey(Node objectPatternKey) {
            this.objectPatternKey = objectPatternKey;
            return this;
        }

        Builder setIsRest(boolean isRest) {
            this.isRest = isRest;
            return this;
        }

        DestructuredTarget build() {
            Preconditions.checkNotNull(this.node, "Must set a node");
            return new DestructuredTarget(this.pattern, this.node, this.defaultValue, this.objectPatternKey, this.registry, this.patternTypeSupplier, this.isRest);
        }
    }
}

