/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Set;

class DestructuringGlobalNameExtractor {
    DestructuringGlobalNameExtractor() {
    }

    static void reassignDestructringLvalue(Node stringKey, Node newName, @Nullable Set<GlobalNamespace.AstChange> newNodes, GlobalNamespace.Ref ref, AbstractCompiler compiler) {
        Node lvalueToReassign;
        Node pattern = stringKey.getParent();
        Node assignmentType = pattern.getParent();
        Preconditions.checkState(assignmentType.isAssign() || assignmentType.isDestructuringLhs(), assignmentType);
        Node originalRvalue = pattern.getNext();
        Preconditions.checkState(originalRvalue.isQualifiedName());
        Node node = lvalueToReassign = stringKey.getOnlyChild().isDefaultValue() ? stringKey.getOnlyChild().getFirstChild() : stringKey.getOnlyChild();
        if (newNodes != null) {
            newNodes.add(new GlobalNamespace.AstChange(ref.scope, newName));
        }
        Node rvalue = DestructuringGlobalNameExtractor.makeNewRvalueForDestructuringKey(stringKey, newName, newNodes, ref);
        if (stringKey.getPrevious() == null && stringKey.getNext() != null) {
            DestructuringGlobalNameExtractor.replaceDestructuringAssignment(pattern, lvalueToReassign.detach(), rvalue);
        } else {
            DestructuringGlobalNameExtractor.addAfter(pattern, lvalueToReassign.detach(), rvalue);
        }
        if (stringKey.getNext() != null) {
            Node newRvalue;
            Node newPattern = DestructuringGlobalNameExtractor.createNewObjectPatternFromSuccessiveKeys(stringKey).srcref(pattern);
            if (stringKey.getPrevious() == null) {
                newRvalue = originalRvalue.detach();
            } else {
                newRvalue = originalRvalue.cloneTree();
                if (newNodes != null) {
                    newNodes.add(new GlobalNamespace.AstChange(ref.scope, newRvalue));
                }
            }
            DestructuringGlobalNameExtractor.addAfter(lvalueToReassign, newPattern, newRvalue);
        }
        stringKey.detach();
        compiler.reportChangeToEnclosingScope(lvalueToReassign);
    }

    private static void addAfter(Node originalLvalue, Node newLvalue, Node newRvalue) {
        Node parent = originalLvalue.getParent();
        if (parent.isAssign()) {
            Node newAssign = IR.assign(newLvalue, newRvalue).srcref(parent);
            Node newComma = new Node(Token.COMMA, newAssign);
            parent.replaceWith(newComma);
            newComma.addChildToFront(parent);
            return;
        }
        if (newLvalue.isDestructuringPattern()) {
            newLvalue = new Node(Token.DESTRUCTURING_LHS, newLvalue, newRvalue).srcref(parent);
        } else {
            newLvalue.addChildToBack(newRvalue);
        }
        Node declaration = parent.isDestructuringLhs() ? originalLvalue.getGrandparent() : parent;
        Preconditions.checkState(NodeUtil.isNameDeclaration(declaration), declaration);
        if (NodeUtil.isStatementParent(declaration.getParent())) {
            Node newDeclaration = new Node(declaration.getToken()).srcref(declaration);
            newDeclaration.addChildToBack(newLvalue);
            newDeclaration.insertAfter(declaration);
        } else {
            declaration.addChildToBack(newLvalue);
        }
    }

    private static void replaceDestructuringAssignment(Node pattern, Node newLvalue, Node newRvalue) {
        Node parent = pattern.getParent();
        if (parent.isAssign()) {
            Node newAssign = IR.assign(newLvalue, newRvalue).srcref(parent);
            parent.replaceWith(newAssign);
        } else if (newLvalue.isName()) {
            Preconditions.checkState(parent.isDestructuringLhs());
            parent.replaceWith(newLvalue);
            newLvalue.addChildToBack(newRvalue);
        } else {
            pattern.getNext().detach();
            pattern.detach();
            parent.addChildToBack(newLvalue);
            parent.addChildToBack(newRvalue);
        }
    }

    private static Node makeNewRvalueForDestructuringKey(Node stringKey, Node rvalue, Set<GlobalNamespace.AstChange> newNodes, GlobalNamespace.Ref ref) {
        if (stringKey.getOnlyChild().isDefaultValue()) {
            Node defaultValue = stringKey.getFirstChild().getSecondChild().detach();
            Node rvalueForSheq = rvalue.cloneTree();
            if (newNodes != null) {
                newNodes.add(new GlobalNamespace.AstChange(ref.scope, rvalueForSheq));
            }
            rvalue = IR.hook(IR.sheq(NodeUtil.newUndefinedNode(rvalue), rvalueForSheq), defaultValue, rvalue).srcrefTree(defaultValue);
        }
        return rvalue;
    }

    private static Node createNewObjectPatternFromSuccessiveKeys(Node stringKey) {
        Node newPattern = stringKey.getParent().cloneNode();
        Node next = stringKey.getNext();
        while (next != null) {
            Node newKey = next;
            next = newKey.getNext();
            newPattern.addChildToBack(newKey.detach());
        }
        return newPattern;
    }
}

