/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckAccessControls;
import com.google.javascript.jscomp.CheckClosureImports;
import com.google.javascript.jscomp.CheckConformance;
import com.google.javascript.jscomp.CheckDebuggerStatement;
import com.google.javascript.jscomp.CheckGlobalThis;
import com.google.javascript.jscomp.CheckJSDoc;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CheckMissingRequires;
import com.google.javascript.jscomp.CheckMissingReturn;
import com.google.javascript.jscomp.CheckRegExp;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckSuspiciousCode;
import com.google.javascript.jscomp.CheckTypeImportCodeReferences;
import com.google.javascript.jscomp.CheckUnreachableCode;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.ClosurePrimitiveErrors;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ConstCheck;
import com.google.javascript.jscomp.ConstParamCheck;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.FunctionTypeBuilder;
import com.google.javascript.jscomp.ImplicitNullabilityCheck;
import com.google.javascript.jscomp.InlineAndCollapseProperties;
import com.google.javascript.jscomp.J2clChecksPass;
import com.google.javascript.jscomp.JSChunkGraph;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.MarkUntranspilableFeaturesAsRemoved;
import com.google.javascript.jscomp.PeepholeFoldConstants;
import com.google.javascript.jscomp.PhaseOptimizer;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.ProcessClosurePrimitives;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.ProcessDefines;
import com.google.javascript.jscomp.ProcessTweaks;
import com.google.javascript.jscomp.RewritePolyfills;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.StrictModeCheck;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.disambiguate.DisambiguateProperties;
import com.google.javascript.jscomp.ijs.IjsErrors;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.lint.CheckArrayWithGoogObject;
import com.google.javascript.jscomp.lint.CheckConstPrivateProperties;
import com.google.javascript.jscomp.lint.CheckConstantCaseNames;
import com.google.javascript.jscomp.lint.CheckDefaultExportOfGoogModule;
import com.google.javascript.jscomp.lint.CheckDuplicateCase;
import com.google.javascript.jscomp.lint.CheckEmptyStatements;
import com.google.javascript.jscomp.lint.CheckEnums;
import com.google.javascript.jscomp.lint.CheckEs6ModuleFileStructure;
import com.google.javascript.jscomp.lint.CheckEs6Modules;
import com.google.javascript.jscomp.lint.CheckExtraRequires;
import com.google.javascript.jscomp.lint.CheckGoogModuleTypeScriptName;
import com.google.javascript.jscomp.lint.CheckInterfaces;
import com.google.javascript.jscomp.lint.CheckJSDocStyle;
import com.google.javascript.jscomp.lint.CheckMissingSemicolon;
import com.google.javascript.jscomp.lint.CheckNestedNames;
import com.google.javascript.jscomp.lint.CheckNoMutatedEs6Exports;
import com.google.javascript.jscomp.lint.CheckNullabilityModifiers;
import com.google.javascript.jscomp.lint.CheckPrimitiveAsObject;
import com.google.javascript.jscomp.lint.CheckPrototypeProperties;
import com.google.javascript.jscomp.lint.CheckProvidesSorted;
import com.google.javascript.jscomp.lint.CheckRequiresSorted;
import com.google.javascript.jscomp.lint.CheckUnusedLabels;
import com.google.javascript.jscomp.lint.CheckUnusedPrivateProperties;
import com.google.javascript.jscomp.lint.CheckUselessBlocks;
import com.google.javascript.jscomp.lint.CheckVar;
import com.google.javascript.jscomp.modules.ModuleMapCreator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DiagnosticGroups {
    static final DiagnosticType UNUSED = DiagnosticType.warning("JSC_UNUSED", "{0}");
    public static final Set<String> wildcardExcludedGroups = ImmutableSet.of("reportUnknownTypes", "analyzerChecks", "missingSourcesWarnings");
    private static final Map<String, DiagnosticGroup> groupsByName = new HashMap<String, DiagnosticGroup>();
    static final String DIAGNOSTIC_GROUP_NAMES = "accessControls, checkPrototypalTypes, checkRegExp, checkTypes, checkVars, conformanceViolations, const, constantProperty, deprecated, deprecatedAnnotations, duplicateMessage, es5Strict, externsValidation, functionParams, globalThis, invalidCasts, misplacedTypeAnnotation, missingOverride, missingPolyfill, missingProperties, missingProvide, missingRequire, missingReturn, missingSourcesWarnings, moduleLoad, moduleImports, msgDescriptions, nonStandardJsDocs, partialAlias, polymer, reportUnknownTypes, strictCheckTypes, strictMissingProperties, strictModuleDepCheck, strictPrimitiveOperators, suspiciousCode, typeInvalidation, undefinedVars, underscore, unknownDefines, unusedLocalVariables, unusedPrivateMembers, uselessCode, untranspilableFeatures,visibility";
    public static final DiagnosticGroup UNSTRANSPILABLE_FEATURES = DiagnosticGroups.registerGroup("untranspilableFeatures", MarkUntranspilableFeaturesAsRemoved.UNTRANSPILABLE_FEATURE_PRESENT);
    public static final DiagnosticGroup FEATURES_NOT_SUPPORTED_BY_PASS = DiagnosticGroups.registerGroup("featuresNotSupportedByPass", PhaseOptimizer.FEATURES_NOT_SUPPORTED_BY_PASS);
    public static final DiagnosticGroup MODULE_LOAD = DiagnosticGroups.registerGroup("moduleLoad", ModuleLoader.LOAD_WARNING, ModuleMapCreator.MISSING_NAMESPACE_IMPORT, ProcessCommonJSModules.SUSPICIOUS_EXPORTS_ASSIGNMENT, ProcessCommonJSModules.UNKNOWN_REQUIRE_ENSURE);
    public static final DiagnosticGroup MODULE_IMPORT = DiagnosticGroups.registerGroup("moduleImport", ModuleMapCreator.DOES_NOT_HAVE_EXPORT, ModuleMapCreator.DOES_NOT_HAVE_EXPORT_WITH_DETAILS);
    public static final DiagnosticGroup GLOBAL_THIS = DiagnosticGroups.registerGroup("globalThis", CheckGlobalThis.GLOBAL_THIS);
    public static final DiagnosticGroup DEPRECATED = DiagnosticGroups.registerGroup("deprecated", CheckAccessControls.DEPRECATED_NAME, CheckAccessControls.DEPRECATED_NAME_REASON, CheckAccessControls.DEPRECATED_PROP, CheckAccessControls.DEPRECATED_PROP_REASON, CheckAccessControls.DEPRECATED_CLASS, CheckAccessControls.DEPRECATED_CLASS_REASON);
    public static final DiagnosticGroup UNDERSCORE = DiagnosticGroups.registerDeprecatedGroup("underscore");
    public static final DiagnosticGroup VISIBILITY = DiagnosticGroups.registerGroup("visibility", CheckAccessControls.BAD_PRIVATE_GLOBAL_ACCESS, CheckAccessControls.BAD_PRIVATE_PROPERTY_ACCESS, CheckAccessControls.BAD_PACKAGE_PROPERTY_ACCESS, CheckAccessControls.BAD_PROTECTED_PROPERTY_ACCESS, CheckAccessControls.EXTEND_FINAL_CLASS, CheckAccessControls.FINAL_PROPERTY_OVERRIDDEN, CheckAccessControls.PRIVATE_OVERRIDE, CheckAccessControls.VISIBILITY_MISMATCH);
    public static final DiagnosticGroup ACCESS_CONTROLS = DiagnosticGroups.registerGroup("accessControls", VISIBILITY);
    public static final DiagnosticGroup NON_STANDARD_JSDOC = DiagnosticGroups.registerGroup("nonStandardJsDocs", RhinoErrorReporter.BAD_JSDOC_ANNOTATION, RhinoErrorReporter.INVALID_PARAM, RhinoErrorReporter.JSDOC_IMPORT_TYPE_WARNING, CheckJSDoc.JSDOC_IN_BLOCK_COMMENT);
    public static final DiagnosticGroup INVALID_CASTS = DiagnosticGroups.registerGroup("invalidCasts", TypeValidator.INVALID_CAST);
    public static final DiagnosticGroup STRICT_MODULE_DEP_CHECK = DiagnosticGroups.registerGroup("strictModuleDepCheck", VarCheck.STRICT_MODULE_DEP_ERROR, CheckClosureImports.CROSS_CHUNK_REQUIRE_ERROR);
    public static final DiagnosticGroup VIOLATED_MODULE_DEP = DiagnosticGroups.registerGroup("violatedModuleDep", VarCheck.VIOLATED_MODULE_DEP_ERROR);
    public static final DiagnosticGroup EXTERNS_VALIDATION = DiagnosticGroups.registerGroup("externsValidation", VarCheck.NAME_REFERENCE_IN_EXTERNS_ERROR, VarCheck.UNDEFINED_EXTERN_VAR_ERROR);
    public static final DiagnosticGroup UNKNOWN_DEFINES = DiagnosticGroups.registerGroup("unknownDefines", ProcessDefines.UNKNOWN_DEFINE_WARNING);
    public static final DiagnosticGroup TWEAKS = DiagnosticGroups.registerGroup("tweakValidation", ProcessTweaks.INVALID_TWEAK_DEFAULT_VALUE_WARNING, ProcessTweaks.TWEAK_WRONG_GETTER_TYPE_WARNING);
    public static final DiagnosticGroup MISSING_OVERRIDE = DiagnosticGroups.registerGroup("missingOverride", TypeCheck.HIDDEN_INTERFACE_PROPERTY, TypeCheck.HIDDEN_PROTOTYPAL_SUPERTYPE_PROPERTY, TypeCheck.HIDDEN_SUPERCLASS_PROPERTY);
    public static final DiagnosticGroup MISSING_PROPERTIES = DiagnosticGroups.registerGroup("missingProperties", TypeCheck.INEXISTENT_PROPERTY, TypeCheck.INEXISTENT_PROPERTY_WITH_SUGGESTION, TypeCheck.POSSIBLE_INEXISTENT_PROPERTY);
    public static final DiagnosticGroup GLOBALLY_MISSING_PROPERTIES = DiagnosticGroups.registerGroup("globallyMissingProperties", TypeCheck.POSSIBLE_INEXISTENT_PROPERTY);
    public static final DiagnosticGroup J2CL_CHECKS = DiagnosticGroups.registerGroup("j2clChecks", J2clChecksPass.J2CL_REFERENCE_EQUALITY);
    public static final DiagnosticGroup MISSING_RETURN = DiagnosticGroups.registerGroup("missingReturn", CheckMissingReturn.MISSING_RETURN_STATEMENT);
    public static final DiagnosticGroup UNDEFINED_VARIABLES = DiagnosticGroups.registerGroup("undefinedVars", VarCheck.UNDEFINED_VAR_ERROR);
    public static final DiagnosticGroup DEBUGGER_STATEMENT_PRESENT = DiagnosticGroups.registerGroup("checkDebuggerStatement", CheckDebuggerStatement.DEBUGGER_STATEMENT_PRESENT);
    public static final DiagnosticGroup CHECK_REGEXP = DiagnosticGroups.registerGroup("checkRegExp", CheckRegExp.REGEXP_REFERENCE, CheckRegExp.MALFORMED_REGEXP);
    public static final DiagnosticGroup CHECK_TYPES = DiagnosticGroups.registerGroup("checkTypes", TypeValidator.ALL_DIAGNOSTICS, TypeCheck.ALL_DIAGNOSTICS, FunctionTypeBuilder.ALL_DIAGNOSTICS, GLOBAL_THIS);
    public static final DiagnosticGroup CHECK_PROTOTYPAL_TYPES;
    public static final DiagnosticGroup CHECK_STATIC_OVERRIDES;
    public static final DiagnosticGroup TOO_MANY_TYPE_PARAMS;
    public static final DiagnosticGroup STRICT_MISSING_PROPERTIES;
    public static final DiagnosticGroup STRICT_PRIMITIVE_OPERATORS;
    public static final DiagnosticGroup STRICT_CHECK_TYPES;
    public static final DiagnosticGroup REPORT_UNKNOWN_TYPES;
    public static final DiagnosticGroup CHECK_VARIABLES;
    public static final DiagnosticGroup CHECK_USELESS_CODE;
    public static final DiagnosticGroup CONST;
    public static final DiagnosticGroup CONSTANT_PROPERTY;
    static final DiagnosticGroup ACCESS_CONTROLS_CONST;
    public static final DiagnosticGroup TYPE_INVALIDATION;
    public static final DiagnosticGroup DUPLICATE_VARS;
    public static final DiagnosticGroup ES5_STRICT;
    public static final DiagnosticGroup MISSING_PROVIDE;
    public static final DiagnosticGroup UNRECOGNIZED_TYPE_ERROR;
    public static final DiagnosticGroup MISSING_REQUIRE;
    public static final DiagnosticGroup MISSING_SOURCES_WARNINGS;
    public static final DiagnosticGroup STRICT_REQUIRES;
    public static final DiagnosticGroup EXTRA_REQUIRE;
    @GwtIncompatible(value="JsMessage")
    public static final DiagnosticGroup DUPLICATE_MESSAGE;
    @GwtIncompatible(value="JsMessage")
    public static final DiagnosticGroup MESSAGE_DESCRIPTIONS;
    @GwtIncompatible(value="JsMessage")
    public static final DiagnosticGroup MSG_CONVENTIONS;
    public static final DiagnosticGroup MISPLACED_TYPE_ANNOTATION;
    public static final DiagnosticGroup MISPLACED_MSG_ANNOTATION;
    public static final DiagnosticGroup MISPLACED_SUPPRESS;
    public static final DiagnosticGroup SUSPICIOUS_CODE;
    public static final DiagnosticGroup FUNCTION_PARAMS;
    public static final DiagnosticGroup DEPRECATED_ANNOTATIONS;
    @Deprecated
    public static final DiagnosticGroup UNUSED_PRIVATE_PROPERTY;
    public static final DiagnosticGroup UNUSED_LOCAL_VARIABLE;
    @Deprecated
    public static final DiagnosticGroup MISSING_CONST_PROPERTY;
    public static final DiagnosticGroup JSDOC_MISSING_TYPE;
    public static final DiagnosticGroup UNNECESSARY_ESCAPE;
    public static final DiagnosticGroup TYPE_IMPORT_CODE_REFERENCES;
    public static final DiagnosticGroup PARTIAL_ALIAS;
    static final DiagnosticGroup USE_OF_GOOG_PROVIDE;
    public static final DiagnosticGroup LINT_CHECKS;
    public static final DiagnosticGroup STRICT_MODULE_CHECKS;
    public static final DiagnosticGroup ANALYZER_CHECKS;
    public static final DiagnosticGroup CLOSURE_DEP_METHOD_USAGE_CHECKS;
    @VisibleForTesting
    public static final DiagnosticGroup MALFORMED_GOOG_MODULE;
    @GwtIncompatible(value="Conformance")
    public static final DiagnosticGroup CONFORMANCE_VIOLATIONS;
    public static final DiagnosticGroup LATE_PROVIDE;
    public static final DiagnosticGroup DUPLICATE_NAMESPACES;
    public static final DiagnosticGroup INVALID_DEFINES;
    public static final DiagnosticGroup INVALID_CONST_PARAM;
    public static final DiagnosticGroup CANNOT_TRANSPILE_FEATURE;
    public static final DiagnosticGroup MISSING_POLYFILL;
    public static final DiagnosticGroup POLYMER;
    static final DiagnosticGroup BOUNDED_GENERICS;
    public static final DiagnosticGroup PARSING;

    static DiagnosticGroup registerDeprecatedGroup(String name) {
        return DiagnosticGroups.registerGroup(name, new DiagnosticGroup(name, UNUSED));
    }

    static DiagnosticGroup registerUnsuppressibleGroup(DiagnosticType ... types) {
        return new DiagnosticGroup(types);
    }

    static DiagnosticGroup registerGroup(String name, DiagnosticGroup group) {
        groupsByName.put(name, group);
        return group;
    }

    public static DiagnosticGroup registerGroup(String name, DiagnosticType ... types) {
        DiagnosticGroup group = new DiagnosticGroup(name, types);
        groupsByName.put(name, group);
        return group;
    }

    static DiagnosticGroup registerGroup(String name, DiagnosticGroup ... groups) {
        DiagnosticGroup group = new DiagnosticGroup(name, groups);
        groupsByName.put(name, group);
        return group;
    }

    public static ImmutableMap<String, DiagnosticGroup> getRegisteredGroups() {
        return ImmutableMap.copyOf(groupsByName);
    }

    public static DiagnosticGroup forName(String name) {
        return groupsByName.get(name);
    }

    public void setWarningLevel(CompilerOptions options, String name, CheckLevel level) {
        DiagnosticGroup group = DiagnosticGroups.forName(name);
        Preconditions.checkNotNull(group, "No warning class for name: %s", (Object)name);
        options.setWarningLevel(group, level);
    }

    static {
        CHECK_STATIC_OVERRIDES = CHECK_PROTOTYPAL_TYPES = DiagnosticGroups.registerGroup("checkPrototypalTypes", TypeCheck.UNKNOWN_PROTOTYPAL_OVERRIDE, TypeCheck.HIDDEN_PROTOTYPAL_SUPERTYPE_PROPERTY, TypeCheck.HIDDEN_PROTOTYPAL_SUPERTYPE_PROPERTY_MISMATCH);
        TOO_MANY_TYPE_PARAMS = DiagnosticGroups.registerGroup("tooManyTypeParams", RhinoErrorReporter.TOO_MANY_TEMPLATE_PARAMS);
        STRICT_MISSING_PROPERTIES = DiagnosticGroups.registerGroup("strictMissingProperties", TypeCheck.STRICT_INEXISTENT_PROPERTY, TypeCheck.STRICT_INEXISTENT_PROPERTY_WITH_SUGGESTION, TypeCheck.STRICT_INEXISTENT_UNION_PROPERTY);
        STRICT_PRIMITIVE_OPERATORS = DiagnosticGroups.registerGroup("strictPrimitiveOperators", TypeValidator.INVALID_OPERAND_TYPE);
        STRICT_CHECK_TYPES = DiagnosticGroups.registerGroup("strictCheckTypes", STRICT_MISSING_PROPERTIES, STRICT_PRIMITIVE_OPERATORS);
        REPORT_UNKNOWN_TYPES = DiagnosticGroups.registerGroup("reportUnknownTypes", TypeCheck.UNKNOWN_EXPR_TYPE);
        CHECK_VARIABLES = DiagnosticGroups.registerGroup("checkVars", VarCheck.UNDEFINED_VAR_ERROR, VarCheck.VAR_MULTIPLY_DECLARED_ERROR, VariableReferenceCheck.EARLY_REFERENCE, VariableReferenceCheck.REDECLARED_VARIABLE);
        CHECK_USELESS_CODE = DiagnosticGroups.registerGroup("uselessCode", CheckSideEffects.USELESS_CODE_ERROR, CheckUnreachableCode.UNREACHABLE_CODE);
        CONST = DiagnosticGroups.registerGroup("const", CheckAccessControls.CONST_PROPERTY_DELETED, CheckAccessControls.CONST_PROPERTY_REASSIGNED_VALUE, ConstCheck.CONST_REASSIGNED_VALUE_ERROR);
        CONSTANT_PROPERTY = DiagnosticGroups.registerGroup("constantProperty", CheckAccessControls.CONST_PROPERTY_DELETED, CheckAccessControls.CONST_PROPERTY_REASSIGNED_VALUE);
        ACCESS_CONTROLS_CONST = DiagnosticGroups.registerGroup("accessControlsConst", CONSTANT_PROPERTY);
        TYPE_INVALIDATION = DiagnosticGroups.registerGroup("typeInvalidation", DisambiguateProperties.PROPERTY_INVALIDATION);
        DUPLICATE_VARS = DiagnosticGroups.registerGroup("duplicate", InlineAndCollapseProperties.NAMESPACE_REDEFINED_WARNING, TypeValidator.DUP_VAR_DECLARATION, TypeValidator.DUP_VAR_DECLARATION_TYPE_MISMATCH, TypeCheck.FUNCTION_MASKS_VARIABLE, VarCheck.VAR_MULTIPLY_DECLARED_ERROR, VariableReferenceCheck.REDECLARED_VARIABLE);
        ES5_STRICT = DiagnosticGroups.registerGroup("es5Strict", RhinoErrorReporter.INVALID_OCTAL_LITERAL, RhinoErrorReporter.DUPLICATE_PARAM, StrictModeCheck.ARGUMENTS_ASSIGNMENT, StrictModeCheck.ARGUMENTS_DECLARATION, StrictModeCheck.ARGUMENTS_CALLEE_FORBIDDEN, StrictModeCheck.ARGUMENTS_CALLER_FORBIDDEN, StrictModeCheck.DELETE_VARIABLE, StrictModeCheck.DUPLICATE_MEMBER, StrictModeCheck.EVAL_ASSIGNMENT, StrictModeCheck.EVAL_DECLARATION, StrictModeCheck.FUNCTION_ARGUMENTS_PROP_FORBIDDEN, StrictModeCheck.FUNCTION_CALLER_FORBIDDEN, StrictModeCheck.USE_OF_WITH);
        MISSING_PROVIDE = DiagnosticGroups.registerGroup("missingProvide", ClosurePrimitiveErrors.MISSING_MODULE_OR_PROVIDE_FOR_FORWARD_DECLARE);
        UNRECOGNIZED_TYPE_ERROR = DiagnosticGroups.registerGroup("unrecognizedTypeError", RhinoErrorReporter.UNRECOGNIZED_TYPE_ERROR);
        MISSING_REQUIRE = DiagnosticGroups.registerGroup("missingRequire", CheckMissingRequires.MISSING_REQUIRE, CheckMissingRequires.MISSING_REQUIRE_IN_PROVIDES_FILE, CheckMissingRequires.MISSING_REQUIRE_TYPE, CheckMissingRequires.MISSING_REQUIRE_TYPE_IN_PROVIDES_FILE);
        MISSING_SOURCES_WARNINGS = DiagnosticGroups.registerGroup("missingSourcesWarnings", REPORT_UNKNOWN_TYPES, UNDEFINED_VARIABLES, MISSING_PROVIDE, DiagnosticGroup.forType(FunctionTypeBuilder.RESOLVED_TAG_EMPTY), DiagnosticGroup.forType(ClosurePrimitiveErrors.MISSING_MODULE_OR_PROVIDE), DiagnosticGroup.forType(ModuleMapCreator.MISSING_NAMESPACE_IMPORT), MISSING_PROPERTIES, DUPLICATE_VARS, DiagnosticGroup.forType(ProcessDefines.INVALID_DEFINE_VALUE), DiagnosticGroup.forType(ModuleLoader.LOAD_WARNING));
        STRICT_REQUIRES = DiagnosticGroups.registerDeprecatedGroup("legacyGoogScopeRequire");
        EXTRA_REQUIRE = DiagnosticGroups.registerGroup("extraRequire", CheckExtraRequires.EXTRA_REQUIRE_WARNING);
        DUPLICATE_MESSAGE = DiagnosticGroups.registerGroup("duplicateMessage", JsMessageVisitor.MESSAGE_DUPLICATE_KEY);
        MESSAGE_DESCRIPTIONS = DiagnosticGroups.registerGroup("msgDescriptions", JsMessageVisitor.MESSAGE_HAS_NO_DESCRIPTION);
        MSG_CONVENTIONS = DiagnosticGroups.registerGroup("messageConventions", JsMessageVisitor.MESSAGE_HAS_NO_DESCRIPTION, JsMessageVisitor.MESSAGE_HAS_NO_TEXT, JsMessageVisitor.MESSAGE_TREE_MALFORMED, JsMessageVisitor.MESSAGE_HAS_NO_VALUE, JsMessageVisitor.MESSAGE_DUPLICATE_KEY, JsMessageVisitor.MESSAGE_NOT_INITIALIZED_USING_NEW_SYNTAX);
        MISPLACED_TYPE_ANNOTATION = DiagnosticGroups.registerGroup("misplacedTypeAnnotation", CheckJSDoc.ARROW_FUNCTION_AS_CONSTRUCTOR, CheckJSDoc.BAD_REST_PARAMETER_ANNOTATION, CheckJSDoc.DEFAULT_PARAM_MUST_BE_MARKED_OPTIONAL, CheckJSDoc.DISALLOWED_MEMBER_JSDOC, CheckJSDoc.INVALID_NO_SIDE_EFFECT_ANNOTATION, CheckJSDoc.INVALID_MODIFIES_ANNOTATION, CheckJSDoc.JSDOC_ON_RETURN, CheckJSDoc.MISPLACED_ANNOTATION, CheckJSDoc.MISPLACED_MSG_ANNOTATION);
        MISPLACED_MSG_ANNOTATION = DiagnosticGroups.registerGroup("misplacedMsgAnnotation", CheckJSDoc.MISPLACED_MSG_ANNOTATION);
        MISPLACED_SUPPRESS = DiagnosticGroups.registerGroup("misplacedSuppress", CheckJSDoc.MISPLACED_SUPPRESS);
        SUSPICIOUS_CODE = DiagnosticGroups.registerGroup("suspiciousCode", CheckDuplicateCase.DUPLICATE_CASE, CheckSuspiciousCode.SUSPICIOUS_SEMICOLON, CheckSuspiciousCode.SUSPICIOUS_COMPARISON_WITH_NAN, CheckSuspiciousCode.SUSPICIOUS_IN_OPERATOR, CheckSuspiciousCode.SUSPICIOUS_INSTANCEOF_LEFT_OPERAND, CheckSuspiciousCode.SUSPICIOUS_LEFT_OPERAND_OF_LOGICAL_OPERATOR, CheckSuspiciousCode.SUSPICIOUS_NEGATED_LEFT_OPERAND_OF_IN_OPERATOR, ProcessCommonJSModules.SUSPICIOUS_EXPORTS_ASSIGNMENT, TypeCheck.DETERMINISTIC_TEST);
        FUNCTION_PARAMS = DiagnosticGroups.registerGroup("functionParams", FunctionTypeBuilder.INEXISTENT_PARAM, FunctionTypeBuilder.OPTIONAL_ARG_AT_END);
        DEPRECATED_ANNOTATIONS = DiagnosticGroups.registerGroup("deprecatedAnnotations", CheckJSDoc.ANNOTATION_DEPRECATED);
        UNUSED_PRIVATE_PROPERTY = DiagnosticGroups.registerDeprecatedGroup("unusedPrivateMembers");
        UNUSED_LOCAL_VARIABLE = DiagnosticGroups.registerGroup("unusedLocalVariables", VariableReferenceCheck.UNUSED_LOCAL_ASSIGNMENT);
        MISSING_CONST_PROPERTY = DiagnosticGroups.registerDeprecatedGroup("jsdocMissingConst");
        JSDOC_MISSING_TYPE = DiagnosticGroups.registerGroup("jsdocMissingType", RhinoErrorReporter.JSDOC_MISSING_TYPE_WARNING);
        UNNECESSARY_ESCAPE = DiagnosticGroups.registerGroup("unnecessaryEscape", RhinoErrorReporter.UNNECESSARY_ESCAPE);
        TYPE_IMPORT_CODE_REFERENCES = DiagnosticGroups.registerGroup("typeImportCodeReferences", CheckTypeImportCodeReferences.TYPE_IMPORT_CODE_REFERENCE);
        PARTIAL_ALIAS = DiagnosticGroups.registerGroup("partialAlias", InlineAndCollapseProperties.PARTIAL_NAMESPACE_WARNING);
        USE_OF_GOOG_PROVIDE = DiagnosticGroups.registerGroup("useOfGoogProvide", ClosureCheckModule.USE_OF_GOOG_PROVIDE);
        LINT_CHECKS = DiagnosticGroups.registerGroup("lintChecks", CheckJSDocStyle.LINT_DIAGNOSTICS, USE_OF_GOOG_PROVIDE, new DiagnosticGroup(CheckClosureImports.LET_CLOSURE_IMPORT, CheckConstPrivateProperties.MISSING_CONST_PROPERTY, CheckConstantCaseNames.REASSIGNED_CONSTANT_CASE_NAME, CheckConstantCaseNames.MISSING_CONST_PROPERTY, CheckDefaultExportOfGoogModule.DEFAULT_EXPORT_IN_GOOG_MODULE, CheckDefaultExportOfGoogModule.MAYBE_ACCIDENTAL_DEFAULT_EXPORT_IN_GOOG_MODULE, CheckEmptyStatements.USELESS_EMPTY_STATEMENT, CheckEnums.COMPUTED_PROP_NAME_IN_ENUM, CheckEnums.DUPLICATE_ENUM_VALUE, CheckEnums.ENUM_PROP_NOT_CONSTANT, CheckEnums.ENUM_TYPE_NOT_STRING_OR_NUMBER, CheckEnums.NON_STATIC_INITIALIZER_STRING_VALUE_IN_ENUM, CheckEnums.SHORTHAND_ASSIGNMENT_IN_ENUM, CheckEs6ModuleFileStructure.MUST_COME_BEFORE, CheckEs6Modules.DUPLICATE_IMPORT, CheckEs6Modules.NO_DEFAULT_EXPORT, CheckGoogModuleTypeScriptName.MODULE_NAMESPACE_MISMATCHES_TYPESCRIPT_NAMESPACE, CheckInterfaces.INTERFACE_CLASS_NONSTATIC_METHOD_NOT_EMPTY, CheckInterfaces.INTERFACE_CONSTRUCTOR_SHOULD_NOT_TAKE_ARGS, CheckInterfaces.INTERFACE_DEFINED_WITH_EXTENDS, CheckInterfaces.NON_DECLARATION_STATEMENT_IN_INTERFACE, CheckInterfaces.MISSING_JSDOC_IN_DECLARATION_STATEMENT, CheckInterfaces.STATIC_MEMBER_FUNCTION_IN_INTERFACE_CLASS, CheckMissingSemicolon.MISSING_SEMICOLON, CheckNoMutatedEs6Exports.MUTATED_EXPORT, CheckNullabilityModifiers.MISSING_NULLABILITY_MODIFIER_JSDOC, CheckNullabilityModifiers.NULL_MISSING_NULLABILITY_MODIFIER_JSDOC, CheckNullabilityModifiers.REDUNDANT_NULLABILITY_MODIFIER_JSDOC, CheckPrimitiveAsObject.NEW_PRIMITIVE_OBJECT, CheckPrimitiveAsObject.PRIMITIVE_OBJECT_DECLARATION, CheckPrototypeProperties.ILLEGAL_PROTOTYPE_MEMBER, CheckProvidesSorted.PROVIDES_NOT_SORTED, CheckRequiresSorted.REQUIRES_NOT_SORTED, CheckUnusedLabels.UNUSED_LABEL, CheckUnusedPrivateProperties.UNUSED_PRIVATE_PROPERTY, CheckUselessBlocks.USELESS_BLOCK, CheckVar.VAR, ClosureCheckModule.DECLARE_LEGACY_NAMESPACE_IN_NON_MODULE, ClosureCheckModule.GOOG_MODULE_IN_NON_MODULE, ClosureCheckModule.INCORRECT_SHORTNAME_CAPITALIZATION, ClosureRewriteModule.USELESS_USE_STRICT_DIRECTIVE, RhinoErrorReporter.JSDOC_MISSING_BRACES_WARNING));
        STRICT_MODULE_CHECKS = DiagnosticGroups.registerGroup("strictModuleChecks", ClosureCheckModule.AT_EXPORT_IN_NON_LEGACY_GOOG_MODULE, ClosureCheckModule.LET_GOOG_REQUIRE, ClosureCheckModule.REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME, ClosureCheckModule.REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME);
        ANALYZER_CHECKS = DiagnosticGroups.registerGroup("analyzerChecks", CheckArrayWithGoogObject.ARRAY_PASSED_TO_GOOG_OBJECT, ImplicitNullabilityCheck.IMPLICITLY_NONNULL_JSDOC, ImplicitNullabilityCheck.IMPLICITLY_NULLABLE_JSDOC, CheckNestedNames.NESTED_NAME_IN_GOOG_MODULE);
        CLOSURE_DEP_METHOD_USAGE_CHECKS = DiagnosticGroups.registerGroup("closureDepMethodUsageChecks", ProcessClosurePrimitives.CLOSURE_CALL_CANNOT_BE_ALIASED_ERROR, ProcessClosurePrimitives.CLOSURE_CALL_CANNOT_BE_ALIASED_OUTSIDE_MODULE_ERROR, ClosurePrimitiveErrors.INVALID_CLOSURE_CALL_SCOPE_ERROR, ClosurePrimitiveErrors.INVALID_GET_CALL_SCOPE);
        MALFORMED_GOOG_MODULE = DiagnosticGroups.registerUnsuppressibleGroup(ClosureCheckModule.GOOG_MODULE_MISPLACED, ClosureCheckModule.LEGACY_NAMESPACE_NOT_AFTER_GOOG_MODULE);
        DiagnosticGroups.registerGroup("transitionalSuspiciousCodeWarnings", PeepholeFoldConstants.FRACTIONAL_BITWISE_OPERAND);
        CONFORMANCE_VIOLATIONS = DiagnosticGroups.registerGroup("conformanceViolations", CheckConformance.CONFORMANCE_VIOLATION, CheckConformance.CONFORMANCE_POSSIBLE_VIOLATION);
        LATE_PROVIDE = DiagnosticGroups.registerGroup("lateProvide", CheckClosureImports.LATE_PROVIDE_ERROR);
        DUPLICATE_NAMESPACES = DiagnosticGroups.registerUnsuppressibleGroup(ClosurePrimitiveErrors.DUPLICATE_MODULE, ClosurePrimitiveErrors.DUPLICATE_NAMESPACE, ClosurePrimitiveErrors.DUPLICATE_NAMESPACE_AND_MODULE);
        INVALID_DEFINES = DiagnosticGroups.registerUnsuppressibleGroup(ProcessDefines.INVALID_DEFINE_VALUE, ProcessDefines.INVALID_DEFINE_TYPE);
        INVALID_CONST_PARAM = DiagnosticGroups.registerUnsuppressibleGroup(ConstParamCheck.CONST_NOT_STRING_LITERAL_ERROR);
        CANNOT_TRANSPILE_FEATURE = DiagnosticGroups.registerUnsuppressibleGroup(Es6ToEs3Util.CANNOT_CONVERT, Es6ToEs3Util.CANNOT_CONVERT_YET);
        MISSING_POLYFILL = DiagnosticGroups.registerGroup("missingPolyfill", RewritePolyfills.INSUFFICIENT_OUTPUT_VERSION_ERROR);
        POLYMER = DiagnosticGroups.registerGroup("polymer", PolymerPassErrors.POLYMER_DESCRIPTOR_NOT_VALID);
        BOUNDED_GENERICS = DiagnosticGroups.registerGroup("boundedGenerics", RhinoErrorReporter.UNSUPPORTED_BOUNDED_GENERIC_TYPES, RhinoErrorReporter.BOUNDED_GENERIC_TYPE_ERROR);
        PARSING = DiagnosticGroup.forType(RhinoErrorReporter.PARSE_ERROR);
        DiagnosticGroups.registerGroup("polymerBehavior", PolymerPassErrors.POLYMER_UNQUALIFIED_BEHAVIOR);
        DiagnosticGroups.registerGroup("invalidProvide", ProcessClosurePrimitives.INVALID_PROVIDE_ERROR);
        DiagnosticGroups.registerDeprecatedGroup("es6Typed");
        DiagnosticGroups.registerDeprecatedGroup("duplicateZipContents");
        DiagnosticGroups.registerGroup("conflictingIjsFile", IjsErrors.CONFLICTING_IJS_FILE);
        DiagnosticGroups.registerGroup("implicitWeakEntryPoint", JSChunkGraph.IMPLICIT_WEAK_ENTRY_POINT_ERROR);
    }
}

