/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefaultNameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.Token;

public final class Es6ForOfConverter
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.FOR_OF);
    private final DefaultNameGenerator namer;
    private final AstFactory astFactory;
    private final StaticScope namespace;
    private static final String ITER_BASE = "$jscomp$iter$";
    private static final String ITER_RESULT = "$jscomp$key$";

    public Es6ForOfConverter(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.namer = new DefaultNameGenerator();
        this.astFactory = compiler.createAstFactory();
        this.namespace = compiler.getTranspilationNamespace();
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isForOf()) {
            this.visitForOf(n);
        }
    }

    private void visitForOf(Node node) {
        Node declarationOrAssign;
        Node variable = node.removeFirstChild();
        Node iterable = node.removeFirstChild();
        Node body = node.removeFirstChild();
        JSDocInfo varJSDocInfo = variable.getJSDocInfo();
        Node iterName = this.astFactory.createName(ITER_BASE + this.compiler.getUniqueNameIdSupplier().get(), AstFactory.type(StandardColors.ITERATOR_ID));
        iterName.makeNonIndexable();
        Node getNext = this.astFactory.createCallWithUnknownType(this.astFactory.createGetPropWithUnknownType(iterName.cloneTree(), "next"), new Node[0]);
        String iteratorResultName = ITER_RESULT;
        iteratorResultName = NodeUtil.isNameDeclaration(variable) ? iteratorResultName + variable.getFirstChild().getString() : (variable.isName() ? iteratorResultName + variable.getString() : iteratorResultName + this.namer.generateNextName());
        Node iterResult = this.astFactory.createNameWithUnknownType(iteratorResultName);
        iterResult.makeNonIndexable();
        Node call = this.astFactory.createJSCompMakeIteratorCall(iterable, this.namespace);
        Node init = IR.var(iterName.cloneTree().setColor(iterName.getColor()), call);
        Node initIterResult = iterResult.cloneTree();
        initIterResult.addChildToFront(getNext.cloneTree());
        init.addChildToBack(initIterResult);
        Node cond = this.astFactory.createNot(this.astFactory.createGetProp(iterResult.cloneTree(), "done", AstFactory.type(StandardColors.BOOLEAN)));
        Node incr = this.astFactory.createAssign(iterResult.cloneTree(), getNext.cloneTree());
        if (!NodeUtil.isNameDeclaration(variable)) {
            declarationOrAssign = this.astFactory.createAssign(variable.cloneTree().setJSDocInfo(null), this.astFactory.createGetProp(iterResult.cloneTree(), "value", AstFactory.type(variable)));
            declarationOrAssign.setJSDocInfo(varJSDocInfo);
            declarationOrAssign = IR.exprResult(declarationOrAssign);
        } else {
            AstFactory.Type type = AstFactory.type(variable.getFirstChild());
            Token declarationType = variable.getToken();
            declarationOrAssign = new Node(declarationType, this.astFactory.createName(variable.getFirstChild().getString(), type).srcref(variable.getFirstChild()));
            declarationOrAssign.getFirstChild().addChildToBack(this.astFactory.createGetProp(iterResult.cloneTree(), "value", type));
            declarationOrAssign.setJSDocInfo(varJSDocInfo);
        }
        Node newBody = IR.block(declarationOrAssign, body).srcref(body);
        Node newFor = IR.forNode(init, cond, incr, newBody);
        newFor.srcrefTreeIfMissing(node);
        node.replaceWith(newFor);
        this.compiler.reportChangeToEnclosingScope(newFor);
    }
}

