/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Splitter;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Table;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.List;

final class Es6RenameReferences
extends NodeTraversal.AbstractPostOrderCallback {
    private static final Splitter SPLIT_ON_DOT = Splitter.on('.').limit(2);
    private final Table<Node, String, String> renameTable;
    private final boolean typesOnly;

    Es6RenameReferences(Table<Node, String, String> renameTable, boolean typesOnly) {
        this.renameTable = renameTable;
        this.typesOnly = typesOnly;
    }

    Es6RenameReferences(Table<Node, String, String> renameTable) {
        this(renameTable, false);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo info;
        if (!this.typesOnly && NodeUtil.isReferenceName(n)) {
            this.renameReference(t, n, false);
        }
        if ((info = n.getJSDocInfo()) != null) {
            for (Node root : info.getTypeNodes()) {
                this.renameTypeNodeRecursive(t, root);
            }
        }
    }

    private void renameTypeNodeRecursive(NodeTraversal t, Node n) {
        if (n.isStringLit()) {
            this.renameReference(t, n, true);
        }
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            this.renameTypeNodeRecursive(t, child);
        }
    }

    private void renameReference(NodeTraversal t, Node n, boolean isType) {
        String fullName = n.getString();
        List<String> split = SPLIT_ON_DOT.splitToList(fullName);
        String oldName = split.get(0);
        for (Scope current = t.getScope(); current != null; current = current.getParent()) {
            String newName = this.renameTable.get(current.getRootNode(), oldName);
            if (newName != null) {
                String rest = split.size() == 2 ? "." + split.get(1) : "";
                n.setString(newName + rest);
                if (!isType) {
                    t.reportCodeChange();
                }
                return;
            }
            if (!current.hasOwnSlot(oldName)) continue;
            return;
        }
    }
}

