/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6RenameReferences;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.HashBasedTable;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Es6RenameVariablesInParamLists
implements NodeTraversal.ScopedCallback,
CompilerPass {
    private final AbstractCompiler compiler;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.DEFAULT_PARAMETERS, FeatureSet.Feature.COMPUTED_PROPERTIES);

    public Es6RenameVariablesInParamLists(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void enterScope(NodeTraversal t) {
    }

    @Override
    public void exitScope(NodeTraversal t) {
        Node block = t.getScopeRoot();
        Node function = block.getParent();
        if (!block.isBlock() || !function.isFunction()) {
            return;
        }
        Node paramList = function.getSecondChild();
        final CollectReferences collector = new CollectReferences();
        NodeTraversal.traverse(this.compiler, paramList, new NodeTraversal.AbstractPreOrderCallback(){

            @Override
            public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
                if (parent == null) {
                    return true;
                }
                if (parent.isDefaultValue() && n == parent.getLastChild() || parent.isComputedProp() && n == parent.getFirstChild()) {
                    NodeTraversal.traverse(Es6RenameVariablesInParamLists.this.compiler, n, collector);
                    return false;
                }
                return true;
            }
        });
        Scope blockScope = t.getScope();
        HashBasedTable<Node, String, String> renameTable = HashBasedTable.create();
        Map renameRow = renameTable.row((Object)block);
        for (Var var : blockScope.getVarIterable()) {
            String oldName = var.getName();
            if (!collector.currFuncReferences.contains(oldName)) continue;
            renameRow.computeIfAbsent(oldName, x -> oldName + "$" + this.compiler.getUniqueNameIdSupplier().get());
        }
        NodeTraversal.builder().setCompiler(this.compiler).setScopeCreator(t.getScopeCreator()).setCallback(new Es6RenameReferences(renameTable)).traverseAtScope(blockScope);
    }

    @Override
    public void visit(NodeTraversal t, Node block, Node function) {
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
    }

    private static class CollectReferences
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Set<String> currFuncReferences = new HashSet<String>();

        private CollectReferences() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isReferenceName(n)) {
                return;
            }
            this.currFuncReferences.add(n.getString());
        }
    }
}

