/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.AbstractVar;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6RenameReferences;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Predicate;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Supplier;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.HashBasedTable;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.HashMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.LinkedHashMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Multimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Table;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class Es6RewriteBlockScopedDeclaration
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final Table<Node, String, String> renameTable = HashBasedTable.create();
    private final Set<Node> letConsts = new HashSet<Node>();
    private final Set<String> undeclaredNames = new HashSet<String>();
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.LET_DECLARATIONS, FeatureSet.Feature.CONST_DECLARATIONS);
    private final Supplier<String> uniqueNameIdSupplier;
    private static final Predicate<Node> isLoopOrFunction = new Predicate<Node>(){

        @Override
        public boolean apply(Node n) {
            return n.isFunction() || NodeUtil.isLoopStructure(n);
        }
    };

    public Es6RewriteBlockScopedDeclaration(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.uniqueNameIdSupplier = compiler.getUniqueNameIdSupplier();
        this.astFactory = compiler.createAstFactory();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (!n.hasChildren() || !NodeUtil.isBlockScopedDeclaration(n.getFirstChild())) {
            return;
        }
        Preconditions.checkState(parent == null || !parent.isForOf(), parent);
        if (n.isLet() || n.isConst()) {
            this.letConsts.add(n);
        }
        if (NodeUtil.isNameDeclaration(n)) {
            for (Node nameNode = n.getFirstChild(); nameNode != null; nameNode = nameNode.getNext()) {
                this.visitBlockScopedName(t, n, nameNode);
            }
        } else {
            Preconditions.checkState(n.isFunction() || n.isCatch(), "Unexpected declaration node: %s", (Object)n);
            this.visitBlockScopedName(t, n, n.getFirstChild());
        }
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new CollectUndeclaredNames());
        NodeTraversal.traverse(this.compiler, root, this);
        NodeTraversal.traverse(this.compiler, root, new Es6RenameReferences(this.renameTable));
        LoopClosureTransformer transformer = new LoopClosureTransformer();
        NodeTraversal.traverse(this.compiler, root, transformer);
        transformer.transformLoopClosure();
        this.rewriteDeclsToVars();
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    private void visitBlockScopedName(NodeTraversal t, Node decl, Node nameNode) {
        Scope scope = t.getScope();
        Node parent = decl.getParent();
        if (!(!decl.isLet() && !decl.isConst() || nameNode.hasChildren() || parent != null && parent.isForIn() || !this.inLoop(decl))) {
            Node undefined = this.astFactory.createUndefinedValue().srcrefTree(nameNode);
            nameNode.addChildToFront(undefined);
            this.compiler.reportChangeToEnclosingScope(undefined);
        }
        String oldName = nameNode.getString();
        Scope hoistScope = (Scope)scope.getClosestHoistScope();
        if (scope != hoistScope) {
            String newName = oldName;
            if (hoistScope.hasSlot(oldName) || this.undeclaredNames.contains(oldName)) {
                while (hoistScope.hasSlot(newName = oldName + "$" + this.compiler.getUniqueNameIdSupplier().get())) {
                }
                nameNode.setString(newName);
                this.compiler.reportChangeToEnclosingScope(nameNode);
                Node scopeRoot = scope.getRootNode();
                this.renameTable.put(scopeRoot, oldName, newName);
            }
            Var oldVar = (Var)scope.getVar(oldName);
            scope.undeclare(oldVar);
            hoistScope.declare(newName, nameNode, oldVar.getInput());
        }
    }

    private boolean inLoop(Node n) {
        Node enclosingNode = NodeUtil.getEnclosingNode(n, isLoopOrFunction);
        return enclosingNode != null && !enclosingNode.isFunction();
    }

    private static void extractInlineJSDoc(Node srcDeclaration, Node srcName, Node destDeclaration) {
        JSDocInfo existingInfo = srcDeclaration.getJSDocInfo();
        if (existingInfo == null) {
            existingInfo = srcName.getJSDocInfo();
            srcName.setJSDocInfo(null);
        }
        JSDocInfo.Builder builder = JSDocInfo.Builder.maybeCopyFrom(existingInfo);
        destDeclaration.setJSDocInfo(builder.build());
    }

    private static void maybeAddConstJSDoc(Node srcDeclaration, Node srcName, Node destDeclaration) {
        if (srcDeclaration.isConst()) {
            Es6RewriteBlockScopedDeclaration.extractInlineJSDoc(srcDeclaration, srcName, destDeclaration);
            JSDocInfo.Builder builder = JSDocInfo.Builder.maybeCopyFrom(destDeclaration.getJSDocInfo());
            builder.recordConstancy();
            destDeclaration.setJSDocInfo(builder.build());
        }
    }

    private void handleDeclarationList(Node declarationList, Node parent) {
        while (declarationList.hasMoreThanOneChild()) {
            Node name = declarationList.getLastChild();
            Node newDeclaration = IR.var(name.detach()).srcref(declarationList);
            Es6RewriteBlockScopedDeclaration.maybeAddConstJSDoc(declarationList, name, newDeclaration);
            newDeclaration.insertAfter(declarationList);
            this.compiler.reportChangeToEnclosingScope(parent);
        }
        Es6RewriteBlockScopedDeclaration.maybeAddConstJSDoc(declarationList, declarationList.getFirstChild(), declarationList);
        declarationList.setToken(Token.VAR);
    }

    private void addNodeBeforeLoop(Node newNode, Node loopNode) {
        Node insertSpot = loopNode;
        while (insertSpot.getParent().isLabel()) {
            insertSpot = insertSpot.getParent();
        }
        newNode.insertBefore(insertSpot);
        this.compiler.reportChangeToEnclosingScope(newNode);
    }

    private void rewriteDeclsToVars() {
        if (!this.letConsts.isEmpty()) {
            for (Node n : this.letConsts) {
                if (n.isConst()) {
                    this.handleDeclarationList(n, n.getParent());
                }
                n.setToken(Token.VAR);
                this.compiler.reportChangeToEnclosingScope(n);
            }
        }
    }

    private Node cloneWithType(Node node) {
        Node clone = node.cloneNode();
        if (this.astFactory.isAddingColors()) {
            clone.setColor(node.getColor());
        }
        return clone;
    }

    private class LoopClosureTransformer
    extends NodeTraversal.AbstractPostOrderCallback {
        private static final String LOOP_OBJECT_NAME = "$jscomp$loop";
        private static final String LOOP_OBJECT_PROPERTY_NAME = "$jscomp$loop$prop$";
        private final Map<Node, LoopObject> loopObjectMap = new LinkedHashMap<Node, LoopObject>();
        private final Multimap<Node, LoopObject> functionLoopObjectsMap = LinkedHashMultimap.create();
        private final Multimap<Node, String> functionHandledMap = HashMultimap.create();
        private final Multimap<Var, Node> referenceMap = LinkedHashMultimap.create();
        private final Map<Var, String> propertyNameMap = new LinkedHashMap<Var, String>();

        private LoopClosureTransformer() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isReferenceName(n)) {
                return;
            }
            String name = n.getString();
            Scope referencedIn = t.getScope();
            Var var = (Var)referencedIn.getVar(name);
            if (var == null) {
                return;
            }
            if (!var.isLet() && !var.isConst()) {
                return;
            }
            if (n.getParent().isLet() || n.getParent().isConst()) {
                Es6RewriteBlockScopedDeclaration.this.letConsts.add(n.getParent());
            }
            Scope declaredIn = (Scope)var.getScope();
            Node loopNode = null;
            Scope s = declaredIn;
            while (true) {
                Node scopeRoot;
                if (NodeUtil.isLoopStructure(scopeRoot = s.getRootNode())) {
                    loopNode = scopeRoot;
                    break;
                }
                if (scopeRoot.hasParent() && NodeUtil.isLoopStructure(scopeRoot.getParent())) {
                    loopNode = scopeRoot.getParent();
                    break;
                }
                if (s.isFunctionBlockScope() || s.isGlobal()) {
                    return;
                }
                s = s.getParent();
            }
            this.referenceMap.put(var, n);
            AbstractScope outerMostFunctionScope = null;
            for (Scope s2 = referencedIn; s2 != declaredIn && s2.getRootNode() != loopNode; s2 = s2.getParent()) {
                if (!s2.isFunctionScope()) continue;
                outerMostFunctionScope = s2;
            }
            if (outerMostFunctionScope != null) {
                Node function = outerMostFunctionScope.getRootNode();
                if (this.functionHandledMap.containsEntry(function, name)) {
                    return;
                }
                this.functionHandledMap.put(function, name);
                LoopObject object = this.loopObjectMap.computeIfAbsent(loopNode, k -> new LoopObject("$jscomp$loop$" + Es6RewriteBlockScopedDeclaration.this.compiler.getUniqueNameIdSupplier().get()));
                String newPropertyName = this.createUniquePropertyName(var);
                object.vars.add(var);
                this.propertyNameMap.put(var, newPropertyName);
                this.functionLoopObjectsMap.put(function, object);
            }
        }

        private String createUniquePropertyName(Var var) {
            return LOOP_OBJECT_PROPERTY_NAME + var.getName() + "$" + (String)Es6RewriteBlockScopedDeclaration.this.uniqueNameIdSupplier.get();
        }

        private void transformLoopClosure() {
            if (this.loopObjectMap.isEmpty()) {
                return;
            }
            for (Node loopNode : this.loopObjectMap.keySet()) {
                LoopObject loopObject = this.loopObjectMap.get(loopNode);
                Node objectLitNextIteration = Es6RewriteBlockScopedDeclaration.this.astFactory.createObjectLit(new Node[0]);
                for (Var var : loopObject.vars) {
                    String newPropertyName = this.propertyNameMap.get(var);
                    objectLitNextIteration.addChildToBack(Es6RewriteBlockScopedDeclaration.this.astFactory.createStringKey(newPropertyName, this.createLoopVarReferenceReplacement(loopObject, var.getNameNode(), newPropertyName)));
                }
                Node updateLoopObject = Es6RewriteBlockScopedDeclaration.this.astFactory.createAssign(this.createLoopObjectNameNode(loopObject), objectLitNextIteration);
                Node objectLit = IR.var(this.createLoopObjectNameNode(loopObject), Es6RewriteBlockScopedDeclaration.this.astFactory.createObjectLit(new Node[0])).srcrefTree(loopNode);
                Es6RewriteBlockScopedDeclaration.this.addNodeBeforeLoop(objectLit, loopNode);
                if (loopNode.isVanillaFor()) {
                    Node increment;
                    Node initializer = loopNode.getFirstChild();
                    initializer.replaceWith(IR.empty());
                    if (!initializer.isEmpty()) {
                        if (!NodeUtil.isNameDeclaration(initializer)) {
                            initializer = IR.exprResult(initializer).srcref(initializer);
                        }
                        Es6RewriteBlockScopedDeclaration.this.addNodeBeforeLoop(initializer, loopNode);
                    }
                    if ((increment = loopNode.getChildAtIndex(2)).isEmpty()) {
                        increment.replaceWith(updateLoopObject.srcrefTreeIfMissing(loopNode));
                    } else {
                        Node placeHolder = IR.empty();
                        increment.replaceWith(placeHolder);
                        placeHolder.replaceWith(Es6RewriteBlockScopedDeclaration.this.astFactory.createComma(updateLoopObject, increment).srcrefTreeIfMissing(loopNode));
                    }
                } else {
                    String innerBlockLabel = loopObject.name;
                    Node loopBody = NodeUtil.getLoopCodeBlock(loopNode);
                    if (this.maybeUpdateContinueStatements(loopNode, innerBlockLabel)) {
                        Node innerBlock = IR.block().srcref(loopBody);
                        innerBlock.addChildrenToFront(loopBody.removeChildren());
                        loopBody.addChildToFront(IR.label(IR.labelName(innerBlockLabel).srcref(loopBody), innerBlock).srcref(loopBody));
                    }
                    loopBody.addChildToBack(IR.exprResult(updateLoopObject).srcrefTreeIfMissing(loopNode));
                }
                Es6RewriteBlockScopedDeclaration.this.compiler.reportChangeToEnclosingScope(loopNode);
                for (Object var : loopObject.vars) {
                    String newPropertyName = this.propertyNameMap.get(var);
                    for (Node reference : this.referenceMap.get((Var)var)) {
                        Preconditions.checkState(!loopNode.isForOf(), loopNode);
                        if (loopNode.isForIn() && loopNode.getFirstChild() == reference.getParent()) {
                            Preconditions.checkState(reference == ((AbstractVar)var).getNameNode(), reference);
                            Node referenceParent = reference.getParent();
                            Preconditions.checkState(NodeUtil.isNameDeclaration(referenceParent), referenceParent);
                            Preconditions.checkState(reference.isName(), reference);
                            Node loopVarReference = reference.cloneNode();
                            loopNode.getLastChild().addChildToFront(IR.exprResult(Es6RewriteBlockScopedDeclaration.this.astFactory.createAssign(this.createLoopVarReferenceReplacement(loopObject, reference, newPropertyName), loopVarReference)).srcrefTreeIfMissing(reference));
                            continue;
                        }
                        if (NodeUtil.isNameDeclaration(reference.getParent())) {
                            Node declaration = reference.getParent();
                            Node grandParent = declaration.getParent();
                            Es6RewriteBlockScopedDeclaration.this.handleDeclarationList(declaration, grandParent);
                            declaration = reference.getParent();
                            if (reference.hasChildren()) {
                                Node newReference = Es6RewriteBlockScopedDeclaration.this.cloneWithType(reference);
                                Node assign = Es6RewriteBlockScopedDeclaration.this.astFactory.createAssign(newReference, reference.removeFirstChild());
                                Es6RewriteBlockScopedDeclaration.extractInlineJSDoc(declaration, reference, declaration);
                                Es6RewriteBlockScopedDeclaration.maybeAddConstJSDoc(declaration, reference, declaration);
                                assign.setJSDocInfo(declaration.getJSDocInfo());
                                Node replacement = IR.exprResult(assign).srcrefTreeIfMissing(declaration);
                                declaration.replaceWith(replacement);
                                reference = newReference;
                            } else {
                                declaration.detach();
                            }
                            Es6RewriteBlockScopedDeclaration.this.letConsts.remove(declaration);
                            Es6RewriteBlockScopedDeclaration.this.compiler.reportChangeToEnclosingScope(grandParent);
                        }
                        if (reference.getParent().isCall() && reference.getParent().getFirstChild() == reference) {
                            reference.getParent().putBooleanProp(Node.FREE_CALL, false);
                        }
                        Node changeScope = NodeUtil.getEnclosingChangeScopeRoot(reference);
                        reference.replaceWith(this.createLoopVarReferenceReplacement(loopObject, reference, newPropertyName));
                        if (changeScope == null) continue;
                        Es6RewriteBlockScopedDeclaration.this.compiler.reportChangeToChangeScope(changeScope);
                    }
                }
            }
            for (Node function : this.functionLoopObjectsMap.keySet()) {
                Node returnNode = IR.returnNode();
                Collection<LoopObject> objects = this.functionLoopObjectsMap.get(function);
                Node[] objectNames = new Node[objects.size()];
                Node[] objectNamesForCall = new Node[objects.size()];
                int i = 0;
                for (LoopObject object : objects) {
                    Node paramObjectName;
                    objectNames[i] = paramObjectName = this.createLoopObjectNameNode(object);
                    objectNamesForCall[i] = this.createLoopObjectNameNode(object);
                    ++i;
                }
                Node iife = Es6RewriteBlockScopedDeclaration.this.astFactory.createFunction("", IR.paramList(objectNames), IR.block(returnNode), AstFactory.type(StandardColors.TOP_OBJECT));
                Es6RewriteBlockScopedDeclaration.this.compiler.reportChangeToChangeScope(iife);
                Node call = Es6RewriteBlockScopedDeclaration.this.astFactory.createCall(iife, AstFactory.type(function), objectNamesForCall);
                call.putBooleanProp(Node.FREE_CALL, true);
                Node replacement = NodeUtil.isFunctionDeclaration(function) ? IR.var(IR.name(function.getFirstChild().getString()), call).srcrefTreeIfMissing(function) : call.srcrefTreeIfMissing(function);
                function.replaceWith(replacement);
                returnNode.addChildToFront(function);
                Es6RewriteBlockScopedDeclaration.this.compiler.reportChangeToEnclosingScope(replacement);
            }
        }

        private Node createLoopVarReferenceReplacement(LoopObject loopObject, Node reference, String propertyName) {
            Node replacement = Es6RewriteBlockScopedDeclaration.this.astFactory.createGetProp(this.createLoopObjectNameNode(loopObject), propertyName, AstFactory.type(reference));
            replacement.srcrefTree(reference);
            return replacement;
        }

        private Node createLoopObjectNameNode(LoopObject loopObject) {
            return Es6RewriteBlockScopedDeclaration.this.astFactory.createName(loopObject.name, AstFactory.type(StandardColors.TOP_OBJECT));
        }

        private boolean maybeUpdateContinueStatements(Node loopNode, String breakLabel) {
            Node loopParent = loopNode.getParent();
            String originalLoopLabel = loopParent.isLabel() ? loopParent.getFirstChild().getString() : null;
            ContinueStatementUpdater continueStatementUpdater = new ContinueStatementUpdater(breakLabel, originalLoopLabel);
            NodeTraversal.traverse(Es6RewriteBlockScopedDeclaration.this.compiler, NodeUtil.getLoopCodeBlock(loopNode), continueStatementUpdater);
            return continueStatementUpdater.replacedAContinueStatement;
        }

        private class LoopObject {
            private final String name;
            private final Set<Var> vars = new LinkedHashSet<Var>();

            private LoopObject(String name) {
                this.name = name;
            }
        }

        private class ContinueStatementUpdater
        implements NodeTraversal.Callback {
            private final String breakLabel;
            @Nullable
            private final String originalLoopLabel;
            int loopDepth = 0;
            boolean replacedAContinueStatement = false;

            public ContinueStatementUpdater(@Nullable String breakLabel, String originalLoopLabel) {
                this.breakLabel = breakLabel;
                this.originalLoopLabel = originalLoopLabel;
            }

            @Override
            public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
                Preconditions.checkState(!n.isClass(), n);
                if (n.isFunction()) {
                    return false;
                }
                if (NodeUtil.isLoopStructure(n)) {
                    if (this.originalLoopLabel == null) {
                        return false;
                    }
                    ++this.loopDepth;
                    return true;
                }
                return true;
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (NodeUtil.isLoopStructure(n)) {
                    --this.loopDepth;
                } else if (n.isContinue()) {
                    if (this.loopDepth == 0 && !n.hasChildren()) {
                        this.replaceWithBreak(n);
                    } else if (this.originalLoopLabel != null && n.hasChildren() && this.originalLoopLabel.equals(n.getOnlyChild().getString())) {
                        this.replaceWithBreak(n);
                    }
                }
            }

            private void replaceWithBreak(Node continueNode) {
                Node labelName = IR.labelName(this.breakLabel).srcref(continueNode);
                Node breakNode = IR.breakNode(labelName).srcref(continueNode);
                continueNode.replaceWith(breakNode);
                this.replacedAContinueStatement = true;
            }
        }
    }

    private class CollectUndeclaredNames
    extends NodeTraversal.AbstractPostOrderCallback {
        private CollectUndeclaredNames() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName() && !t.getScope().hasSlot(n.getString())) {
                Es6RewriteBlockScopedDeclaration.this.undeclaredNames.add(n.getString());
            }
        }
    }
}

