/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import java.util.ArrayList;
import java.util.List;

public final class Es6RewriteRestAndSpread
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private static final String FRESH_SPREAD_VAR = "$jscomp$spread$args";
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.REST_PARAMETERS, FeatureSet.Feature.SPREAD_EXPRESSIONS);
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final StaticScope namespace;
    private static final AstFactory.Type arrayType = AstFactory.type(StandardColors.ARRAY_ID);
    private static final AstFactory.Type concatFnType = AstFactory.type(StandardColors.TOP_OBJECT);

    public Es6RewriteRestAndSpread(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.namespace = compiler.getTranspilationNamespace();
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void visit(NodeTraversal traversal, Node current, Node parent) {
        block0 : switch (current.getToken()) {
            case ITER_REST: {
                this.visitRestParam(traversal, current, parent);
                break;
            }
            case ARRAYLIT: 
            case NEW: 
            case CALL: {
                for (Node child = current.getFirstChild(); child != null; child = child.getNext()) {
                    if (!child.isSpread()) continue;
                    this.visitArrayLitOrCallWithSpread(current);
                    break block0;
                }
                break;
            }
        }
    }

    private void visitRestParam(NodeTraversal t, Node restParam, Node paramList) {
        Node functionBody = paramList.getNext();
        int restIndex = paramList.getIndexOfChild(restParam);
        Node nameNode = restParam.getOnlyChild();
        String paramName = nameNode.getString();
        restParam.detach();
        if (!functionBody.hasChildren()) {
            t.reportCodeChange();
            return;
        }
        Node let = this.astFactory.createSingleLetNameDeclaration(paramName, this.astFactory.createCall(this.astFactory.createQNameWithUnknownType("$jscomp.getRestArguments.apply"), AstFactory.type(nameNode), this.astFactory.createNumber(restIndex), this.astFactory.createArgumentsReference())).srcrefTreeIfMissing(functionBody);
        functionBody.addChildToFront(let);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.LET_DECLARATIONS, this.compiler);
        this.compiler.ensureLibraryInjected("es6/util/restarguments", false);
        t.reportCodeChange();
    }

    private void visitArrayLitOrCallWithSpread(Node spreadParent) {
        if (spreadParent.isArrayLit()) {
            this.visitArrayLitContainingSpread(spreadParent);
        } else if (spreadParent.isCall()) {
            this.visitCallContainingSpread(spreadParent);
        } else {
            Preconditions.checkArgument(spreadParent.isNew(), spreadParent);
            this.visitNewWithSpread(spreadParent);
        }
    }

    private List<Node> extractSpreadGroups(Node spreadParent) {
        Preconditions.checkArgument(spreadParent.isCall() || spreadParent.isArrayLit() || spreadParent.isNew());
        ArrayList<Node> groups = new ArrayList<Node>();
        Node currGroup = null;
        Node currElement = spreadParent.removeFirstChild();
        while (currElement != null) {
            if (currElement.isSpread()) {
                Node spreadExpression = currElement.removeFirstChild();
                if (spreadExpression.isArrayLit()) {
                    if (currGroup == null) {
                        currGroup = spreadExpression;
                    } else {
                        currGroup.addChildrenToBack(spreadExpression.removeChildren());
                    }
                } else {
                    if (currGroup != null) {
                        groups.add(currGroup);
                        currGroup = null;
                    }
                    Es6ToEs3Util.preloadEs6RuntimeFunction(this.compiler, "arrayFromIterable");
                    groups.add(this.astFactory.createJscompArrayFromIterableCall(spreadExpression, this.namespace));
                }
            } else {
                if (currGroup == null) {
                    currGroup = this.astFactory.createArraylit(new Node[0]);
                }
                currGroup.addChildToBack(currElement);
            }
            currElement = spreadParent.removeFirstChild();
        }
        if (currGroup != null) {
            groups.add(currGroup);
        }
        return groups;
    }

    private void visitArrayLitContainingSpread(Node spreadParent) {
        Node joinedGroups;
        Preconditions.checkArgument(spreadParent.isArrayLit());
        List<Node> groups = this.extractSpreadGroups(spreadParent);
        Node baseArrayLit = groups.get(0).isArrayLit() ? groups.remove(0) : this.astFactory.createArraylit(new Node[0]);
        if (groups.isEmpty()) {
            joinedGroups = baseArrayLit;
        } else {
            Node concat = this.astFactory.createGetProp(baseArrayLit, "concat", concatFnType);
            joinedGroups = this.astFactory.createCall(concat, AstFactory.type(spreadParent), groups.toArray(new Node[0]));
        }
        joinedGroups.srcrefTreeIfMissing(spreadParent);
        spreadParent.replaceWith(joinedGroups);
        this.compiler.reportChangeToEnclosingScope(joinedGroups);
    }

    private void visitCallContainingSpread(Node spreadParent) {
        Node callToApply;
        Node joinedGroups;
        Preconditions.checkArgument(spreadParent.isCall());
        Node callee = spreadParent.getFirstChild();
        Preconditions.checkState(!callee.isSuper(), "Cannot spread into super calls");
        boolean calleeMayHaveSideEffects = this.compiler.getAstAnalyzer().mayHaveSideEffects(callee);
        callee.detach();
        while (callee.isCast()) {
            callee = callee.removeFirstChild();
        }
        if (spreadParent.hasOneChild() && this.isSpreadOfArguments(spreadParent.getOnlyChild())) {
            joinedGroups = spreadParent.removeFirstChild().removeFirstChild();
        } else {
            List<Node> groups = this.extractSpreadGroups(spreadParent);
            Preconditions.checkState(!groups.isEmpty());
            if (groups.size() == 1) {
                joinedGroups = groups.remove(0);
            } else {
                Node baseArrayLit = groups.get(0).isArrayLit() ? groups.remove(0) : this.astFactory.createArraylit(new Node[0]);
                Node concat = this.astFactory.createGetProp(baseArrayLit, "concat", concatFnType);
                joinedGroups = this.astFactory.createCall(concat, arrayType, groups.toArray(new Node[0]));
            }
        }
        boolean isFreeCall = spreadParent.getBooleanProp(Node.FREE_CALL);
        if (calleeMayHaveSideEffects && callee.isGetProp() && !isFreeCall) {
            Node freshVar = this.astFactory.createName(FRESH_SPREAD_VAR + this.compiler.getUniqueNameIdSupplier().get(), AstFactory.type(callee.getFirstChild()));
            Node freshVarDeclaration = IR.var(freshVar.cloneTree());
            Node statementContainingSpread = NodeUtil.getEnclosingStatement(spreadParent);
            freshVarDeclaration.srcrefTreeIfMissing(statementContainingSpread);
            freshVarDeclaration.insertBefore(statementContainingSpread);
            callee.addChildToFront(this.astFactory.createAssign(freshVar.cloneTree(), callee.removeFirstChild()));
            callToApply = this.astFactory.createCallWithUnknownType(this.astFactory.createGetPropWithUnknownType(callee, "apply"), freshVar.cloneTree(), joinedGroups);
        } else {
            Node context = (callee.isGetProp() || callee.isGetElem()) && !isFreeCall ? callee.getFirstChild().cloneTree() : this.astFactory.createNull();
            callToApply = this.astFactory.createCall(this.astFactory.createGetPropWithUnknownType(callee, "apply"), AstFactory.type(spreadParent), context, joinedGroups);
        }
        callToApply.setColor(spreadParent.getColor());
        callToApply.srcrefTreeIfMissing(spreadParent);
        spreadParent.replaceWith(callToApply);
        this.compiler.reportChangeToEnclosingScope(callToApply);
    }

    private boolean isSpreadOfArguments(Node n) {
        return n.isSpread() && n.getOnlyChild().matchesName("arguments");
    }

    private void visitNewWithSpread(Node spreadParent) {
        Node joinedGroups;
        Preconditions.checkArgument(spreadParent.isNew());
        Node callee = spreadParent.removeFirstChild();
        List<Node> groups = this.extractSpreadGroups(spreadParent);
        Node baseArrayLit = groups.get(0).isArrayLit() ? groups.remove(0) : this.astFactory.createArraylit(new Node[0]);
        baseArrayLit.addChildToFront(this.astFactory.createNull());
        Node node = joinedGroups = groups.isEmpty() ? baseArrayLit : this.astFactory.createCall(this.astFactory.createGetProp(baseArrayLit, "concat", concatFnType), arrayType, groups.toArray(new Node[0]));
        if (FeatureSet.ES3.contains(this.compiler.getOptions().getOutputFeatureSet())) {
            Es6ToEs3Util.cannotConvert(this.compiler, spreadParent, "\"...\" passed to a constructor (consider using --language_out=ES5)");
        }
        Node bindApply = this.astFactory.createGetPropWithUnknownType(this.astFactory.createGetPropWithUnknownType(this.astFactory.createPrototypeAccess(this.astFactory.createName(this.namespace, "Function")), "bind"), "apply");
        Node result = IR.newNode(this.astFactory.createCallWithUnknownType(bindApply, callee, joinedGroups), new Node[0]).setColor(spreadParent.getColor());
        result.srcrefTreeIfMissing(spreadParent);
        spreadParent.replaceWith(result);
        this.compiler.reportChangeToEnclosingScope(result);
    }
}

