/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.Locale;

public final class Es6ToEs3Util {
    public static final DiagnosticType CANNOT_CONVERT = DiagnosticType.error("JSC_CANNOT_CONVERT", "This code cannot be converted from ES6. {0}");
    public static final DiagnosticType CANNOT_CONVERT_YET = DiagnosticType.error("JSC_CANNOT_CONVERT_YET", "ES6 transpilation of ''{0}'' is not yet implemented.");

    static void cannotConvert(AbstractCompiler compiler, Node n, String message) {
        compiler.report(JSError.make(n, CANNOT_CONVERT, message));
    }

    static void cannotConvertYet(AbstractCompiler compiler, Node n, String feature) {
        compiler.report(JSError.make(n, CANNOT_CONVERT_YET, feature));
    }

    static void preloadEs6RuntimeFunction(AbstractCompiler compiler, String function) {
        compiler.ensureLibraryInjected("es6/util/" + function.toLowerCase(Locale.ROOT), false);
    }

    static JSType createType(boolean shouldCreate, JSTypeRegistry registry, JSTypeNative typeName) {
        if (!shouldCreate) {
            return null;
        }
        return registry.getNativeType(typeName);
    }

    static JSType createGenericType(boolean shouldCreate, JSTypeRegistry registry, JSTypeNative typeName, JSType typeArg) {
        if (!shouldCreate) {
            return null;
        }
        ObjectType genericType = (ObjectType)registry.getNativeType(typeName);
        ObjectType uninstantiated = genericType.getRawType();
        return registry.createTemplatizedType(uninstantiated, ImmutableList.of(typeArg));
    }
}

