/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefaultNameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Joiner;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Splitter;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Lists;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

final class ExternExportsPass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private static final Joiner Q_NAME_JOINER = Joiner.on('.');
    private static final Splitter Q_NAME_SPLITTER = Splitter.on('.');
    private final List<Export> exports = new ArrayList<Export>();
    private final Map<String, Node> definitionMap;
    private final AbstractCompiler compiler;
    private final Node externsRoot;
    private final Map<String, String> mappedPaths;
    private final Set<String> alreadyExportedPaths;
    private ImmutableSet<String> exportSymbolFunctionNames;
    private ImmutableSet<String> exportPropertyFunctionNames;

    private static ImmutableList<String> computePathPrefixes(String path) {
        List<String> pieces = Q_NAME_SPLITTER.splitToList(path);
        ImmutableList.Builder pathPrefixes = ImmutableList.builder();
        String partial = pieces.get(0);
        pathPrefixes.add(partial);
        for (int i = 1; i < pieces.size(); ++i) {
            partial = Q_NAME_JOINER.join(partial, pieces.get(i), new Object[0]);
            pathPrefixes.add(partial);
        }
        return pathPrefixes.build();
    }

    ExternExportsPass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.definitionMap = new HashMap<String, Node>();
        this.externsRoot = IR.script();
        this.alreadyExportedPaths = new HashSet<String>();
        this.mappedPaths = new HashMap<String, String>();
        this.initExportMethods();
    }

    private void initExportMethods() {
        CodingConvention convention = this.compiler.getCodingConvention();
        this.exportSymbolFunctionNames = ImmutableSet.of(convention.getExportSymbolFunction(), "google_exportSymbol");
        this.exportPropertyFunctionNames = ImmutableSet.of(convention.getExportPropertyFunction(), "google_exportProperty");
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        TreeSet<Export> sorted = new TreeSet<Export>(Comparator.comparing(Export::getExportedPath));
        sorted.addAll(this.exports);
        for (Export export : sorted) {
            export.generateExterns();
        }
        this.setGeneratedExternsOnCompiler();
    }

    private void setGeneratedExternsOnCompiler() {
        CodePrinter.Builder builder = new CodePrinter.Builder(this.externsRoot).setPrettyPrint(true).setOutputTypes(true).setTypeRegistry(this.compiler.getTypeRegistry());
        this.compiler.setExternExports(Joiner.on("\n").join("/**", " * @fileoverview Generated externs.", " * @externs", " */", builder.build()));
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        this.lookForQnameDefinition(n);
        this.lookForAtExportOnThisDotProperty(t, n);
        this.lookForSymbolExportCall(n);
        this.lookForPropertyExportCall(n);
    }

    private void lookForQnameDefinition(Node n) {
        String lvalueName;
        if (n.isClass()) {
            if (NodeUtil.isClassDeclaration(n)) {
                this.definitionMap.put(n.getFirstChild().getString(), n);
            }
        } else if (n.isFunction()) {
            if (NodeUtil.isFunctionDeclaration(n)) {
                this.definitionMap.put(n.getFirstChild().getString(), n);
            }
        } else if (n.isAssign()) {
            Node lhs = n.getFirstChild();
            if (!(!lhs.isQualifiedName() || lhs.hasChildren() && lhs.getFirstChild().isThis())) {
                this.definitionMap.put(lhs.getQualifiedName(), n.getLastChild());
            }
        } else if (n.isName()) {
            Node value;
            Node parent = Preconditions.checkNotNull(n.getParent(), n);
            if (NodeUtil.isNameDeclaration(parent) && (value = n.getFirstChild()) != null) {
                this.definitionMap.put(n.getString(), value);
            }
        } else if (n.isMemberFunctionDef() && (lvalueName = NodeUtil.getBestLValueName(n)) != null) {
            this.definitionMap.put(lvalueName, n.getOnlyChild());
        }
    }

    private void lookForSymbolExportCall(Node n) {
        if (!this.isCallToOneOf(n, this.exportSymbolFunctionNames)) {
            return;
        }
        if (!n.hasXChildren(3)) {
            return;
        }
        Node thisNode = n.getFirstChild();
        Node nameArg = thisNode.getNext();
        Node valueArg = nameArg.getNext();
        if (!nameArg.isStringLit()) {
            return;
        }
        this.exports.add(new SymbolExport(nameArg.getString(), valueArg));
    }

    private void lookForPropertyExportCall(Node n) {
        if (!this.isCallToOneOf(n, this.exportPropertyFunctionNames)) {
            return;
        }
        if (!n.hasXChildren(4)) {
            return;
        }
        Node thisNode = n.getFirstChild();
        Node objectArg = thisNode.getNext();
        Node nameArg = objectArg.getNext();
        Node valueArg = nameArg.getNext();
        if (!objectArg.isQualifiedName()) {
            return;
        }
        if (!nameArg.isStringLit()) {
            return;
        }
        this.exports.add(new PropertyExport(objectArg.getQualifiedName(), nameArg.getString(), valueArg));
    }

    private boolean isCallToOneOf(Node n, ImmutableSet<String> functionQnames) {
        if (!n.isCall()) {
            return false;
        }
        Node callee = n.getFirstChild();
        return callee.isQualifiedName() && functionQnames.contains(callee.getQualifiedName());
    }

    private void lookForAtExportOnThisDotProperty(NodeTraversal t, Node thisDotPropName) {
        if (!thisDotPropName.isGetProp() || !thisDotPropName.getFirstChild().isThis()) {
            return;
        }
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(thisDotPropName);
        if (jsdoc == null || !jsdoc.isExport()) {
            return;
        }
        Node constructorNode = t.getEnclosingFunction();
        if (!NodeUtil.isConstructor(constructorNode)) {
            return;
        }
        Node classNode = NodeUtil.isEs6Constructor(constructorNode) ? NodeUtil.getEnclosingClass(constructorNode) : constructorNode;
        String className = NodeUtil.getName(classNode);
        String propertyName = thisDotPropName.getString();
        String prototypeName = className + ".prototype";
        Node propertyNameNode = NodeUtil.newQName(this.compiler, "this." + propertyName);
        this.exports.add(new PropertyExport(prototypeName, propertyName, propertyNameNode));
    }

    private class PropertyExport
    extends Export {
        private final String exportPath;

        public PropertyExport(String exportPath, String symbolName, Node value) {
            super(symbolName, value);
            this.exportPath = Preconditions.checkNotNull(exportPath);
        }

        @Override
        String getExportedPath() {
            for (String currentPath : Lists.reverse(ExternExportsPass.computePathPrefixes(this.exportPath))) {
                Preconditions.checkState(currentPath.length() > 0);
                String mappedPath = (String)ExternExportsPass.this.mappedPaths.get(currentPath);
                if (mappedPath == null) continue;
                mappedPath = mappedPath + this.exportPath.substring(currentPath.length());
                return Q_NAME_JOINER.join(mappedPath, this.symbolName, new Object[0]);
            }
            return Q_NAME_JOINER.join(this.exportPath, this.symbolName, new Object[0]);
        }
    }

    private class SymbolExport
    extends Export {
        public SymbolExport(String symbolName, Node value) {
            super(symbolName, value);
            String qualifiedName = value.getQualifiedName();
            if (qualifiedName != null) {
                ExternExportsPass.this.mappedPaths.put(qualifiedName, symbolName);
            }
        }

        @Override
        String getExportedPath() {
            return this.symbolName;
        }
    }

    private abstract class Export {
        protected final String symbolName;
        protected final Node value;

        Export(String symbolName, Node value) {
            this.symbolName = Preconditions.checkNotNull(symbolName);
            this.value = Preconditions.checkNotNull(value);
        }

        void generateExterns() {
            this.appendExtern(this.getExportedPath(), this.getValue());
        }

        abstract String getExportedPath();

        void appendExtern(String path, Node valueToExport) {
            ImmutableList pathPrefixes = ExternExportsPass.computePathPrefixes(path);
            for (int i = 0; i < pathPrefixes.size(); ++i) {
                Node initializer;
                boolean skipPathPrefix;
                String pathPrefix = (String)pathPrefixes.get(i);
                boolean isCompletePathPrefix = i == pathPrefixes.size() - 1;
                boolean bl = skipPathPrefix = pathPrefix.endsWith(".prototype") || ExternExportsPass.this.alreadyExportedPaths.contains(pathPrefix) && !isCompletePathPrefix;
                if (skipPathPrefix) continue;
                boolean exportedValueDefinesNewType = false;
                if (valueToExport != null) {
                    JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(valueToExport);
                    if (valueToExport.isClass() || jsdoc != null && jsdoc.containsTypeDefinition()) {
                        exportedValueDefinesNewType = true;
                    }
                }
                JSDocInfo jsdoc = null;
                if (isCompletePathPrefix && valueToExport != null) {
                    if (valueToExport.isFunction()) {
                        initializer = this.createExternFunction(valueToExport);
                    } else if (valueToExport.isClass()) {
                        initializer = this.createExternFunctionForEs6Class(valueToExport);
                    } else {
                        Preconditions.checkState(valueToExport.isObjectLit());
                        initializer = this.createExternObjectLit(valueToExport);
                    }
                } else if (!isCompletePathPrefix && exportedValueDefinesNewType) {
                    jsdoc = this.buildNamespaceJSDoc();
                    initializer = this.createExternObjectLit(IR.objectlit(new Node[0]));
                    initializer.setJSDocInfo(null);
                } else {
                    initializer = IR.empty();
                }
                this.appendPathDefinition(pathPrefix, initializer, jsdoc);
            }
        }

        private void appendPathDefinition(String path, Node initializer, JSDocInfo jsdoc) {
            Node pathDefinition;
            if (path.contains(".")) {
                Node qualifiedPath = NodeUtil.newQName(ExternExportsPass.this.compiler, path);
                pathDefinition = initializer.isEmpty() ? NodeUtil.newExpr(qualifiedPath) : NodeUtil.newExpr(IR.assign(qualifiedPath, initializer));
            } else {
                pathDefinition = initializer.isEmpty() ? IR.var(IR.name(path)) : NodeUtil.newVarNode(path, initializer);
            }
            if (jsdoc != null) {
                if (pathDefinition.isExprResult()) {
                    pathDefinition.getFirstChild().setJSDocInfo(jsdoc);
                } else {
                    Preconditions.checkState(pathDefinition.isVar());
                    pathDefinition.setJSDocInfo(jsdoc);
                }
            }
            ExternExportsPass.this.externsRoot.addChildToBack(pathDefinition);
            ExternExportsPass.this.alreadyExportedPaths.add(path);
        }

        private Node createExternFunction(Node exportedFunction) {
            Node paramList = this.createExternsParamListFromOriginalFunction(exportedFunction);
            Node externFunction = IR.function(IR.name(""), paramList, IR.block());
            externFunction.setJSType(exportedFunction.getJSType());
            return externFunction;
        }

        private Node createExternsParamListFromOriginalFunction(Node exportedFunction) {
            Node originalParamList = NodeUtil.getFunctionParameters(exportedFunction);
            ArrayList<String> originalParamNames = new ArrayList<String>();
            for (Node originalParam = originalParamList.getFirstChild(); originalParam != null; originalParam = originalParam.getNext()) {
                originalParamNames.add(this.getOriginalNameForParam(originalParam));
            }
            return this.createExternsParamListFromOriginalParamList(originalParamNames);
        }

        private Node createExternsParamListFromFunctionType(JSType functionType) {
            List<String> emptyParamNames = Collections.nCopies(functionType.assertFunctionType().getParameters().size(), "");
            return this.createExternsParamListFromOriginalParamList(emptyParamNames);
        }

        private Node createExternsParamListFromOriginalParamList(List<String> originalParamNames) {
            Node paramList = IR.paramList(new Node[0]);
            DefaultNameGenerator nameGenerator = new DefaultNameGenerator(ImmutableSet.copyOf(originalParamNames), "", null);
            for (String originalParamName : originalParamNames) {
                String externParamName = originalParamName.isEmpty() ? nameGenerator.generateNextName() : originalParamName;
                paramList.addChildToBack(IR.name(externParamName));
            }
            return paramList;
        }

        private String getOriginalNameForParam(Node paramNode) {
            Node nameOrPatternNode = paramNode.isRest() ? paramNode.getOnlyChild() : (paramNode.isDefaultValue() ? paramNode.getFirstChild() : paramNode);
            if (nameOrPatternNode.isName()) {
                String originalName = nameOrPatternNode.getOriginalName();
                return originalName != null ? originalName : nameOrPatternNode.getString();
            }
            Preconditions.checkState(nameOrPatternNode.isDestructuringPattern(), nameOrPatternNode);
            return "";
        }

        private Node createExternFunctionForEs6Class(Node exportedClass) {
            Node constructorMethodDefinition = NodeUtil.getEs6ClassConstructorMemberFunctionDef(exportedClass);
            if (constructorMethodDefinition == null) {
                JSType classJSType = exportedClass.getJSType();
                Node paramList = this.createExternsParamListFromFunctionType(classJSType);
                Node externFunction = IR.function(IR.name(""), paramList, IR.block());
                externFunction.setJSType(classJSType);
                return externFunction;
            }
            return this.createExternFunction(constructorMethodDefinition.getOnlyChild());
        }

        private JSDocInfo buildEmptyJSDoc() {
            return JSDocInfo.builder().build(true);
        }

        private JSDocInfo buildNamespaceJSDoc() {
            JSDocInfo.Builder builder = JSDocInfo.builder();
            builder.recordConstancy();
            builder.recordSuppressions(ImmutableSet.of("const", "duplicate"));
            return builder.build();
        }

        private Node createExternObjectLit(Node exportedObjectLit) {
            Node lit = IR.objectlit(new Node[0]);
            lit.setJSType(exportedObjectLit.getJSType());
            lit.setJSDocInfo(this.buildEmptyJSDoc());
            int index = 1;
            for (Node child = exportedObjectLit.getFirstChild(); child != null; child = child.getNext()) {
                if (!child.isStringKey()) continue;
                lit.addChildToBack(IR.propdef(IR.stringKey(child.getString()), IR.number(index++)));
            }
            return lit;
        }

        protected Node getValue() {
            String qualifiedName = this.value.getQualifiedName();
            if (qualifiedName == null) {
                return null;
            }
            Node definition = (Node)ExternExportsPass.this.definitionMap.get(qualifiedName);
            if (definition == null) {
                return null;
            }
            if (definition.isFunction() || definition.isClass() || definition.isObjectLit()) {
                return definition;
            }
            return null;
        }
    }
}

