/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

class FindExportableNodes
extends NodeTraversal.AbstractPostOrderCallback {
    static final DiagnosticType NON_GLOBAL_ERROR = DiagnosticType.error("JSC_NON_GLOBAL_ERROR", "@export only allowed on symbols/properties defined in the global scope.\nConvert to a global definition or enable --export_local_property_definitions/ options.setExportLocalPropertyDefinitions(true)");
    static final DiagnosticType EXPORT_ANNOTATION_NOT_ALLOWED = DiagnosticType.error("JSC_EXPORT_ANNOTATION_NOT_ALLOWED", "@export is not supported on this expression.");
    private final AbstractCompiler compiler;
    private final LinkedHashMap<String, Node> exports = new LinkedHashMap();
    private final LinkedHashMap<Node, String> es6ClassExports = new LinkedHashMap();
    private final LinkedHashSet<String> localExports = new LinkedHashSet();
    private final boolean allowLocalExports;

    FindExportableNodes(AbstractCompiler compiler, boolean allowLocalExports) {
        this.compiler = compiler;
        this.allowLocalExports = allowLocalExports;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo parentInfo;
        JSDocInfo docInfo = n.getJSDocInfo();
        if (docInfo == null || !docInfo.isExport()) {
            return;
        }
        if (parent.isAssign() && (n.isFunction() || n.isClass()) && (parentInfo = parent.getJSDocInfo()) != null && parentInfo.isExport()) {
            return;
        }
        Mode mode = null;
        String export = null;
        Node context = null;
        switch (n.getToken()) {
            case FUNCTION: 
            case CLASS: {
                if (!parent.isScript()) break;
                export = NodeUtil.getName(n);
                context = n;
                mode = Mode.EXPORT;
                break;
            }
            case ASSIGN: {
                Node grandparent = parent.getParent();
                if (!parent.isExprResult() || n.getLastChild().isAssign()) break;
                if (grandparent != null && grandparent.isScript() && n.getFirstChild().isQualifiedName()) {
                    export = n.getFirstChild().getQualifiedName();
                    context = n;
                    mode = Mode.EXPORT;
                    break;
                }
                if (!this.allowLocalExports || !n.getFirstChild().isGetProp()) break;
                Node target = n.getFirstChild();
                export = target.getString();
                mode = Mode.EXTERN;
                break;
            }
            case VAR: 
            case LET: 
            case CONST: {
                if (!parent.isScript() || !n.getFirstChild().hasChildren() || n.getFirstFirstChild().isAssign()) break;
                export = n.getFirstChild().getString();
                context = n;
                mode = Mode.EXPORT;
                break;
            }
            case GETPROP: {
                if (!this.allowLocalExports || !parent.isExprResult()) break;
                export = n.getString();
                mode = Mode.EXTERN;
                break;
            }
            case MEMBER_FUNCTION_DEF: {
                if (parent.getParent().isClass()) {
                    String methodOwnerName = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(parent.getParent()));
                    if (methodOwnerName == null) {
                        t.report(n, EXPORT_ANNOTATION_NOT_ALLOWED, new String[0]);
                        return;
                    }
                    this.es6ClassExports.put(n, methodOwnerName + (n.isStaticMember() ? "" : ".prototype"));
                    return;
                }
            }
            case STRING_KEY: 
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (!this.allowLocalExports) break;
                export = n.getString();
                mode = Mode.EXTERN;
                break;
            }
        }
        if (export != null) {
            if (mode == Mode.EXPORT) {
                Preconditions.checkNotNull(context);
                this.exports.put(export, context);
            } else {
                Preconditions.checkState(context == null);
                Preconditions.checkState(mode == Mode.EXTERN);
                Preconditions.checkState(!export.isEmpty());
                this.localExports.add(export);
            }
        } else if (!(n.isGetProp() && parent.isExprResult() || n.isFunction() && NodeUtil.mayBeObjectLitKey(parent))) {
            if (this.allowLocalExports) {
                this.compiler.report(JSError.make(n, EXPORT_ANNOTATION_NOT_ALLOWED, new String[0]));
            } else {
                this.compiler.report(JSError.make(n, NON_GLOBAL_ERROR, new String[0]));
            }
        }
    }

    LinkedHashMap<String, Node> getExports() {
        return this.exports;
    }

    LinkedHashSet<String> getLocalExports() {
        return this.localExports;
    }

    LinkedHashMap<Node, String> getEs6ClassExports() {
        return this.es6ClassExports;
    }

    static enum Mode {
        EXPORT,
        EXTERN;

    }
}

