/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AutoValue_GlobalNamespace_ObjLitStringKeyAnalysis;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.ModuleImportResolver;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.jscomp.jarjar.com.google.auto.value.AutoValue;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Joiner;
import com.google.javascript.jscomp.jarjar.com.google.common.base.MoreObjects;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.HashBasedTable;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Table;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.StaticRef;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.StaticSlot;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.StaticSymbolTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;

class GlobalNamespace
implements StaticScope,
StaticSymbolTable<Name, Ref> {
    private final AbstractCompiler compiler;
    private final boolean enableImplicityAliasedValues;
    private final Node root;
    private final Node externsRoot;
    private final Node globalRoot = IR.root(new Node[0]);
    private final LinkedHashMap<Node, Boolean> spreadSiblingCache = new LinkedHashMap();
    private SourceKind sourceKind;
    private boolean generated = false;
    @Nullable
    private final LogFile decisionsLog;
    private static final QualifiedName GOOG_PROVIDE = QualifiedName.of("goog.provide");
    private final List<Name> globalNames = new ArrayList<Name>();
    private final Map<String, Name> nameMap = new HashMap<String, Name>();
    private final Table<ModuleMetadataMap.ModuleMetadata, String, Name> nameMapByModule = HashBasedTable.create();
    private Predicate<Node> shouldTraverseScript = n -> true;

    GlobalNamespace(LogFile decisionsLog, AbstractCompiler compiler, Node root) {
        this(decisionsLog, compiler, null, root);
    }

    GlobalNamespace(AbstractCompiler compiler, Node root) {
        this(null, compiler, null, root);
    }

    GlobalNamespace(AbstractCompiler compiler, Node externsRoot, Node root) {
        this(null, compiler, externsRoot, root);
    }

    GlobalNamespace(LogFile decisionsLog, AbstractCompiler compiler, Node externsRoot, Node root) {
        this.decisionsLog = decisionsLog;
        this.compiler = compiler;
        this.externsRoot = externsRoot;
        this.root = root;
        this.enableImplicityAliasedValues = !compiler.getOptions().getAssumeStaticInheritanceIsNotUsed();
    }

    void setShouldTraverseScriptPredicate(Predicate<Node> shouldTraverseScript) {
        this.shouldTraverseScript = shouldTraverseScript;
    }

    boolean hasExternsRoot() {
        return this.externsRoot != null;
    }

    @Override
    public Node getRootNode() {
        return this.root.getParent();
    }

    private Node getRootNode(String name, Scope s) {
        Var v = (Var)s.getVar(name = GlobalNamespace.getTopVarName(name));
        if (v == null) {
            Name providedName = this.nameMap.get(name);
            return providedName != null && providedName.isProvided ? this.globalRoot : null;
        }
        return v.isLocal() ? v.getScopeRoot() : this.globalRoot;
    }

    @Override
    public StaticScope getParentScope() {
        return null;
    }

    @Override
    public Name getSlot(String name) {
        return this.getOwnSlot(name);
    }

    @Override
    public Name getOwnSlot(String name) {
        this.ensureGenerated();
        return this.nameMap.get(name);
    }

    @Override
    public Iterable<Ref> getReferences(Name slot) {
        this.ensureGenerated();
        return Collections.unmodifiableCollection(slot.getRefs());
    }

    @Override
    public StaticScope getScope(Name slot) {
        return this;
    }

    @Override
    public Collection<Name> getAllSymbols() {
        this.ensureGenerated();
        return Collections.unmodifiableCollection(this.getNameIndex().values());
    }

    private void ensureGenerated() {
        if (!this.generated) {
            this.process();
        }
    }

    List<Name> getNameForest() {
        this.ensureGenerated();
        return this.globalNames;
    }

    Map<String, Name> getNameIndex() {
        this.ensureGenerated();
        return this.nameMap;
    }

    void scanNewNodes(Set<AstChange> newNodes) {
        BuildGlobalNamespace builder = new BuildGlobalNamespace();
        for (AstChange info : newNodes) {
            if (!info.node.isQualifiedName() && !NodeUtil.mayBeObjectLitKey(info.node)) continue;
            this.scanFromNode(builder, info.scope, info.node);
        }
    }

    private void scanFromNode(BuildGlobalNamespace builder, Scope scope, Node n) {
        Node parent = n.getParent();
        if ((n.isName() || n.isGetProp()) && parent.isGetProp()) {
            this.scanFromNode(builder, scope, n.getParent());
        } else if (n.getPrevious() != null && n.getPrevious().isObjectPattern()) {
            Node pattern = n.getPrevious();
            for (Node key = pattern.getFirstChild(); key != null; key = key.getNext()) {
                if (!key.isStringKey()) continue;
                this.scanFromNode(builder, scope, key);
            }
        }
        builder.collect(scope, n);
    }

    private void process() {
        NodeTraversal.Builder traversal = NodeTraversal.builder().setCompiler(this.compiler).setCallback(new BuildGlobalNamespace());
        if (this.hasExternsRoot()) {
            traversal.traverseRoots(this.externsRoot, this.root);
        } else {
            traversal.traverse(this.root);
        }
        this.generated = true;
    }

    private static String getTopVarName(String name) {
        int firstDotIndex = name.indexOf(46);
        return firstDotIndex == -1 ? name : name.substring(0, firstDotIndex);
    }

    @Nullable
    Name getNameFromModule(ModuleMetadataMap.ModuleMetadata moduleMetadata, String name) {
        Preconditions.checkNotNull(moduleMetadata);
        Preconditions.checkNotNull(name);
        this.ensureGenerated();
        return this.nameMapByModule.get(moduleMetadata, name);
    }

    private boolean declarationHasFollowingObjectSpreadSibling(Node declaration) {
        Preconditions.checkState(declaration.getParent().isObjectLit(), declaration);
        Boolean cached = this.spreadSiblingCache.get(declaration);
        if (cached != null) {
            return cached;
        }
        boolean toCache = false;
        for (Node sibling = declaration.getParent().getLastChild(); sibling != null; sibling = sibling.getPrevious()) {
            if (sibling.isSpread()) {
                toCache = true;
            }
            this.spreadSiblingCache.put(sibling, toCache);
        }
        return this.spreadSiblingCache.get(declaration);
    }

    @VisibleForTesting
    Name createNameForTesting(String name) {
        return new Name(name, null, SourceKind.CODE);
    }

    private static boolean isQnameDeclarationWithoutAssignment(@Nullable Node node) {
        return node != null && node.isGetProp() && node.getParent().isExprResult();
    }

    @AutoValue
    static abstract class ObjLitStringKeyAnalysis {
        ObjLitStringKeyAnalysis() {
        }

        @Nullable
        public abstract String getNameString();

        @Nullable
        public abstract NameType getNameType();

        static ObjLitStringKeyAnalysis forObjectDefineProperty(String nameString) {
            return new AutoValue_GlobalNamespace_ObjLitStringKeyAnalysis(Preconditions.checkNotNull(nameString), NameType.GET_SET);
        }

        static ObjLitStringKeyAnalysis forObjLitAssignment(String nameString, NameType nameType) {
            return new AutoValue_GlobalNamespace_ObjLitStringKeyAnalysis(Preconditions.checkNotNull(nameString), nameType);
        }

        static ObjLitStringKeyAnalysis forNonReference() {
            return new AutoValue_GlobalNamespace_ObjLitStringKeyAnalysis(null, NameType.OTHER);
        }
    }

    static class Ref
    implements StaticRef {
        private Node node;
        final Name name;
        final Type type;
        final Scope scope;
        private Ref twin = null;

        private Ref(Scope scope, Node node, Name name, Type type) {
            this.node = node;
            this.name = name;
            this.type = type;
            this.scope = scope;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public StaticSourceFile getSourceFile() {
            return this.node != null ? this.node.getStaticSourceFile() : null;
        }

        @Override
        public StaticSlot getSymbol() {
            return this.name;
        }

        Ref getTwin() {
            return this.twin;
        }

        boolean isSet() {
            return this.type == Type.SET_FROM_GLOBAL || this.type == Type.SET_FROM_LOCAL;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("type", (Object)this.type).add("node", this.node).add("isTwin", this.twin != null).add("scope", this.scope).toString();
        }

        static enum Type {
            SET_FROM_GLOBAL,
            SET_FROM_LOCAL,
            PROTOTYPE_GET,
            ALIASING_GET,
            DIRECT_GET,
            CALL_GET,
            DELETE_PROP,
            SUBCLASSING_GET;

        }
    }

    final class Name
    implements StaticSlot {
        private final String baseName;
        private final Name parent;
        @Nullable
        List<Name> props;
        private Ref declaration;
        private final LinkedHashSet<Ref> refs = new LinkedHashSet();
        private final Map<Node, ImmutableList<Ref>> refsForNodeMap = new HashMap<Node, ImmutableList<Ref>>();
        private NameType type;
        private DeclaredTypeKind declaredType = DeclaredTypeKind.NOT_A_TYPE;
        private boolean isDeclared = false;
        private boolean isModuleProp = false;
        private boolean isProvided = false;
        private boolean usedHasOwnProperty = false;
        private int globalSets = 0;
        private int localSets = 0;
        private int localSetsWithNoCollapse = 0;
        private int aliasingGets = 0;
        private int totalGets = 0;
        private int callGets = 0;
        private int deleteProps = 0;
        private int subclassingGets = 0;
        private final SourceKind sourceKind;
        @Nullable
        private JSDocInfo firstDeclarationJSDocInfo = null;
        @Nullable
        private JSDocInfo firstQnameDeclarationWithoutAssignmentJsDocInfo = null;

        private Name(String name, Name parent, SourceKind sourceKind) {
            this.baseName = name;
            this.parent = parent;
            this.type = NameType.OTHER;
            this.sourceKind = sourceKind;
        }

        Name addProperty(String name, SourceKind sourceKind) {
            if (this.props == null) {
                this.props = new ArrayList<Name>();
            }
            Name node = new Name(name, this, sourceKind);
            this.props.add(node);
            return node;
        }

        String getBaseName() {
            return this.baseName;
        }

        boolean inExterns() {
            return this.sourceKind == SourceKind.EXTERN;
        }

        SourceKind getSourceKind() {
            return this.sourceKind;
        }

        int subclassingGetCount() {
            return this.subclassingGets;
        }

        @Override
        public String getName() {
            return this.getFullName();
        }

        String getFullName() {
            return this.parent == null ? this.baseName : this.parent.getFullName() + '.' + this.baseName;
        }

        boolean usesHasOwnProperty() {
            return this.usedHasOwnProperty;
        }

        @Override
        @Nullable
        public Ref getDeclaration() {
            return this.declaration;
        }

        boolean isFunction() {
            return this.type == NameType.FUNCTION;
        }

        boolean isClass() {
            return this.type == NameType.CLASS;
        }

        boolean isObjectLiteral() {
            return this.type == NameType.OBJECTLIT;
        }

        int getAliasingGets() {
            return this.aliasingGets;
        }

        int getSubclassingGets() {
            return this.subclassingGets;
        }

        int getLocalSets() {
            return this.localSets;
        }

        int getGlobalSets() {
            return this.globalSets;
        }

        int getTotalSets() {
            return this.globalSets + this.localSets;
        }

        int getCallGets() {
            return this.callGets;
        }

        int getTotalGets() {
            return this.totalGets;
        }

        int getDeleteProps() {
            return this.deleteProps;
        }

        Name getParent() {
            return this.parent;
        }

        @Override
        public StaticScope getScope() {
            throw new UnsupportedOperationException();
        }

        private void addTwinRefs(Scope scope, Node node, Ref.Type setType) {
            Preconditions.checkArgument(setType == Ref.Type.SET_FROM_GLOBAL || setType == Ref.Type.SET_FROM_LOCAL, (Object)setType);
            Ref setRef = this.createNewRef(scope, node, setType);
            Ref getRef = this.createNewRef(scope, node, Ref.Type.ALIASING_GET);
            setRef.twin = getRef;
            getRef.twin = setRef;
            this.refsForNodeMap.put(node, ImmutableList.of(setRef, getRef));
            this.refs.add(setRef);
            this.updateStateForAddedRef(setRef);
            this.refs.add(getRef);
            this.updateStateForAddedRef(getRef);
        }

        private void addSingleRef(Scope scope, Node node, Ref.Type type) {
            this.checkNoExistingRefsForNode(node);
            Ref ref = this.createNewRef(scope, node, type);
            this.refs.add(ref);
            this.refsForNodeMap.put(node, ImmutableList.of(ref));
            this.updateStateForAddedRef(ref);
        }

        private void checkNoExistingRefsForNode(Node node) {
            ImmutableList<Ref> refsForNode = this.refsForNodeMap.get(node);
            Preconditions.checkState(refsForNode == null, "Refs already exist for node: %s", refsForNode);
        }

        private Ref createNewRef(Scope scope, Node node, Ref.Type type) {
            return new Ref(Preconditions.checkNotNull(scope), Preconditions.checkNotNull(node), this, type);
        }

        Ref addSingleRefForTesting(Ref.Type type) {
            Ref ref = new Ref(null, null, this, type);
            this.refs.add(ref);
            this.updateStateForAddedRef(ref);
            return ref;
        }

        void addAliasingGetClonedFromDeclaration(Node newRefNode) {
            Ref declRef = Preconditions.checkNotNull(this.declaration);
            this.addSingleRef(declRef.scope, newRefNode, Ref.Type.ALIASING_GET);
        }

        private void updateStateForAddedRef(Ref ref) {
            switch (ref.type) {
                case SET_FROM_GLOBAL: {
                    if (this.declaration == null) {
                        this.declaration = ref;
                    }
                    if (this.firstDeclarationJSDocInfo == null) {
                        this.firstDeclarationJSDocInfo = this.getDocInfoForDeclaration(ref);
                    }
                    ++this.globalSets;
                    break;
                }
                case SET_FROM_LOCAL: {
                    JSDocInfo info;
                    ++this.localSets;
                    JSDocInfo jSDocInfo = info = ref.getNode() == null ? null : NodeUtil.getBestJSDocInfo(ref.getNode());
                    if (info == null || !info.isNoCollapse()) break;
                    ++this.localSetsWithNoCollapse;
                    break;
                }
                case PROTOTYPE_GET: 
                case DIRECT_GET: {
                    Node node = ref.getNode();
                    if (this.firstQnameDeclarationWithoutAssignmentJsDocInfo == null && GlobalNamespace.isQnameDeclarationWithoutAssignment(node)) {
                        this.firstQnameDeclarationWithoutAssignmentJsDocInfo = node.getJSDocInfo();
                    }
                    ++this.totalGets;
                    break;
                }
                case ALIASING_GET: {
                    ++this.aliasingGets;
                    ++this.totalGets;
                    break;
                }
                case CALL_GET: {
                    ++this.callGets;
                    ++this.totalGets;
                    break;
                }
                case DELETE_PROP: {
                    ++this.deleteProps;
                    break;
                }
                case SUBCLASSING_GET: {
                    ++this.subclassingGets;
                    ++this.totalGets;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        void updateRefNode(Ref ref, @Nullable Node newNode) {
            Preconditions.checkArgument(ref.node != newNode, "redundant update to Ref node: %s", (Object)ref);
            Node oldNode = ref.getNode();
            Preconditions.checkState(oldNode != null, "Ref's node is already null: %s", (Object)ref);
            ref.node = newNode;
            Ref twinRef = ref.getTwin();
            if (twinRef != null) {
                ref.twin = null;
                twinRef.twin = null;
                this.refsForNodeMap.put(oldNode, ImmutableList.of(twinRef));
            } else {
                this.refsForNodeMap.remove(oldNode);
            }
            if (newNode != null) {
                ImmutableList<Ref> existingRefsForNewNode = this.refsForNodeMap.get(newNode);
                Preconditions.checkArgument(existingRefsForNewNode == null, "refs already exist: %s", existingRefsForNewNode);
                this.refsForNodeMap.put(newNode, ImmutableList.of(ref));
            }
        }

        void removeTwinRefs(Ref ref) {
            Preconditions.checkArgument(ref.name == this, "removeTwinRefs(%s): node does not belong to this name: %s", (Object)ref, (Object)this);
            Preconditions.checkState(this.refs.contains(ref), "removeRef(%s): unknown ref", (Object)ref);
            Ref twinRef = ref.getTwin();
            Preconditions.checkArgument(twinRef != null, ref);
            this.removeTwinRefsFromNodeMap(ref);
            this.removeRefAndUpdateState(ref);
            this.removeRefAndUpdateState(twinRef);
        }

        void removeRef(Ref ref) {
            Preconditions.checkState(ref.name == this, "removeRef(%s): node does not belong to this name: %s", (Object)ref, (Object)this);
            Preconditions.checkState(this.refs.contains(ref), "removeRef(%s): unknown ref", (Object)ref);
            Node refNode = ref.getNode();
            if (refNode != null) {
                this.removeSingleRefFromNodeMap(ref);
            }
            this.removeRefAndUpdateState(ref);
        }

        private void removeRefAndUpdateState(Ref ref) {
            this.refs.remove(ref);
            if (ref == this.declaration) {
                this.declaration = null;
                for (Ref maybeNewDecl : this.refs) {
                    if (maybeNewDecl.type != Ref.Type.SET_FROM_GLOBAL) continue;
                    this.declaration = maybeNewDecl;
                    break;
                }
            }
            switch (ref.type) {
                case SET_FROM_GLOBAL: {
                    --this.globalSets;
                    break;
                }
                case SET_FROM_LOCAL: {
                    JSDocInfo info;
                    --this.localSets;
                    JSDocInfo jSDocInfo = info = ref.getNode() == null ? null : NodeUtil.getBestJSDocInfo(ref.getNode());
                    if (info == null || !info.isNoCollapse()) break;
                    --this.localSetsWithNoCollapse;
                    break;
                }
                case PROTOTYPE_GET: 
                case DIRECT_GET: {
                    --this.totalGets;
                    break;
                }
                case ALIASING_GET: {
                    --this.aliasingGets;
                    --this.totalGets;
                    break;
                }
                case CALL_GET: {
                    --this.callGets;
                    --this.totalGets;
                    break;
                }
                case DELETE_PROP: {
                    --this.deleteProps;
                    break;
                }
                case SUBCLASSING_GET: {
                    --this.subclassingGets;
                    --this.totalGets;
                }
            }
        }

        private void removeSingleRefFromNodeMap(Ref ref) {
            Node refNode = Preconditions.checkNotNull(ref.getNode(), ref);
            if (ref.getTwin() != null) {
                this.removeTwinRefsFromNodeMap(ref);
                Ref twinRef = ref.getTwin();
                ref.twin = null;
                twinRef.twin = null;
                this.refsForNodeMap.put(refNode, ImmutableList.of(twinRef));
            } else {
                ImmutableList<Ref> refsForNode = this.refsForNodeMap.get(refNode);
                Preconditions.checkState(refsForNode.size() == 1 && refsForNode.get(0) == ref, "Unexpected Refs for Node: %s: when removing Ref: %s", refsForNode, (Object)ref);
                this.refsForNodeMap.remove(refNode);
            }
        }

        private void removeTwinRefsFromNodeMap(Ref ref) {
            Ref twinRef = Preconditions.checkNotNull(ref.getTwin(), ref);
            Node refNode = Preconditions.checkNotNull(ref.getNode(), ref);
            ImmutableList<Ref> refsForNode = this.refsForNodeMap.get(refNode);
            Preconditions.checkState(refsForNode.size() == 2, "unexpected Refs for Node: %s, when removing: %s", refsForNode, (Object)ref);
            Preconditions.checkState(refsForNode.contains(ref), "Refs for Node: %s does not contain Ref to remove: %s", refsForNode, (Object)ref);
            Preconditions.checkState(refsForNode.contains(twinRef), "Refs for Node: %s does not contain expected twin: %s", refsForNode, (Object)twinRef);
            this.refsForNodeMap.remove(refNode);
        }

        Collection<Ref> getRefs() {
            return this.refs == null ? ImmutableList.of() : Collections.unmodifiableCollection(this.refs);
        }

        @VisibleForTesting
        ImmutableList<Ref> getRefsForNode(Node node) {
            ImmutableList<Ref> refsForNode = this.refsForNodeMap.get(Preconditions.checkNotNull(node));
            return refsForNode == null ? ImmutableList.of() : refsForNode;
        }

        Ref getFirstRef() {
            Preconditions.checkState(!this.refs.isEmpty(), "no first Ref to get");
            return Iterables.get(this.refs, 0);
        }

        boolean canEliminate() {
            if (!this.canCollapseUnannotatedChildNames() || this.totalGets > 0) {
                return false;
            }
            if (this.props != null) {
                for (Name n : this.props) {
                    if (n.canCollapse()) continue;
                    return false;
                }
            }
            return true;
        }

        boolean isSimpleStubDeclaration() {
            Ref ref;
            return this.getRefs().size() == 1 && (ref = Iterables.get(this.refs, 0)).node.getParent().isExprResult();
        }

        boolean isCollapsingExplicitlyDenied() {
            JSDocInfo docInfo = this.getJSDocInfo();
            return docInfo != null && docInfo.isNoCollapse();
        }

        Inlinability calculateInlinability() {
            if (this.inExterns() || this.globalSets != 1 || this.localSets != 0) {
                return Inlinability.DO_NOT_INLINE;
            }
            Inlinability collapsibility = this.canCollapseOrInline();
            if (!collapsibility.shouldInlineUsages()) {
                return Inlinability.DO_NOT_INLINE;
            }
            block6: for (Ref ref : this.getRefs()) {
                switch (ref.type) {
                    case SET_FROM_GLOBAL: {
                        continue block6;
                    }
                    case SET_FROM_LOCAL: {
                        throw new IllegalStateException();
                    }
                    case PROTOTYPE_GET: 
                    case DIRECT_GET: 
                    case ALIASING_GET: 
                    case CALL_GET: 
                    case SUBCLASSING_GET: {
                        continue block6;
                    }
                    case DELETE_PROP: {
                        return Inlinability.DO_NOT_INLINE;
                    }
                }
                throw new IllegalStateException();
            }
            return collapsibility;
        }

        boolean canCollapse() {
            return this.canCollapseOrInline().canCollapse();
        }

        Inlinability canCollapseOrInline() {
            Node declaration;
            if (this.inExterns()) {
                this.logDecision(Inlinability.DO_NOT_INLINE, "declared in externs");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.isGetOrSetDefinition()) {
                this.logDecision(Inlinability.DO_NOT_INLINE, "getter / setter");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.isCollapsingExplicitlyDenied()) {
                this.logDecision(Inlinability.DO_NOT_INLINE, "@nocollapse");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.referencesSuperOrInnerClassName()) {
                this.logDecision(Inlinability.DO_NOT_INLINE, "references super or inner class name");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.getDeclaration() != null && (declaration = this.getDeclaration().getNode()).getParent().isObjectLit()) {
                if (GlobalNamespace.this.declarationHasFollowingObjectSpreadSibling(declaration)) {
                    this.logDecision(Inlinability.DO_NOT_INLINE, "obj lit property followed by spread");
                    return Inlinability.DO_NOT_INLINE;
                }
                Node grandparent = declaration.getGrandparent();
                if (grandparent.isOr() || grandparent.isHook()) {
                    this.logDecision(Inlinability.DO_NOT_INLINE, "conditional definition");
                    return Inlinability.DO_NOT_INLINE;
                }
            }
            boolean isUnchangedThroughFullName = (this.globalSets > 0 || this.localSets > 0) && this.localSetsWithNoCollapse == 0 && this.deleteProps == 0;
            Inlinability parentInlinability = this.parent == null ? Inlinability.INLINE_COMPLETELY : this.parent.canCollapseOrInlineChildNames();
            switch (parentInlinability) {
                case INLINE_COMPLETELY: {
                    if (isUnchangedThroughFullName) {
                        this.logDecision(Inlinability.INLINE_COMPLETELY, "parent inlineable: unchanged through full name");
                        return Inlinability.INLINE_COMPLETELY;
                    }
                    Inlinability unsafeInlinablility = this.getUnsafeInlinabilityBasedOnDeclaredType();
                    this.logDecision(unsafeInlinablility, "parent inlineable: changed through full name");
                    return unsafeInlinablility;
                }
                case INLINE_BUT_KEEP_DECLARATION_CLASS: 
                case INLINE_BUT_KEEP_DECLARATION_ENUM: 
                case INLINE_BUT_KEEP_DECLARATION_INTERFACE: {
                    if (this.isDeclaredType()) {
                        Inlinability unsafeInlinability = this.getUnsafeInlinabilityBasedOnDeclaredType();
                        this.logDecision(unsafeInlinability, "parent unsafely inlineable & is declared type");
                        return unsafeInlinability;
                    }
                    if (isUnchangedThroughFullName) {
                        this.logDecision(parentInlinability, "parent unsafely inlineable & unchanged through full name");
                        return parentInlinability;
                    }
                    this.logDecision(Inlinability.DO_NOT_INLINE, "parent unsafely inlineable & changed through full name");
                    return Inlinability.DO_NOT_INLINE;
                }
                case DO_NOT_INLINE: {
                    Inlinability unsafeInlinability = this.getUnsafeInlinabilityBasedOnDeclaredType();
                    this.logDecision(unsafeInlinability, "parent cannot be inlined");
                    return unsafeInlinability;
                }
            }
            throw new IllegalStateException("unknown enum value " + (Object)((Object)parentInlinability));
        }

        private void logDecision(Inlinability inlinability, String reason) {
            if (GlobalNamespace.this.decisionsLog != null) {
                GlobalNamespace.this.decisionsLog.log("%s: %s: %s", new Object[]{this.getFullName(), inlinability, reason});
            }
        }

        private Inlinability getUnsafeInlinabilityBasedOnDeclaredType() {
            switch (this.declaredType) {
                case CLASS: {
                    return Inlinability.INLINE_BUT_KEEP_DECLARATION_CLASS;
                }
                case INTERFACE: {
                    return Inlinability.INLINE_BUT_KEEP_DECLARATION_INTERFACE;
                }
                case ENUM: {
                    return Inlinability.INLINE_BUT_KEEP_DECLARATION_ENUM;
                }
                case NOT_A_TYPE: {
                    return Inlinability.DO_NOT_INLINE;
                }
            }
            throw new IllegalStateException(SimpleFormat.format("unexpected declaredType value: %s", new Object[]{this.declaredType}));
        }

        boolean referencesSuperOrInnerClassName() {
            Ref ref = this.getDeclaration();
            if (ref == null) {
                return false;
            }
            Node member = ref.getNode();
            if (member == null || !member.isStaticMember() || !member.getParent().isClassMembers()) {
                return false;
            }
            if (NodeUtil.referencesSuper(NodeUtil.getFunctionBody(member.getFirstChild()))) {
                return true;
            }
            Node classNode = member.getGrandparent();
            if (NodeUtil.isClassDeclaration(classNode)) {
                return false;
            }
            Node innerNameNode = classNode.getFirstChild();
            return !innerNameNode.isEmpty() && NodeUtil.isNameReferenced(member, innerNameNode.getString());
        }

        private boolean isSetInLoop() {
            Node n;
            Ref ref = this.getDeclaration();
            if (ref != null && (n = ref.getNode()) != null) {
                return NodeUtil.isWithinLoop(n);
            }
            return false;
        }

        boolean isGetOrSetDefinition() {
            return this.type == NameType.GET_SET;
        }

        boolean canCollapseUnannotatedChildNames() {
            return this.canCollapseOrInlineChildNames().canCollapse();
        }

        Inlinability canCollapseOrInlineChildNames() {
            if (this.type == NameType.OTHER) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, "NameType.OTHER");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.isGetOrSetDefinition()) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, "getter/setter");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.globalSets != 1) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, () -> SimpleFormat.format("set %d times globally", this.globalSets));
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.localSets != 0) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, () -> SimpleFormat.format("set %d times locally", this.localSets));
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.deleteProps != 0) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, () -> SimpleFormat.format("properties are deleted %d times", this.deleteProps));
                return Inlinability.DO_NOT_INLINE;
            }
            Preconditions.checkNotNull(this.declaration);
            if (this.declaration.getTwin() != null) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, "twinned declaration");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.isCollapsingExplicitlyDenied()) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, "@nocollapse");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.isSetInLoop()) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, "set in a loop");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.usedHasOwnProperty) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, "hasOwnProperty() call exists");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.valueImplicitlySupportsAliasing()) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, "value implicitly supports aliasing");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.parent != null && this.parent.shouldKeepKeys()) {
                Inlinability unsafeInlinability = this.getUnsafeInlinabilityBasedOnDeclaredType();
                this.logChildNamesDecision(unsafeInlinability, "parent.shouldKeepKeys()");
                return unsafeInlinability;
            }
            if (this.aliasingGets > 0) {
                Inlinability unsafeInlinability = this.getUnsafeInlinabilityBasedOnDeclaredType();
                this.logChildNamesDecision(unsafeInlinability, () -> SimpleFormat.format("%d aliasing gets exist", this.aliasingGets));
                return unsafeInlinability;
            }
            if (this.parent == null) {
                this.logChildNamesDecision(Inlinability.INLINE_COMPLETELY, "no reason not to inline");
                return Inlinability.INLINE_COMPLETELY;
            }
            Inlinability parentInlinability = this.parent.canCollapseOrInlineChildNames();
            if (parentInlinability == Inlinability.DO_NOT_INLINE) {
                Inlinability unsafeInlinability = this.getUnsafeInlinabilityBasedOnDeclaredType();
                this.logChildNamesDecision(unsafeInlinability, "parent is not inlineable");
                return unsafeInlinability;
            }
            this.logChildNamesDecision(parentInlinability, "inherited from parent");
            return parentInlinability;
        }

        private void logChildNamesDecision(Inlinability inlinability, String reason) {
            if (GlobalNamespace.this.decisionsLog != null) {
                GlobalNamespace.this.decisionsLog.log("%s: children: %s: %s", new Object[]{this.getFullName(), inlinability, reason});
            }
        }

        private void logChildNamesDecision(Inlinability inlinability, Supplier<String> reasonSupplier) {
            if (GlobalNamespace.this.decisionsLog != null) {
                GlobalNamespace.this.decisionsLog.log(() -> SimpleFormat.format("%s: children: %s: %s", new Object[]{this.getFullName(), inlinability, reasonSupplier.get()}));
            }
        }

        private boolean valueImplicitlySupportsAliasing() {
            if (!GlobalNamespace.this.enableImplicityAliasedValues) {
                return false;
            }
            switch (this.type) {
                case CLASS: {
                    return true;
                }
                case FUNCTION: {
                    JSDocInfo jsdoc = this.getJSDocInfo();
                    return jsdoc != null && jsdoc.isConstructorOrInterface();
                }
            }
            return false;
        }

        boolean shouldKeepKeys() {
            return this.type == NameType.OBJECTLIT && (this.aliasingGets > 0 || this.isCollapsingExplicitlyDenied());
        }

        boolean needsToBeStubbed() {
            return this.globalSets == 0 && this.localSets > 0 && this.localSetsWithNoCollapse == 0 && !this.isCollapsingExplicitlyDenied();
        }

        void setDeclaredType(DeclaredTypeKind kind) {
            this.declaredType = kind;
            if (kind != DeclaredTypeKind.NOT_A_TYPE) {
                Name ancestor = this.parent;
                while (ancestor != null) {
                    ancestor.isDeclared = true;
                    ancestor = ancestor.parent;
                }
            }
        }

        boolean isDeclaredType() {
            return this.declaredType != DeclaredTypeKind.NOT_A_TYPE;
        }

        boolean isConstructor() {
            Node declNode = this.declaration.node;
            Node rvalueNode = NodeUtil.getRValueOfLValue(declNode);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(declNode);
            return rvalueNode != null && rvalueNode.isFunction() && jsdoc != null && jsdoc.isConstructor();
        }

        boolean isNamespaceObjectLit() {
            return this.isDeclared && this.type == NameType.OBJECTLIT;
        }

        boolean isSimpleName() {
            return this.parent == null;
        }

        public String toString() {
            return this.getFullName() + " (" + (Object)((Object)this.type) + "): " + Joiner.on(", ").join("globalSets=" + this.globalSets, "localSets=" + this.localSets, "totalGets=" + this.totalGets, "aliasingGets=" + this.aliasingGets, "callGets=" + this.callGets, "subclassingGets=" + this.subclassingGets);
        }

        @Override
        @Nullable
        public JSDocInfo getJSDocInfo() {
            return this.firstDeclarationJSDocInfo != null ? this.firstDeclarationJSDocInfo : this.firstQnameDeclarationWithoutAssignmentJsDocInfo;
        }

        private JSDocInfo getDocInfoForDeclaration(Ref ref) {
            if (ref.node != null) {
                Node refParent = ref.node.getParent();
                if (refParent == null) {
                    return null;
                }
                switch (refParent.getToken()) {
                    case ASSIGN: 
                    case FUNCTION: 
                    case CLASS: {
                        return refParent.getJSDocInfo();
                    }
                    case VAR: 
                    case LET: 
                    case CONST: {
                        return ref.node == refParent.getFirstChild() ? refParent.getJSDocInfo() : ref.node.getJSDocInfo();
                    }
                    case OBJECTLIT: 
                    case CLASS_MEMBERS: {
                        return ref.node.getJSDocInfo();
                    }
                }
            }
            return null;
        }

        boolean isModuleExport() {
            return this.isModuleProp;
        }
    }

    static enum Inlinability {
        INLINE_COMPLETELY(true, true, true),
        INLINE_BUT_KEEP_DECLARATION_ENUM(true, false, true),
        INLINE_BUT_KEEP_DECLARATION_INTERFACE(true, false, true),
        INLINE_BUT_KEEP_DECLARATION_CLASS(true, false, true),
        DO_NOT_INLINE(false, false, false);

        private final boolean shouldInlineUsages;
        private final boolean shouldRemoveDeclaration;
        private final boolean canCollapse;

        private Inlinability(boolean shouldInlineUsages, boolean shouldRemoveDeclaration, boolean canCollapse) {
            this.shouldInlineUsages = shouldInlineUsages;
            this.shouldRemoveDeclaration = shouldRemoveDeclaration;
            this.canCollapse = canCollapse;
        }

        boolean shouldInlineUsages() {
            return this.shouldInlineUsages;
        }

        boolean shouldRemoveDeclaration() {
            return this.shouldRemoveDeclaration;
        }

        boolean canCollapse() {
            return this.canCollapse;
        }
    }

    private static enum DeclaredTypeKind {
        CLASS,
        INTERFACE,
        ENUM,
        NOT_A_TYPE;

    }

    static enum NameType {
        CLASS,
        OBJECTLIT,
        FUNCTION,
        SUBCLASSING_GET,
        GET_SET,
        OTHER;

    }

    private class BuildGlobalNamespace
    extends NodeTraversal.AbstractPreOrderCallback {
        private Node curModuleRoot = null;
        private ModuleMetadataMap.ModuleMetadata curMetadata = null;

        private BuildGlobalNamespace() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isScript() && !GlobalNamespace.this.shouldTraverseScript.test(n)) {
                return false;
            }
            if (GlobalNamespace.this.hasExternsRoot() && n.isScript()) {
                GlobalNamespace.this.sourceKind = SourceKind.fromScriptNode(n);
            } else if (n == GlobalNamespace.this.root) {
                GlobalNamespace.this.sourceKind = SourceKind.CODE;
            }
            if (n.isModuleBody() || NodeUtil.isBundledGoogModuleScopeRoot(n)) {
                this.setupModuleMetadata(n);
            } else if (n.isScript() || NodeUtil.isBundledGoogModuleCall(n)) {
                this.curModuleRoot = null;
                this.curMetadata = null;
            }
            this.collect(t.getScope(), n);
            return true;
        }

        private void setupModuleMetadata(Node moduleRoot) {
            ModuleMap moduleMap = GlobalNamespace.this.compiler.getModuleMap();
            if (moduleMap == null) {
                return;
            }
            this.curModuleRoot = moduleRoot;
            this.curMetadata = Preconditions.checkNotNull(ModuleImportResolver.getModuleFromScopeRoot(moduleMap, GlobalNamespace.this.compiler, moduleRoot).metadata());
            if (this.curMetadata.isGoogModule()) {
                this.getOrCreateName("exports", this.curMetadata);
            }
        }

        private void collect(Scope scope, Node n) {
            ModuleMetadataMap.ModuleMetadata nameMetadata;
            String name;
            Node parent = n.getParent();
            boolean isSet = false;
            NameType type = NameType.OTHER;
            switch (n.getToken()) {
                case GETTER_DEF: 
                case SETTER_DEF: 
                case MEMBER_FUNCTION_DEF: {
                    if (parent.isClassMembers() && !n.isStaticMember()) {
                        return;
                    }
                    name = NodeUtil.getBestLValueName(n);
                    isSet = true;
                    type = n.isMemberFunctionDef() ? NameType.FUNCTION : NameType.GET_SET;
                    break;
                }
                case STRING_KEY: {
                    name = null;
                    if (parent.isObjectLit()) {
                        ObjLitStringKeyAnalysis analysis = this.createObjLitStringKeyAnalysis(n);
                        name = analysis.getNameString();
                        type = analysis.getNameType();
                        isSet = true;
                        break;
                    }
                    if (!parent.isObjectPattern()) break;
                    name = this.getNameForObjectPatternKey(n);
                    type = this.getValueType(n.getFirstChild());
                    break;
                }
                case GETPROP: 
                case NAME: {
                    switch (parent.getToken()) {
                        case VAR: 
                        case LET: 
                        case CONST: {
                            isSet = true;
                            Node rvalue = n.getFirstChild();
                            type = rvalue == null ? NameType.OTHER : this.getValueType(rvalue);
                            break;
                        }
                        case ASSIGN: {
                            if (parent.getFirstChild() != n) break;
                            isSet = true;
                            type = this.getValueType(n.getNext());
                            break;
                        }
                        case GETPROP: {
                            return;
                        }
                        case FUNCTION: {
                            Node grandparent = parent.getParent();
                            if (grandparent == null || NodeUtil.isFunctionExpression(parent)) {
                                return;
                            }
                            isSet = true;
                            type = NameType.FUNCTION;
                            break;
                        }
                        case CATCH: 
                        case INC: 
                        case DEC: {
                            isSet = true;
                            type = NameType.OTHER;
                            break;
                        }
                        case CLASS: {
                            if (parent.getFirstChild() != n) break;
                            isSet = true;
                            type = NameType.CLASS;
                            break;
                        }
                        case STRING_KEY: 
                        case ARRAY_PATTERN: 
                        case DEFAULT_VALUE: 
                        case COMPUTED_PROP: 
                        case ITER_REST: 
                        case OBJECT_REST: {
                            if (!n.isName() || !NodeUtil.isLhsByDestructuring(n)) break;
                            isSet = true;
                            type = NameType.OTHER;
                            break;
                        }
                        case ITER_SPREAD: 
                        case OBJECT_SPREAD: {
                            break;
                        }
                        case CALL: {
                            if (!n.isFirstChildOf(parent) || !this.isObjectHasOwnPropertyCall(parent)) break;
                            String qname = n.getFirstChild().getQualifiedName();
                            Name globalName = this.getOrCreateName(qname, this.curMetadata);
                            globalName.usedHasOwnProperty = true;
                            break;
                        }
                        default: {
                            if (!NodeUtil.isAssignmentOp(parent) || parent.getFirstChild() != n) break;
                            isSet = true;
                            type = NameType.OTHER;
                        }
                    }
                    if (!n.isQualifiedName()) {
                        return;
                    }
                    name = n.getQualifiedName();
                    break;
                }
                case CALL: {
                    if (parent.isExprResult() && GOOG_PROVIDE.matches(n.getFirstChild()) && n.getSecondChild().isStringLit()) {
                        this.createNamesFromProvide(n.getSecondChild().getString());
                        return;
                    }
                    return;
                }
                default: {
                    return;
                }
            }
            if (name == null) {
                return;
            }
            Node root = GlobalNamespace.this.getRootNode(name, scope);
            if (!this.isTopLevelScopeRoot(root)) {
                return;
            }
            ModuleMetadataMap.ModuleMetadata moduleMetadata = nameMetadata = root == GlobalNamespace.this.globalRoot ? null : this.curMetadata;
            if (isSet) {
                Scope hoistScope = (Scope)scope.getClosestHoistScope();
                if (hoistScope.isGlobal() || root != GlobalNamespace.this.globalRoot && hoistScope.getRootNode() == this.curModuleRoot) {
                    this.handleSetFromGlobal(scope, n, name, type, nameMetadata);
                } else {
                    this.handleSetFromLocal(scope, n, name, nameMetadata);
                }
            } else {
                this.handleGet(scope, n, name, nameMetadata);
            }
        }

        private ObjLitStringKeyAnalysis createObjLitStringKeyAnalysis(Node stringKeyNode) {
            Node receiverNode;
            String nameString = NodeUtil.getBestLValueName(stringKeyNode);
            if (nameString != null) {
                return ObjLitStringKeyAnalysis.forObjLitAssignment(nameString, this.getValueType(stringKeyNode.getOnlyChild()));
            }
            Node objLitNode = stringKeyNode.getParent();
            Preconditions.checkArgument(objLitNode.isObjectLit(), objLitNode);
            Node objLitParentNode = objLitNode.getParent();
            if (NodeUtil.isObjectDefinePropertiesDefinition(objLitParentNode) && (receiverNode = objLitParentNode.getSecondChild()).isQualifiedName()) {
                Preconditions.checkState(objLitNode == receiverNode.getNext(), objLitParentNode);
                nameString = receiverNode.getQualifiedName() + "." + stringKeyNode.getString();
                return ObjLitStringKeyAnalysis.forObjectDefineProperty(nameString);
            }
            return ObjLitStringKeyAnalysis.forNonReference();
        }

        private void createNamesFromProvide(String namespace) {
            int dot = 0;
            while (dot >= 0) {
                String subNamespace = (dot = namespace.indexOf(46, dot + 1)) < 0 ? namespace : namespace.substring(0, dot);
                Preconditions.checkState(!subNamespace.isEmpty());
                Name name = this.getOrCreateName(subNamespace, null);
                name.isProvided = true;
            }
            Name newName = this.getOrCreateName(namespace, null);
            newName.isProvided = true;
        }

        private boolean isTopLevelScopeRoot(Node root) {
            if (root == null) {
                return false;
            }
            if (root == GlobalNamespace.this.globalRoot) {
                return true;
            }
            if (root == this.curModuleRoot) {
                return true;
            }
            return this.curModuleRoot != null && this.curModuleRoot.isBlock() && root == this.curModuleRoot.getParent();
        }

        String getNameForObjectPatternKey(Node stringKey) {
            Node parent = stringKey.getParent();
            Preconditions.checkState(parent.isObjectPattern());
            Node patternParent = parent.getParent();
            if (patternParent.isAssign() || patternParent.isDestructuringLhs()) {
                Node rhs = patternParent.getSecondChild();
                if (rhs == null || !rhs.isQualifiedName()) {
                    return null;
                }
                return rhs.getQualifiedName() + "." + stringKey.getString();
            }
            return null;
        }

        NameType getValueType(Node n) {
            switch (n.getToken()) {
                case CLASS: {
                    return NameType.CLASS;
                }
                case OBJECTLIT: {
                    return NameType.OBJECTLIT;
                }
                case FUNCTION: {
                    return NameType.FUNCTION;
                }
                case OR: {
                    return this.getValueType(n.getLastChild());
                }
                case HOOK: {
                    Node second = n.getSecondChild();
                    NameType t = this.getValueType(second);
                    if (t != NameType.OTHER) {
                        return t;
                    }
                    Node third = second.getNext();
                    return this.getValueType(third);
                }
            }
            return NameType.OTHER;
        }

        void handleSetFromGlobal(Scope scope, Node n, String name, NameType type, ModuleMetadataMap.ModuleMetadata metadata) {
            if (this.maybeHandlePrototypePrefix(scope, n, name, metadata)) {
                return;
            }
            Name nameObj = this.getOrCreateName(name, metadata);
            if (!nameObj.isGetOrSetDefinition()) {
                nameObj.type = type;
            }
            if (n.getBooleanProp(Node.MODULE_EXPORT)) {
                nameObj.isModuleProp = true;
            }
            if (this.isNestedAssign(n.getParent())) {
                Ref.Type refType = Ref.Type.SET_FROM_GLOBAL;
                this.addOrConfirmTwinRefs(nameObj, n, refType, scope);
            } else {
                this.addOrConfirmRef(nameObj, n, Ref.Type.SET_FROM_GLOBAL, scope);
                nameObj.setDeclaredType(this.getDeclaredTypeKind(n));
            }
        }

        private void addOrConfirmTwinRefs(Name nameObj, Node node, Ref.Type setRefType, Scope scope) {
            ImmutableList<Ref> existingRefs = nameObj.getRefsForNode(node);
            if (existingRefs.isEmpty()) {
                nameObj.addTwinRefs(scope, node, setRefType);
            } else {
                Preconditions.checkState(existingRefs.size() == 2, "unexpected existing refs: %s", existingRefs);
                Ref setRef = (Ref)existingRefs.get(0);
                Preconditions.checkState(setRef.type == setRefType, "unexpected existing set Ref type: %s", (Object)setRef.type);
            }
        }

        private DeclaredTypeKind getDeclaredTypeKind(Node n) {
            JSDocInfo info;
            Node valueNode = NodeUtil.getRValueOfLValue(n);
            DeclaredTypeKind kind = valueNode == null ? DeclaredTypeKind.NOT_A_TYPE : (valueNode.isClass() ? DeclaredTypeKind.CLASS : ((info = NodeUtil.getBestJSDocInfo(n)) == null ? DeclaredTypeKind.NOT_A_TYPE : (info.isConstructor() && valueNode.isFunction() ? DeclaredTypeKind.CLASS : (info.isInterface() && valueNode.isFunction() ? DeclaredTypeKind.INTERFACE : (info.hasEnumParameterType() && valueNode.isObjectLit() ? DeclaredTypeKind.ENUM : DeclaredTypeKind.NOT_A_TYPE)))));
            return kind;
        }

        void handleSetFromLocal(Scope scope, Node n, String name, ModuleMetadataMap.ModuleMetadata metadata) {
            if (this.maybeHandlePrototypePrefix(scope, n, name, metadata)) {
                return;
            }
            Name nameObj = this.getOrCreateName(name, metadata);
            if (n.getBooleanProp(Node.MODULE_EXPORT)) {
                nameObj.isModuleProp = true;
            }
            if (this.isNestedAssign(n.getParent())) {
                this.addOrConfirmTwinRefs(nameObj, n, Ref.Type.SET_FROM_LOCAL, scope);
            } else {
                this.addOrConfirmRef(nameObj, n, Ref.Type.SET_FROM_LOCAL, scope);
            }
        }

        void handleGet(Scope scope, Node n, String name, ModuleMetadataMap.ModuleMetadata metadata) {
            if (this.maybeHandlePrototypePrefix(scope, n, name, metadata)) {
                return;
            }
            Ref.Type type = this.determineRefTypeForGet(n, n, name);
            this.addOrConfirmRef(this.getOrCreateName(name, metadata), n, type, scope);
        }

        private Ref.Type determineRefTypeForGet(Node n, Node referenceNode, String name) {
            Ref.Type type;
            Node parent = n.getParent();
            block0 : switch (parent.getToken()) {
                case EXPR_RESULT: 
                case IF: 
                case WHILE: 
                case FOR: 
                case INSTANCEOF: 
                case TYPEOF: 
                case VOID: 
                case NOT: 
                case BITNOT: 
                case POS: 
                case NEG: 
                case SHEQ: 
                case EQ: 
                case SHNE: 
                case NE: 
                case LT: 
                case LE: 
                case GT: 
                case GE: 
                case ADD: 
                case SUB: 
                case MUL: 
                case DIV: 
                case MOD: 
                case EXPONENT: 
                case BITAND: 
                case BITOR: 
                case BITXOR: 
                case LSH: 
                case RSH: 
                case URSH: {
                    type = Ref.Type.DIRECT_GET;
                    break;
                }
                case CALL: 
                case OPTCHAIN_CALL: {
                    if (n == parent.getFirstChild()) {
                        type = Ref.Type.CALL_GET;
                        break;
                    }
                    if (this.isClassDefiningCall(parent)) {
                        type = Ref.Type.DIRECT_GET;
                        break;
                    }
                    type = Ref.Type.ALIASING_GET;
                    break;
                }
                case NEW: {
                    type = n == parent.getFirstChild() ? Ref.Type.DIRECT_GET : Ref.Type.ALIASING_GET;
                    break;
                }
                case OR: 
                case CAST: 
                case AND: 
                case COALESCE: {
                    type = this.determineRefTypeForGet(parent, referenceNode, name);
                    break;
                }
                case NAME: {
                    if (n != referenceNode && name.equals(parent.getString())) {
                        type = Ref.Type.DIRECT_GET;
                        break;
                    }
                    type = Ref.Type.ALIASING_GET;
                    break;
                }
                case HOOK: 
                case COMMA: {
                    if (n != parent.getFirstChild()) {
                        type = this.determineRefTypeForGet(parent, referenceNode, name);
                        break;
                    }
                    type = Ref.Type.DIRECT_GET;
                    break;
                }
                case DELPROP: {
                    type = Ref.Type.DELETE_PROP;
                    break;
                }
                case CLASS: {
                    type = Ref.Type.SUBCLASSING_GET;
                    break;
                }
                case ASSIGN: 
                case DESTRUCTURING_LHS: {
                    Node lhs = n.getPrevious();
                    if (lhs == null) {
                        type = Ref.Type.ALIASING_GET;
                        break;
                    }
                    while (lhs.isCast()) {
                        lhs = lhs.getOnlyChild();
                    }
                    if (n != referenceNode && lhs.matchesQualifiedName(name)) {
                        return Ref.Type.DIRECT_GET;
                    }
                    switch (lhs.getToken()) {
                        case GETPROP: 
                        case ARRAY_PATTERN: 
                        case NAME: 
                        case GETELEM: 
                        case OBJECT_PATTERN: {
                            type = Ref.Type.ALIASING_GET;
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Unexpected previous sibling of " + (Object)((Object)n.getToken()) + ": " + n.getPrevious());
                }
                default: {
                    type = Ref.Type.ALIASING_GET;
                }
            }
            return type;
        }

        private void addOrConfirmRef(Name nameObj, Node node, Ref.Type refType, Scope scope) {
            ImmutableList<Ref> existingRefs = nameObj.getRefsForNode(node);
            if (existingRefs.isEmpty()) {
                nameObj.addSingleRef(scope, node, refType);
            } else {
                Preconditions.checkState(existingRefs.size() == 1, "unexpected twin refs: %s", existingRefs);
                Ref.Type existingRefType = ((Ref)existingRefs.get((int)0)).type;
                Preconditions.checkState(existingRefType == refType, "existing ref type: %s expected: %s", (Object)existingRefType, (Object)refType);
            }
        }

        private boolean isClassDefiningCall(Node callNode) {
            CodingConvention convention = GlobalNamespace.this.compiler.getCodingConvention();
            CodingConvention.SubclassRelationship classes = convention.getClassesDefinedByCall(callNode);
            if (classes != null) {
                return true;
            }
            String className = convention.getSingletonGetterClassName(callNode);
            return className != null;
        }

        private boolean isObjectHasOwnPropertyCall(Node callNode) {
            Preconditions.checkArgument(callNode.isCall(), callNode);
            if (!callNode.hasTwoChildren()) {
                return false;
            }
            Node callee = callNode.getFirstChild();
            if (!callee.isGetProp()) {
                return false;
            }
            Node receiver = callee.getFirstChild();
            return "hasOwnProperty".equals(callee.getString()) && receiver.isQualifiedName();
        }

        boolean maybeHandlePrototypePrefix(Scope scope, Node n, String name, ModuleMetadataMap.ModuleMetadata metadata) {
            int i;
            String prefix;
            int numLevelsToRemove;
            if (name.endsWith(".prototype")) {
                numLevelsToRemove = 1;
                prefix = name.substring(0, name.length() - 10);
            } else {
                i = name.indexOf(".prototype.");
                if (i == -1) {
                    return false;
                }
                prefix = name.substring(0, i);
                numLevelsToRemove = 2;
                i = name.indexOf(46, i + 11);
                while (i >= 0) {
                    ++numLevelsToRemove;
                    i = name.indexOf(46, i + 1);
                }
            }
            if (NodeUtil.mayBeObjectLitKey(n)) {
                return true;
            }
            for (i = 0; i < numLevelsToRemove; ++i) {
                n = n.getFirstChild();
            }
            this.addOrConfirmRef(this.getOrCreateName(prefix, metadata), n, Ref.Type.PROTOTYPE_GET, scope);
            return true;
        }

        boolean isNestedAssign(Node parent) {
            return parent.isAssign() && !parent.getParent().isExprResult();
        }

        Name getOrCreateName(String name, ModuleMetadataMap.ModuleMetadata metadata) {
            Name node;
            Name name2 = node = metadata == null ? (Name)GlobalNamespace.this.nameMap.get(name) : (Name)GlobalNamespace.this.nameMapByModule.get(metadata, name);
            if (node == null) {
                int i = name.lastIndexOf(46);
                if (i >= 0) {
                    String parentName = name.substring(0, i);
                    Name parent = this.getOrCreateName(parentName, metadata);
                    node = parent.addProperty(name.substring(i + 1), GlobalNamespace.this.sourceKind);
                    if (metadata == null) {
                        GlobalNamespace.this.nameMap.put(name, node);
                    } else {
                        GlobalNamespace.this.nameMapByModule.put(metadata, name, node);
                    }
                } else {
                    node = new Name(name, null, GlobalNamespace.this.sourceKind);
                    if (metadata == null) {
                        GlobalNamespace.this.globalNames.add(node);
                        GlobalNamespace.this.nameMap.put(name, node);
                    } else {
                        GlobalNamespace.this.nameMapByModule.put(metadata, name, node);
                    }
                }
            }
            return node;
        }
    }

    static class AstChange {
        final Scope scope;
        final Node node;

        AstChange(Scope scope, Node node) {
            this.scope = scope;
            this.node = node;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AstChange) {
                AstChange other = (AstChange)obj;
                return Objects.equals(this.scope, other.scope) && Objects.equals(this.node, other.node);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.scope, this.node);
        }
    }

    static enum SourceKind {
        EXTERN,
        TYPE_SUMMARY,
        CODE;


        static SourceKind fromScriptNode(Node n) {
            if (!n.isFromExterns()) {
                return CODE;
            }
            if (NodeUtil.isFromTypeSummary(n)) {
                return TYPE_SUMMARY;
            }
            return EXTERN;
        }
    }
}

