/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PureFunctionIdentifier;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Strings;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.HashMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Multimap;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class J2clClinitPrunerPass
implements CompilerPass {
    private final Map<String, Node> emptiedClinitMethods = new LinkedHashMap<String, Node>();
    private final AbstractCompiler compiler;
    private final List<Node> changedScopeNodes;

    J2clClinitPrunerPass(AbstractCompiler compiler, List<Node> changedScopeNodes) {
        this.compiler = compiler;
        this.changedScopeNodes = changedScopeNodes;
    }

    @Override
    public void process(Node externs, Node root) {
        if (!J2clSourceFileChecker.shouldRunJ2clPasses(this.compiler)) {
            return;
        }
        this.removeRedundantClinits(root, this.changedScopeNodes);
        this.pruneEmptyClinits(root, this.changedScopeNodes);
        if (this.emptiedClinitMethods.isEmpty()) {
            return;
        }
        Multimap<String, Node> clinitReferences = this.collectClinitReferences(root);
        do {
            List<Node> newChangedScopes = this.cleanEmptyClinitReferences(clinitReferences);
            this.pruneEmptyClinits(root, newChangedScopes);
        } while (!this.emptiedClinitMethods.isEmpty());
        new PureFunctionIdentifier.Driver(this.compiler).process(externs, root);
    }

    private void removeRedundantClinits(Node root, List<Node> changedScopeNodes) {
        List<Node> changedRoots = J2clClinitPrunerPass.getNonNestedParentScopeNodes(changedScopeNodes);
        NodeTraversal.traverseScopeRoots(this.compiler, root, changedRoots, new RedundantClinitPruner(changedRoots), true);
        NodeTraversal.traverseScopeRoots(this.compiler, root, changedScopeNodes, new LookAheadRedundantClinitPruner(), false);
    }

    private void pruneEmptyClinits(Node root, List<Node> changedScopes) {
        this.emptiedClinitMethods.clear();
        NodeTraversal.traverseScopeRoots(this.compiler, root, changedScopes, new EmptyClinitPruner(), false);
        for (Map.Entry<String, Node> clinitReplacementEntry : this.emptiedClinitMethods.entrySet()) {
            clinitReplacementEntry.setValue(this.resolveReplacement(clinitReplacementEntry.getValue()));
        }
    }

    private Node resolveReplacement(Node node) {
        if (node == null) {
            return null;
        }
        String clinitName = J2clClinitPrunerPass.getClinitMethodName(node);
        return this.emptiedClinitMethods.containsKey(clinitName) ? this.resolveReplacement(this.emptiedClinitMethods.get(clinitName)) : node;
    }

    private Multimap<String, Node> collectClinitReferences(Node root) {
        final HashMultimap<String, Node> clinitReferences = HashMultimap.create();
        NodeTraversal.traverse(this.compiler, root, new NodeTraversal.AbstractPostOrderCallback(){

            @Override
            public void visit(NodeTraversal t, Node node, Node parent) {
                String clinitName = J2clClinitPrunerPass.getClinitMethodName(node);
                if (clinitName != null) {
                    clinitReferences.put(clinitName, node);
                }
            }
        });
        return clinitReferences;
    }

    private List<Node> cleanEmptyClinitReferences(Multimap<String, Node> clinitReferences) {
        ArrayList<Node> newChangedScopes = new ArrayList<Node>();
        for (Map.Entry<String, Node> clinitReplacementEntry : this.emptiedClinitMethods.entrySet()) {
            String clinitName = clinitReplacementEntry.getKey();
            Node replacement = clinitReplacementEntry.getValue();
            Collection<Node> references = clinitReferences.removeAll(clinitName);
            for (Node reference : references) {
                Node changedScope = NodeUtil.getEnclosingChangeScopeRoot(reference.getParent());
                if (replacement == null) {
                    NodeUtil.deleteFunctionCall(reference, this.compiler);
                } else {
                    replacement = replacement.cloneTree();
                    reference.replaceWith(replacement);
                    this.compiler.reportChangeToChangeScope(changedScope);
                    clinitReferences.put(J2clClinitPrunerPass.getClinitMethodName(replacement), replacement);
                }
                newChangedScopes.add(changedScope);
            }
        }
        return newChangedScopes;
    }

    private static List<Node> getNonNestedParentScopeNodes(List<Node> changedScopeNodes) {
        return changedScopeNodes == null ? null : NodeUtil.removeNestedChangeScopeNodes(NodeUtil.getParentChangeScopeNodes(changedScopeNodes));
    }

    private static boolean isClinitMethod(Node node) {
        return node.isFunction() && J2clClinitPrunerPass.isClinitMethodName(J2clClinitPrunerPass.getQualifiedNameOfFunction(node));
    }

    private static String getClinitMethodName(Node node) {
        if (node.isCall()) {
            String fnName = NodeUtil.getBestLValueName(node.getFirstChild());
            return J2clClinitPrunerPass.isClinitMethodName(fnName) ? fnName : null;
        }
        return null;
    }

    private static boolean isClinitMethodName(String fnName) {
        return fnName != null && (fnName.endsWith("$$0clinit") || fnName.endsWith(".$clinit"));
    }

    private static String getQualifiedNameOfFunction(Node function) {
        Preconditions.checkArgument(function.isFunction(), function);
        Node lValue = NodeUtil.getBestLValue(function);
        return NodeUtil.getBestLValueName(lValue);
    }

    private static class HierarchicalSet<T> {
        private final Set<T> currentSet = new HashSet<T>();
        @Nullable
        private final HierarchicalSet<T> parent;

        public HierarchicalSet(@Nullable HierarchicalSet<T> parent) {
            this.parent = parent;
        }

        public boolean add(T o) {
            return !this.parentsContains(o) && this.currentSet.add(o);
        }

        private boolean parentsContains(T o) {
            return this.parent != null && (this.parent.currentSet.contains(o) || super.parentsContains(o));
        }
    }

    private final class EmptyClinitPruner
    extends NodeTraversal.AbstractPostOrderCallback {
        private EmptyClinitPruner() {
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node parent) {
            if (!J2clClinitPrunerPass.isClinitMethod(node)) {
                return;
            }
            this.trySubstituteEmptyFunction(node);
        }

        private void trySubstituteEmptyFunction(Node fnNode) {
            Node replaceReferencesWith;
            String fnQualifiedName = J2clClinitPrunerPass.getQualifiedNameOfFunction(fnNode);
            if (Strings.isNullOrEmpty(fnQualifiedName)) {
                return;
            }
            Node body = fnNode.getLastChild();
            if (!body.hasChildren()) {
                return;
            }
            Node firstExpr = body.getFirstChild();
            if (!this.isAssignToEmptyFn(firstExpr, fnQualifiedName)) {
                return;
            }
            Node secondExpr = firstExpr.getNext();
            if (secondExpr == null) {
                replaceReferencesWith = null;
            } else if (secondExpr.getNext() == null && secondExpr.isExprResult() && J2clClinitPrunerPass.getClinitMethodName(secondExpr.getFirstChild()) != null) {
                replaceReferencesWith = secondExpr.getFirstChild();
            } else {
                return;
            }
            J2clClinitPrunerPass.this.emptiedClinitMethods.put(fnQualifiedName, replaceReferencesWith);
            NodeUtil.deleteNode(firstExpr, J2clClinitPrunerPass.this.compiler);
        }

        private boolean isAssignToEmptyFn(Node node, String enclosingFnName) {
            if (!NodeUtil.isExprAssign(node)) {
                return false;
            }
            Node lhs = node.getFirstFirstChild();
            if (lhs.isGetElem()) {
                return false;
            }
            Preconditions.checkState(lhs.isName() || lhs.isGetProp(), lhs);
            Node rhs = node.getFirstChild().getLastChild();
            return NodeUtil.isEmptyFunctionExpression(rhs) && Objects.equals(NodeUtil.getBestLValueName(lhs), enclosingFnName);
        }
    }

    private final class LookAheadRedundantClinitPruner
    extends NodeTraversal.AbstractPostOrderCallback {
        private LookAheadRedundantClinitPruner() {
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node parent) {
            if (!node.isExprResult()) {
                return;
            }
            String clinitName = J2clClinitPrunerPass.getClinitMethodName(node.getFirstChild());
            if (clinitName == null) {
                return;
            }
            Node callOrNewNode = this.getCallOrNewNode(node.getNext());
            if (callOrNewNode == null || !callOrNewNode.getFirstChild().isName()) {
                return;
            }
            Node enclosingFunction = NodeUtil.getEnclosingFunction(node);
            if (enclosingFunction == null || callOrNewNode.getFirstChild().getString().equals(NodeUtil.getNearestFunctionName(enclosingFunction))) {
                return;
            }
            Var var = (Var)t.getScope().getVar(callOrNewNode.getFirstChild().getString());
            if (var == null || var.getInitialValue() == null || !var.getInitialValue().isFunction()) {
                return;
            }
            Node staticFnNode = var.getInitialValue();
            if (this.callsClinit(staticFnNode, clinitName) && this.hasSafeArguments(t, callOrNewNode)) {
                node.detach();
                J2clClinitPrunerPass.this.compiler.reportChangeToEnclosingScope(parent);
            }
        }

        private boolean hasSafeArguments(NodeTraversal t, Node callOrNewNode) {
            for (Node child = callOrNewNode.getSecondChild(); child != null; child = child.getNext()) {
                if (NodeUtil.isLiteralValue(child, false) || this.isParameter(t, child)) continue;
                return false;
            }
            return true;
        }

        private boolean isParameter(NodeTraversal t, Node n) {
            if (!n.isName()) {
                return false;
            }
            Var var = (Var)t.getScope().getVar(n.getString());
            return var.getParentNode().isParamList();
        }

        private Node getCallOrNewNode(Node n) {
            if (n == null) {
                return null;
            }
            switch (n.getToken()) {
                case EXPR_RESULT: 
                case RETURN: {
                    return this.getCallOrNewNode(n.getFirstChild());
                }
                case CALL: 
                case NEW: {
                    return n;
                }
                case CONST: 
                case LET: 
                case VAR: {
                    return n.hasOneChild() ? this.getCallOrNewNode(n.getFirstFirstChild()) : null;
                }
            }
            return null;
        }

        private boolean callsClinit(Node fnNode, String clinitName) {
            Preconditions.checkNotNull(clinitName);
            Node child = fnNode.getLastChild().getFirstChild();
            return child != null && child.isExprResult() && clinitName.equals(J2clClinitPrunerPass.getClinitMethodName(child.getFirstChild()));
        }
    }

    private final class RedundantClinitPruner
    implements NodeTraversal.Callback {
        private final ImmutableSet<Node> roots;
        private final Deque<HierarchicalSet<String>> stateStack = new ArrayDeque<HierarchicalSet<String>>();
        private HierarchicalSet<String> clinitsCalledAtBranch = new HierarchicalSet(null);

        RedundantClinitPruner(Iterable<Node> roots) {
            this.roots = roots == null ? ImmutableSet.of() : ImmutableSet.copyOf(roots);
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node node, Node parent) {
            if (this.roots.contains(node)) {
                this.clinitsCalledAtBranch = new HierarchicalSet(null);
                this.stateStack.clear();
            }
            if (NodeUtil.isFunctionDeclaration(node) || node.isScript()) {
                this.stateStack.addLast(this.clinitsCalledAtBranch);
                this.clinitsCalledAtBranch = new HierarchicalSet(null);
            }
            if (this.isNewControlBranch(parent)) {
                this.clinitsCalledAtBranch = new HierarchicalSet<String>(this.clinitsCalledAtBranch);
                if (J2clClinitPrunerPass.isClinitMethod(parent)) {
                    this.clinitsCalledAtBranch.add(J2clClinitPrunerPass.getQualifiedNameOfFunction(parent));
                }
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node parent) {
            this.tryRemovingClinit(node);
            if (this.isNewControlBranch(parent)) {
                this.clinitsCalledAtBranch = ((HierarchicalSet)this.clinitsCalledAtBranch).parent;
            }
            if (NodeUtil.isFunctionDeclaration(node) || node.isScript()) {
                this.clinitsCalledAtBranch = this.stateStack.removeLast();
            }
        }

        private void tryRemovingClinit(Node node) {
            String clinitName = J2clClinitPrunerPass.getClinitMethodName(node);
            if (clinitName == null) {
                return;
            }
            if (this.clinitsCalledAtBranch.add(clinitName)) {
                return;
            }
            NodeUtil.deleteFunctionCall(node, J2clClinitPrunerPass.this.compiler);
        }

        private boolean isNewControlBranch(Node n) {
            return n != null && (NodeUtil.isControlStructure(n) || n.isDefaultValue() || n.isHook() || n.isAnd() || n.isOr() || n.isFunction());
        }
    }
}

