/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.Es6SortedDependencies;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JSChunk
extends DependencyInfo.Base
implements Serializable {
    public static final String STRONG_CHUNK_NAME = "$strong$";
    public static final String WEAK_CHUNK_NAME = "$weak$";
    private static final long serialVersionUID = 1L;
    private final String name;
    private transient Map<String, CompilerInput> inputs = new LinkedHashMap<String, CompilerInput>();
    private final List<JSChunk> deps = new ArrayList<JSChunk>();
    private int depth;
    private int index;

    public JSChunk(String name) {
        this.name = name;
        this.depth = -1;
        this.index = -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImmutableList<String> getProvides() {
        return ImmutableList.of(this.name);
    }

    @Override
    public boolean getHasExternsAnnotation() {
        return false;
    }

    @Override
    public boolean getHasNoCompileAnnotation() {
        return false;
    }

    @Override
    public ImmutableList<DependencyInfo.Require> getRequires() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JSChunk m : this.deps) {
            builder.add(DependencyInfo.Require.compilerModule(m.getName()));
        }
        return builder.build();
    }

    @Override
    public ImmutableList<String> getTypeRequires() {
        return ImmutableList.of();
    }

    @Override
    public String getPathRelativeToClosureBase() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableMap<String, String> getLoadFlags() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isModule() {
        throw new UnsupportedOperationException();
    }

    public void add(SourceFile file) {
        this.add(new CompilerInput(file));
    }

    public void add(CompilerInput input) {
        String inputName = input.getName();
        Preconditions.checkArgument(!this.inputs.containsKey(inputName), "%s already exist in chunk %s", (Object)inputName, (Object)this.getName());
        this.inputs.put(inputName, input);
        input.setModule(this);
    }

    void addAndOverrideChunk(CompilerInput input) {
        String inputName = input.getName();
        Preconditions.checkArgument(!this.inputs.containsKey(inputName), "%s already exist in chunk %s", (Object)inputName, (Object)this.getName());
        this.inputs.put(inputName, input);
        input.overrideModule(this);
    }

    public void addDependency(JSChunk dep) {
        Preconditions.checkNotNull(dep);
        Preconditions.checkState(dep != this, "Cannot add dependency on self", (Object)this);
        this.deps.add(dep);
    }

    public void remove(CompilerInput input) {
        input.setModule(null);
        this.inputs.remove(input.getName());
    }

    public void removeAll() {
        for (CompilerInput input : this.inputs.values()) {
            input.setModule(null);
        }
        this.inputs.clear();
    }

    public ImmutableList<JSChunk> getDependencies() {
        return ImmutableList.copyOf(this.deps);
    }

    List<String> getSortedDependencyNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (JSChunk chunk : this.getDependencies()) {
            names.add(chunk.getName());
        }
        Collections.sort(names);
        return names;
    }

    public Set<JSChunk> getAllDependencies() {
        Set<JSChunk> allDeps = Sets.newIdentityHashSet();
        allDeps.addAll(this.deps);
        ArrayDeque<JSChunk> stack = new ArrayDeque<JSChunk>(this.deps);
        while (!stack.isEmpty()) {
            JSChunk chunk = stack.pop();
            List<JSChunk> chunkDeps = chunk.deps;
            for (JSChunk dep : chunkDeps) {
                if (!allDeps.add(dep)) continue;
                stack.push(dep);
            }
        }
        return allDeps;
    }

    public Set<JSChunk> getThisAndAllDependencies() {
        Set<JSChunk> deps = this.getAllDependencies();
        deps.add(this);
        return deps;
    }

    public int getInputCount() {
        return this.inputs.size();
    }

    public CompilerInput getFirst() {
        return this.inputs.values().iterator().next();
    }

    public List<CompilerInput> getInputs() {
        return ImmutableList.copyOf(this.inputs.values());
    }

    public CompilerInput getByName(String name) {
        return this.inputs.get(name);
    }

    public boolean removeByName(String name) {
        CompilerInput value = this.inputs.remove(name);
        return value != null;
    }

    public boolean isSynthetic() {
        return this.name.equals(STRONG_CHUNK_NAME) || this.name.equals(WEAK_CHUNK_NAME);
    }

    public boolean isWeak() {
        return this.name.equals(WEAK_CHUNK_NAME);
    }

    public String toString() {
        return this.name;
    }

    public void sortInputsByDeps(AbstractCompiler compiler) {
        for (CompilerInput input : this.inputs.values()) {
            input.setCompiler(compiler);
        }
        List<CompilerInput> sortedList = new Es6SortedDependencies<CompilerInput>(this.getInputs()).getSortedList();
        this.inputs.clear();
        for (CompilerInput input : sortedList) {
            this.inputs.put(input.getName(), input);
        }
    }

    public void setDepth(int dep) {
        Preconditions.checkArgument(dep >= 0, "invalid depth: %s", dep);
        this.depth = dep;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setIndex(int index) {
        Preconditions.checkArgument(index >= 0, "Invalid chunk index: %s", index);
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @GwtIncompatible(value="ObjectinputStream")
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.inputs = new LinkedHashMap<String, CompilerInput>();
    }
}

