/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AutoValue_JSError;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.jarjar.com.google.auto.value.AutoValue;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Strings;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.Node;
import java.io.Serializable;

@AutoValue
public abstract class JSError
implements Serializable {
    private static final int DEFAULT_LINENO = -1;
    private static final int DEFAULT_CHARNO = -1;
    private static final String DEFAULT_SOURCENAME = null;
    private static final Node DEFAULT_NODE = null;

    public abstract DiagnosticType getType();

    public abstract String getDescription();

    @Nullable
    public abstract String getSourceName();

    public abstract int getLineno();

    public abstract int getCharno();

    @Nullable
    public abstract Node getNode();

    public abstract CheckLevel getDefaultLevel();

    public static JSError make(DiagnosticType type, String ... arguments) {
        return new AutoValue_JSError(type, type.format(arguments), DEFAULT_SOURCENAME, -1, -1, DEFAULT_NODE, type.level);
    }

    public static JSError make(String sourceName, int lineno, int charno, DiagnosticType type, String ... arguments) {
        return new AutoValue_JSError(type, type.format(arguments), sourceName, lineno, charno, DEFAULT_NODE, type.level);
    }

    public static JSError make(String sourceName, int lineno, int charno, CheckLevel level, DiagnosticType type, String ... arguments) {
        return new AutoValue_JSError(type, type.format(arguments), sourceName, lineno, charno, DEFAULT_NODE, level);
    }

    public static JSError make(Node n, DiagnosticType type, String ... arguments) {
        return new AutoValue_JSError(type, type.format(arguments), n.getSourceFileName(), n.getLineno(), n.getCharno(), n, type.level);
    }

    public static JSError make(Node n, CheckLevel level, DiagnosticType type, String ... arguments) {
        return new AutoValue_JSError(type, type.format(arguments), n.getSourceFileName(), n.getLineno(), n.getCharno(), n, level);
    }

    public final String toString() {
        String sourceName = Strings.emptyToNull(this.getSourceName()) != null ? this.getSourceName() : "(unknown source)";
        String lineno = this.getLineno() != -1 ? String.valueOf(this.getLineno()) : "(unknown line)";
        String charno = this.getCharno() != -1 ? String.valueOf(this.getCharno()) : "(unknown column)";
        return this.getType().key + ". " + this.getDescription() + " at " + sourceName + " line " + lineno + " : " + charno;
    }

    public final String format(CheckLevel level, MessageFormatter formatter) {
        switch (level) {
            case ERROR: {
                return formatter.formatError(this);
            }
            case WARNING: {
                return formatter.formatWarning(this);
            }
        }
        return null;
    }

    public final int getNodeSourceOffset() {
        return this.getNode() != null ? this.getNode().getSourceOffset() : -1;
    }

    public final int getNodeLength() {
        return this.getNode() != null ? this.getNode().getLength() : 0;
    }

    public final int getLineNumber() {
        return this.getLineno();
    }

    JSError() {
    }
}

