/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckJSDoc;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckSuper;
import com.google.javascript.jscomp.CheckTypeImportCodeReferences;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.ClosureRewriteClass;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DefaultPassConfig;
import com.google.javascript.jscomp.GatherModuleMetadata;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.lint.CheckConstPrivateProperties;
import com.google.javascript.jscomp.lint.CheckConstantCaseNames;
import com.google.javascript.jscomp.lint.CheckDefaultExportOfGoogModule;
import com.google.javascript.jscomp.lint.CheckDuplicateCase;
import com.google.javascript.jscomp.lint.CheckEmptyStatements;
import com.google.javascript.jscomp.lint.CheckEnums;
import com.google.javascript.jscomp.lint.CheckExtraRequires;
import com.google.javascript.jscomp.lint.CheckGoogModuleTypeScriptName;
import com.google.javascript.jscomp.lint.CheckInterfaces;
import com.google.javascript.jscomp.lint.CheckJSDocStyle;
import com.google.javascript.jscomp.lint.CheckMissingSemicolon;
import com.google.javascript.jscomp.lint.CheckNullabilityModifiers;
import com.google.javascript.jscomp.lint.CheckPrimitiveAsObject;
import com.google.javascript.jscomp.lint.CheckPrototypeProperties;
import com.google.javascript.jscomp.lint.CheckProvidesSorted;
import com.google.javascript.jscomp.lint.CheckRequiresSorted;
import com.google.javascript.jscomp.lint.CheckUnusedLabels;
import com.google.javascript.jscomp.lint.CheckUnusedPrivateProperties;
import com.google.javascript.jscomp.lint.CheckUselessBlocks;
import com.google.javascript.jscomp.lint.CheckVar;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import java.util.List;

class LintPassConfig
extends PassConfig.PassConfigDelegate {
    private final PassFactory gatherModuleMetadataPass = PassFactory.builder().setName("gatherModuleMetadata").setInternalFactory(compiler -> new GatherModuleMetadata((AbstractCompiler)compiler, compiler.getOptions().getProcessCommonJSModules(), compiler.getOptions().getModuleResolutionMode())).setFeatureSet(FeatureSet.latest()).build();
    private final PassFactory earlyLintChecks = PassFactory.builder().setName("earlyLintChecks").setInternalFactory(compiler -> new CombinedCompilerPass((AbstractCompiler)compiler, (List<NodeTraversal.Callback>)ImmutableList.of(new CheckConstPrivateProperties((AbstractCompiler)compiler), new CheckConstantCaseNames((AbstractCompiler)compiler), new CheckDefaultExportOfGoogModule((AbstractCompiler)compiler), new CheckDuplicateCase((AbstractCompiler)compiler), new CheckEmptyStatements((AbstractCompiler)compiler), new CheckEnums((AbstractCompiler)compiler), new CheckExtraRequires((AbstractCompiler)compiler, this.options.getUnusedImportsToRemove()), new CheckGoogModuleTypeScriptName((AbstractCompiler)compiler), new CheckJSDocStyle((AbstractCompiler)compiler), new CheckJSDoc((AbstractCompiler)compiler), new CheckMissingSemicolon((AbstractCompiler)compiler), new CheckSuper((AbstractCompiler)compiler), new NodeTraversal.Callback[]{new CheckPrimitiveAsObject((AbstractCompiler)compiler), new ClosureCheckModule((AbstractCompiler)compiler, compiler.getModuleMetadataMap()), new CheckNullabilityModifiers((AbstractCompiler)compiler), new CheckProvidesSorted(CheckProvidesSorted.Mode.COLLECT_AND_REPORT), new CheckRequiresSorted(CheckRequiresSorted.Mode.COLLECT_AND_REPORT), new CheckSideEffects((AbstractCompiler)compiler, true, false), new CheckTypeImportCodeReferences((AbstractCompiler)compiler), new CheckUnusedLabels((AbstractCompiler)compiler), new CheckUnusedPrivateProperties((AbstractCompiler)compiler), new CheckUselessBlocks((AbstractCompiler)compiler), new CheckVar((AbstractCompiler)compiler)}))).setFeatureSet(FeatureSet.latest()).build();
    private final PassFactory variableReferenceCheck = PassFactory.builder().setName("variableReferenceCheck").setRunInFixedPointLoop(true).setInternalFactory(VariableReferenceCheck::new).setFeatureSet(FeatureSet.latest()).build();
    private final PassFactory closureRewriteClass = PassFactory.builder().setName("closureRewriteClass").setInternalFactory(ClosureRewriteClass::new).setFeatureSet(FeatureSet.latest()).build();
    private final PassFactory lateLintChecks = PassFactory.builder().setName("lateLintChecks").setInternalFactory(compiler -> new CombinedCompilerPass((AbstractCompiler)compiler, (List<NodeTraversal.Callback>)ImmutableList.of(new CheckInterfaces((AbstractCompiler)compiler), new CheckPrototypeProperties((AbstractCompiler)compiler)))).setFeatureSet(FeatureSet.latest()).build();

    LintPassConfig(CompilerOptions options) {
        super(new DefaultPassConfig(options));
    }

    @Override
    protected List<PassFactory> getChecks() {
        return ImmutableList.of(this.gatherModuleMetadataPass, this.earlyLintChecks, this.variableReferenceCheck, this.closureRewriteClass, this.lateLintChecks);
    }

    @Override
    protected List<PassFactory> getOptimizations() {
        return ImmutableList.of();
    }

    @Override
    protected List<PassFactory> getFinalizations() {
        return ImmutableList.of();
    }
}

