/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

@GwtIncompatible(value="Unnecessary")
final class LocaleDataPasses {
    static final String GOOG_LOCALE_REPLACEMENT = "__JSC_LOCALE__";
    static final String LOCALE_VALUE_REPLACEMENT = "__JSC_LOCALE_VALUE__";
    static final DiagnosticType UNEXPECTED_GOOG_LOCALE = DiagnosticType.error("JSC_UNEXPECTED_GOOG_LOCALE", "`goog.LOCALE` appears in a file lacking `@localeFile`.");
    public static final DiagnosticType LOCALE_FILE_MALFORMED = DiagnosticType.error("JSC_LOCALE_FILE_MALFORMED", "Malformed locale data file. {0}");
    public static final DiagnosticType LOCALE_MISSING_BASE_FILE = DiagnosticType.error("JSC_LOCALE_MISSING_BASE_FILE", "Missing base file for extension file: {0}");
    private static final Node QNAME_FOR_GOOG_LOCALE = IR.getprop(IR.name("goog"), "LOCALE");

    private LocaleDataPasses() {
    }

    private static boolean isGoogDotLocaleReference(Node n) {
        return n.matchesQualifiedName(QNAME_FOR_GOOG_LOCALE);
    }

    private static String normalizeLocale(String locale) {
        return locale.replace('-', '_');
    }

    public static void addLocaleDataToAST(AbstractCompiler compiler, AbstractCompiler.LocaleData localeData) {
        ArrayList<LinkedHashMap<String, Node>> data = localeData == null ? null : ((LocaleDataImpl)localeData).data;
        Node arr = IR.arraylit(new Node[0]);
        if (data != null) {
            for (LinkedHashMap<String, Node> localeValueEntry : data) {
                Node obj = IR.objectlit(new Node[0]);
                arr.addChildToBack(obj);
                for (Map.Entry<String, Node> entry : localeValueEntry.entrySet()) {
                    String locale = entry.getKey();
                    Node value = entry.getValue();
                    obj.addChildToBack(IR.quotedStringKey(locale, value));
                }
            }
        }
        Node stmt = IR.var(IR.name("__JSC_LOCALE_DATA__"), arr);
        Node root = compiler.getJsRoot();
        Node script = root.getFirstChild();
        Preconditions.checkState(script.isScript());
        stmt.srcrefTreeIfMissing(script);
        script.addChildToFront(stmt);
    }

    public static AbstractCompiler.LocaleData reconstituteLocaleDataFromAST(AbstractCompiler compiler) {
        ArrayList<LinkedHashMap<String, Node>> localeData = new ArrayList<LinkedHashMap<String, Node>>();
        Node root = compiler.getJsRoot();
        Node script = root.getFirstChild();
        Preconditions.checkState(script.isScript());
        Node stmt = script.removeFirstChild();
        Preconditions.checkState(stmt.isVar());
        Node nameNode = stmt.getFirstChild();
        Preconditions.checkState(nameNode.isName());
        Node arrlit = nameNode.getLastChild();
        Preconditions.checkState(arrlit.isArrayLit());
        for (Node obj = arrlit.getFirstChild(); obj != null; obj = obj.getNext()) {
            Preconditions.checkState(obj.isObjectLit());
            LinkedHashMap<String, Node> map = new LinkedHashMap<String, Node>();
            localeData.add(map);
            for (Node member = obj.getFirstChild(); member != null; member = member.getNext()) {
                Preconditions.checkState(member.isStringKey());
                String locale = member.getString();
                Node value = member.removeFirstChild();
                map.put(LocaleDataPasses.normalizeLocale(locale), value);
            }
        }
        return new LocaleDataImpl(localeData);
    }

    static class LocaleSubstitutions
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private static final String DEFAULT_LOCALE = "en";
        private final Node qnameForLocale = IR.name("__JSC_LOCALE__");
        private final AbstractCompiler compiler;
        private final ArrayList<LinkedHashMap<String, Node>> localeValueMap;
        private final String locale;

        LocaleSubstitutions(AbstractCompiler compiler, String locale, AbstractCompiler.LocaleData localeData) {
            this.compiler = compiler;
            this.locale = locale == null ? DEFAULT_LOCALE : locale;
            this.localeValueMap = null;
        }

        @Override
        public void process(Node externs, Node root) {
            NodeTraversal.traverse(this.compiler, root, this);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.matchesName(this.qnameForLocale)) {
                Node replacement = IR.string(Preconditions.checkNotNull(this.locale)).srcref(n);
                n.replaceWith(replacement);
                this.compiler.reportChangeToEnclosingScope(replacement);
            }
        }
    }

    private static class ProtectCurrentLocale
    implements NodeTraversal.Callback {
        private final AbstractCompiler compiler;
        private boolean replaced = false;

        ProtectCurrentLocale(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !this.replaced;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (parent != null && parent.isAssign() && parent.getFirstChild() == n && LocaleDataPasses.isGoogDotLocaleReference(n)) {
                Node value = parent.getLastChild();
                Node replacement = IR.name(LocaleDataPasses.GOOG_LOCALE_REPLACEMENT);
                replacement.putBooleanProp(Node.IS_CONSTANT_NAME, true);
                value.replaceWith(replacement);
                this.compiler.reportChangeToEnclosingScope(parent);
                this.replaced = true;
            }
        }
    }

    static class ExtractAndProtect
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private AbstractCompiler.LocaleData localeData;

        ExtractAndProtect(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void process(Node externs, Node root) {
            NodeUtil.createSynthesizedExternsSymbol(this.compiler, LocaleDataPasses.GOOG_LOCALE_REPLACEMENT);
            ProtectCurrentLocale protectLocaleCallback = new ProtectCurrentLocale(this.compiler);
            NodeTraversal.traverse(this.compiler, root, protectLocaleCallback);
            this.localeData = new LocaleDataImpl(null);
        }

        public AbstractCompiler.LocaleData getLocaleValuesDataMaps() {
            Preconditions.checkNotNull(this.localeData, "process must be called before getLocaleValuesDataMaps");
            return this.localeData;
        }
    }

    private static class LocaleDataImpl
    implements AbstractCompiler.LocaleData {
        ArrayList<LinkedHashMap<String, Node>> data;

        LocaleDataImpl(ArrayList<LinkedHashMap<String, Node>> data) {
            this.data = data;
        }
    }
}

