/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerInputProvider;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ScopedName;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.modules.Binding;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.Map;
import java.util.function.Function;

final class ModuleImportResolver {
    private final ModuleMap moduleMap;
    private final Function<Node, TypedScope> nodeToScopeMapper;
    private final JSTypeRegistry registry;
    private static final String GOOG = "goog";
    private static final ImmutableSet<String> GOOG_DEPENDENCY_CALLS = ImmutableSet.of("require", "requireType", "forwardDeclare");
    private static final QualifiedName GOOG_MODULE_GET = QualifiedName.of("goog.module.get");

    ModuleImportResolver(ModuleMap moduleMap, Function<Node, TypedScope> nodeToScopeMapper, JSTypeRegistry registry) {
        this.moduleMap = moduleMap;
        this.nodeToScopeMapper = nodeToScopeMapper;
        this.registry = registry;
    }

    static boolean isGoogModuleDependencyCall(Node value) {
        if (!(value != null && value.isCall() && value.hasTwoChildren() && value.getSecondChild().isStringLit())) {
            return false;
        }
        Node callee = value.getFirstChild();
        if (!callee.isGetProp()) {
            return false;
        }
        Node owner = callee.getFirstChild();
        return owner.isName() && owner.getString().equals(GOOG) && GOOG_DEPENDENCY_CALLS.contains(callee.getString()) || GOOG_MODULE_GET.matches(callee);
    }

    ScopedName getClosureNamespaceTypeFromCall(Node googRequire) {
        if (this.moduleMap == null) {
            return null;
        }
        String moduleId = googRequire.getSecondChild().getString();
        Module module = this.moduleMap.getClosureModule(moduleId);
        if (module == null) {
            return null;
        }
        switch (module.metadata().moduleType()) {
            case GOOG_PROVIDE: {
                Node provide = module.metadata().rootNode();
                if (provide != null && provide.isScript()) {
                    return ScopedName.of(moduleId, provide.getGrandparent());
                }
                return null;
            }
            case GOOG_MODULE: 
            case LEGACY_GOOG_MODULE: {
                Node scopeRoot = this.getGoogModuleScopeRoot(module);
                return scopeRoot != null ? ScopedName.of("exports", scopeRoot) : null;
            }
            case ES6_MODULE: {
                Node moduleBody = module.metadata().rootNode().getFirstChild();
                return ScopedName.of("*exports*", moduleBody);
            }
            case COMMON_JS: {
                throw new IllegalStateException("Type checking CommonJs modules not yet supported");
            }
            case SCRIPT: {
                throw new IllegalStateException("Cannot import a name from a SCRIPT");
            }
        }
        throw new AssertionError();
    }

    @Nullable
    private Node getGoogModuleScopeRoot(@Nullable Module module) {
        Preconditions.checkArgument(module.metadata().isGoogModule(), module.metadata());
        Node scriptNode = module.metadata().rootNode();
        if (scriptNode.isScript() && scriptNode.hasOneChild() && scriptNode.getOnlyChild().isModuleBody()) {
            return scriptNode.getOnlyChild();
        }
        if (scriptNode.isCall()) {
            Node functionLiteral = scriptNode.getSecondChild();
            return NodeUtil.getFunctionBody(functionLiteral);
        }
        return null;
    }

    Map<Node, ScopedName> declareEsModuleImports(Module module, TypedScope scope, CompilerInput moduleInput) {
        Preconditions.checkArgument(module.metadata().isEs6Module(), module);
        Preconditions.checkArgument(scope.isModuleScope(), scope);
        ImmutableMap.Builder<Node, ScopedName> missingNames = ImmutableMap.builder();
        for (Map.Entry boundName : module.boundNames().entrySet()) {
            JSType typedefType;
            Binding binding = (Binding)boundName.getValue();
            String localName = (String)boundName.getKey();
            if (!binding.isCreatedByEsImport()) continue;
            ScopedName export = ModuleImportResolver.getScopedNameFromEsBinding(binding);
            TypedScope modScope = this.nodeToScopeMapper.apply(export.getScopeRoot());
            if (modScope == null) {
                Preconditions.checkState(binding.sourceNode().getString().equals(localName), binding.sourceNode());
                missingNames.put(binding.sourceNode(), export);
                continue;
            }
            TypedVar originalVar = modScope.getVar(export.getName());
            JSType importType = originalVar.getType();
            scope.declare(localName, binding.sourceNode(), importType, moduleInput, originalVar.isTypeInferred());
            if (binding.isModuleNamespace() || binding.sourceNode().getTypedefTypeProp() != null || (typedefType = originalVar.getNameNode().getTypedefTypeProp()) == null) continue;
            binding.sourceNode().setTypedefTypeProp(typedefType);
            this.registry.declareType(scope, localName, typedefType);
        }
        return missingNames.buildOrThrow();
    }

    void updateEsModuleNamespaceType(ObjectType namespace, Module module, TypedScope scope) {
        Preconditions.checkArgument(module.metadata().isEs6Module(), module);
        Preconditions.checkArgument(scope.isModuleScope(), scope);
        for (Map.Entry boundName : module.namespace().entrySet()) {
            TypedScope originalScope;
            String exportKey = (String)boundName.getKey();
            if (namespace.isPropertyTypeDeclared(exportKey)) continue;
            Binding binding = (Binding)boundName.getValue();
            Node bindingSourceNode = binding.sourceNode();
            ScopedName export = ModuleImportResolver.getScopedNameFromEsBinding(binding);
            TypedScope typedScope = originalScope = export.getScopeRoot() == scope.getRootNode() ? scope : this.nodeToScopeMapper.apply(export.getScopeRoot());
            if (originalScope == null) {
                namespace.defineInferredProperty(exportKey, this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE), bindingSourceNode);
                this.updateAstForExport(bindingSourceNode, this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE), null);
                continue;
            }
            TypedVar originalName = (TypedVar)originalScope.getSlot(export.getName());
            JSType exportType = originalName.getType();
            if (exportType == null) {
                exportType = this.registry.getNativeType(JSTypeNative.NO_TYPE);
            }
            if (originalName.isTypeInferred()) {
                namespace.defineInferredProperty(exportKey, exportType, bindingSourceNode);
            } else {
                namespace.defineDeclaredProperty(exportKey, exportType, bindingSourceNode);
            }
            this.updateAstForExport(bindingSourceNode, exportType, originalName.getNameNode().getTypedefTypeProp());
        }
    }

    private void updateAstForExport(Node bindingSourceNode, JSType exportType, JSType typedefType) {
        bindingSourceNode.setJSType(exportType);
        bindingSourceNode.setTypedefTypeProp(typedefType);
        if (bindingSourceNode.getParent().isExportSpec()) {
            bindingSourceNode.getNext().setJSType(exportType);
        }
    }

    private static ScopedName getScopedNameFromEsBinding(Binding binding) {
        ModuleMetadataMap.ModuleMetadata originalMetadata;
        String name = binding.isModuleNamespace() ? "*exports*" : binding.boundName();
        ModuleMetadataMap.ModuleMetadata moduleMetadata = originalMetadata = binding.isModuleNamespace() ? binding.metadata() : binding.originatingExport().moduleMetadata();
        if (!originalMetadata.isEs6Module()) {
            return ScopedName.of(name, null);
        }
        Node scriptNode = originalMetadata.rootNode();
        Preconditions.checkState(scriptNode == null || scriptNode.isScript(), scriptNode);
        return ScopedName.of(name, scriptNode != null ? scriptNode.getOnlyChild() : null);
    }

    @Nullable
    static Module getModuleFromScopeRoot(ModuleMap moduleMap, CompilerInputProvider inputProvider, Node moduleBody) {
        if (ModuleImportResolver.isGoogModuleBody(moduleBody)) {
            Node googModuleCall = moduleBody.getFirstChild();
            String namespace = googModuleCall.getFirstChild().getSecondChild().getString();
            return moduleMap.getClosureModule(namespace);
        }
        if (moduleBody.isModuleBody()) {
            Node scriptNode = moduleBody.getParent();
            CompilerInput input = Preconditions.checkNotNull(inputProvider.getInput(scriptNode.getInputId()));
            Module module = moduleMap.getModule(input.getPath());
            Preconditions.checkState(module.metadata().isEs6Module(), "Typechecking of non-goog- and non-es-modules not supported");
            return module;
        }
        return null;
    }

    private static boolean isGoogModuleBody(Node moduleBody) {
        if (moduleBody.isModuleBody()) {
            return moduleBody.getParent().getBooleanProp(Node.GOOG_MODULE);
        }
        if (moduleBody.isBlock()) {
            return moduleBody.getParent().isFunction() && NodeUtil.isBundledGoogModuleCall(moduleBody.getGrandparent());
        }
        return false;
    }
}

