/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AutoValue_PassFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.jarjar.com.google.auto.value.AutoValue;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.errorprone.annotations.ForOverride;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import java.util.function.Function;

@AutoValue
public abstract class PassFactory {
    public abstract String getName();

    public abstract boolean isRunInFixedPointLoop();

    public abstract FeatureSet getFeatureSet();

    abstract Function<AbstractCompiler, ? extends CompilerPass> getInternalFactory();

    public abstract Builder toBuilder();

    PassFactory() {
    }

    public static Builder builder() {
        return new AutoValue_PassFactory.Builder().setRunInFixedPointLoop(false);
    }

    public static PassFactory createEmptyPass(String name) {
        return PassFactory.builder().setName(name).setFeatureSet(FeatureSet.all()).setInternalFactory(c -> (externs, root) -> {}).build();
    }

    final CompilerPass create(AbstractCompiler compiler) {
        return this.getInternalFactory().apply(compiler);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setName(String var1);

        public abstract Builder setRunInFixedPointLoop(boolean var1);

        public abstract Builder setFeatureSet(FeatureSet var1);

        public abstract Builder setInternalFactory(Function<AbstractCompiler, ? extends CompilerPass> var1);

        @ForOverride
        abstract PassFactory autoBuild();

        public final Builder setFeatureSetForChecks() {
            return this.setFeatureSet(FeatureSet.ES_NEXT_IN);
        }

        public final Builder setFeatureSetForOptimizations() {
            return this.setFeatureSet(FeatureSet.ES_NEXT);
        }

        public final PassFactory build() {
            PassFactory result = this.autoBuild();
            Preconditions.checkState(!result.getName().isEmpty());
            return result;
        }
    }
}

