/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PeepholeFoldConstants;
import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Predicate;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;

class PeepholeRemoveDeadCode
extends AbstractPeepholeOptimization {
    static final Predicate<Node> MATCH_UNNAMED_BREAK = new MatchUnnamedBreak();

    PeepholeRemoveDeadCode() {
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        switch (subtree.getToken()) {
            case ASSIGN: {
                return this.tryFoldAssignment(subtree);
            }
            case COMMA: {
                return this.tryFoldComma(subtree);
            }
            case SCRIPT: 
            case BLOCK: {
                return this.tryOptimizeBlock(subtree);
            }
            case EXPR_RESULT: {
                return this.tryFoldExpr(subtree);
            }
            case HOOK: {
                return this.tryFoldHook(subtree);
            }
            case SWITCH: {
                return this.tryOptimizeSwitch(subtree);
            }
            case IF: {
                return this.tryFoldIf(subtree);
            }
            case WHILE: {
                throw PeepholeRemoveDeadCode.checkNormalization(false, "WHILE");
            }
            case FOR: {
                Node condition = NodeUtil.getConditionExpression(subtree);
                if (condition != null) {
                    this.tryFoldForCondition(condition);
                }
                return this.tryFoldFor(subtree);
            }
            case DO: {
                Node foldedDo = this.tryFoldDoAway(subtree);
                if (foldedDo.isDo()) {
                    return this.tryFoldEmptyDo(foldedDo);
                }
                return foldedDo;
            }
            case TRY: {
                return this.tryFoldTry(subtree);
            }
            case LABEL: {
                return this.tryFoldLabel(subtree);
            }
            case ARRAY_PATTERN: {
                return this.tryOptimizeArrayPattern(subtree);
            }
            case OBJECT_PATTERN: {
                return this.tryOptimizeObjectPattern(subtree);
            }
            case VAR: 
            case CONST: 
            case LET: {
                return this.tryOptimizeNameDeclaration(subtree);
            }
            case DEFAULT_VALUE: {
                return this.tryRemoveDefaultValue(subtree);
            }
        }
        return subtree;
    }

    private Node tryRemoveDefaultValue(Node defaultValue) {
        Preconditions.checkArgument(defaultValue.isDefaultValue(), defaultValue);
        Node lValue = defaultValue.getFirstChild();
        Node val = defaultValue.getSecondChild();
        boolean removeVal = false;
        if (val.isName() && val.getString().equals("undefined")) {
            removeVal = true;
        }
        if (val.isVoid()) {
            Node voidArg = val.getFirstChild();
            boolean bl = removeVal = !this.mayHaveSideEffects(voidArg);
        }
        if (removeVal) {
            defaultValue.replaceWith(lValue.detach());
            this.reportChangeToEnclosingScope(lValue);
            return lValue;
        }
        return defaultValue;
    }

    private Node tryFoldLabel(Node n) {
        String labelName = n.getFirstChild().getString();
        Node stmt = n.getLastChild();
        if (stmt.isEmpty() || stmt.isBlock() && !stmt.hasChildren()) {
            this.reportChangeToEnclosingScope(n);
            n.detach();
            return null;
        }
        Node child = PeepholeRemoveDeadCode.getOnlyInterestingChild(stmt);
        if (child != null) {
            stmt = child;
        }
        if (stmt.isBreak() && stmt.getFirstChild().getString().equals(labelName)) {
            this.reportChangeToEnclosingScope(n);
            n.detach();
            return null;
        }
        return n;
    }

    @Nullable
    private static Node getOnlyInterestingChild(Node block) {
        if (!block.isBlock()) {
            return null;
        }
        if (block.hasOneChild()) {
            return block.getOnlyChild();
        }
        Node ret = null;
        for (Node child = block.getFirstChild(); child != null; child = child.getNext()) {
            if (child.isSyntheticBlock() && !child.hasChildren()) continue;
            if (ret != null) {
                return null;
            }
            ret = child;
        }
        return ret;
    }

    private Node tryFoldTry(Node n) {
        Preconditions.checkState(n.isTry(), n);
        Node body = n.getFirstChild();
        Node catchBlock = body.getNext();
        Node finallyBlock = catchBlock.getNext();
        if (!(catchBlock.hasChildren() || finallyBlock != null && finallyBlock.hasChildren())) {
            body.detach();
            n.replaceWith(body);
            this.reportChangeToEnclosingScope(body);
            return body;
        }
        if (!body.hasChildren()) {
            NodeUtil.redeclareVarsInsideBranch(catchBlock);
            this.reportChangeToEnclosingScope(n);
            if (finallyBlock != null) {
                finallyBlock.detach();
                n.replaceWith(finallyBlock);
            } else {
                n.detach();
            }
            return finallyBlock;
        }
        return n;
    }

    private Node tryFoldAssignment(Node subtree) {
        Preconditions.checkState(subtree.isAssign());
        Node left = subtree.getFirstChild();
        Node right = subtree.getLastChild();
        if (left.isName() && right.isName() && left.getString().equals(right.getString())) {
            subtree.replaceWith(right.detach());
            this.reportChangeToEnclosingScope(right);
            return right;
        }
        if (left.isDestructuringPattern() && !left.hasChildren()) {
            subtree.replaceWith(right.detach());
            this.reportChangeToEnclosingScope(right);
            return right;
        }
        return subtree;
    }

    private Node tryOptimizeNameDeclaration(Node subtree) {
        Node pattern;
        Preconditions.checkState(NodeUtil.isNameDeclaration(subtree));
        Node left = subtree.getFirstChild();
        if (left.isDestructuringLhs() && left.hasTwoChildren() && !(pattern = left.getFirstChild()).hasChildren()) {
            Node value = left.getSecondChild();
            subtree.replaceWith(IR.exprResult(value.detach()).srcref(value));
            this.reportChangeToEnclosingScope(value);
        }
        return subtree;
    }

    private Node tryFoldExpr(Node subtree) {
        Node result = this.trySimplifyUnusedResult(subtree.getFirstChild());
        if (result == null) {
            Node parent = subtree.getParent();
            if (parent.isLabel()) {
                Node replacement = IR.block().srcref(subtree);
                subtree.replaceWith(replacement);
                subtree = replacement;
            } else {
                subtree.detach();
                subtree = null;
            }
        }
        return subtree;
    }

    @Nullable
    private Node trySimplifyUnusedResult(Node expression) {
        ArrayDeque<Node> sideEffectRoots = new ArrayDeque<Node>();
        boolean atFixedPoint = this.trySimplifyUnusedResultInternal(expression, sideEffectRoots);
        if (atFixedPoint) {
            return expression;
        }
        if (sideEffectRoots.isEmpty()) {
            this.deleteNode(expression);
            return null;
        }
        if (sideEffectRoots.peekFirst() == expression) {
            Preconditions.checkState(sideEffectRoots.size() == 1, sideEffectRoots);
            this.reportChangeToEnclosingScope(expression);
            return expression;
        }
        Node sideEffects = PeepholeRemoveDeadCode.asDetachedExpression(sideEffectRoots.pollFirst());
        while (!sideEffectRoots.isEmpty()) {
            Node next = PeepholeRemoveDeadCode.asDetachedExpression(sideEffectRoots.pollFirst());
            sideEffects = IR.comma(sideEffects, next).srcref(next);
        }
        sideEffects.insertBefore(expression);
        this.deleteNode(expression);
        return sideEffects;
    }

    private boolean trySimplifyUnusedResultInternal(Node tree, ArrayDeque<Node> sideEffectRoots) {
        switch (tree.getToken()) {
            case HOOK: {
                Node trueNode = this.trySimplifyUnusedResult(tree.getSecondChild());
                Node falseNode = this.trySimplifyUnusedResult(tree.getLastChild());
                if (trueNode == null && falseNode != null) {
                    Preconditions.checkState(tree.hasTwoChildren(), tree);
                    tree.setToken(Token.OR);
                    sideEffectRoots.addLast(tree);
                    return false;
                }
                if (trueNode != null && falseNode == null) {
                    Preconditions.checkState(tree.hasTwoChildren(), tree);
                    tree.setToken(Token.AND);
                    sideEffectRoots.addLast(tree);
                    return false;
                }
                if (trueNode == null && falseNode == null) {
                    this.trySimplifyUnusedResultInternal(tree.getOnlyChild(), sideEffectRoots);
                    return false;
                }
                sideEffectRoots.addLast(tree);
                return PeepholeRemoveDeadCode.hasFixedPointParent(tree);
            }
            case AND: 
            case OR: 
            case COALESCE: {
                Node conditionalResultNode = this.trySimplifyUnusedResult(tree.getLastChild());
                if (conditionalResultNode == null) {
                    this.trySimplifyUnusedResultInternal(tree.getOnlyChild(), sideEffectRoots);
                    return false;
                }
                sideEffectRoots.addLast(tree);
                return PeepholeRemoveDeadCode.hasFixedPointParent(tree);
            }
            case FUNCTION: {
                return false;
            }
        }
        if (this.nodeTypeMayHaveSideEffects(tree)) {
            sideEffectRoots.addLast(tree);
            return PeepholeRemoveDeadCode.hasFixedPointParent(tree);
        }
        if (!tree.hasChildren()) {
            return false;
        }
        boolean atFixedPoint = PeepholeRemoveDeadCode.hasFixedPointParent(tree);
        for (Node child = tree.getFirstChild(); child != null; child = child.getNext()) {
            atFixedPoint &= this.trySimplifyUnusedResultInternal(child, sideEffectRoots);
        }
        return atFixedPoint;
    }

    private static Node asDetachedExpression(Node expr) {
        block0 : switch (expr.getToken()) {
            case ITER_SPREAD: 
            case OBJECT_SPREAD: {
                switch (expr.getParent().getToken()) {
                    case ARRAYLIT: 
                    case NEW: 
                    case CALL: 
                    case OPTCHAIN_CALL: {
                        expr = IR.arraylit(expr.detach()).srcref(expr);
                        break block0;
                    }
                    case OBJECTLIT: {
                        expr = IR.objectlit(expr.detach()).srcref(expr);
                        break block0;
                    }
                }
                throw new IllegalStateException(expr.toStringTree());
            }
        }
        if (expr.hasParent()) {
            expr.detach();
        }
        Preconditions.checkState(IR.mayBeExpression(expr), expr);
        return expr;
    }

    private static boolean hasFixedPointParent(Node expr) {
        switch (expr.getParent().getToken()) {
            case COMMA: 
            case HOOK: 
            case AND: 
            case OR: 
            case COALESCE: {
                return true;
            }
            case ARRAYLIT: 
            case OBJECTLIT: {
                return expr.isSpread();
            }
        }
        return NodeUtil.isStatement(expr.getParent());
    }

    private void removeIfUnnamedBreak(Node maybeBreak) {
        if (maybeBreak != null && maybeBreak.isBreak() && !maybeBreak.hasChildren()) {
            this.reportChangeToEnclosingScope(maybeBreak);
            maybeBreak.detach();
        }
    }

    private Node tryRemoveSwitchWithSingleCase(Node n, boolean shouldHoistCondition) {
        Node caseBlock = n.getLastChild().getLastChild();
        this.removeIfUnnamedBreak(caseBlock.getLastChild());
        if (NodeUtil.has(caseBlock, MATCH_UNNAMED_BREAK, NodeUtil.MATCH_NOT_FUNCTION)) {
            return n;
        }
        if (shouldHoistCondition) {
            Node switchBlock = caseBlock.getGrandparent();
            IR.exprResult(n.removeFirstChild()).srcref(n).insertBefore(switchBlock);
        }
        n.replaceWith(caseBlock.detach());
        this.reportChangeToEnclosingScope(caseBlock);
        return caseBlock;
    }

    private Node tryRemoveSwitch(Node n) {
        if (n.hasOneChild()) {
            Node condition = n.removeFirstChild();
            Node replacement = IR.exprResult(condition).srcref(n);
            n.replaceWith(replacement);
            this.reportChangeToEnclosingScope(replacement);
            return replacement;
        }
        if (n.hasTwoChildren() && n.getLastChild().isDefaultCase()) {
            if (n.getFirstChild().isCall() || n.getFirstChild().isOptChainCall()) {
                return this.tryRemoveSwitchWithSingleCase(n, true);
            }
            return this.tryRemoveSwitchWithSingleCase(n, false);
        }
        return n;
    }

    private Node tryOptimizeSwitch(Node n) {
        Preconditions.checkState(n.isSwitch(), n);
        Node defaultCase = this.tryOptimizeDefaultCase(n);
        if (defaultCase == null || n.getLastChild().isDefaultCase()) {
            Node cond = n.getFirstChild();
            Node prev = null;
            Node next = null;
            Node cur = cond.getNext();
            while (cur != null) {
                next = cur.getNext();
                if (!this.mayHaveSideEffects(cur.getFirstChild()) && this.isUselessCase(cur, prev, defaultCase)) {
                    this.removeCase(n, cur);
                } else {
                    prev = cur;
                }
                cur = next;
            }
            if (NodeUtil.isLiteralValue(cond, false)) {
                Tri caseMatches = Tri.TRUE;
                cur = cond.getNext();
                while (cur != null) {
                    next = cur.getNext();
                    Node caseLabel = cur.getFirstChild();
                    caseMatches = PeepholeFoldConstants.evaluateComparison(this, Token.SHEQ, cond, caseLabel);
                    if (caseMatches == Tri.TRUE || caseMatches == Tri.UNKNOWN) break;
                    this.removeCase(n, cur);
                    cur = next;
                }
                if (cur != null && caseMatches == Tri.TRUE) {
                    Node matchingCase = cur;
                    Node matchingCaseBlock = matchingCase.getLastChild();
                    while (cur != null) {
                        Node block = cur.getLastChild();
                        Node lastStm = block.getLastChild();
                        boolean isLastStmRemovableBreak = false;
                        if (lastStm != null && PeepholeRemoveDeadCode.isExit(lastStm)) {
                            this.removeIfUnnamedBreak(lastStm);
                            isLastStmRemovableBreak = true;
                        }
                        next = cur.getNext();
                        if (cur != matchingCase) {
                            while (block.hasChildren()) {
                                matchingCaseBlock.addChildToBack(block.removeFirstChild());
                            }
                            this.reportChangeToEnclosingScope(cur);
                            cur.detach();
                        }
                        cur = next;
                        if (!isLastStmRemovableBreak) continue;
                        break;
                    }
                    while (cur != null) {
                        next = cur.getNext();
                        this.removeCase(n, cur);
                        cur = next;
                    }
                    cur = cond.getNext();
                    if (cur != null && cur.getNext() == null) {
                        return this.tryRemoveSwitchWithSingleCase(n, false);
                    }
                }
            }
        }
        return this.tryRemoveSwitch(n);
    }

    private Node tryOptimizeDefaultCase(Node n) {
        Preconditions.checkState(n.isSwitch(), n);
        Node lastNonRemovable = n.getFirstChild();
        for (Node c = n.getSecondChild(); c != null; c = c.getNext()) {
            if (c.isDefaultCase()) {
                Node prevCase;
                Node caseToRemove = lastNonRemovable.getNext();
                while (caseToRemove != c) {
                    Node next = caseToRemove.getNext();
                    this.removeCase(n, caseToRemove);
                    caseToRemove = next;
                }
                Node node = prevCase = lastNonRemovable == n.getFirstChild() ? null : lastNonRemovable;
                if (this.isUselessCase(c, prevCase, c)) {
                    this.removeCase(n, c);
                    return null;
                }
                return c;
            }
            Preconditions.checkState(c.isCase());
            if (!c.getLastChild().hasChildren() && !this.mayHaveSideEffects(c.getFirstChild())) continue;
            lastNonRemovable = c;
        }
        return null;
    }

    private void removeCase(Node switchNode, Node caseNode) {
        NodeUtil.redeclareVarsInsideBranch(caseNode);
        caseNode.detach();
        this.reportChangeToEnclosingScope(switchNode);
    }

    private boolean isUselessCase(Node caseNode, @Nullable Node previousCase, @Nullable Node defaultCase) {
        Node previousBlock;
        Preconditions.checkState(previousCase == null || previousCase.getNext() == caseNode);
        Node switchNode = caseNode.getParent();
        if (!(switchNode.getLastChild() == caseNode || previousCase == null || (previousBlock = previousCase.getLastChild()).hasChildren() && PeepholeRemoveDeadCode.isExit(previousBlock.getLastChild()))) {
            return false;
        }
        for (Node executingCase = caseNode; executingCase != null; executingCase = executingCase.getNext()) {
            Preconditions.checkState(executingCase.isDefaultCase() || executingCase.isCase());
            Preconditions.checkState(caseNode == executingCase || !executingCase.isDefaultCase());
            if (!executingCase.isDefaultCase() && this.mayHaveSideEffects(executingCase.getFirstChild())) {
                return false;
            }
            Node block = executingCase.getLastChild();
            Preconditions.checkState(block.isBlock());
            if (!block.hasChildren()) continue;
            block5: for (Node blockChild = block.getFirstChild(); blockChild != null; blockChild = blockChild.getNext()) {
                switch (blockChild.getToken()) {
                    case BREAK: {
                        return !blockChild.hasChildren() && (defaultCase == null || defaultCase == executingCase);
                    }
                    case VAR: {
                        if (blockChild.hasOneChild() && blockChild.getFirstFirstChild() == null) continue block5;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean isExit(Node n) {
        switch (n.getToken()) {
            case BREAK: 
            case CONTINUE: 
            case RETURN: 
            case THROW: {
                return true;
            }
        }
        return false;
    }

    private Node tryFoldComma(Node n) {
        Node parent = n.getParent();
        Node left = n.getFirstChild();
        Node right = left.getNext();
        if ((left = this.trySimplifyUnusedResult(left)) == null || !this.mayHaveSideEffects(left)) {
            right.detach();
            n.replaceWith(right);
            this.reportChangeToEnclosingScope(parent);
            return right;
        }
        return n;
    }

    Node tryOptimizeBlock(Node n) {
        Node c = n.getFirstChild();
        while (c != null) {
            Node next = c.getNext();
            if (!PeepholeRemoveDeadCode.isUnremovableNode(c) && !this.mayHaveSideEffects(c)) {
                PeepholeRemoveDeadCode.checkNormalization(!NodeUtil.isFunctionDeclaration(n), "function declaration");
                c.detach();
                this.reportChangeToEnclosingScope(n);
                this.markFunctionsDeleted(c);
            } else {
                this.tryOptimizeConditionalAfterAssign(c);
            }
            c = next;
        }
        if (n.isSyntheticBlock() || n.isScript() || n.getParent() == null) {
            return n;
        }
        Node parent = n.getParent();
        if (NodeUtil.tryMergeBlock(n, this.isASTNormalized())) {
            this.reportChangeToEnclosingScope(parent);
            return null;
        }
        return n;
    }

    private static boolean isUnremovableNode(Node n) {
        return n.isBlock() && n.isSyntheticBlock() || n.isScript();
    }

    private void tryOptimizeConditionalAfterAssign(Node n) {
        Node next = n.getNext();
        if (PeepholeRemoveDeadCode.isSimpleAssignment(n) && this.isConditionalStatement(next)) {
            Node rhsAssign;
            Tri value;
            Node lhsAssign = this.getSimpleAssignmentName(n);
            Node condition = this.getConditionalStatementCondition(next);
            if (lhsAssign.isName() && condition.isName() && lhsAssign.getString().equals(condition.getString()) && (value = NodeUtil.getBooleanValue(rhsAssign = this.getSimpleAssignmentValue(n))) != Tri.UNKNOWN) {
                Node replacementConditionNode = NodeUtil.booleanNode(value.toBoolean(true));
                condition.replaceWith(replacementConditionNode);
                this.reportChangeToEnclosingScope(replacementConditionNode);
            }
        }
    }

    private static boolean isSimpleAssignment(Node n) {
        if (NodeUtil.isExprAssign(n) && n.getFirstFirstChild().isName()) {
            return true;
        }
        return NodeUtil.isNameDeclaration(n) && n.hasOneChild() && n.getFirstFirstChild() != null;
    }

    private Node getSimpleAssignmentName(Node n) {
        Preconditions.checkState(PeepholeRemoveDeadCode.isSimpleAssignment(n));
        if (NodeUtil.isExprAssign(n)) {
            return n.getFirstFirstChild();
        }
        return n.getFirstChild();
    }

    private Node getSimpleAssignmentValue(Node n) {
        Preconditions.checkState(PeepholeRemoveDeadCode.isSimpleAssignment(n));
        return n.getFirstChild().getLastChild();
    }

    private boolean isConditionalStatement(Node n) {
        return n != null && (n.isIf() || PeepholeRemoveDeadCode.isExprConditional(n));
    }

    private static boolean isExprConditional(Node n) {
        if (n.isExprResult()) {
            switch (n.getFirstChild().getToken()) {
                case HOOK: 
                case AND: 
                case OR: 
                case COALESCE: {
                    return true;
                }
            }
        }
        return false;
    }

    private Node getConditionalStatementCondition(Node n) {
        if (n.isIf()) {
            return NodeUtil.getConditionExpression(n);
        }
        Preconditions.checkState(PeepholeRemoveDeadCode.isExprConditional(n));
        return n.getFirstFirstChild();
    }

    private Node tryFoldIf(Node n) {
        Preconditions.checkState(n.isIf(), n);
        Node parent = n.getParent();
        Preconditions.checkNotNull(parent);
        Token type = n.getToken();
        Node cond = n.getFirstChild();
        Node thenBody = cond.getNext();
        Node elseBody = thenBody.getNext();
        if (elseBody != null && !this.mayHaveSideEffects(elseBody)) {
            elseBody.detach();
            this.reportChangeToEnclosingScope(n);
            elseBody = null;
        }
        if (!this.mayHaveSideEffects(thenBody) && elseBody != null) {
            elseBody.detach();
            thenBody.replaceWith(elseBody);
            Node notCond = new Node(Token.NOT);
            cond.replaceWith(notCond);
            this.reportChangeToEnclosingScope(n);
            notCond.addChildToFront(cond);
            cond = notCond;
            thenBody = cond.getNext();
            elseBody = null;
        }
        if (!this.mayHaveSideEffects(thenBody) && elseBody == null) {
            if (this.mayHaveSideEffects(cond)) {
                cond.detach();
                Node replacement = NodeUtil.newExpr(cond);
                n.replaceWith(replacement);
                this.reportChangeToEnclosingScope(parent);
                return replacement;
            }
            NodeUtil.removeChild(parent, n);
            this.reportChangeToEnclosingScope(parent);
            return null;
        }
        Tri condValue = NodeUtil.getBooleanValue(cond);
        if (condValue == Tri.UNKNOWN) {
            return n;
        }
        if (this.mayHaveSideEffects(cond)) {
            boolean newConditionValue;
            boolean bl = newConditionValue = condValue == Tri.TRUE;
            if (!newConditionValue && elseBody == null) {
                elseBody = IR.block().srcref(n);
                n.addChildToBack(elseBody);
            }
            Node newCond = NodeUtil.booleanNode(newConditionValue);
            cond.replaceWith(newCond);
            Node branchToKeep = newConditionValue ? thenBody : elseBody;
            branchToKeep.addChildToFront(IR.exprResult(cond).srcref(cond));
            this.reportChangeToEnclosingScope(branchToKeep);
            cond = newCond;
        }
        boolean condTrue = condValue.toBoolean(true);
        if (n.hasTwoChildren()) {
            Preconditions.checkState(type == Token.IF);
            if (condTrue) {
                Node thenStmt = n.getSecondChild();
                thenStmt.detach();
                n.replaceWith(thenStmt);
                this.reportChangeToEnclosingScope(thenStmt);
                return thenStmt;
            }
            NodeUtil.redeclareVarsInsideBranch(n);
            NodeUtil.removeChild(parent, n);
            this.reportChangeToEnclosingScope(parent);
            this.markFunctionsDeleted(n);
            return null;
        }
        Node trueBranch = n.getSecondChild();
        Node falseBranch = trueBranch.getNext();
        Node branchToKeep = condTrue ? trueBranch : falseBranch;
        Node branchToRemove = condTrue ? falseBranch : trueBranch;
        NodeUtil.redeclareVarsInsideBranch(branchToRemove);
        branchToKeep.detach();
        n.replaceWith(branchToKeep);
        this.reportChangeToEnclosingScope(branchToKeep);
        this.markFunctionsDeleted(n);
        return branchToKeep;
    }

    private Node tryFoldHook(Node n) {
        Node replacement;
        Node branchToRemove;
        Node branchToKeep;
        Preconditions.checkState(n.isHook(), n);
        Node parent = n.getParent();
        Preconditions.checkNotNull(parent);
        Node cond = n.getFirstChild();
        Node thenBody = cond.getNext();
        Node elseBody = thenBody.getNext();
        Tri condValue = NodeUtil.getBooleanValue(cond);
        if (condValue == Tri.UNKNOWN && !this.areNodesEqualForInlining(thenBody, elseBody)) {
            return n;
        }
        if (condValue.toBoolean(true)) {
            branchToKeep = thenBody;
            branchToRemove = elseBody;
        } else {
            branchToKeep = elseBody;
            branchToRemove = thenBody;
        }
        boolean condHasSideEffects = this.mayHaveSideEffects(cond);
        n.detachChildren();
        if (condHasSideEffects) {
            replacement = IR.comma(cond, branchToKeep).srcref(n);
        } else {
            replacement = branchToKeep;
            this.markFunctionsDeleted(cond);
        }
        n.replaceWith(replacement);
        this.reportChangeToEnclosingScope(replacement);
        this.markFunctionsDeleted(branchToRemove);
        return replacement;
    }

    Node tryFoldFor(Node n) {
        Preconditions.checkArgument(n.isVanillaFor());
        Node init = n.getFirstChild();
        Node cond = init.getNext();
        Node increment = cond.getNext();
        if (!init.isEmpty() && !NodeUtil.isNameDeclaration(init) && (init = this.trySimplifyUnusedResult(init)) == null) {
            init = IR.empty().srcref(n);
            n.addChildToFront(init);
        }
        if (!increment.isEmpty() && (increment = this.trySimplifyUnusedResult(increment)) == null) {
            increment = IR.empty().srcref(n);
            increment.insertAfter(cond);
        }
        if (!n.getFirstChild().isEmpty()) {
            return n;
        }
        if (NodeUtil.getBooleanValue(cond) != Tri.FALSE) {
            return n;
        }
        Node parent = n.getParent();
        NodeUtil.redeclareVarsInsideBranch(n);
        if (!this.mayHaveSideEffects(cond)) {
            NodeUtil.removeChild(parent, n);
        } else {
            Node statement = IR.exprResult(cond.detach()).srcrefIfMissing(cond);
            if (parent.isLabel()) {
                Node block = IR.block();
                block.srcrefIfMissing(statement);
                block.addChildToFront(statement);
                statement = block;
            }
            n.replaceWith(statement);
        }
        this.reportChangeToEnclosingScope(parent);
        return null;
    }

    Node tryFoldDoAway(Node n) {
        Preconditions.checkArgument(n.isDo());
        Node cond = NodeUtil.getConditionExpression(n);
        if (NodeUtil.getBooleanValue(cond) != Tri.FALSE) {
            return n;
        }
        Node block = NodeUtil.getLoopCodeBlock(n);
        if (n.getParent().isLabel() || PeepholeRemoveDeadCode.hasUnnamedBreakOrContinue(block)) {
            return n;
        }
        Node parent = n.getParent();
        n.replaceWith(block.detach());
        if (this.mayHaveSideEffects(cond)) {
            Node condStatement = IR.exprResult(cond.detach()).srcref(cond);
            condStatement.insertAfter(block);
        }
        this.reportChangeToEnclosingScope(parent);
        return block;
    }

    Node tryFoldEmptyDo(Node n) {
        Preconditions.checkArgument(n.isDo());
        Node body = NodeUtil.getLoopCodeBlock(n);
        if (body.isBlock() && !body.hasChildren()) {
            Node cond = NodeUtil.getConditionExpression(n);
            Node forNode = IR.forNode(IR.empty().srcref(n), cond.detach(), IR.empty().srcref(n), body.detach());
            n.replaceWith(forNode);
            this.reportChangeToEnclosingScope(forNode);
            return forNode;
        }
        return n;
    }

    Node tryOptimizeObjectPattern(Node pattern) {
        Preconditions.checkArgument(pattern.isObjectPattern(), pattern);
        if (pattern.hasChildren() && pattern.getLastChild().isRest()) {
            return pattern;
        }
        Node child = pattern.getFirstChild();
        while (child != null) {
            Node key = child;
            child = key.getNext();
            if (!key.isStringKey() || !this.isRemovableDestructuringTarget(key.getOnlyChild())) continue;
            key.detach();
            this.reportChangeToEnclosingScope(pattern);
        }
        return pattern;
    }

    Node tryOptimizeArrayPattern(Node pattern) {
        Preconditions.checkArgument(pattern.isArrayPattern(), pattern);
        Node lastChild = pattern.getLastChild();
        while (lastChild != null && (lastChild.isEmpty() || this.isRemovableDestructuringTarget(lastChild))) {
            Node prev = lastChild.getPrevious();
            lastChild.detach();
            lastChild = prev;
            this.reportChangeToEnclosingScope(pattern);
        }
        return pattern;
    }

    private boolean isRemovableDestructuringTarget(Node destructruringElement) {
        Node target = destructruringElement;
        Node defaultValue = null;
        if (destructruringElement.isDefaultValue()) {
            target = destructruringElement.getFirstChild();
            defaultValue = destructruringElement.getSecondChild();
        }
        if (!target.isDestructuringPattern() || target.hasChildren()) {
            return false;
        }
        return defaultValue == null || !this.mayHaveSideEffects(defaultValue);
    }

    static boolean hasUnnamedBreakOrContinue(Node n) {
        return NodeUtil.has(n, node -> node.isBreak() && !node.hasChildren(), node -> !IR.mayBeExpression(node) && !NodeUtil.isLoopStructure(node) && !node.isSwitch()) || NodeUtil.has(n, node -> node.isContinue() && !node.hasChildren(), node -> !IR.mayBeExpression(node) && !NodeUtil.isLoopStructure(node));
    }

    private void tryFoldForCondition(Node forCondition) {
        if (this.getSideEffectFreeBooleanValue(forCondition) == Tri.TRUE) {
            this.reportChangeToEnclosingScope(forCondition);
            forCondition.replaceWith(IR.empty());
        }
    }

    private static IllegalStateException checkNormalization(boolean condition, String feature) {
        Preconditions.checkState(condition, "Unexpected %s. AST should be normalized.", (Object)feature);
        return null;
    }

    private static class MatchUnnamedBreak
    implements Predicate<Node> {
        private MatchUnnamedBreak() {
        }

        @Override
        public boolean apply(Node n) {
            return n.isBreak() && !n.hasChildren();
        }
    }
}

