/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ClosurePrimitiveErrors;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.jscomp.jarjar.com.google.common.base.MoreObjects;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Sets;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class ProcessDefines
implements CompilerPass {
    private static final ImmutableSet<String> KNOWN_DEFINES = ImmutableSet.of("COMPILED", "goog.DEBUG", "$jscomp.ISOLATE_POLYFILLS");
    private static final Node GOOG_DEFINE = IR.getprop(IR.name("goog"), "define");
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final ImmutableMap<String, Node> replacementValuesFromFlags;
    private final Mode mode;
    private final Supplier<GlobalNamespace> namespaceSupplier;
    private final boolean recognizeClosureDefines;
    private final LinkedHashSet<JSDocInfo> knownDefineJsdocs = new LinkedHashSet();
    private final LinkedHashSet<Node> knownGoogDefineCalls = new LinkedHashSet();
    private final LinkedHashMap<String, Define> defineByDefineName = new LinkedHashMap();
    private final LinkedHashMap<String, Node> replacementValuesFromClosureDefines = new LinkedHashMap();
    private final LinkedHashSet<Node> validDefineValueExpressions = new LinkedHashSet();
    private GlobalNamespace namespace;
    static final DiagnosticType UNKNOWN_DEFINE_WARNING = DiagnosticType.warning("JSC_UNKNOWN_DEFINE_WARNING", "unknown @define variable {0}");
    static final DiagnosticType INVALID_DEFINE_NAME_ERROR = DiagnosticType.error("JSC_INVALID_DEFINE_NAME_ERROR", "\"{0}\" is not a valid JS identifier name");
    static final DiagnosticType MISSING_DEFINE_ANNOTATION = DiagnosticType.error("JSC_INVALID_MISSING_DEFINE_ANNOTATION", "Missing @define annotation");
    static final DiagnosticType INVALID_DEFINE_TYPE = DiagnosticType.error("JSC_INVALID_DEFINE_TYPE", "@define tag only permits primitive types");
    static final DiagnosticType INVALID_DEFINE_VALUE = DiagnosticType.error("JSC_INVALID_DEFINE_VALUE", "invalid initialization value for @define {0}");
    static final DiagnosticType INVALID_DEFINE_LOCATION = DiagnosticType.error("JSC_INVALID_DEFINE_LOCATION", "@define must be initalized on a static qualified name in global or module scope");
    static final DiagnosticType NON_CONST_DEFINE = DiagnosticType.error("JSC_NON_CONST_DEFINE", "@define {0} has already been set at {1}.");
    static final DiagnosticType CLOSURE_DEFINES_ERROR = DiagnosticType.error("JSC_CLOSURE_DEFINES_ERROR", "Invalid CLOSURE_DEFINES definition");
    static final DiagnosticType NON_GLOBAL_CLOSURE_DEFINES_ERROR = DiagnosticType.error("JSC_NON_GLOBAL_CLOSURE_DEFINES_ERROR", "CLOSURE_DEFINES definition must be in top-level global scope");
    static final DiagnosticType DEFINE_CALL_WITHOUT_ASSIGNMENT = DiagnosticType.error("JSC_DEFINE_CALL_WITHOUT_ASSIGNMENT", "The result of a goog.define call must be assigned as an isolated statement.");

    private ProcessDefines(Builder builder) {
        this.mode = builder.mode;
        this.compiler = builder.compiler;
        this.registry = this.mode.check ? this.compiler.getTypeRegistry() : null;
        this.replacementValuesFromFlags = ImmutableMap.copyOf(builder.replacementValues);
        this.namespaceSupplier = builder.namespaceSupplier;
        this.recognizeClosureDefines = builder.recognizeClosureDefines;
    }

    @Override
    public void process(Node externs, Node root) {
        this.initNamespace(externs, root);
        this.collectDefines();
        this.reportInvalidDefineLocations(root);
        this.collectValidDefineValueExpressions();
        this.validateDefineDeclarations();
        this.overrideDefines();
    }

    final ImmutableSet<String> collectDefineNames(Node externs, Node root) {
        this.initNamespace(externs, root);
        this.collectDefines();
        return ImmutableSet.copyOf(this.defineByDefineName.keySet());
    }

    private void initNamespace(Node externs, Node root) {
        if (this.namespaceSupplier != null) {
            this.namespace = this.namespaceSupplier.get();
        }
        if (this.namespace == null) {
            this.namespace = new GlobalNamespace(this.compiler, externs, root);
        }
    }

    private void overrideDefines() {
        if (this.mode.optimize) {
            for (Define define : this.defineByDefineName.values()) {
                boolean changed;
                Node inputValue;
                if (define.valueParent == null || (inputValue = this.getReplacementForDefine(define)) == null || inputValue == define.value || !(changed = define.value == null || inputValue.getToken() != define.value.getToken() || !inputValue.isEquivalentTo(define.value))) continue;
                if (define.value == null) {
                    define.valueParent.addChildToBack(inputValue.cloneTree());
                } else {
                    define.value.replaceWith(inputValue.cloneTree());
                }
                this.compiler.reportChangeToEnclosingScope(define.valueParent);
            }
        }
        if (this.mode.optimize) {
            Sets.SetView<String> unusedReplacements = Sets.difference(Sets.union(this.replacementValuesFromFlags.keySet(), this.replacementValuesFromClosureDefines.keySet()), Sets.union(KNOWN_DEFINES, this.defineByDefineName.keySet()));
            for (String unknownDefine : unusedReplacements) {
                this.compiler.report(JSError.make(UNKNOWN_DEFINE_WARNING, unknownDefine));
            }
        }
    }

    @Nullable
    private Node getReplacementForDefine(Define define) {
        Node replacementFromFlags = this.replacementValuesFromFlags.get(define.defineName);
        if (replacementFromFlags != null) {
            return replacementFromFlags;
        }
        Node replacementFromClosureDefines = this.replacementValuesFromClosureDefines.get(define.defineName);
        if (replacementFromClosureDefines != null) {
            return replacementFromClosureDefines;
        }
        if (this.isGoogDefineCall(define.value) && define.value.getChildCount() == 3) {
            return define.value.getChildAtIndex(2);
        }
        return null;
    }

    private boolean isValidDefineType(JSTypeExpression expression) {
        JSType type = this.registry.evaluateTypeExpressionInGlobalScope(expression);
        return !type.isUnknownType() && type.isSubtypeOf(this.registry.getNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN));
    }

    private void collectDefines() {
        for (GlobalNamespace.Name name : this.namespace.getAllSymbols()) {
            String defineName;
            Node value;
            if (this.recognizeClosureDefines && name.getFullName().equals("CLOSURE_DEFINES")) {
                this.collectClosureDefinesValues(name);
                continue;
            }
            GlobalNamespace.Ref declaration = this.selectDefineDeclaration(name);
            if (declaration == null) continue;
            int totalSets = name.getTotalSets();
            Node valueParent = ProcessDefines.getValueParentForDefine(declaration);
            Node node = value = valueParent != null ? valueParent.getLastChild() : null;
            if (this.isGoogDefineCall(value) && this.verifyGoogDefine(value)) {
                Node nameNode = value.getSecondChild();
                defineName = nameNode.getString();
            } else {
                defineName = name.getFullName();
            }
            Define existingDefine = this.defineByDefineName.putIfAbsent(defineName, new Define(defineName, name, declaration, valueParent, value));
            if (existingDefine != null) {
                declaration = existingDefine.declaration;
                totalSets += existingDefine.name.getTotalSets();
            }
            if (totalSets <= 1) continue;
            for (GlobalNamespace.Ref ref : name.getRefs()) {
                if (!ref.isSet() || ref.equals(declaration)) continue;
                this.compiler.report(JSError.make(ref.getNode(), NON_CONST_DEFINE, defineName, declaration.getNode().getLocation()));
            }
        }
    }

    @Nullable
    private GlobalNamespace.Ref selectDefineDeclaration(GlobalNamespace.Name name) {
        for (GlobalNamespace.Ref ref : name.getRefs()) {
            JSDocInfo jsdoc;
            Node refNode;
            if (!GlobalNamespace.Ref.Type.SET_FROM_GLOBAL.equals((Object)ref.type) || !(refNode = ref.getNode()).isQualifiedName() || (jsdoc = NodeUtil.getBestJSDocInfo(refNode)) == null || !jsdoc.isDefine()) continue;
            this.knownDefineJsdocs.add(jsdoc);
            return ref;
        }
        return null;
    }

    private static Node getValueParentForDefine(GlobalNamespace.Ref declaration) {
        Node declarationNode = declaration.getNode();
        Node declarationParent = declarationNode.getParent();
        if (declarationParent.isVar() || declarationParent.isConst()) {
            Preconditions.checkState(declarationNode.isName(), declarationNode);
            return declarationNode;
        }
        if (declarationParent.isAssign() && declarationNode.isFirstChildOf(declarationParent)) {
            return declarationParent;
        }
        return null;
    }

    private void collectValidDefineValueExpressions() {
        LinkedHashSet<GlobalNamespace.Name> namesToCheck = this.namespace.getAllSymbols().stream().filter(ProcessDefines::isGlobalConst).collect(Collectors.toCollection(LinkedHashSet::new));
        for (Define define : this.defineByDefineName.values()) {
            namesToCheck.remove(define.name);
            define.name.getRefs().stream().filter(r -> !r.isSet()).map(GlobalNamespace.Ref::getNode).forEachOrdered(this.validDefineValueExpressions::add);
        }
        while (true) {
            LinkedHashSet<GlobalNamespace.Name> namesToCheckAgain = new LinkedHashSet<GlobalNamespace.Name>();
            block6: for (GlobalNamespace.Name name : namesToCheck) {
                Node declValue = ProcessDefines.getConstantDeclValue(name.getDeclaration().getNode());
                switch (this.isValidDefineValue(declValue)) {
                    case TRUE: {
                        for (GlobalNamespace.Ref ref : name.getRefs()) {
                            this.validDefineValueExpressions.add(ref.getNode());
                        }
                        continue block6;
                    }
                    case UNKNOWN: {
                        namesToCheckAgain.add(name);
                        break;
                    }
                }
            }
            if (namesToCheckAgain.size() == namesToCheck.size()) break;
            namesToCheck = namesToCheckAgain;
        }
    }

    private final void validateDefineDeclarations() {
        if (!this.mode.check) {
            return;
        }
        for (Define define : this.defineByDefineName.values()) {
            JSDocInfo jsdoc;
            Node declarationNode = define.declaration.getNode();
            if (!this.hasValidValue(define)) {
                this.compiler.report(JSError.make(MoreObjects.firstNonNull(define.value, MoreObjects.firstNonNull(define.valueParent, declarationNode)), INVALID_DEFINE_VALUE, define.defineName));
            }
            if ((jsdoc = NodeUtil.getBestJSDocInfo(declarationNode)) != null && this.isValidDefineType(jsdoc.getType())) continue;
            this.compiler.report(JSError.make(declarationNode, INVALID_DEFINE_TYPE, new String[0]));
        }
    }

    private void reportInvalidDefineLocations(Node root) {
        if (!this.mode.check) {
            return;
        }
        NodeTraversal.builder().setCompiler(this.compiler).setCallback((t, n, parent) -> {
            JSDocInfo jsdoc = n.getJSDocInfo();
            if (jsdoc != null && jsdoc.isDefine() && this.knownDefineJsdocs.add(jsdoc)) {
                this.compiler.report(JSError.make(n, INVALID_DEFINE_LOCATION, new String[0]));
            }
            if (this.isGoogDefineCall(n) && this.knownGoogDefineCalls.add(n)) {
                this.verifyGoogDefine(n);
            }
            if (n.matchesName("CLOSURE_DEFINES") && NodeUtil.isNameDeclaration(parent) && !NodeUtil.getEnclosingScopeRoot(n).isRoot()) {
                this.compiler.report(JSError.make(n, NON_GLOBAL_CLOSURE_DEFINES_ERROR, new String[0]));
            }
        }).traverse(root);
    }

    private void collectClosureDefinesValues(GlobalNamespace.Name closureDefines) {
        for (GlobalNamespace.Ref ref : closureDefines.getRefs()) {
            Node n;
            if (!ref.isSet() || !NodeUtil.isNameDeclaration((n = ref.getNode()).getParent()) || !n.hasOneChild() || !n.getFirstChild().isObjectLit()) continue;
            for (Node c = n.getFirstFirstChild(); c != null; c = c.getNext()) {
                if (c.isStringKey() && ProcessDefines.isValidClosureDefinesValue(c.getFirstChild())) {
                    this.replacementValuesFromClosureDefines.put(c.getString(), c.getFirstChild().cloneNode());
                    continue;
                }
                if (!this.mode.check) continue;
                this.compiler.report(JSError.make(n, CLOSURE_DEFINES_ERROR, new String[0]));
            }
        }
    }

    private static boolean isValidClosureDefinesValue(Node val) {
        switch (val.getToken()) {
            case STRINGLIT: 
            case NUMBER: 
            case TRUE: 
            case FALSE: {
                return true;
            }
            case NEG: {
                return val.getFirstChild().isNumber();
            }
        }
        return false;
    }

    private boolean hasValidValue(Define define) {
        if (define.valueParent == null) {
            return false;
        }
        if (define.valueParent.isFromExterns()) {
            return true;
        }
        return this.isValidDefineValue(define.value).toBoolean(false);
    }

    private static boolean isGlobalConst(GlobalNamespace.Name name) {
        return name.getTotalSets() == 1 && name.getDeclaration() != null && name.getDeclaration().type.equals((Object)GlobalNamespace.Ref.Type.SET_FROM_GLOBAL);
    }

    private Tri isValidDefineValue(@Nullable Node val) {
        if (val == null) {
            return Tri.FALSE;
        }
        switch (val.getToken()) {
            case STRINGLIT: 
            case NUMBER: 
            case TRUE: 
            case FALSE: {
                return Tri.TRUE;
            }
            case AND: 
            case OR: 
            case COALESCE: 
            case ADD: 
            case BITAND: 
            case BITNOT: 
            case BITOR: 
            case BITXOR: 
            case DIV: 
            case EQ: 
            case EXPONENT: 
            case GE: 
            case GT: 
            case LE: 
            case LSH: 
            case LT: 
            case MOD: 
            case MUL: 
            case NE: 
            case RSH: 
            case SHEQ: 
            case SHNE: 
            case SUB: 
            case URSH: {
                return this.isValidDefineValue(val.getFirstChild()).and(this.isValidDefineValue(val.getLastChild()));
            }
            case HOOK: {
                return this.isValidDefineValue(val.getFirstChild()).and(this.isValidDefineValue(val.getSecondChild())).and(this.isValidDefineValue(val.getLastChild()));
            }
            case NEG: 
            case NOT: 
            case POS: {
                return this.isValidDefineValue(val.getFirstChild());
            }
            case NAME: 
            case GETPROP: {
                if (!val.isQualifiedName()) break;
                return this.validDefineValueExpressions.contains(val) ? Tri.TRUE : Tri.UNKNOWN;
            }
            case CALL: {
                if (!this.isGoogDefineCall(val)) {
                    return Tri.FALSE;
                }
                if (!val.hasXChildren(3)) {
                    return Tri.TRUE;
                }
                return this.isValidDefineValue(val.getChildAtIndex(2));
            }
        }
        return Tri.FALSE;
    }

    private static Node getConstantDeclValue(Node name) {
        Node parent = name.getParent();
        if (parent == null) {
            return null;
        }
        if (name.isName()) {
            if (parent.isConst()) {
                return name.getFirstChild();
            }
            if (!parent.isVar()) {
                return null;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(name);
            return jsdoc != null && jsdoc.isConstant() ? name.getFirstChild() : null;
        }
        if (name.isGetProp() && parent.isAssign()) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(name);
            return jsdoc != null && jsdoc.isConstant() ? name.getNext() : null;
        }
        return null;
    }

    private boolean isGoogDefineCall(Node node) {
        if (!this.recognizeClosureDefines) {
            return false;
        }
        if (node == null || !node.isCall()) {
            return false;
        }
        return node.getFirstChild().matchesQualifiedName(GOOG_DEFINE);
    }

    private boolean verifyGoogDefine(Node callNode) {
        this.knownGoogDefineCalls.add(callNode);
        Node parent = callNode.getParent();
        Node methodName = callNode.getFirstChild();
        Node args = callNode.getSecondChild();
        if (NodeUtil.getEnclosingFunction(callNode) != null) {
            this.compiler.report(JSError.make(methodName.getParent(), ClosurePrimitiveErrors.INVALID_CLOSURE_CALL_SCOPE_ERROR, new String[0]));
            return false;
        }
        if (parent.isAssign() && parent.getParent().isExprResult()) {
            parent = parent.getParent();
        } else if (parent.isName() && NodeUtil.isNameDeclaration(parent.getParent())) {
            parent = parent.getParent();
        } else {
            this.compiler.report(JSError.make(methodName.getParent(), DEFINE_CALL_WITHOUT_ASSIGNMENT, new String[0]));
            return false;
        }
        Node arg = args;
        if (!this.verifyNotNull(methodName, arg) || !this.verifyOfType(methodName, arg, Token.STRINGLIT)) {
            return false;
        }
        arg = arg.getNext();
        if (!(args.isFromExterns() || this.verifyNotNull(methodName, arg) && this.verifyIsLast(methodName, arg))) {
            return false;
        }
        String name = args.getString();
        if (!NodeUtil.isValidQualifiedName(this.compiler.getOptions().getLanguageIn().toFeatureSet(), name)) {
            this.compiler.report(JSError.make(args, INVALID_DEFINE_NAME_ERROR, name));
            return false;
        }
        JSDocInfo info = (parent.isExprResult() ? parent.getFirstChild() : parent).getJSDocInfo();
        if (info == null || !info.isDefine()) {
            this.compiler.report(JSError.make(parent, MISSING_DEFINE_ANNOTATION, new String[0]));
            return false;
        }
        return true;
    }

    private boolean verifyNotNull(Node methodName, Node arg) {
        if (arg == null) {
            this.compiler.report(JSError.make(methodName, ClosurePrimitiveErrors.NULL_ARGUMENT_ERROR, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private boolean verifyIsLast(Node methodName, Node arg) {
        if (arg.getNext() != null) {
            this.compiler.report(JSError.make(methodName, ClosurePrimitiveErrors.TOO_MANY_ARGUMENTS_ERROR, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private boolean verifyOfType(Node methodName, Node arg, Token desiredType) {
        if (arg.getToken() != desiredType) {
            this.compiler.report(JSError.make(methodName, ClosurePrimitiveErrors.INVALID_ARGUMENT_ERROR, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private static final class Define {
        final String defineName;
        final GlobalNamespace.Name name;
        final GlobalNamespace.Ref declaration;
        @Nullable
        final Node valueParent;
        @Nullable
        final Node value;

        public Define(String defineName, GlobalNamespace.Name name, GlobalNamespace.Ref declaration, @Nullable Node valueParent, @Nullable Node value) {
            Preconditions.checkState(valueParent == null || value == null || value.getParent() == valueParent);
            Preconditions.checkState(declaration.isSet());
            Preconditions.checkState(declaration.name.equals(name));
            this.defineName = defineName;
            this.name = name;
            this.declaration = declaration;
            this.valueParent = valueParent;
            this.value = value;
        }
    }

    static class Builder {
        private final AbstractCompiler compiler;
        private final Map<String, Node> replacementValues = new LinkedHashMap<String, Node>();
        private Mode mode;
        private Supplier<GlobalNamespace> namespaceSupplier;
        private boolean recognizeClosureDefines = true;

        Builder(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        Builder putReplacements(Map<String, Node> replacementValues) {
            this.replacementValues.putAll(replacementValues);
            return this;
        }

        Builder setMode(Mode x) {
            this.mode = x;
            return this;
        }

        Builder injectNamespace(Supplier<GlobalNamespace> namespaceSupplier) {
            this.namespaceSupplier = namespaceSupplier;
            return this;
        }

        Builder setRecognizeClosureDefines(boolean recognizeClosureDefines) {
            this.recognizeClosureDefines = recognizeClosureDefines;
            return this;
        }

        ProcessDefines build() {
            return new ProcessDefines(this);
        }
    }

    static enum Mode {
        CHECK(true, false),
        OPTIMIZE(false, true),
        CHECK_AND_OPTIMIZE(true, true);

        private final boolean check;
        private final boolean optimize;

        private Mode(boolean check, boolean optimize) {
            this.check = check;
            this.optimize = optimize;
        }
    }
}

