/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.Node;

class RemoveWeakSources
implements CompilerPass {
    private final AbstractCompiler compiler;

    public RemoveWeakSources(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        for (Node script = root.getFirstChild(); script != null; script = script.getNext()) {
            Preconditions.checkState(script.isScript());
            if (!script.getStaticSourceFile().isWeak()) continue;
            NodeUtil.deleteChildren(script, this.compiler);
        }
    }
}

