/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.MessageBundle;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Ascii;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@GwtIncompatible(value="JsMessage")
public final class ReplaceMessages {
    public static final DiagnosticType BUNDLE_DOES_NOT_HAVE_THE_MESSAGE = DiagnosticType.error("JSC_BUNDLE_DOES_NOT_HAVE_THE_MESSAGE", "Message with id = {0} could not be found in replacement bundle");
    public static final DiagnosticType INVALID_ALTERNATE_MESSAGE_PLACEHOLDERS = DiagnosticType.error("JSC_INVALID_ALTERNATE_MESSAGE_PLACEHOLDERS", "Alternate message ID={0} placeholders ({1}) differs from {2} placeholders ({3}).");
    private final AbstractCompiler compiler;
    private final MessageBundle bundle;
    private final JsMessage.Style style;
    private final boolean strictReplacement;
    private final AstFactory astFactory;

    ReplaceMessages(AbstractCompiler compiler, MessageBundle bundle, JsMessage.Style style, boolean strictReplacement) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.bundle = bundle;
        this.style = style;
        this.strictReplacement = strictReplacement;
    }

    public CompilerPass getMsgProtectionPass() {
        return new MsgProtectionPass();
    }

    private Node createMsgPropertiesNode(JsMessage message, MsgOptions msgOptions) {
        String meaning;
        QuotedKeyObjectLitBuilder msgPropsBuilder = new QuotedKeyObjectLitBuilder();
        msgPropsBuilder.addString("key", message.getKey());
        String altId = message.getAlternateId();
        if (altId != null) {
            msgPropsBuilder.addString("alt_id", altId);
        }
        if ((meaning = message.getMeaning()) != null) {
            msgPropsBuilder.addString("meaning", meaning);
        }
        msgPropsBuilder.addString("msg_text", message.toString());
        if (msgOptions.escapeLessThan) {
            msgPropsBuilder.addString("escapeLessThan", "");
        }
        if (msgOptions.unescapeHtmlEntities) {
            msgPropsBuilder.addString("unescapeHtmlEntities", "");
        }
        return msgPropsBuilder.build();
    }

    public CompilerPass getReplacementCompletionPass() {
        return new ReplacementCompletionPass();
    }

    private JsMessage lookupMessage(Node callNode, MessageBundle bundle, JsMessage message) {
        JsMessage translatedMessage = bundle.getMessage(message.getId());
        if (translatedMessage != null) {
            return translatedMessage;
        }
        String alternateId = message.getAlternateId();
        if (alternateId == null) {
            return null;
        }
        JsMessage alternateMessage = bundle.getMessage(alternateId);
        if (alternateMessage != null && !Objects.equals(message.placeholders(), alternateMessage.placeholders())) {
            this.compiler.report(JSError.make(callNode, INVALID_ALTERNATE_MESSAGE_PLACEHOLDERS, alternateId, String.valueOf(alternateMessage.placeholders()), message.getKey(), String.valueOf(message.placeholders())));
            return null;
        }
        return alternateMessage;
    }

    public CompilerPass getFullReplacementPass() {
        return new FullReplacementPass();
    }

    private Map<String, Node> createPlaceholderNodeMap(Node objLitNode) throws JsMessageVisitor.MalformedException {
        HashMap<String, Node> placeholderMap = new HashMap<String, Node>();
        if (objLitNode != null) {
            for (Node key = objLitNode.getFirstChild(); key != null; key = key.getNext()) {
                boolean isKeyAlreadySeen;
                Preconditions.checkState(key.isStringKey(), key);
                String name = key.getString();
                boolean bl = isKeyAlreadySeen = placeholderMap.put(name, key.getOnlyChild()) != null;
                if (!isKeyAlreadySeen) continue;
                throw new JsMessageVisitor.MalformedException("Duplicate placeholder name", key);
            }
        }
        return placeholderMap;
    }

    private Node constructStringExprNode(List<CharSequence> msgParts, Map<String, Node> placeholderMap, MsgOptions options) {
        if (msgParts.isEmpty()) {
            return this.astFactory.createString("");
        }
        Node resultNode = null;
        for (CharSequence msgPart : msgParts) {
            Node partNode = this.createNodeForMsgPart(msgPart, options, placeholderMap);
            resultNode = resultNode == null ? partNode : this.astFactory.createAdd(resultNode, partNode);
        }
        return resultNode;
    }

    private Node createNodeForMsgPart(CharSequence part, MsgOptions options, Map<String, Node> placeholderMap) {
        Node partNode;
        if (part instanceof JsMessage.PlaceholderReference) {
            JsMessage.PlaceholderReference phRef = (JsMessage.PlaceholderReference)part;
            String placeholderName = phRef.getName();
            partNode = Preconditions.checkNotNull(placeholderMap.get(placeholderName)).cloneTree();
        } else {
            String s = part.toString();
            if (options.escapeLessThan) {
                s = s.replace("<", "&lt;");
            }
            if (options.unescapeHtmlEntities) {
                s = s.replace("&lt;", "<").replace("&gt;", ">").replace("&apos;", "'").replace("&quot;", "\"").replace("&amp;", "&");
            }
            partNode = this.astFactory.createString(s);
        }
        return partNode;
    }

    private static MsgOptions getOptions(@Nullable Node optionsNode) throws JsMessageVisitor.MalformedException {
        MsgOptions options = new MsgOptions();
        if (optionsNode == null) {
            return options;
        }
        if (!optionsNode.isObjectLit()) {
            throw new JsMessageVisitor.MalformedException("OBJLIT node expected", optionsNode);
        }
        block8: for (Node aNode = optionsNode.getFirstChild(); aNode != null; aNode = aNode.getNext()) {
            if (!aNode.isStringKey()) {
                throw new JsMessageVisitor.MalformedException("STRING_KEY node expected as OBJLIT key", aNode);
            }
            String optName = aNode.getString();
            Node value = aNode.getFirstChild();
            if (!value.isTrue() && !value.isFalse()) {
                throw new JsMessageVisitor.MalformedException("Literal true or false expected", value);
            }
            switch (optName) {
                case "html": {
                    options.escapeLessThan = value.isTrue();
                    continue block8;
                }
                case "unescapeHtmlEntities": {
                    options.unescapeHtmlEntities = value.isTrue();
                    continue block8;
                }
                default: {
                    throw new JsMessageVisitor.MalformedException("Unexpected option", aNode);
                }
            }
        }
        return options;
    }

    private static List<CharSequence> mergeStringParts(List<CharSequence> parts) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        for (CharSequence part : parts) {
            CharSequence lastPart;
            if (part instanceof JsMessage.PlaceholderReference) {
                result.add(part);
                continue;
            }
            CharSequence charSequence = lastPart = result.isEmpty() ? null : Iterables.getLast(result);
            if (lastPart == null || lastPart instanceof JsMessage.PlaceholderReference) {
                result.add(part);
                continue;
            }
            result.set(result.size() - 1, lastPart.toString() + part);
        }
        return result;
    }

    private static void checkStringExprNode(@Nullable Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Expected a string; found: null");
        }
        switch (node.getToken()) {
            case STRINGLIT: 
            case TEMPLATELIT: {
                break;
            }
            case ADD: {
                Node c = node.getFirstChild();
                ReplaceMessages.checkStringExprNode(c);
                ReplaceMessages.checkStringExprNode(c.getNext());
                break;
            }
            default: {
                throw new IllegalArgumentException("Expected a string; found: " + (Object)((Object)node.getToken()));
            }
        }
    }

    public static class ProtectedJsMessage {
        private final JsMessage jsMessage;
        private final Node definitionNode;
        @Nullable
        private final Node substitutionsNode;
        private final boolean escapeLessThan;
        private final boolean unescapeHtmlEntities;

        private ProtectedJsMessage(JsMessage jsMessage, Node definitionNode, @Nullable Node substitutionsNode, boolean escapeLessThan, boolean unescapeHtmlEntities) {
            this.jsMessage = jsMessage;
            this.definitionNode = definitionNode;
            this.substitutionsNode = substitutionsNode;
            this.escapeLessThan = escapeLessThan;
            this.unescapeHtmlEntities = unescapeHtmlEntities;
        }

        @Nullable
        public static ProtectedJsMessage fromAstNode(Node node, JsMessage.IdGenerator idGenerator) {
            if (!node.isCall()) {
                return null;
            }
            Node calleeNode = Preconditions.checkNotNull(node.getFirstChild(), node);
            if (!calleeNode.matchesName("__jscomp_define_msg__")) {
                return null;
            }
            Node propertiesNode = Preconditions.checkNotNull(calleeNode.getNext(), calleeNode);
            Node substitutionsNode = propertiesNode.getNext();
            boolean escapeLessThanOption = false;
            boolean unescapeHtmlEntitiesOption = false;
            JsMessage.Builder jsMessageBuilder = new JsMessage.Builder();
            Preconditions.checkState(propertiesNode.isObjectLit(), propertiesNode);
            block18: for (Node strKey = propertiesNode.getFirstChild(); strKey != null; strKey = strKey.getNext()) {
                Preconditions.checkState(strKey.isStringKey(), strKey);
                String key = strKey.getString();
                Node valueNode = strKey.getOnlyChild();
                Preconditions.checkState(valueNode.isStringLit(), valueNode);
                String value = valueNode.getString();
                switch (key) {
                    case "key": {
                        jsMessageBuilder.setKey(value);
                        continue block18;
                    }
                    case "meaning": {
                        jsMessageBuilder.setMeaning(value);
                        continue block18;
                    }
                    case "alt_id": {
                        jsMessageBuilder.setAlternateId(value);
                        continue block18;
                    }
                    case "msg_text": {
                        try {
                            jsMessageBuilder.setMsgText(value);
                            continue block18;
                        }
                        catch (JsMessage.PlaceholderFormatException unused) {
                            throw new IllegalStateException(valueNode.getLocation() + ": Placeholder incorrectly formatted: >" + value + "<");
                        }
                    }
                    case "escapeLessThan": {
                        escapeLessThanOption = true;
                        continue block18;
                    }
                    case "unescapeHtmlEntities": {
                        unescapeHtmlEntitiesOption = true;
                        continue block18;
                    }
                    default: {
                        throw new IllegalStateException("unknown protected message key: " + strKey);
                    }
                }
            }
            return new ProtectedJsMessage(jsMessageBuilder.build(idGenerator), node, substitutionsNode, escapeLessThanOption, unescapeHtmlEntitiesOption);
        }
    }

    private static class MsgOptions {
        private boolean escapeLessThan = false;
        private boolean unescapeHtmlEntities = false;

        private MsgOptions() {
        }
    }

    class FullReplacementPass
    extends JsMessageVisitor {
        public FullReplacementPass() {
            super(ReplaceMessages.this.compiler, ReplaceMessages.this.style, ReplaceMessages.this.bundle.idGenerator());
        }

        @Override
        void processMessageFallback(Node callNode, JsMessage message1, JsMessage message2) {
            boolean isFirstMessageTranslated = ReplaceMessages.this.lookupMessage(callNode, ReplaceMessages.this.bundle, message1) != null;
            boolean isSecondMessageTranslated = ReplaceMessages.this.lookupMessage(callNode, ReplaceMessages.this.bundle, message2) != null;
            Node replacementNode = isSecondMessageTranslated && !isFirstMessageTranslated ? callNode.getChildAtIndex(2) : callNode.getSecondChild();
            callNode.replaceWith(replacementNode.detach());
            Node changeScope = NodeUtil.getEnclosingChangeScopeRoot(replacementNode);
            if (changeScope != null) {
                this.compiler.reportChangeToChangeScope(changeScope);
            }
        }

        @Override
        protected void processJsMessage(JsMessage message, JsMessageDefinition definition) {
            Node newValue;
            Node callNode = definition.getMessageNode();
            JsMessage replacement = ReplaceMessages.this.lookupMessage(callNode, ReplaceMessages.this.bundle, message);
            if (replacement == null) {
                if (ReplaceMessages.this.strictReplacement) {
                    this.compiler.report(JSError.make(callNode, BUNDLE_DOES_NOT_HAVE_THE_MESSAGE, message.getId()));
                    return;
                }
                replacement = message;
            }
            Node msgNode = definition.getMessageNode();
            try {
                newValue = this.getNewValueNode(replacement, msgNode);
            }
            catch (JsMessageVisitor.MalformedException e) {
                this.compiler.report(JSError.make(e.getNode(), MESSAGE_TREE_MALFORMED, e.getMessage()));
                newValue = msgNode;
            }
            if (newValue != msgNode) {
                newValue.srcrefTreeIfMissing(msgNode);
                msgNode.replaceWith(newValue);
                this.compiler.reportChangeToEnclosingScope(newValue);
            }
        }

        private Node getNewValueNode(JsMessage message, Node origValueNode) throws JsMessageVisitor.MalformedException {
            switch (origValueNode.getToken()) {
                case FUNCTION: {
                    this.updateFunctionNode(message, origValueNode);
                    return origValueNode;
                }
                case STRINGLIT: {
                    String newString = message.toString();
                    if (!origValueNode.getString().equals(newString)) {
                        origValueNode.setString(newString);
                        this.compiler.reportChangeToEnclosingScope(origValueNode);
                    }
                    return origValueNode;
                }
                case ADD: {
                    return ReplaceMessages.this.astFactory.createString(message.toString());
                }
                case CALL: {
                    return this.replaceCallNode(message, origValueNode);
                }
            }
            throw new JsMessageVisitor.MalformedException("Expected FUNCTION, STRING, or ADD node; found: " + (Object)((Object)origValueNode.getToken()), origValueNode);
        }

        private void updateFunctionNode(JsMessage message, Node functionNode) throws JsMessageVisitor.MalformedException {
            this.checkNode(functionNode, Token.FUNCTION);
            Node nameNode = functionNode.getFirstChild();
            this.checkNode(nameNode, Token.NAME);
            Node argListNode = nameNode.getNext();
            this.checkNode(argListNode, Token.PARAM_LIST);
            Node oldBlockNode = argListNode.getNext();
            this.checkNode(oldBlockNode, Token.BLOCK);
            Node valueNode = this.constructAddOrStringNode(message.getParts(), argListNode);
            Node newBlockNode = IR.block(ReplaceMessages.this.astFactory.createReturn(valueNode));
            if (!newBlockNode.isEquivalentTo(oldBlockNode, false, true, false, false)) {
                newBlockNode.srcrefTreeIfMissing(oldBlockNode);
                oldBlockNode.replaceWith(newBlockNode);
                this.compiler.reportChangeToEnclosingScope(newBlockNode);
            }
        }

        private Node constructAddOrStringNode(ImmutableList<CharSequence> parts, Node argListNode) throws JsMessageVisitor.MalformedException {
            if (parts.isEmpty()) {
                return ReplaceMessages.this.astFactory.createString("");
            }
            Node resultNode = null;
            for (CharSequence part : parts) {
                Node partNode = this.constructLegacyFunctionMsgPart(argListNode, part);
                resultNode = resultNode == null ? partNode : ReplaceMessages.this.astFactory.createAdd(resultNode, partNode);
            }
            return resultNode;
        }

        private Node constructLegacyFunctionMsgPart(Node argListNode, CharSequence part) throws JsMessageVisitor.MalformedException {
            Node partNode = null;
            if (part instanceof JsMessage.PlaceholderReference) {
                JsMessage.PlaceholderReference phRef = (JsMessage.PlaceholderReference)part;
                for (Node node = argListNode.getFirstChild(); node != null; node = node.getNext()) {
                    String arg;
                    if (!node.isName() || !Ascii.equalsIgnoreCase(arg = node.getString(), phRef.getName())) continue;
                    partNode = IR.name(arg);
                }
                if (partNode == null) {
                    throw new JsMessageVisitor.MalformedException("Unrecognized message placeholder referenced: " + phRef.getName(), argListNode);
                }
            } else {
                partNode = ReplaceMessages.this.astFactory.createString(part.toString());
            }
            return partNode;
        }

        private Node replaceCallNode(JsMessage message, Node callNode) throws JsMessageVisitor.MalformedException {
            this.checkNode(callNode, Token.CALL);
            Node getPropNode = callNode.getFirstChild();
            this.checkNode(getPropNode, Token.GETPROP);
            Node stringExprNode = getPropNode.getNext();
            ReplaceMessages.checkStringExprNode(stringExprNode);
            Node objLitNode = stringExprNode.getNext();
            MsgOptions options = ReplaceMessages.getOptions(objLitNode != null ? objLitNode.getNext() : null);
            Map placeholderMap = ReplaceMessages.this.createPlaceholderNodeMap(objLitNode);
            ImmutableSet<String> placeholderNames = message.placeholders();
            if (placeholderMap.isEmpty() && !placeholderNames.isEmpty()) {
                throw new JsMessageVisitor.MalformedException("Empty placeholder value map for a translated message with placeholders.", callNode);
            }
            for (String placeholderName : placeholderNames) {
                if (placeholderMap.containsKey(placeholderName)) continue;
                throw new JsMessageVisitor.MalformedException("Unrecognized message placeholder referenced: " + placeholderName, callNode);
            }
            return ReplaceMessages.this.constructStringExprNode(ReplaceMessages.mergeStringParts(message.getParts()), placeholderMap, options);
        }
    }

    private static class ProtectedMsgFallback {
        final Node callNode;
        final String firstMsgKey;
        final Node firstMsgValue;
        final String secondMsgKey;
        final Node secondMsgValue;

        ProtectedMsgFallback(Node callNode, String firstMsgKey, Node firstMsgValue, String secondMsgKey, Node secondMsgValue) {
            this.callNode = callNode;
            this.firstMsgKey = firstMsgKey;
            this.firstMsgValue = firstMsgValue;
            this.secondMsgKey = secondMsgKey;
            this.secondMsgValue = secondMsgValue;
        }

        @Nullable
        static ProtectedMsgFallback fromAstNode(Node n) {
            if (!n.isCall()) {
                return null;
            }
            Node callee = n.getFirstChild();
            if (!callee.matchesName("__jscomp_msg_fallback__")) {
                return null;
            }
            Preconditions.checkState(n.hasXChildren(5), "bad message fallback call: %s", (Object)n);
            Node firstMsgKeyNode = callee.getNext();
            String firstMsgKey = firstMsgKeyNode.getString();
            Node firstMsgValue = firstMsgKeyNode.getNext();
            Node secondMsgKeyNode = firstMsgValue.getNext();
            String secondMsgKey = secondMsgKeyNode.getString();
            Node secondMsgValue = secondMsgKeyNode.getNext();
            return new ProtectedMsgFallback(n, firstMsgKey, firstMsgValue, secondMsgKey, secondMsgValue);
        }
    }

    class ReplacementCompletionPass
    implements CompilerPass {
        final Set<String> translatedMsgKeys = new HashSet<String>();

        ReplacementCompletionPass() {
        }

        @Override
        public void process(Node externs, Node root) {
            NodeTraversal.traverse(ReplaceMessages.this.compiler, root, new NodeTraversal.AbstractPostOrderCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    ProtectedJsMessage protectedJsMessage = ProtectedJsMessage.fromAstNode(n, ReplaceMessages.this.bundle.idGenerator());
                    if (protectedJsMessage != null) {
                        ReplacementCompletionPass.this.visitMsgDefinition(protectedJsMessage);
                    } else {
                        ProtectedMsgFallback protectedMsgFallback = ProtectedMsgFallback.fromAstNode(n);
                        if (protectedMsgFallback != null) {
                            ReplacementCompletionPass.this.visitMsgFallback(protectedMsgFallback);
                        }
                    }
                }
            });
        }

        void visitMsgDefinition(ProtectedJsMessage protectedJsMessage) {
            try {
                JsMessage msgToUse;
                JsMessage originalMsg = protectedJsMessage.jsMessage;
                Node nodeToReplace = protectedJsMessage.definitionNode;
                JsMessage translatedMsg = ReplaceMessages.this.lookupMessage(protectedJsMessage.definitionNode, ReplaceMessages.this.bundle, originalMsg);
                if (translatedMsg != null) {
                    msgToUse = translatedMsg;
                    this.translatedMsgKeys.add(originalMsg.getKey());
                } else {
                    if (ReplaceMessages.this.strictReplacement) {
                        ReplaceMessages.this.compiler.report(JSError.make(nodeToReplace, BUNDLE_DOES_NOT_HAVE_THE_MESSAGE, originalMsg.getId()));
                    }
                    msgToUse = originalMsg;
                }
                MsgOptions msgOptions = new MsgOptions();
                msgOptions.escapeLessThan = protectedJsMessage.escapeLessThan;
                msgOptions.unescapeHtmlEntities = protectedJsMessage.unescapeHtmlEntities;
                Map placeholderMap = ReplaceMessages.this.createPlaceholderNodeMap(protectedJsMessage.substitutionsNode);
                ImmutableSet<String> placeholderNames = msgToUse.placeholders();
                if (placeholderMap.isEmpty() && !placeholderNames.isEmpty()) {
                    throw new JsMessageVisitor.MalformedException("Empty placeholder value map for a translated message with placeholders.", nodeToReplace);
                }
                for (String placeholderName : placeholderNames) {
                    if (placeholderMap.containsKey(placeholderName)) continue;
                    throw new JsMessageVisitor.MalformedException("Unrecognized message placeholder referenced: " + placeholderName, nodeToReplace);
                }
                Node finalMsgConstructionExpression = ReplaceMessages.this.constructStringExprNode(ReplaceMessages.mergeStringParts(msgToUse.getParts()), placeholderMap, msgOptions);
                finalMsgConstructionExpression.srcrefTreeIfMissing(nodeToReplace);
                nodeToReplace.replaceWith(finalMsgConstructionExpression);
                ReplaceMessages.this.compiler.reportChangeToEnclosingScope(finalMsgConstructionExpression);
            }
            catch (JsMessageVisitor.MalformedException e) {
                ReplaceMessages.this.compiler.report(JSError.make(e.getNode(), JsMessageVisitor.MESSAGE_TREE_MALFORMED, e.getMessage()));
            }
        }

        private void visitMsgFallback(ProtectedMsgFallback protectedMsgFallback) {
            Node valueNodeToUse = this.translatedMsgKeys.contains(protectedMsgFallback.firstMsgKey) ? protectedMsgFallback.firstMsgValue : (this.translatedMsgKeys.contains(protectedMsgFallback.secondMsgKey) ? protectedMsgFallback.secondMsgValue : protectedMsgFallback.firstMsgValue);
            valueNodeToUse.detach();
            protectedMsgFallback.callNode.replaceWith(valueNodeToUse);
            ReplaceMessages.this.compiler.reportChangeToEnclosingScope(valueNodeToUse);
        }
    }

    private final class QuotedKeyObjectLitBuilder {
        private final LinkedHashMap<String, Node> keyToValueNodeMap = new LinkedHashMap();

        private QuotedKeyObjectLitBuilder() {
        }

        private QuotedKeyObjectLitBuilder addString(String key, String value) {
            return this.addNode(key, ReplaceMessages.this.astFactory.createString(value));
        }

        private QuotedKeyObjectLitBuilder addNode(String key, Node node) {
            Preconditions.checkState(!this.keyToValueNodeMap.containsKey(key), "repeated key: %s", (Object)key);
            this.keyToValueNodeMap.put(key, node);
            return this;
        }

        private Node build() {
            Node result = ReplaceMessages.this.astFactory.createObjectLit(new Node[0]);
            for (Map.Entry<String, Node> entry : this.keyToValueNodeMap.entrySet()) {
                result.addChildToBack(ReplaceMessages.this.astFactory.createQuotedStringKey(entry.getKey(), entry.getValue()));
            }
            return result;
        }
    }

    class MsgProtectionPass
    extends JsMessageVisitor {
        public MsgProtectionPass() {
            super(ReplaceMessages.this.compiler, ReplaceMessages.this.style, ReplaceMessages.this.bundle.idGenerator());
        }

        @Override
        public void process(Node externs, Node root) {
            NodeUtil.createSynthesizedExternsSymbol(this.compiler, "__jscomp_define_msg__");
            NodeUtil.createSynthesizedExternsSymbol(this.compiler, "__jscomp_msg_fallback__");
            super.process(externs, root);
        }

        @Override
        protected void processJsMessage(JsMessage message, JsMessageDefinition definition) {
            try {
                Node origValueNode = definition.getMessageNode();
                switch (origValueNode.getToken()) {
                    case CALL: {
                        this.protectGetMsgCall(origValueNode, message);
                        break;
                    }
                    case STRINGLIT: 
                    case ADD: {
                        this.protectStringLiteralOrConcatMsg(origValueNode, message);
                        break;
                    }
                    case FUNCTION: {
                        this.protectLegacyFunctionMsg(origValueNode, message);
                        break;
                    }
                    default: {
                        throw new JsMessageVisitor.MalformedException("Expected FUNCTION, STRING, ADD, or CALL node; found: " + origValueNode, origValueNode);
                    }
                }
            }
            catch (JsMessageVisitor.MalformedException e) {
                this.compiler.report(JSError.make(e.getNode(), MESSAGE_TREE_MALFORMED, e.getMessage()));
            }
        }

        private void protectGetMsgCall(Node callNode, JsMessage message) throws JsMessageVisitor.MalformedException {
            Preconditions.checkArgument(callNode.isCall(), callNode);
            Node googGetMsg = callNode.getFirstChild();
            Node originalMessageString = Preconditions.checkNotNull(googGetMsg.getNext());
            Node placeholdersNode = originalMessageString.getNext();
            Node optionsNode = placeholdersNode == null ? null : placeholdersNode.getNext();
            MsgOptions msgOptions = ReplaceMessages.getOptions(optionsNode);
            String protectionFunctionName = "__jscomp_define_msg__";
            Node newCallee = this.createProtectionFunctionCallee("__jscomp_define_msg__").srcref(googGetMsg);
            Node msgPropertiesNode = ReplaceMessages.this.createMsgPropertiesNode(message, msgOptions).srcrefTree(originalMessageString);
            Node newCallNode = ReplaceMessages.this.astFactory.createCall(newCallee, AstFactory.type(callNode), msgPropertiesNode).srcref(callNode);
            newCallNode.setSideEffectFlags(0);
            if (placeholdersNode != null) {
                Preconditions.checkState(placeholdersNode.isObjectLit(), placeholdersNode);
                for (Node strKey = placeholdersNode.getFirstChild(); strKey != null; strKey = strKey.getNext()) {
                    Preconditions.checkState(strKey.isStringKey(), strKey);
                    strKey.setQuotedString();
                }
                newCallNode.addChildToBack(placeholdersNode.detach());
            }
            callNode.replaceWith(newCallNode);
            this.compiler.reportChangeToEnclosingScope(newCallNode);
        }

        private Node createProtectionFunctionCallee(String protectionFunctionName) {
            Node callee = ReplaceMessages.this.astFactory.createNameWithUnknownType(protectionFunctionName);
            callee.putBooleanProp(Node.IS_CONSTANT_NAME, true);
            return callee;
        }

        private void protectStringLiteralOrConcatMsg(Node valueNode, JsMessage message) {
            Node msgProps = ReplaceMessages.this.createMsgPropertiesNode(message, new MsgOptions());
            Node newCallNode = ReplaceMessages.this.astFactory.createCall(this.createProtectionFunctionCallee("__jscomp_define_msg__"), AstFactory.type(valueNode), msgProps).srcrefTreeIfMissing(valueNode);
            newCallNode.setSideEffectFlags(0);
            valueNode.replaceWith(newCallNode);
            this.compiler.reportChangeToEnclosingScope(newCallNode);
        }

        private void protectLegacyFunctionMsg(Node functionNode, JsMessage message) {
            Preconditions.checkArgument(functionNode.isFunction(), functionNode);
            Node paramListNode = functionNode.getSecondChild();
            Node origBlock = paramListNode.getNext();
            Node returnNode = origBlock.getOnlyChild();
            Node origValueNode = returnNode.getOnlyChild();
            Node newCallee = this.createProtectionFunctionCallee("__jscomp_define_msg__");
            Node msgPropertiesNode = ReplaceMessages.this.createMsgPropertiesNode(message, new MsgOptions());
            QuotedKeyObjectLitBuilder placeholderObjLlitBuilder = new QuotedKeyObjectLitBuilder();
            for (Node paramName = paramListNode.getFirstChild(); paramName != null; paramName = paramName.getNext()) {
                Preconditions.checkState(paramName.isName(), paramName);
                placeholderObjLlitBuilder.addNode(paramName.getString(), paramName.cloneNode());
            }
            Node placeholderNode = placeholderObjLlitBuilder.build();
            Node newValueNode = ReplaceMessages.this.astFactory.createCall(newCallee, AstFactory.type(origValueNode), msgPropertiesNode, placeholderNode).srcrefTreeIfMissing(origValueNode);
            origValueNode.replaceWith(newValueNode);
            this.compiler.reportChangeToChangeScope(functionNode);
        }

        @Override
        void processMessageFallback(Node callNode, JsMessage message1, JsMessage message2) {
            Node originalCallee = Preconditions.checkNotNull(callNode.getFirstChild(), callNode);
            Node fallbackCallee = this.createProtectionFunctionCallee("__jscomp_msg_fallback__").srcref(originalCallee);
            Node originalFirstArg = Preconditions.checkNotNull(originalCallee.getNext(), callNode);
            Node firstMsgKey = ReplaceMessages.this.astFactory.createString(message1.getKey()).srcref(originalFirstArg);
            Node originalSecondArg = Preconditions.checkNotNull(originalFirstArg.getNext(), callNode);
            Node secondMsgKey = ReplaceMessages.this.astFactory.createString(message2.getKey()).srcref(originalSecondArg);
            Node newCallNode = ReplaceMessages.this.astFactory.createCall(fallbackCallee, AstFactory.type(callNode), firstMsgKey, originalFirstArg.detach(), secondMsgKey, originalSecondArg.detach()).srcref(callNode);
            newCallNode.setSideEffectFlags(0);
            callNode.replaceWith(newCallNode);
            this.compiler.reportChangeToEnclosingScope(newCallNode);
        }
    }
}

