/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ArrayListMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ListMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Lists;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Multimaps;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class RewriteGlobalDeclarationsForTryCatchWrapping
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;
    private final ListMultimap<JSChunk, Node> functions = ArrayListMultimap.create();
    private final ArrayList<Node> classes = new ArrayList();

    RewriteGlobalDeclarationsForTryCatchWrapping(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        for (Map.Entry<JSChunk, List<Node>> entry : Multimaps.asMap(this.functions).entrySet()) {
            Node addingRoot = this.compiler.getNodeForCodeInsertion(entry.getKey());
            List<Node> fnNodes = Lists.reverse(entry.getValue());
            if (fnNodes.isEmpty()) continue;
            for (Node n : fnNodes) {
                Node parent = n.getParent();
                n.detach();
                this.compiler.reportChangeToEnclosingScope(parent);
                Node nameNode = n.getFirstChild();
                String name = nameNode.getString();
                nameNode.setString("");
                addingRoot.addChildToFront(IR.var(IR.name(name), n).srcrefTreeIfMissing(n));
                this.compiler.reportChangeToEnclosingScope(nameNode);
            }
            this.compiler.reportChangeToEnclosingScope(addingRoot);
        }
        for (Node n : this.classes) {
            Node originalNameNode = n.getFirstChild();
            originalNameNode.replaceWith(IR.empty());
            Node var = IR.var(originalNameNode);
            n.replaceWith(var);
            originalNameNode.addChildToFront(n);
            this.compiler.reportChangeToEnclosingScope(n);
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        Node grandparent = n.getAncestor(2);
        return grandparent == null || !grandparent.isScript();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (parent == null || !parent.isScript()) {
            return;
        }
        if (NodeUtil.isFunctionDeclaration(n)) {
            this.functions.put(t.getChunk(), n);
        }
        if (NodeUtil.isClassDeclaration(n)) {
            this.classes.add(n);
        }
        if (n.isConst() || n.isLet()) {
            n.setToken(Token.VAR);
            this.compiler.reportChangeToEnclosingScope(n);
        }
    }
}

