/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RewriteLogicalAssignmentOperatorsHelper;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;

public final class RewriteLogicalAssignmentOperatorsPass
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;
    private final RewriteLogicalAssignmentOperatorsHelper rewriteLogicalAssignmentOperatorsHelper;

    public RewriteLogicalAssignmentOperatorsPass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.rewriteLogicalAssignmentOperatorsHelper = new RewriteLogicalAssignmentOperatorsHelper(compiler, compiler.createAstFactory(), compiler.getUniqueIdSupplier());
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, FeatureSet.Feature.LOGICAL_ASSIGNMENT, new FeatureSet.Feature[0]);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            FeatureSet scriptFeatures = NodeUtil.getFeatureSetOfScript(n);
            return scriptFeatures == null || scriptFeatures.contains(FeatureSet.Feature.LOGICAL_ASSIGNMENT);
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node logicalAssignment, Node parent) {
        switch (logicalAssignment.getToken()) {
            case ASSIGN_OR: 
            case ASSIGN_AND: 
            case ASSIGN_COALESCE: {
                this.rewriteLogicalAssignmentOperatorsHelper.visitLogicalAssignmentOperator(t, logicalAssignment);
                break;
            }
        }
    }
}

