/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.JSCompZipFileCache;
import com.google.javascript.jscomp.Platform;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.SimpleRegion;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Strings;
import com.google.javascript.jscomp.jarjar.com.google.common.io.CharStreams;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.serialization.SourceFileProto;
import com.google.javascript.rhino.StaticSourceFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class SourceFile
implements StaticSourceFile,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String UTF8_BOM = "\ufeff";
    private static final String BANG_SLASH = "!" + Platform.getFileSeperator();
    private static final int SOURCE_EXCERPT_REGION_LENGTH = 5;
    private final String fileName;
    private StaticSourceFile.SourceKind kind;
    private final CodeLoader loader;
    private transient int[] lineOffsets = null;
    private volatile transient String code = null;
    private static final int SEVEN_BITS = 127;

    private SourceFile(CodeLoader loader, String fileName, StaticSourceFile.SourceKind kind) {
        if (Strings.isNullOrEmpty(fileName)) {
            throw new IllegalArgumentException("a source must have a name");
        }
        if (!"/".equals(Platform.getFileSeperator())) {
            fileName = fileName.replace(Platform.getFileSeperator(), "/");
        }
        this.loader = loader;
        this.fileName = fileName;
        this.kind = kind;
    }

    @Override
    public int getLineOffset(int lineno) {
        this.findLineOffsets();
        if (lineno < 1 || lineno > this.lineOffsets.length) {
            throw new IllegalArgumentException("Expected line number between 1 and " + this.lineOffsets.length + "\nActual: " + lineno);
        }
        return this.lineOffsets[lineno - 1];
    }

    int getNumLines() {
        this.findLineOffsets();
        return this.lineOffsets.length;
    }

    private void findLineOffsets() {
        if (this.lineOffsets != null) {
            return;
        }
        if (this.code == null) {
            try {
                this.getCode();
            }
            catch (IOException e) {
                this.lineOffsets = new int[1];
            }
            Preconditions.checkNotNull(this.lineOffsets);
            return;
        }
        String[] sourceLines = this.code.split("\n", -1);
        this.lineOffsets = new int[sourceLines.length];
        for (int ii = 1; ii < sourceLines.length; ++ii) {
            this.lineOffsets[ii] = this.lineOffsets[ii - 1] + sourceLines[ii - 1].length() + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getCode() throws IOException {
        if (this.code == null) {
            SourceFile sourceFile = this;
            synchronized (sourceFile) {
                if (this.code == null) {
                    this.setCodeAndDoBookkeeping(this.loader.loadUncachedCode());
                }
            }
        }
        return this.code;
    }

    @Deprecated
    final void setCodeDeprecated(String code) {
        this.setCodeAndDoBookkeeping(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GwtIncompatible(value="java.io.Reader")
    public Reader getCodeReader() throws IOException {
        if (this.code == null) {
            SourceFile sourceFile = this;
            synchronized (sourceFile) {
                Reader uncachedReader;
                if (this.code == null && (uncachedReader = this.loader.openUncachedReader()) != null) {
                    return uncachedReader;
                }
            }
        }
        return new StringReader(this.getCode());
    }

    private void setCodeAndDoBookkeeping(String sourceCode) {
        this.code = null;
        this.lineOffsets = null;
        if (sourceCode != null) {
            if (sourceCode.startsWith(UTF8_BOM)) {
                sourceCode = sourceCode.substring(UTF8_BOM.length());
            }
            this.code = sourceCode;
            this.findLineOffsets();
        }
    }

    @Deprecated
    public String getOriginalPath() {
        return this.getName();
    }

    public void clearCachedSource() {
        this.setCodeAndDoBookkeeping(null);
    }

    boolean hasSourceInMemory() {
        return this.code != null;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public StaticSourceFile.SourceKind getKind() {
        return this.kind;
    }

    public void setKind(StaticSourceFile.SourceKind kind) {
        this.kind = kind;
    }

    @Override
    public int getLineOfOffset(int offset) {
        this.findLineOffsets();
        int search = Arrays.binarySearch(this.lineOffsets, offset);
        if (search >= 0) {
            return search + 1;
        }
        int insertionPoint = -1 * (search + 1);
        return Math.min(insertionPoint - 1, this.lineOffsets.length - 1) + 1;
    }

    @Override
    public int getColumnOfOffset(int offset) {
        int line = this.getLineOfOffset(offset);
        return offset - this.lineOffsets[line - 1];
    }

    public String getLine(int lineNumber) {
        this.findLineOffsets();
        if (lineNumber > this.lineOffsets.length) {
            return null;
        }
        if (lineNumber < 1) {
            lineNumber = 1;
        }
        int pos = this.lineOffsets[lineNumber - 1];
        String js = "";
        try {
            js = this.getCode();
        }
        catch (IOException e) {
            return null;
        }
        if (js.indexOf(10, pos) == -1) {
            if (pos >= js.length()) {
                return null;
            }
            return js.substring(pos);
        }
        return js.substring(pos, js.indexOf(10, pos));
    }

    public Region getLines(int lineNumber, int length) {
        int endLine;
        this.findLineOffsets();
        if (lineNumber > this.lineOffsets.length) {
            return null;
        }
        if (lineNumber < 1) {
            lineNumber = 1;
        }
        if (length <= 0) {
            length = 1;
        }
        String js = "";
        try {
            js = this.getCode();
        }
        catch (IOException e) {
            return null;
        }
        int pos = this.lineOffsets[lineNumber - 1];
        if (pos == js.length()) {
            return new SimpleRegion(lineNumber, lineNumber, "");
        }
        int endChar = pos;
        for (endLine = lineNumber; endChar < pos + length && endLine <= this.lineOffsets.length; ++endLine) {
            endChar = endLine < this.lineOffsets.length ? this.lineOffsets[endLine] : js.length();
        }
        if (js.charAt(endChar - 1) == '\n') {
            return new SimpleRegion(lineNumber, endLine, js.substring(pos, endChar - 1));
        }
        return new SimpleRegion(lineNumber, endLine, js.substring(pos, endChar));
    }

    public Region getRegion(int lineNumber) {
        int nextpos;
        String js = "";
        try {
            js = this.getCode();
        }
        catch (IOException e) {
            return null;
        }
        int pos = 0;
        int startLine = Math.max(1, lineNumber - 3 + 1);
        for (int n = 1; n < startLine && (nextpos = js.indexOf(10, pos)) != -1; ++n) {
            pos = nextpos + 1;
        }
        int end = pos;
        int endLine = startLine;
        int n = 0;
        while (n < 5 && (end = js.indexOf(10, end)) != -1) {
            ++end;
            ++n;
            ++endLine;
        }
        if (lineNumber >= endLine) {
            return null;
        }
        if (end == -1) {
            int last = js.length() - 1;
            if (js.charAt(last) == '\n') {
                return new SimpleRegion(startLine, endLine, js.substring(pos, last));
            }
            return new SimpleRegion(startLine, endLine, js.substring(pos));
        }
        return new SimpleRegion(startLine, endLine, js.substring(pos, end));
    }

    public String toString() {
        return this.fileName;
    }

    @GwtIncompatible(value="fromZipInput")
    public static List<SourceFile> fromZipFile(String zipName, Charset inputCharset) throws IOException {
        try (FileInputStream input = new FileInputStream(zipName);){
            List<SourceFile> list = SourceFile.fromZipInput(zipName, input, inputCharset);
            return list;
        }
    }

    @GwtIncompatible(value="java.util.zip.ZipInputStream")
    public static List<SourceFile> fromZipInput(String zipName, InputStream input, Charset inputCharset) throws IOException {
        String absoluteZipPath = new File(zipName).getAbsolutePath();
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        try (ZipInputStream in = new ZipInputStream(input, inputCharset);){
            ZipEntry zipEntry;
            while ((zipEntry = in.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                if (!entryName.endsWith(".js")) continue;
                sourceFiles.add(SourceFile.builder().withCharset(inputCharset).withOriginalPath(zipName + BANG_SLASH + entryName).withZipEntryPath(absoluteZipPath, entryName).build());
            }
        }
        return sourceFiles;
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromFile(String fileName, Charset charset) {
        return SourceFile.builder().withPath(fileName).withCharset(charset).build();
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromFile(String fileName) {
        return SourceFile.builder().withPath(fileName).build();
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromPath(Path path, Charset charset) {
        return SourceFile.builder().withPath(path).withCharset(charset).build();
    }

    public static SourceFile fromCode(String fileName, String code, StaticSourceFile.SourceKind kind) {
        return SourceFile.builder().withPath(fileName).withKind(kind).withContent(code).build();
    }

    public static SourceFile fromCode(String fileName, String code) {
        return SourceFile.builder().withPath(fileName).withContent(code).build();
    }

    @GwtIncompatible(value="java.io.Reader")
    public static SourceFile fromProto(SourceFileProto protoSourceFile) {
        StaticSourceFile.SourceKind sourceKind = SourceFile.getSourceKindFromProto(protoSourceFile);
        switch (protoSourceFile.getLoaderCase()) {
            case PRELOADED_CONTENTS: {
                return SourceFile.fromCode(protoSourceFile.getFilename(), protoSourceFile.getPreloadedContents(), sourceKind);
            }
            case FILE_ON_DISK: {
                String pathOnDisk = protoSourceFile.getFileOnDisk().getActualPath().isEmpty() ? protoSourceFile.getFilename() : protoSourceFile.getFileOnDisk().getActualPath();
                return SourceFile.builder().withCharset(SourceFile.toCharset(protoSourceFile.getFileOnDisk().getCharset())).withOriginalPath(protoSourceFile.getFilename()).withKind(sourceKind).withPath(pathOnDisk).build();
            }
            case ZIP_ENTRY: {
                SourceFileProto.ZipEntryOnDisk zipEntry = protoSourceFile.getZipEntry();
                return SourceFile.builder().withKind(sourceKind).withOriginalPath(protoSourceFile.getFilename()).withCharset(SourceFile.toCharset(zipEntry.getCharset())).withZipEntryPath(zipEntry.getZipPath(), zipEntry.getEntryName()).build();
            }
        }
        throw new AssertionError();
    }

    private static StaticSourceFile.SourceKind getSourceKindFromProto(SourceFileProto protoSourceFile) {
        switch (protoSourceFile.getSourceKind()) {
            case EXTERN: {
                return StaticSourceFile.SourceKind.EXTERN;
            }
            case CODE: {
                return StaticSourceFile.SourceKind.STRONG;
            }
        }
        throw new AssertionError();
    }

    private static Charset toCharset(String protoCharset) {
        if (protoCharset.isEmpty()) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName(protoCharset);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void restoreFrom(SourceFile other) {
        this.code = other.code;
        this.lineOffsets = other.lineOffsets;
    }

    @GwtIncompatible(value="ObjectOutputStream")
    private void writeObject(ObjectOutputStream os) throws Exception {
        Preconditions.checkState(this.getKind().equals((Object)StaticSourceFile.SourceKind.NON_CODE), "JS SourceFiles must not be serialized and are reconstructed by TypedAstDeserializer. \nHit on:  %s", (Object)this);
        os.defaultWriteObject();
        this.serializeLineOffsetsToVarintDeltas(os);
    }

    @GwtIncompatible(value="ObjectInputStream")
    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        this.deserializeVarintDeltasToLineOffsets(in);
    }

    @GwtIncompatible(value="ObjectOutputStream")
    private void serializeLineOffsetsToVarintDeltas(ObjectOutputStream os) throws Exception {
        if (this.lineOffsets == null) {
            os.writeInt(-1);
            return;
        }
        os.writeInt(this.lineOffsets.length);
        for (int intIndex = 1; intIndex < this.lineOffsets.length; ++intIndex) {
            int delta;
            for (delta = this.lineOffsets[intIndex] - this.lineOffsets[intIndex - 1]; delta > 127; delta >>>= 7) {
                os.writeByte(delta | 0xFFFFFF80);
            }
            os.writeByte(delta);
        }
    }

    @GwtIncompatible(value="ObjectInputStream")
    private void deserializeVarintDeltasToLineOffsets(ObjectInputStream in) throws Exception {
        int lineCount = in.readInt();
        if (lineCount == -1) {
            this.lineOffsets = null;
            return;
        }
        int[] lineOffsets = new int[lineCount];
        for (int intIndex = 1; intIndex < lineCount; ++intIndex) {
            int delta = 0;
            int shift = 0;
            byte segment = in.readByte();
            while (segment < 0) {
                delta |= (segment & 0x7F) << shift;
                shift += 7;
                segment = in.readByte();
            }
            lineOffsets[intIndex] = (delta |= segment << shift) + lineOffsets[intIndex - 1];
        }
        this.lineOffsets = lineOffsets;
    }

    public SourceFileProto getProto() {
        return this.loader.toProtoLocationBuilder(this.getName()).setFilename(this.getName()).setSourceKind(SourceFile.sourceKindToProto(this.getKind())).build();
    }

    private static SourceFileProto.SourceKind sourceKindToProto(StaticSourceFile.SourceKind sourceKind) {
        switch (sourceKind) {
            case EXTERN: {
                return SourceFileProto.SourceKind.EXTERN;
            }
            case STRONG: 
            case WEAK: {
                return SourceFileProto.SourceKind.CODE;
            }
        }
        throw new AssertionError();
    }

    private static abstract class CodeLoader
    implements Serializable {
        private CodeLoader() {
        }

        String loadUncachedCode() throws IOException {
            throw new AssertionError();
        }

        Reader openUncachedReader() throws IOException {
            return null;
        }

        abstract SourceFileProto.Builder toProtoLocationBuilder(String var1);

        static final class AtZip
        extends CodeLoader {
            private static final long serialVersionUID = 1L;
            private final String zipName;
            private final String entryName;
            private final String serializableCharset;

            AtZip(String zipName, String entryName, Charset c) {
                this.zipName = zipName;
                this.entryName = entryName;
                this.serializableCharset = c.name();
            }

            @Override
            @GwtIncompatible
            String loadUncachedCode() throws IOException {
                return CharStreams.toString(this.openUncachedReader());
            }

            @Override
            @GwtIncompatible
            Reader openUncachedReader() throws IOException {
                return new InputStreamReader(JSCompZipFileCache.getEntryStream(this.zipName, this.entryName), this.getCharset());
            }

            private Charset getCharset() {
                return Charset.forName(this.serializableCharset);
            }

            @Override
            SourceFileProto.Builder toProtoLocationBuilder(String fileName) {
                return SourceFileProto.newBuilder().setFilename(fileName).setZipEntry(SourceFileProto.ZipEntryOnDisk.newBuilder().setEntryName(this.entryName).setZipPath(this.zipName).setCharset(this.getCharset().equals(StandardCharsets.UTF_8) ? "" : this.serializableCharset).build());
            }
        }

        static final class OnDisk
        extends CodeLoader {
            private static final long serialVersionUID = 1L;
            private final String serializableCharset;
            private transient Path relativePath;

            OnDisk(Path relativePath, Charset c) {
                this.serializableCharset = c.name();
                this.relativePath = relativePath;
            }

            @Override
            @GwtIncompatible
            String loadUncachedCode() throws IOException {
                String string;
                block8: {
                    Reader r = this.openUncachedReader();
                    try {
                        string = CharStreams.toString(r);
                        if (r == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (r != null) {
                                try {
                                    r.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (MalformedInputException e) {
                            throw new IOException("Failed to read: " + this.relativePath + ", is this input UTF-8 encoded?", e);
                        }
                    }
                    r.close();
                }
                return string;
            }

            @Override
            @GwtIncompatible
            Reader openUncachedReader() throws IOException {
                return Files.newBufferedReader(this.relativePath, this.getCharset());
            }

            @GwtIncompatible
            private void writeObject(ObjectOutputStream out) throws Exception {
                out.defaultWriteObject();
                out.writeObject(this.relativePath.toString());
            }

            @GwtIncompatible
            private void readObject(ObjectInputStream in) throws Exception {
                in.defaultReadObject();
                this.relativePath = Paths.get((String)in.readObject(), new String[0]);
            }

            private Charset getCharset() {
                return Charset.forName(this.serializableCharset);
            }

            @Override
            SourceFileProto.Builder toProtoLocationBuilder(String fileName) {
                String actualPath = this.relativePath.toString();
                return SourceFileProto.newBuilder().setFileOnDisk(SourceFileProto.FileOnDisk.newBuilder().setActualPath(fileName.equals(actualPath) ? "" : actualPath).setCharset(this.getCharset().equals(StandardCharsets.UTF_8) ? "" : this.serializableCharset));
            }
        }

        static final class Preloaded
        extends CodeLoader {
            private static final long serialVersionUID = 2L;
            private final String preloadedCode;

            Preloaded(String preloadedCode) {
                this.preloadedCode = Preconditions.checkNotNull(preloadedCode);
            }

            @Override
            String loadUncachedCode() {
                return this.preloadedCode;
            }

            @Override
            SourceFileProto.Builder toProtoLocationBuilder(String fileName) {
                return SourceFileProto.newBuilder().setPreloadedContents(this.preloadedCode);
            }
        }
    }

    public static final class Builder {
        private StaticSourceFile.SourceKind kind = StaticSourceFile.SourceKind.STRONG;
        private Charset charset = StandardCharsets.UTF_8;
        private String originalPath = null;
        private String path = null;
        private Path pathWithFilesystem = null;
        private String zipEntryPath = null;
        private Supplier<String> lazyContent = null;

        private Builder() {
        }

        public Builder withKind(StaticSourceFile.SourceKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withPath(String path) {
            return this.withPathInternal(path, null);
        }

        public Builder withPath(Path path) {
            return this.withPathInternal(path.toString(), path);
        }

        public Builder withContent(String x) {
            this.lazyContent = x::toString;
            return this;
        }

        @GwtIncompatible
        public Builder withContent(InputStream x) {
            this.lazyContent = () -> {
                Preconditions.checkState(this.charset != null);
                try {
                    return CharStreams.toString(new InputStreamReader(x, this.charset));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
            return this;
        }

        public Builder withZipEntryPath(String zipPath, String entryPath) {
            this.path = zipPath;
            this.zipEntryPath = entryPath;
            return this;
        }

        public Builder withOriginalPath(String originalPath) {
            this.originalPath = originalPath;
            return this;
        }

        public SourceFile build() {
            String displayPath;
            String string = this.originalPath != null ? this.originalPath : (displayPath = this.zipEntryPath == null ? this.path : this.path + BANG_SLASH + this.zipEntryPath);
            if (this.lazyContent != null) {
                return new SourceFile(new CodeLoader.Preloaded(this.lazyContent.get()), displayPath, this.kind);
            }
            if (this.zipEntryPath != null) {
                return new SourceFile(new CodeLoader.AtZip(this.path, this.zipEntryPath, this.charset), displayPath, this.kind);
            }
            return new SourceFile(new CodeLoader.OnDisk(this.pathWithFilesystem != null ? this.pathWithFilesystem : Paths.get(this.path, new String[0]), this.charset), displayPath, this.kind);
        }

        private Builder withPathInternal(String path, @Nullable Path pathWithFilesystem) {
            int bangSlashIndex = path.indexOf(BANG_SLASH);
            if (bangSlashIndex >= 0) {
                String zipPath = path.substring(0, bangSlashIndex);
                String entryPath = path.substring(bangSlashIndex + BANG_SLASH.length());
                if (zipPath.endsWith(".zip") && (entryPath.endsWith(".js") || entryPath.endsWith(".js.map"))) {
                    return this.withZipEntryPath(zipPath, entryPath);
                }
            }
            this.path = path;
            this.pathWithFilesystem = pathWithFilesystem;
            return this;
        }
    }
}

