/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.AstManipulations;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.Node;

final class StatementFusion
extends AbstractPeepholeOptimization {
    StatementFusion() {
    }

    @Override
    Node optimizeSubtree(Node n) {
        if (n.getParent().isFunction() || !this.canFuseIntoOneStatement(n)) {
            return n;
        }
        Node start = n.getFirstChild();
        Node end = n.getLastChild();
        Node result = StatementFusion.fuseIntoOneStatement(start, end);
        StatementFusion.fuseExpressionIntoControlFlowStatement(result, n.getLastChild());
        this.reportChangeToEnclosingScope(n);
        return n;
    }

    private boolean canFuseIntoOneStatement(Node block) {
        if (!block.isBlock()) {
            return false;
        }
        if (!block.hasChildren() || block.hasOneChild()) {
            return false;
        }
        Node last = block.getLastChild();
        for (Node c = block.getFirstChild(); c != null; c = c.getNext()) {
            if (c.isExprResult() || c == last) continue;
            return false;
        }
        return this.isFusableControlStatement(last);
    }

    private boolean isFusableControlStatement(Node n) {
        switch (n.getToken()) {
            case IF: 
            case THROW: 
            case SWITCH: 
            case EXPR_RESULT: {
                return true;
            }
            case RETURN: {
                return n.hasChildren();
            }
            case FOR: {
                return !NodeUtil.isNameDeclaration(n.getFirstChild());
            }
            case FOR_IN: {
                return !this.mayHaveSideEffects(n.getFirstChild());
            }
            case LABEL: {
                return this.isFusableControlStatement(n.getLastChild());
            }
            case BLOCK: {
                return (this.isASTNormalized() || NodeUtil.canMergeBlock(n)) && !n.isSyntheticBlock() && this.isFusableControlStatement(n.getFirstChild());
            }
        }
        return false;
    }

    private static Node fuseIntoOneStatement(Node first, Node last) {
        if (first.getNext() == last) {
            return first;
        }
        Node commaTree = first.removeFirstChild();
        Node next = null;
        Node cur = first.getNext();
        while (cur != last) {
            commaTree = AstManipulations.fuseExpressions(commaTree, cur.removeFirstChild());
            next = cur.getNext();
            cur.detach();
            cur = next;
        }
        first.addChildToBack(commaTree);
        return first;
    }

    private static void fuseExpressionIntoControlFlowStatement(Node before, Node control) {
        Preconditions.checkArgument(before.isExprResult(), "before must be expression result");
        switch (control.getToken()) {
            case IF: 
            case THROW: 
            case SWITCH: 
            case EXPR_RESULT: 
            case RETURN: 
            case FOR: {
                before.detach();
                StatementFusion.fuseExpressionIntoFirstChild(before.removeFirstChild(), control);
                return;
            }
            case FOR_IN: {
                before.detach();
                StatementFusion.fuseExpressionIntoSecondChild(before.removeFirstChild(), control);
                return;
            }
            case LABEL: {
                StatementFusion.fuseExpressionIntoControlFlowStatement(before, control.getLastChild());
                return;
            }
            case BLOCK: {
                StatementFusion.fuseExpressionIntoControlFlowStatement(before, control.getFirstChild());
                return;
            }
        }
        throw new IllegalStateException("Statement fusion missing.");
    }

    private static void fuseExpressionIntoFirstChild(Node exp, Node stmt) {
        Node val = stmt.removeFirstChild();
        Node comma = AstManipulations.fuseExpressions(exp, val);
        stmt.addChildToFront(comma);
    }

    private static void fuseExpressionIntoSecondChild(Node exp, Node stmt) {
        Node val = stmt.getSecondChild().detach();
        Node comma = AstManipulations.fuseExpressions(exp, val);
        comma.insertAfter(stmt.getFirstChild());
    }
}

