/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Es6ConvertSuper;
import com.google.javascript.jscomp.Es6ExtractClasses;
import com.google.javascript.jscomp.Es6ForOfConverter;
import com.google.javascript.jscomp.Es6NormalizeShorthandProperties;
import com.google.javascript.jscomp.Es6RelativizeImportPaths;
import com.google.javascript.jscomp.Es6RenameVariablesInParamLists;
import com.google.javascript.jscomp.Es6RewriteArrowFunction;
import com.google.javascript.jscomp.Es6RewriteBlockScopedDeclaration;
import com.google.javascript.jscomp.Es6RewriteBlockScopedFunctionDeclaration;
import com.google.javascript.jscomp.Es6RewriteClass;
import com.google.javascript.jscomp.Es6RewriteClassExtendsExpressions;
import com.google.javascript.jscomp.Es6RewriteDestructuring;
import com.google.javascript.jscomp.Es6RewriteGenerators;
import com.google.javascript.jscomp.Es6RewriteModules;
import com.google.javascript.jscomp.Es6RewriteModulesToCommonJsModules;
import com.google.javascript.jscomp.Es6RewriteRestAndSpread;
import com.google.javascript.jscomp.Es6SplitVariableDeclarations;
import com.google.javascript.jscomp.Es7RewriteExponentialOperator;
import com.google.javascript.jscomp.InjectTranspilationRuntimeLibraries;
import com.google.javascript.jscomp.LateEs6ToEs3Converter;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.RemoveTrailingCommaFromParamList;
import com.google.javascript.jscomp.ReportBigIntLiteralTranspilationUnsupported;
import com.google.javascript.jscomp.RewriteAsyncFunctions;
import com.google.javascript.jscomp.RewriteAsyncIteration;
import com.google.javascript.jscomp.RewriteCatchWithNoBinding;
import com.google.javascript.jscomp.RewriteClassFields;
import com.google.javascript.jscomp.RewriteLogicalAssignmentOperatorsPass;
import com.google.javascript.jscomp.RewriteNewDotTarget;
import com.google.javascript.jscomp.RewriteNullishCoalesceOperator;
import com.google.javascript.jscomp.RewriteObjectSpread;
import com.google.javascript.jscomp.RewriteOptionalChainingOperator;
import com.google.javascript.jscomp.RewritePolyfills;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import java.util.List;

public class TranspilationPasses {
    private static final PassFactory es6RewriteModuleToCjs = PassFactory.builder().setName("es6RewriteModuleToCjs").setInternalFactory(Es6RewriteModulesToCommonJsModules::new).setFeatureSet(FeatureSet.latest()).build();
    private static final PassFactory es6RelativizeImportPaths = PassFactory.builder().setName("es6RelativizeImportPaths").setInternalFactory(Es6RelativizeImportPaths::new).setFeatureSet(FeatureSet.latest()).build();
    private static final PassFactory rewriteAsyncFunctions = PassFactory.builder().setName("rewriteAsyncFunctions").setInternalFactory(RewriteAsyncFunctions::create).setFeatureSetForChecks().build();
    private static final PassFactory rewriteAsyncIteration = PassFactory.builder().setName("rewriteAsyncIteration").setInternalFactory(RewriteAsyncIteration::create).setFeatureSetForChecks().build();
    private static final PassFactory rewriteObjectSpread = PassFactory.builder().setName("rewriteObjectSpread").setInternalFactory(RewriteObjectSpread::new).setFeatureSetForChecks().build();
    private static final PassFactory rewriteCatchWithNoBinding = PassFactory.builder().setName("rewriteCatchWithNoBinding").setInternalFactory(RewriteCatchWithNoBinding::new).setFeatureSetForChecks().build();
    private static final PassFactory rewriteNewDotTarget = PassFactory.builder().setName("rewriteNewDotTarget").setInternalFactory(RewriteNewDotTarget::new).setFeatureSetForChecks().build();
    private static final PassFactory removeTrailingCommaFromParamList = PassFactory.builder().setName("removeTrailingCommaFromParamList").setInternalFactory(RemoveTrailingCommaFromParamList::new).setFeatureSetForChecks().build();
    private static final PassFactory reportBigIntLiteralTranspilationUnsupported = PassFactory.builder().setName("reportBigIntTranspilationUnsupported").setInternalFactory(ReportBigIntLiteralTranspilationUnsupported::new).setFeatureSetForChecks().build();
    private static final PassFactory rewriteExponentialOperator = PassFactory.builder().setName("rewriteExponentialOperator").setInternalFactory(Es7RewriteExponentialOperator::new).setFeatureSetForChecks().build();
    private static final PassFactory es6NormalizeShorthandProperties = PassFactory.builder().setName("es6NormalizeShorthandProperties").setInternalFactory(Es6NormalizeShorthandProperties::new).setFeatureSetForChecks().build();
    static final PassFactory es6RewriteClassExtends = PassFactory.builder().setName("Es6ExtractClassExtends").setInternalFactory(Es6RewriteClassExtendsExpressions::new).setFeatureSetForChecks().build();
    static final PassFactory es6ExtractClasses = PassFactory.builder().setName("Es6ExtractClasses").setInternalFactory(Es6ExtractClasses::new).setFeatureSetForChecks().build();
    static final PassFactory rewriteClassFields = PassFactory.builder().setName("RewriteClassFields").setInternalFactory(RewriteClassFields::new).setFeatureSetForChecks().build();
    static final PassFactory es6RewriteClass = PassFactory.builder().setName("Es6RewriteClass").setInternalFactory(Es6RewriteClass::new).setFeatureSetForChecks().build();
    static final PassFactory es6RenameVariablesInParamLists = PassFactory.builder().setName("Es6RenameVariablesInParamLists").setInternalFactory(Es6RenameVariablesInParamLists::new).setFeatureSetForChecks().build();
    static final PassFactory es6RewriteArrowFunction = PassFactory.builder().setName("Es6RewriteArrowFunction").setInternalFactory(Es6RewriteArrowFunction::new).setFeatureSetForChecks().build();
    static final PassFactory rewritePolyfills = PassFactory.builder().setName("RewritePolyfills").setInternalFactory(compiler -> new RewritePolyfills((AbstractCompiler)compiler, compiler.getOptions().getRewritePolyfills(), compiler.getOptions().getIsolatePolyfills())).setFeatureSet(FeatureSet.latest()).build();
    static final PassFactory es6SplitVariableDeclarations = PassFactory.builder().setName("Es6SplitVariableDeclarations").setInternalFactory(Es6SplitVariableDeclarations::new).setFeatureSet(FeatureSet.latest()).build();
    static final PassFactory es6ConvertSuper = PassFactory.builder().setName("es6ConvertSuper").setInternalFactory(Es6ConvertSuper::new).setFeatureSetForChecks().build();
    static final PassFactory injectTranspilationRuntimeLibraries = PassFactory.builder().setName("es6InjectRuntimeLibraries").setInternalFactory(InjectTranspilationRuntimeLibraries::new).setFeatureSetForChecks().build();
    static final PassFactory es6RewriteRestAndSpread = PassFactory.builder().setName("es6RewriteRestAndSpread").setInternalFactory(Es6RewriteRestAndSpread::new).setFeatureSet(FeatureSet.latest()).build();
    static final PassFactory lateConvertEs6ToEs3 = PassFactory.builder().setName("lateConvertEs6").setInternalFactory(LateEs6ToEs3Converter::new).setFeatureSet(FeatureSet.latest()).build();
    static final PassFactory es6ForOf = PassFactory.builder().setName("es6ForOf").setInternalFactory(Es6ForOfConverter::new).setFeatureSetForChecks().build();
    static final PassFactory rewriteBlockScopedFunctionDeclaration = PassFactory.builder().setName("Es6RewriteBlockScopedFunctionDeclaration").setInternalFactory(Es6RewriteBlockScopedFunctionDeclaration::new).setFeatureSetForChecks().build();
    static final PassFactory rewriteBlockScopedDeclaration = PassFactory.builder().setName("Es6RewriteBlockScopedDeclaration").setInternalFactory(Es6RewriteBlockScopedDeclaration::new).setFeatureSetForChecks().build();
    static final PassFactory rewriteGenerators = PassFactory.builder().setName("rewriteGenerators").setInternalFactory(Es6RewriteGenerators::new).setFeatureSetForChecks().build();
    static final PassFactory rewriteLogicalAssignmentOperatorsPass = PassFactory.builder().setName("rewriteLogicalAssignmentOperatorsPass").setInternalFactory(RewriteLogicalAssignmentOperatorsPass::new).setFeatureSetForChecks().build();
    static final PassFactory rewriteOptionalChainingOperator = PassFactory.builder().setName("rewriteOptionalChainingOperator").setInternalFactory(RewriteOptionalChainingOperator::new).setFeatureSetForChecks().build();
    static final PassFactory rewriteNullishCoalesceOperator = PassFactory.builder().setName("rewriteNullishCoalesceOperator").setInternalFactory(RewriteNullishCoalesceOperator::new).setFeatureSetForChecks().build();

    private TranspilationPasses() {
    }

    public static void addEs6ModulePass(List<PassFactory> passes, PreprocessorSymbolTable.CachedInstanceFactory preprocessorTableFactory) {
        passes.add(PassFactory.builder().setName("es6RewriteModule").setInternalFactory(compiler -> {
            preprocessorTableFactory.maybeInitialize((AbstractCompiler)compiler);
            return new Es6RewriteModules((AbstractCompiler)compiler, compiler.getModuleMetadataMap(), compiler.getModuleMap(), preprocessorTableFactory.getInstanceOrNull(), compiler.getTopScope(), compiler.getOptions().getChunkOutputType());
        }).setFeatureSetForChecks().build());
    }

    public static void addTranspilationRuntimeLibraries(List<PassFactory> passes, CompilerOptions options) {
        passes.add(injectTranspilationRuntimeLibraries);
    }

    public static void addEs6ModuleToCjsPass(List<PassFactory> passes) {
        passes.add(es6RewriteModuleToCjs);
    }

    public static void addEs6RewriteImportPathPass(List<PassFactory> passes) {
        passes.add(es6RelativizeImportPaths);
    }

    public static void addEarlyOptimizationTranspilationPasses(List<PassFactory> passes, CompilerOptions options) {
        if (options.needsTranspilationOf(FeatureSet.Feature.PUBLIC_CLASS_FIELDS)) {
            passes.add(rewriteClassFields);
        }
        if (options.needsTranspilationOf(FeatureSet.Feature.NUMERIC_SEPARATOR)) {
            passes.add(TranspilationPasses.createFeatureRemovalPass("markNumericSeparatorsRemoved", FeatureSet.Feature.NUMERIC_SEPARATOR, new FeatureSet.Feature[0]));
        }
        if (options.needsTranspilationOf(FeatureSet.Feature.LOGICAL_ASSIGNMENT)) {
            passes.add(rewriteLogicalAssignmentOperatorsPass);
        }
        if (options.needsTranspilationOf(FeatureSet.Feature.OPTIONAL_CHAINING)) {
            passes.add(rewriteOptionalChainingOperator);
        }
        if (options.needsTranspilationOf(FeatureSet.Feature.BIGINT)) {
            passes.add(reportBigIntLiteralTranspilationUnsupported);
        }
        if (options.needsTranspilationOf(FeatureSet.Feature.NULL_COALESCE_OP)) {
            passes.add(rewriteNullishCoalesceOperator);
        }
        if (options.needsTranspilationOf(FeatureSet.Feature.OPTIONAL_CATCH_BINDING)) {
            passes.add(rewriteCatchWithNoBinding);
        }
        if (options.needsTranspilationOf(FeatureSet.Feature.FOR_AWAIT_OF) || options.needsTranspilationOf(FeatureSet.Feature.ASYNC_GENERATORS)) {
            passes.add(rewriteAsyncIteration);
        }
        if (options.needsTranspilationOf(FeatureSet.Feature.OBJECT_LITERALS_WITH_SPREAD) || options.needsTranspilationOf(FeatureSet.Feature.OBJECT_PATTERN_REST)) {
            passes.add(rewriteObjectSpread);
            if (!options.needsTranspilationFrom(FeatureSet.ES2015) && options.needsTranspilationOf(FeatureSet.Feature.OBJECT_PATTERN_REST)) {
                passes.add(es6RenameVariablesInParamLists);
                passes.add(es6SplitVariableDeclarations);
                passes.add(TranspilationPasses.getEs6RewriteDestructuring(Es6RewriteDestructuring.ObjectDestructuringRewriteMode.REWRITE_OBJECT_REST));
            }
        }
        if (options.needsTranspilationOf(FeatureSet.Feature.TRAILING_COMMA_IN_PARAM_LIST)) {
            passes.add(removeTrailingCommaFromParamList);
        }
        if (options.needsTranspilationOf(FeatureSet.Feature.ASYNC_FUNCTIONS)) {
            passes.add(rewriteAsyncFunctions);
        }
        if (options.needsTranspilationOf(FeatureSet.Feature.EXPONENT_OP)) {
            passes.add(rewriteExponentialOperator);
        }
        if (options.needsTranspilationFrom(FeatureSet.ES2015)) {
            passes.add(TranspilationPasses.createFeatureRemovalPass("markEs6FeaturesNotRequiringTranspilationAsRemoved", FeatureSet.Feature.BINARY_LITERALS, FeatureSet.Feature.OCTAL_LITERALS, FeatureSet.Feature.REGEXP_FLAG_U, FeatureSet.Feature.REGEXP_FLAG_Y));
            passes.add(es6NormalizeShorthandProperties);
            passes.add(es6RewriteClassExtends);
            passes.add(es6ConvertSuper);
            passes.add(es6RenameVariablesInParamLists);
            passes.add(es6SplitVariableDeclarations);
            passes.add(TranspilationPasses.getEs6RewriteDestructuring(Es6RewriteDestructuring.ObjectDestructuringRewriteMode.REWRITE_ALL_OBJECT_PATTERNS));
            passes.add(rewriteNewDotTarget);
            passes.add(es6RewriteArrowFunction);
            passes.add(es6ExtractClasses);
            passes.add(es6RewriteClass);
            passes.add(es6RewriteRestAndSpread);
            passes.add(lateConvertEs6ToEs3);
            passes.add(es6ForOf);
            passes.add(rewriteBlockScopedFunctionDeclaration);
            passes.add(rewriteBlockScopedDeclaration);
            passes.add(rewriteGenerators);
        }
    }

    public static void addRewritePolyfillPass(List<PassFactory> passes) {
        passes.add(rewritePolyfills);
    }

    static final PassFactory getEs6RewriteDestructuring(Es6RewriteDestructuring.ObjectDestructuringRewriteMode rewriteMode) {
        return PassFactory.builder().setName("Es6RewriteDestructuring").setInternalFactory(compiler -> new Es6RewriteDestructuring.Builder((AbstractCompiler)compiler).setDestructuringRewriteMode(rewriteMode).build()).setFeatureSetForChecks().build();
    }

    static boolean doesScriptHaveUnsupportedFeatures(Node script, FeatureSet supportedFeatures) {
        FeatureSet features = NodeUtil.getFeatureSetOfScript(script);
        return features != null && !supportedFeatures.contains(features);
    }

    @Deprecated
    static void processTranspile(AbstractCompiler compiler, Node combinedRoot, FeatureSet featureSet, NodeTraversal.Callback ... callbacks) {
        FeatureSet languageOutFeatures = compiler.getOptions().getOutputFeatureSet();
        for (Node singleRoot = combinedRoot.getFirstChild(); singleRoot != null; singleRoot = singleRoot.getNext()) {
            if (!TranspilationPasses.doesScriptHaveUnsupportedFeatures(singleRoot, languageOutFeatures)) continue;
            for (NodeTraversal.Callback callback : callbacks) {
                singleRoot.putBooleanProp(Node.TRANSPILED, true);
                NodeTraversal.traverse(compiler, singleRoot, callback);
            }
        }
    }

    static void maybeMarkFeaturesAsTranspiledAway(AbstractCompiler compiler, FeatureSet transpiledFeatures) {
        if (!compiler.hasHaltingErrors()) {
            compiler.setFeatureSet(compiler.getFeatureSet().without(transpiledFeatures));
        }
    }

    static void maybeMarkFeaturesAsTranspiledAway(AbstractCompiler compiler, FeatureSet.Feature transpiledFeature, FeatureSet.Feature ... moreTranspiledFeatures) {
        if (!compiler.hasHaltingErrors()) {
            compiler.setFeatureSet(compiler.getFeatureSet().without(transpiledFeature, moreTranspiledFeatures));
        }
    }

    private static PassFactory createFeatureRemovalPass(String passName, FeatureSet.Feature featureToRemove, FeatureSet.Feature ... moreFeaturesToRemove) {
        return PassFactory.builder().setName(passName).setInternalFactory(compiler -> (externs, root) -> TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(compiler, featureToRemove, moreFeaturesToRemove)).setFeatureSetForChecks().build();
    }
}

