/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsIterables;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Platform;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Joiner;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Supplier;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeReplacer;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.UnknownType;
import com.google.javascript.rhino.jstype.Visitor;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

class TypeValidator
implements Serializable {
    private final transient AbstractCompiler compiler;
    private final JSTypeRegistry typeRegistry;
    private final JSType allBitwisableValueTypes;
    private final JSType nullOrUndefined;
    private final JSType promiseOfUnknownType;
    private final JSType iterableOrAsyncIterable;
    private JSType.SubtypingMode subtypingMode = JSType.SubtypingMode.NORMAL;
    private final TypeMismatch.Accumulator mismatches = new TypeMismatch.Accumulator();
    private static final String FOUND_REQUIRED = "{0}\nfound   : {1}\nrequired: {2}";
    private static final String FOUND_REQUIRED_MISSING = "{0}\nfound   : {1}\nrequired: {2}\nmissing : [{3}]\nmismatch: [{4}]";
    static final DiagnosticType INVALID_CAST = DiagnosticType.warning("JSC_INVALID_CAST", "invalid cast - must be a subtype or supertype\nfrom: {0}\nto  : {1}");
    static final DiagnosticType TYPE_MISMATCH_WARNING = DiagnosticType.warning("JSC_TYPE_MISMATCH", "{0}");
    static final DiagnosticType INVALID_ASYNC_RETURN_TYPE = DiagnosticType.warning("JSC_INVALID_ASYNC_RETURN_TYPE", "The return type of an async function must be a supertype of Promise\nfound: {0}");
    static final DiagnosticType INVALID_OPERAND_TYPE = DiagnosticType.disabled("JSC_INVALID_OPERAND_TYPE", "{0}");
    static final DiagnosticType MISSING_EXTENDS_TAG_WARNING = DiagnosticType.warning("JSC_MISSING_EXTENDS_TAG", "Missing @extends tag on type {0}");
    static final DiagnosticType DUP_VAR_DECLARATION = DiagnosticType.warning("JSC_DUP_VAR_DECLARATION", "variable {0} redefined, original definition at {1}:{2}");
    static final DiagnosticType DUP_VAR_DECLARATION_TYPE_MISMATCH = DiagnosticType.warning("JSC_DUP_VAR_DECLARATION_TYPE_MISMATCH", "variable {0} redefined with type {1}, original definition at {2}:{3} with type {4}");
    static final DiagnosticType INTERFACE_METHOD_NOT_IMPLEMENTED = DiagnosticType.warning("JSC_INTERFACE_METHOD_NOT_IMPLEMENTED", "property {0} on interface {1} is not implemented by type {2}");
    static final DiagnosticType HIDDEN_INTERFACE_PROPERTY_MISMATCH = DiagnosticType.warning("JSC_HIDDEN_INTERFACE_PROPERTY_MISMATCH", "mismatch of the {0} property on type {4} and the type of the property it overrides from interface {1}\noriginal: {2}\noverride: {3}");
    static final DiagnosticType HIDDEN_SUPERCLASS_PROPERTY_MISMATCH = DiagnosticType.warning("JSC_HIDDEN_SUPERCLASS_PROPERTY_MISMATCH", "mismatch of the {0} property type and the type of the property it overrides from superclass {1}\noriginal: {2}\noverride: {3}");
    static final DiagnosticType ABSTRACT_METHOD_NOT_IMPLEMENTED = DiagnosticType.warning("JSC_ABSTRACT_METHOD_NOT_IMPLEMENTED", "property {0} on abstract class {1} is not implemented by type {2}");
    static final DiagnosticType UNKNOWN_TYPEOF_VALUE = DiagnosticType.warning("JSC_UNKNOWN_TYPEOF_VALUE", "unknown type: {0}");
    static final DiagnosticType ILLEGAL_PROPERTY_ACCESS = DiagnosticType.warning("JSC_ILLEGAL_PROPERTY_ACCESS", "Cannot do {0} access on a {1}");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(ABSTRACT_METHOD_NOT_IMPLEMENTED, DUP_VAR_DECLARATION, DUP_VAR_DECLARATION_TYPE_MISMATCH, HIDDEN_INTERFACE_PROPERTY_MISMATCH, ILLEGAL_PROPERTY_ACCESS, INTERFACE_METHOD_NOT_IMPLEMENTED, INVALID_ASYNC_RETURN_TYPE, INVALID_CAST, MISSING_EXTENDS_TAG_WARNING, TYPE_MISMATCH_WARNING, UNKNOWN_TYPEOF_VALUE);

    TypeValidator(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.typeRegistry = compiler.getTypeRegistry();
        this.allBitwisableValueTypes = this.typeRegistry.createUnionType(JSTypeNative.STRING_TYPE, JSTypeNative.NUMBER_TYPE, JSTypeNative.BOOLEAN_TYPE, JSTypeNative.NULL_TYPE, JSTypeNative.VOID_TYPE);
        this.nullOrUndefined = this.typeRegistry.getNativeType(JSTypeNative.NULL_VOID);
        this.promiseOfUnknownType = this.typeRegistry.createTemplatizedType(this.typeRegistry.getNativeObjectType(JSTypeNative.PROMISE_TYPE), this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE));
        this.iterableOrAsyncIterable = this.typeRegistry.createUnionType(this.typeRegistry.getNativeObjectType(JSTypeNative.ITERATOR_TYPE), this.typeRegistry.getNativeObjectType(JSTypeNative.ASYNC_ITERATOR_TYPE));
    }

    static ObjectType getInstanceOfCtor(@Nullable JSType t) {
        if (t == null) {
            return null;
        }
        FunctionType ctor = JSType.toMaybeFunctionType(t.dereference());
        if (ctor != null && ctor.isConstructor()) {
            return ctor.getInstanceType();
        }
        return null;
    }

    Iterable<TypeMismatch> getMismatches() {
        return this.mismatches.getMismatches();
    }

    void setSubtypingMode(JSType.SubtypingMode mode) {
        this.subtypingMode = mode;
    }

    void expectValidTypeofName(Node n, String found) {
        this.compiler.report(JSError.make(n, UNKNOWN_TYPEOF_VALUE, found));
    }

    boolean expectObject(Node n, JSType type, String msg) {
        if (!type.matchesObjectContext()) {
            this.mismatch(n, msg, type, JSTypeNative.OBJECT_TYPE);
            return false;
        }
        return true;
    }

    void expectActualObject(Node n, JSType type, String msg) {
        if (!type.isObject()) {
            this.mismatch(n, msg, type, JSTypeNative.OBJECT_TYPE);
        }
    }

    void expectAnyObject(Node n, JSType type, String msg) {
        JSType anyObjectType = this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        if (!anyObjectType.isSubtypeOf(type) && !type.isEmptyType()) {
            this.mismatch(n, msg, type, anyObjectType);
        }
    }

    boolean expectAutoboxesToIterable(Node n, JSType type, String msg) {
        if (type.isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                alt = alt.isBoxableScalar() ? alt.autoboxesTo() : alt;
                if (alt.isSubtypeOf(this.getNativeType(JSTypeNative.ITERABLE_TYPE))) continue;
                this.mismatch(n, msg, type, JSTypeNative.ITERABLE_TYPE);
                return false;
            }
        } else {
            JSType autoboxedType;
            JSType jSType = autoboxedType = type.isBoxableScalar() ? type.autoboxesTo() : type;
            if (!autoboxedType.isSubtypeOf(this.getNativeType(JSTypeNative.ITERABLE_TYPE))) {
                this.mismatch(n, msg, type, JSTypeNative.ITERABLE_TYPE);
                return false;
            }
        }
        return true;
    }

    Optional<JSType> expectAutoboxesToIterableOrAsyncIterable(Node n, JSType type, String msg) {
        JsIterables.MaybeBoxedIterableOrAsyncIterable maybeBoxed = JsIterables.maybeBoxIterableOrAsyncIterable(type, this.typeRegistry);
        if (maybeBoxed.isMatch()) {
            return Optional.of(maybeBoxed.getTemplatedType());
        }
        this.mismatch(n, msg, type, this.iterableOrAsyncIterable);
        return Optional.empty();
    }

    void expectGeneratorSupertype(Node n, JSType type, String msg) {
        if (!this.getNativeType(JSTypeNative.GENERATOR_TYPE).isSubtypeOf(type)) {
            this.mismatch(n, msg, type, JSTypeNative.GENERATOR_TYPE);
        }
    }

    void expectAsyncGeneratorSupertype(Node n, JSType type, String msg) {
        if (!this.getNativeType(JSTypeNative.ASYNC_GENERATOR_TYPE).isSubtypeOf(type)) {
            this.mismatch(n, msg, type, JSTypeNative.ASYNC_GENERATOR_TYPE);
        }
    }

    void expectValidAsyncReturnType(Node n, JSType type) {
        if (this.promiseOfUnknownType.isSubtypeOf(type)) {
            return;
        }
        JSError err = JSError.make(n, INVALID_ASYNC_RETURN_TYPE, type.toString());
        this.registerMismatchAndReport(type, this.promiseOfUnknownType, err);
    }

    void expectITemplateArraySupertype(Node n, JSType type, String msg) {
        if (!this.getNativeType(JSTypeNative.I_TEMPLATE_ARRAY_TYPE).isSubtypeOf(type)) {
            this.mismatch(n, msg, type, JSTypeNative.I_TEMPLATE_ARRAY_TYPE);
        }
    }

    void expectString(Node n, JSType type, String msg) {
        if (!type.matchesStringContext()) {
            this.mismatch(n, msg, type, JSTypeNative.STRING_TYPE);
        }
    }

    void expectNumber(Node n, JSType type, String msg) {
        if (!type.matchesNumberContext()) {
            this.mismatch(n, msg, type, JSTypeNative.NUMBER_TYPE);
        } else {
            this.expectNumberStrict(n, type, msg);
        }
    }

    void expectNumberStrict(Node n, JSType type, String msg) {
        if (!type.isSubtypeOf(this.getNativeType(JSTypeNative.NUMBER_TYPE))) {
            this.registerMismatchAndReport(n, INVALID_OPERAND_TYPE, msg, type, this.getNativeType(JSTypeNative.NUMBER_TYPE), null, null);
        }
    }

    void expectMatchingTypesStrict(Node n, JSType left, JSType right, String msg) {
        if (!left.isSubtypeOf(right) && !right.isSubtypeOf(left)) {
            this.registerMismatchAndReport(n, INVALID_OPERAND_TYPE, msg, right, left, null, null);
        }
    }

    void expectBitwiseable(Node n, JSType type, String msg) {
        if (!type.matchesNumberContext() && !type.isSubtypeOf(this.allBitwisableValueTypes)) {
            this.mismatch(n, msg, type, this.allBitwisableValueTypes);
        } else {
            this.expectNumberStrict(n, type, msg);
        }
    }

    void expectNumberOrSymbol(Node n, JSType type, String msg) {
        if (!type.matchesNumberContext() && !type.matchesSymbolContext()) {
            this.mismatch(n, msg, type, JSTypeNative.NUMBER_SYMBOL);
        }
    }

    void expectStringOrSymbol(Node n, JSType type, String msg) {
        if (!type.matchesStringContext() && !type.matchesSymbolContext()) {
            this.mismatch(n, msg, type, JSTypeNative.STRING_SYMBOL);
        }
    }

    void expectUnknownOrComparable(Node n, JSType type, String msg) {
        if (!type.isSubtypeOf(this.getNativeType(JSTypeNative.BIGINT_NUMBER_STRING)) && !type.isSubtypeOf(this.getNativeType(JSTypeNative.BIGINT_NUMBER_STRING_OBJECT))) {
            if (type.matchesNumberContext() || type.matchesStringContext()) {
                this.registerMismatchAndReport(n, INVALID_OPERAND_TYPE, msg, type, this.getNativeType(JSTypeNative.BIGINT_NUMBER_STRING), null, null);
            } else {
                this.mismatch(n, msg, type, JSTypeNative.BIGINT_NUMBER_STRING);
            }
        }
    }

    void expectStringOrNumberOrSymbol(Node n, JSType type, String msg) {
        if (!(type.matchesNumberContext() || type.matchesStringContext() || type.matchesSymbolContext())) {
            this.mismatch(n, msg, type, JSTypeNative.NUMBER_STRING_SYMBOL);
        } else {
            this.expectStringOrNumberOrSymbolStrict(n, type, msg);
        }
    }

    void expectStringOrNumberOrSymbolStrict(Node n, JSType type, String msg) {
        if (!type.isSubtypeOf(this.getNativeType(JSTypeNative.NUMBER_STRING_SYMBOL))) {
            this.registerMismatchAndReport(n, INVALID_OPERAND_TYPE, msg, type, this.getNativeType(JSTypeNative.NUMBER_STRING_SYMBOL), null, null);
        }
    }

    void expectBigIntOrNumber(Node n, JSType type, String msg) {
        if (!type.isSubtypeOf(this.getNativeType(JSTypeNative.BIGINT_NUMBER)) && !type.isSubtypeOf(this.getNativeType(JSTypeNative.BIGINT_NUMBER_OBJECT))) {
            if (type.matchesNumberContext()) {
                this.registerMismatchAndReport(n, INVALID_OPERAND_TYPE, msg, type, this.getNativeType(JSTypeNative.BIGINT_NUMBER), null, null);
            } else {
                this.mismatch(n, msg, type, JSTypeNative.BIGINT_NUMBER);
            }
        }
    }

    boolean expectNotNullOrUndefined(NodeTraversal t, Node n, JSType type, String msg, JSType expectedType) {
        if (!type.isNoType() && !type.isUnknownType() && type.isSubtypeOf(this.nullOrUndefined) && !TypeValidator.containsForwardDeclaredUnresolvedName(type)) {
            if (n.isGetProp() && !t.inGlobalScope() && type.isNullType()) {
                return true;
            }
            this.mismatch(n, msg, type, expectedType);
            return false;
        }
        return true;
    }

    private static boolean containsForwardDeclaredUnresolvedName(JSType type) {
        if (type.isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                if (!TypeValidator.containsForwardDeclaredUnresolvedName(alt)) continue;
                return true;
            }
        }
        return type.isNoResolvedType();
    }

    void expectSwitchMatchesCase(Node n, JSType switchType, JSType caseType) {
        if (!switchType.canTestForShallowEqualityWith(caseType)) {
            this.mismatch(n.getFirstChild(), "case expression doesn't match switch", caseType, switchType);
        }
    }

    void expectIndexMatch(Node n, JSType objType, JSType indexType) {
        Node indexNode;
        Preconditions.checkState(n.isGetElem() || n.isOptChainGetElem() || n.isComputedProp() || n.isComputedFieldDef(), n);
        Node node = indexNode = n.isGetElem() ? n.getLastChild() : n.getFirstChild();
        if (indexType.isSymbolValueType()) {
            return;
        }
        if (objType.isUnknownType()) {
            this.expectStringOrNumberOrSymbol(indexNode, indexType, "property access");
            return;
        }
        ObjectType dereferenced = objType.dereference();
        if (dereferenced != null && dereferenced.getTemplateTypeMap().hasTemplateKey(this.typeRegistry.getObjectIndexKey())) {
            this.expectCanAssignTo(indexNode, indexType, dereferenced.getTemplateTypeMap().getResolvedTemplateType(this.typeRegistry.getObjectIndexKey()), "restricted index type");
        } else if (dereferenced != null && dereferenced.isArrayType()) {
            this.expectNumberOrSymbol(indexNode, indexType, "array access");
        } else if (objType.isStruct()) {
            this.compiler.report(JSError.make(indexNode, ILLEGAL_PROPERTY_ACCESS, "'[]'", "struct"));
        } else if (objType.matchesObjectContext()) {
            this.expectStringOrSymbol(indexNode, indexType, "property access");
        } else {
            this.mismatch(n, "only arrays or objects can be accessed", objType, this.typeRegistry.createUnionType(JSTypeNative.ARRAY_TYPE, JSTypeNative.OBJECT_TYPE));
        }
    }

    boolean expectCanAssignToPropertyOf(Node n, JSType rightType, JSType leftType, Node owner, String propName) {
        Supplier<String> typeNameSupplier;
        if (n.isMemberFieldDef()) {
            FunctionType classType = n.getGrandparent().getJSType().assertFunctionType();
            typeNameSupplier = () -> classType.getInstanceType().toString();
        } else {
            typeNameSupplier = () -> this.typeRegistry.getReadableTypeName(owner);
        }
        return this.expectCanAssignToPropertyOf(n, rightType, leftType, this.getJSType(owner), typeNameSupplier, propName);
    }

    boolean expectCanAssignToPropertyOf(Node n, JSType rightType, JSType leftType, JSType ownerType, Supplier<String> typeNameSupplier, String propName) {
        if (leftType.isTemplateType()) {
            TemplateType left = leftType.toMaybeTemplateType();
            if (rightType.containsReferenceAncestor(left) || rightType.isUnknownType() || left.isUnknownType()) {
                return true;
            }
            this.registerMismatchAndReport(n, TYPE_MISMATCH_WARNING, "assignment to property " + propName + " of " + typeNameSupplier.get(), rightType, leftType, new HashSet<String>(), new HashSet<String>());
            return false;
        }
        if (!leftType.isNoType() && !rightType.isSubtypeOf(leftType)) {
            FunctionType ownerFn;
            if (ownerType.isFunctionPrototypeType() && (ownerFn = ownerType.toObjectType().getOwnerFunction()).isInterface() && rightType.isFunctionType() && leftType.isFunctionType()) {
                return true;
            }
            this.mismatch(n, "assignment to property " + propName + " of " + typeNameSupplier.get(), rightType, leftType);
            return false;
        }
        return true;
    }

    boolean expectCanAssignTo(Node n, JSType rightType, JSType leftType, String msg) {
        if (leftType.isTemplateType()) {
            TemplateType left = leftType.toMaybeTemplateType();
            if (rightType.containsReferenceAncestor(left) || rightType.isUnknownType() || left.isUnknownType()) {
                return true;
            }
            this.registerMismatchAndReport(n, TYPE_MISMATCH_WARNING, msg, rightType, leftType, new HashSet<String>(), new HashSet<String>());
            return false;
        }
        if (!rightType.isSubtypeOf(leftType)) {
            this.mismatch(n, msg, rightType, leftType);
            return false;
        }
        return true;
    }

    void expectArgumentMatchesParameter(Node n, JSType argType, JSType paramType, Node callNode, int ordinal) {
        if (!argType.isSubtypeOf(paramType)) {
            this.mismatch(n, SimpleFormat.format("actual parameter %d of %s does not match formal parameter", ordinal, this.typeRegistry.getReadableTypeNameNoDeref(callNode.getFirstChild())), argType, paramType);
        }
    }

    void expectSuperType(Node n, ObjectType superObject, ObjectType subObject) {
        ObjectType declaredSuper;
        FunctionType subCtor = subObject.getConstructor();
        ObjectType implicitProto = subObject.getImplicitPrototype();
        ObjectType objectType = declaredSuper = implicitProto == null ? null : implicitProto.getImplicitPrototype();
        if (declaredSuper != null && declaredSuper.isTemplatizedType()) {
            declaredSuper = declaredSuper.toMaybeTemplatizedType().getReferencedType();
        }
        if (declaredSuper != null && !(superObject instanceof UnknownType) && !declaredSuper.equals(superObject)) {
            if (declaredSuper.equals(this.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                this.registerMismatchAndReport(superObject, declaredSuper, JSError.make(n, MISSING_EXTENDS_TAG_WARNING, subObject.toString()));
            } else {
                this.mismatch(n, "mismatch in declaration of superclass type", (JSType)superObject, declaredSuper);
            }
            if (!subCtor.hasCachedValues()) {
                subCtor.setPrototypeBasedOn(superObject);
            }
        }
    }

    void expectExtends(Node n, FunctionType subCtor, FunctionType astSuperCtor) {
        if (astSuperCtor == null || !astSuperCtor.isConstructor() && !astSuperCtor.isInterface()) {
            return;
        }
        if (astSuperCtor.isConstructor() != subCtor.isConstructor()) {
            return;
        }
        ObjectType astSuperInstance = astSuperCtor.getInstanceType();
        if (subCtor.isConstructor()) {
            ObjectType registeredSuperInstance;
            FunctionType registeredSuperCtor = subCtor.getSuperClassConstructor();
            if (registeredSuperCtor != null && !astSuperInstance.equals(registeredSuperInstance = registeredSuperCtor.getInstanceType())) {
                this.mismatch(n, "mismatch in declaration of superclass type", (JSType)astSuperInstance, registeredSuperInstance);
            }
        } else if (subCtor.isInterface()) {
            // empty if block
        }
    }

    void expectCanAssignToPrototype(JSType ownerType, Node node, JSType rightType) {
        FunctionType functionType;
        if (ownerType.isFunctionType() && (functionType = ownerType.toMaybeFunctionType()).isConstructor()) {
            this.expectObject(node, rightType, "cannot override prototype with non-object");
        }
    }

    void expectCanCast(Node n, JSType targetType, JSType sourceType) {
        if (!sourceType.canCastTo(targetType)) {
            this.registerMismatchAndReport(sourceType, targetType, JSError.make(n, INVALID_CAST, sourceType.toString(), targetType.toString()));
        } else if (!sourceType.isSubtypeOf(targetType)) {
            this.mismatches.registerMismatch(n, sourceType, targetType);
        }
    }

    TypedVar expectUndeclaredVariable(String sourceName, CompilerInput input, Node n, Node parent, TypedVar var, String variableName, JSType newType) {
        TypedVar newVar = var;
        JSType varType = var.getType();
        if (varType != null && varType != this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE) && newType != null && newType != this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE)) {
            if (var.getInput() == null) {
                TypedScope s = (TypedScope)var.getScope();
                s.undeclare(var);
                newVar = s.declare(variableName, n, varType, input, false);
                n.setJSType(varType);
                if (parent.isVar()) {
                    if (n.hasChildren()) {
                        n.getFirstChild().setJSType(varType);
                    }
                } else {
                    Preconditions.checkState(parent.isFunction() || parent.isClass());
                    parent.setJSType(varType);
                }
            } else {
                boolean allowDupe = TypeValidator.hasDuplicateDeclarationSuppression(this.compiler, var.getNameNode());
                if (!allowDupe) {
                    if (!newType.equals(varType)) {
                        this.compiler.report(JSError.make(n, DUP_VAR_DECLARATION_TYPE_MISMATCH, variableName, newType.toString(), var.getInputName(), String.valueOf(var.getNameNode().getLineno()), varType.toString()));
                    } else if (!var.getParentNode().isExprResult()) {
                        this.compiler.report(JSError.make(n, DUP_VAR_DECLARATION, variableName, var.getInputName(), String.valueOf(var.getNameNode().getLineno())));
                    }
                }
            }
        }
        return newVar;
    }

    void expectAllInterfaceProperties(Node n, FunctionType type) {
        ObjectType instance = type.getInstanceType();
        for (ObjectType implemented : type.getAllImplementedInterfaces()) {
            this.expectInterfaceProperties(n, instance, implemented);
        }
        for (ObjectType extended : type.getExtendedInterfaces()) {
            this.expectInterfaceProperties(n, instance, extended);
        }
    }

    private void expectInterfaceProperties(Node n, ObjectType instance, ObjectType ancestorInterface) {
        for (String prop : ancestorInterface.getOwnPropertyNames()) {
            this.expectInterfaceProperty(n, instance, ancestorInterface, prop);
        }
        if (ancestorInterface.getImplicitPrototype() != null) {
            for (String prop : ancestorInterface.getImplicitPrototype().getOwnPropertyNames()) {
                this.expectInterfaceProperty(n, instance, ancestorInterface, prop);
            }
        }
    }

    private void expectInterfaceProperty(Node n, ObjectType instance, ObjectType implementedInterface, String propName) {
        Property.OwnedProperty propSlot = instance.findClosestDefinition(propName);
        if (propSlot == null || !instance.getConstructor().isInterface() && propSlot.isOwnedByInterface()) {
            if (instance.getConstructor().isAbstract() || instance.getConstructor().isInterface()) {
                return;
            }
            if (implementedInterface.getPropertyType(propName).isVoidable()) {
                return;
            }
            this.registerMismatchAndReport(instance, implementedInterface, JSError.make(n, INTERFACE_METHOD_NOT_IMPLEMENTED, propName, implementedInterface.getReferenceName(), instance.toString()));
        } else {
            boolean local = propSlot.getOwnerInstanceType().equals(instance);
            if (!local && instance.getConstructor().isInterface()) {
                return;
            }
            Property prop = propSlot.getValue();
            Node propNode = prop.getDeclaration() == null ? null : prop.getDeclaration().getNode();
            propNode = propNode == null ? n : propNode;
            this.checkPropertyType(propNode, instance, implementedInterface, propName, prop.getType());
        }
    }

    void checkPropertyType(Node n, JSType instance, ObjectType parent, String propertyName, JSType found) {
        JSType required = parent.getPropertyType(propertyName);
        TemplateTypeMap typeMap = instance.getTemplateTypeMap();
        if (!typeMap.isEmpty() && required.hasAnyTemplateTypes()) {
            required = required.visit(TemplateTypeReplacer.forPartialReplacement(this.typeRegistry, typeMap));
        }
        if (found.isSubtypeOf(required, this.subtypingMode)) {
            return;
        }
        JSError err = JSError.make(n, parent.getConstructor().isInterface() ? HIDDEN_INTERFACE_PROPERTY_MISMATCH : HIDDEN_SUPERCLASS_PROPERTY_MISMATCH, propertyName, parent.getReferenceName(), required.toString(), found.toString(), instance.toString());
        this.registerMismatchAndReport(found, required, err);
    }

    void expectAbstractMethodsImplemented(Node n, FunctionType ctorType) {
        FunctionType currSuperCtor;
        Preconditions.checkArgument(ctorType.isConstructor());
        LinkedHashMap<String, ObjectType> abstractMethodSuperTypeMap = new LinkedHashMap<String, ObjectType>();
        if (currSuperCtor == null || !currSuperCtor.isAbstract()) {
            return;
        }
        for (currSuperCtor = ctorType.getSuperClassConstructor(); currSuperCtor != null && currSuperCtor.isAbstract(); currSuperCtor = currSuperCtor.getSuperClassConstructor()) {
            ObjectType superType = currSuperCtor.getInstanceType();
            for (String string : currSuperCtor.getPrototype().getOwnPropertyNames()) {
                FunctionType maybeAbstractMethod = superType.findPropertyType(string).toMaybeFunctionType();
                if (maybeAbstractMethod == null || !maybeAbstractMethod.isAbstract() || abstractMethodSuperTypeMap.containsKey(string)) continue;
                abstractMethodSuperTypeMap.put(string, superType);
            }
        }
        ObjectType instance = ctorType.getInstanceType();
        for (Map.Entry entry : abstractMethodSuperTypeMap.entrySet()) {
            String method = (String)entry.getKey();
            ObjectType superType = (ObjectType)entry.getValue();
            FunctionType abstractMethod = instance.findPropertyType(method).toMaybeFunctionType();
            if (abstractMethod != null && !abstractMethod.isAbstract()) continue;
            this.registerMismatchAndReport(instance, superType, JSError.make(n, ABSTRACT_METHOD_NOT_IMPLEMENTED, method, superType.toString(), instance.toString()));
        }
    }

    private void mismatch(Node n, String msg, JSType found, JSTypeNative required) {
        this.mismatch(n, msg, found, this.getNativeType(required));
    }

    private void mismatch(Node n, String msg, JSType found, JSType required) {
        if (!found.isSubtypeOf(required, this.subtypingMode)) {
            JSType restrictedType;
            TreeSet<String> missing = null;
            TreeSet<String> mismatch = null;
            JSType structuralType = null;
            if (required.isStructuralType()) {
                structuralType = required;
            } else if (required.isUnionType() && (restrictedType = required.restrictByNotNullOrUndefined()).isStructuralType()) {
                structuralType = restrictedType;
            }
            if (structuralType != null) {
                missing = new TreeSet<String>();
                mismatch = new TreeSet<String>();
                ObjectType requiredObject = structuralType.toMaybeObjectType();
                ObjectType foundObject = found.toMaybeObjectType();
                if (requiredObject != null && foundObject != null) {
                    for (String property : requiredObject.getPropertyNames()) {
                        JSType propRequired = requiredObject.getPropertyType(property);
                        boolean hasProperty = foundObject.hasProperty(property);
                        if (propRequired.isExplicitlyVoidable() && !hasProperty) continue;
                        if (hasProperty) {
                            if (foundObject.getPropertyType(property).isSubtypeOf(propRequired, this.subtypingMode)) continue;
                            mismatch.add(property);
                            continue;
                        }
                        missing.add(property);
                    }
                }
            }
            this.registerMismatchAndReport(n, TYPE_MISMATCH_WARNING, msg, found, required, missing, mismatch);
        }
    }

    private void registerMismatchAndReport(Node n, DiagnosticType diagnostic, String msg, JSType found, JSType required, Set<String> missing, Set<String> mismatch) {
        String foundRequiredFormatted = TypeValidator.formatFoundRequired(msg, found, required, missing, mismatch);
        JSError err = JSError.make(n, diagnostic, foundRequiredFormatted);
        this.registerMismatchAndReport(found, required, err);
    }

    private void registerMismatchAndReport(JSType found, JSType required, JSError error) {
        this.compiler.report(error);
        this.mismatches.registerMismatch(error.getNode(), found, required);
    }

    private static String formatFoundRequired(String description, JSType found, JSType required, Set<String> missing, Set<String> mismatch) {
        String requiredStr;
        String foundStr = found.toString();
        if (foundStr.equals(requiredStr = required.toString())) {
            foundStr = found.toAnnotationString(JSType.Nullability.IMPLICIT);
            requiredStr = required.toAnnotationString(JSType.Nullability.IMPLICIT);
        }
        String missingStr = "";
        String mismatchStr = "";
        if (missing != null && !missing.isEmpty()) {
            missingStr = Joiner.on(",").join(missing);
        }
        if (mismatch != null && !mismatch.isEmpty()) {
            mismatchStr = Joiner.on(",").join(mismatch);
        }
        if (missingStr.length() > 0 || mismatchStr.length() > 0) {
            return Platform.formatMessage(FOUND_REQUIRED_MISSING, description, foundStr, requiredStr, missingStr, mismatchStr);
        }
        return Platform.formatMessage(FOUND_REQUIRED, description, foundStr, requiredStr);
    }

    private JSType getJSType(Node n) {
        return Preconditions.checkNotNull(n.getJSType(), "%s has no JSType attached", (Object)n);
    }

    private JSType getNativeType(JSTypeNative typeId) {
        return this.typeRegistry.getNativeType(typeId);
    }

    static boolean hasDuplicateDeclarationSuppression(AbstractCompiler compiler, Node decl) {
        CheckLevel originalDeclLevel = compiler.getErrorLevel(JSError.make(decl, DUP_VAR_DECLARATION, "dummy", "dummy"));
        return originalDeclLevel == CheckLevel.OFF;
    }

    void expectWellFormedTemplatizedType(Node n) {
        WellFormedTemplatizedTypeVerifier verifier = new WellFormedTemplatizedTypeVerifier(n);
        if (n.getJSType() != null) {
            n.getJSType().visit(verifier);
        }
    }

    final class WellFormedTemplatizedTypeVerifier
    extends Visitor.WithDefaultCase<Boolean> {
        Node node;

        WellFormedTemplatizedTypeVerifier(Node node) {
            this.node = node;
        }

        @Override
        protected Boolean caseDefault(@Nullable JSType type) {
            return true;
        }

        @Override
        public Boolean caseEnumElementType(EnumElementType type) {
            return type.getPrimitiveType() == null || type.getPrimitiveType().visit(this) != false;
        }

        @Override
        public Boolean caseFunctionType(FunctionType type) {
            for (FunctionType.Parameter param : type.getParameters()) {
                if (param.getJSType().visit(this).booleanValue()) continue;
                return false;
            }
            return type.getReturnType().visit(this);
        }

        @Override
        public Boolean caseNamedType(NamedType type) {
            return type.getReferencedType().visit(this);
        }

        @Override
        public Boolean caseUnionType(UnionType type) {
            for (JSType alt : type.getAlternates()) {
                if (alt.visit(this).booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean caseTemplatizedType(TemplatizedType type) {
            ImmutableList<TemplateType> referencedTemplates = type.getReferencedType().getTemplateTypeMap().getTemplateKeys();
            for (int i = 0; i < type.getTemplateTypes().size(); ++i) {
                TemplateType templateType;
                JSType assignedType = (JSType)type.getTemplateTypes().get(i);
                if (i >= referencedTemplates.size() || assignedType.isSubtype((templateType = (TemplateType)referencedTemplates.get(i)).getBound())) continue;
                TypeValidator.this.registerMismatchAndReport(assignedType, templateType.getBound(), JSError.make(this.node, RhinoErrorReporter.BOUNDED_GENERIC_TYPE_ERROR, assignedType.toString(), templateType.getReferenceName(), templateType.getBound().toString()));
                return false;
            }
            return true;
        }

        @Override
        public Boolean caseTemplateType(TemplateType templateType) {
            return !templateType.containsCycle() && templateType.getBound().visit(this) != false;
        }
    }
}

