/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstValidator;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ForbiddenChange;
import com.google.javascript.jscomp.GatherExternProperties;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.rhino.Node;

class ValidityCheck
implements CompilerPass {
    static final DiagnosticType CANNOT_PARSE_GENERATED_CODE = DiagnosticType.error("JSC_CANNOT_PARSE_GENERATED_CODE", "Internal compiler error. Cannot parse generated code: {0}");
    static final DiagnosticType GENERATED_BAD_CODE = DiagnosticType.error("JSC_GENERATED_BAD_CODE", "Internal compiler error. Generated bad code.----------------------------------------\nExpected:\n{0}\n----------------------------------------\nActual:\n{1}");
    static final DiagnosticType EXTERN_PROPERTIES_CHANGED = DiagnosticType.error("JSC_EXTERN_PROPERTIES_CHANGED", "Internal compiler error. Extern properties modified from:\n{0}\nto:\n{1}");
    private final AbstractCompiler compiler;
    private final AstValidator astValidator;

    ValidityCheck(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astValidator = new AstValidator(compiler);
    }

    @Override
    public void process(Node externs, Node root) {
        this.checkAst(externs, root);
        this.checkNormalization(externs, root);
        this.checkVars(externs, root);
        this.checkExternProperties(externs);
    }

    private void checkAst(Node externs, Node root) {
        this.astValidator.validateCodeRoot(externs);
        this.astValidator.validateCodeRoot(root);
    }

    private void checkVars(Node externs, Node root) {
        if (this.compiler.getLifeCycleStage().isNormalized()) {
            new VarCheck(this.compiler, true).process(externs, root);
        }
    }

    private void checkNormalization(Node externs, Node root) {
        ForbiddenChange handler = new ForbiddenChange();
        this.compiler.addChangeHandler(handler);
        if (this.compiler.getLifeCycleStage().isNormalized()) {
            new Normalize(this.compiler, true).process(externs, root);
            if (this.compiler.getLifeCycleStage().isNormalizedUnobfuscated()) {
                boolean checkUserDeclarations = true;
                Normalize.VerifyConstants pass = new Normalize.VerifyConstants(this.compiler, checkUserDeclarations);
                pass.process(externs, root);
            }
        }
        this.compiler.removeChangeHandler(handler);
    }

    private void checkExternProperties(Node externs) {
        ImmutableSet<String> externProperties = this.compiler.getExternProperties();
        if (externProperties == null) {
            return;
        }
        new GatherExternProperties(this.compiler, GatherExternProperties.Mode.CHECK).process(externs, null);
        if (!this.compiler.getExternProperties().equals(externProperties)) {
            this.compiler.report(JSError.make(EXTERN_PROPERTIES_CHANGED, ((Object)externProperties).toString(), this.compiler.getExternProperties().toString()));
            throw new IllegalStateException("Validity Check failed: Extern properties changed from:\n" + externProperties + "\nto:\n" + this.compiler.getExternProperties());
        }
    }
}

