/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.base;

import java.util.Locale;

public enum Tri {
    FALSE(-1),
    UNKNOWN(0),
    TRUE(1);

    private final int value;
    private static final Tri[] VALUES;

    private Tri(int value) {
        this.value = value;
    }

    public Tri or(Tri x) {
        return this.value > x.value ? this : x;
    }

    public Tri and(Tri x) {
        return this.value < x.value ? this : x;
    }

    public Tri xor(Tri x) {
        return Tri.forInt(-this.value * x.value);
    }

    public Tri not() {
        return Tri.forInt(-this.value);
    }

    public boolean toBoolean(boolean x) {
        switch (this) {
            case FALSE: {
                return false;
            }
            case UNKNOWN: {
                return x;
            }
            case TRUE: {
                return true;
            }
        }
        throw new AssertionError((Object)this);
    }

    public static Tri forBoolean(boolean x) {
        return x ? TRUE : FALSE;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    private static Tri forInt(int x) {
        return VALUES[x + 1];
    }

    static {
        VALUES = Tri.values();
    }
}

