/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.colors;

import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.ColorId;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSetMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.MultimapBuilder;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.SetMultimap;
import java.util.LinkedHashMap;

public final class ColorRegistry {
    private final ImmutableMap<ColorId, Color> nativeColors;
    private final ImmutableSetMultimap<Color, Color> colorToDisambiguationSupertypeGraph;
    private final ImmutableSetMultimap<ColorId, String> mismatchLocations;
    public static final ImmutableSet<ColorId> REQUIRED_IDS = StandardColors.STANDARD_OBJECT_IDS;

    private ColorRegistry(Builder builder) {
        this.nativeColors = ImmutableMap.copyOf(builder.nativeColors);
        this.colorToDisambiguationSupertypeGraph = ImmutableSetMultimap.copyOf(builder.colorToDisambiguationSupertypeGraph);
        this.mismatchLocations = ImmutableSetMultimap.copyOf(builder.mismatchLocations);
        Preconditions.checkState(((ImmutableSet)this.nativeColors.keySet()).equals(REQUIRED_IDS));
    }

    public final Color get(ColorId id) {
        Preconditions.checkNotNull(id);
        return Preconditions.checkNotNull(this.nativeColors.get(id), "Missing Color for %s", (Object)id);
    }

    public final ImmutableSet<Color> getDisambiguationSupertypes(Color x) {
        return this.colorToDisambiguationSupertypeGraph.get((Object)x);
    }

    public final ImmutableSetMultimap<ColorId, String> getMismatchLocationsForDebugging() {
        return this.mismatchLocations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final LinkedHashMap<ColorId, Color> nativeColors = new LinkedHashMap();
        private final SetMultimap<Color, Color> colorToDisambiguationSupertypeGraph = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        private final SetMultimap<ColorId, String> mismatchLocations = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();

        private Builder() {
        }

        public Builder setNativeColor(Color x) {
            Preconditions.checkState(REQUIRED_IDS.contains(x.getId()), x);
            this.nativeColors.put(x.getId(), x);
            return this;
        }

        public Builder addDisambiguationEdge(Color subtype, Color supertype) {
            this.colorToDisambiguationSupertypeGraph.put(subtype, supertype);
            return this;
        }

        public Builder addMismatchLocation(ColorId id, String location) {
            this.mismatchLocations.put(id, location);
            return this;
        }

        @VisibleForTesting
        public Builder setDefaultNativeColorsForTesting() {
            for (ColorId id : REQUIRED_IDS) {
                this.setNativeColor(Color.singleBuilder().setId(id).build());
            }
            return this;
        }

        public ColorRegistry build() {
            return new ColorRegistry(this);
        }
    }
}

