/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.deps.AutoValue_BrowserWithTransformedPrefixesModuleResolver_PrefixReplacement;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.deps.ModuleResolver;
import com.google.javascript.jscomp.jarjar.com.google.auto.value.AutoValue;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSortedSet;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;

public class BrowserWithTransformedPrefixesModuleResolver
extends ModuleResolver {
    static final DiagnosticType INVALID_AMBIGUOUS_PATH = DiagnosticType.error("JSC_INVALID_AMBIGUOUS_PATH", "The path \"{0}\" is invalid. Expected any of the following prefixes for non-relative paths: {1}.");
    private final ImmutableSet<PrefixReplacement> prefixReplacements;
    private final String expectedPrefixes;

    public BrowserWithTransformedPrefixesModuleResolver(ImmutableSet<String> modulePaths, ImmutableList<String> moduleRootPaths, ErrorHandler errorHandler, ModuleLoader.PathEscaper pathEscaper, ImmutableMap<String, String> prefixReplacements) {
        super(modulePaths, moduleRootPaths, errorHandler, pathEscaper);
        Set p = prefixReplacements.entrySet().stream().map(entry -> PrefixReplacement.of((String)entry.getKey(), (String)entry.getValue())).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.comparingInt(r -> r.prefix().length()).reversed().thenComparing(PrefixReplacement::prefix)));
        this.prefixReplacements = ImmutableSet.copyOf(p);
        this.expectedPrefixes = this.prefixReplacements.stream().map(PrefixReplacement::prefix).sorted().collect(Collectors.joining(", "));
    }

    @Override
    @Nullable
    public String resolveJsModule(String scriptAddress, String moduleAddress, String sourcename, int lineno, int colno) {
        String transformedAddress = moduleAddress;
        boolean replaced = false;
        for (PrefixReplacement prefixReplacement : this.prefixReplacements) {
            if (!moduleAddress.startsWith(prefixReplacement.prefix())) continue;
            transformedAddress = prefixReplacement.replacement() + moduleAddress.substring(prefixReplacement.prefix().length());
            replaced = true;
            break;
        }
        if (!replaced && ModuleLoader.isAmbiguousIdentifier(transformedAddress)) {
            this.errorHandler.report(CheckLevel.WARNING, JSError.make(sourcename, lineno, colno, INVALID_AMBIGUOUS_PATH, transformedAddress, this.expectedPrefixes));
            return null;
        }
        String loadAddress = this.locate(scriptAddress, transformedAddress);
        if (transformedAddress == null) {
            this.errorHandler.report(CheckLevel.WARNING, JSError.make(sourcename, lineno, colno, ModuleLoader.LOAD_WARNING, moduleAddress));
        }
        return loadAddress;
    }

    @Override
    public String resolveModuleAsPath(String scriptAddress, String moduleAddress) {
        if (ModuleLoader.isRelativeIdentifier(moduleAddress)) {
            return super.resolveModuleAsPath(scriptAddress, moduleAddress);
        }
        String transformedAddress = moduleAddress;
        for (PrefixReplacement prefixReplacement : this.prefixReplacements) {
            if (!moduleAddress.startsWith(prefixReplacement.prefix())) continue;
            transformedAddress = prefixReplacement.replacement() + moduleAddress.substring(prefixReplacement.prefix().length());
            break;
        }
        return ModuleLoader.normalize(transformedAddress, this.moduleRootPaths);
    }

    @AutoValue
    static abstract class PrefixReplacement {
        PrefixReplacement() {
        }

        abstract String prefix();

        abstract String replacement();

        public static PrefixReplacement of(String prefix, String replacement) {
            return new AutoValue_BrowserWithTransformedPrefixesModuleResolver_PrefixReplacement(prefix, replacement);
        }
    }

    public static final class Factory
    implements ModuleLoader.ModuleResolverFactory {
        private final ImmutableMap<String, String> prefixReplacements;

        public Factory(ImmutableMap<String, String> prefixReplacements) {
            this.prefixReplacements = prefixReplacements;
        }

        @Override
        public ModuleResolver create(ImmutableSet<String> modulePaths, ImmutableList<String> moduleRootPaths, ErrorHandler errorHandler, ModuleLoader.PathEscaper pathEscaper) {
            return new BrowserWithTransformedPrefixesModuleResolver(modulePaths, moduleRootPaths, errorHandler, pathEscaper, this.prefixReplacements);
        }
    }
}

