/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.disambiguate.ColorGraphNode;
import com.google.javascript.jscomp.disambiguate.ColorGraphNodeFactory;
import com.google.javascript.jscomp.disambiguate.PropertyClustering;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.function.Function;

final class ColorFindPropertyReferences
extends NodeTraversal.AbstractPostOrderCallback {
    private LinkedHashMap<String, PropertyClustering> propIndex = new LinkedHashMap();
    private final ColorGraphNodeFactory colorGraphNodeFactory;
    private final IsPropertyReflector isPropertyReflector;

    ColorFindPropertyReferences(ColorGraphNodeFactory colorGraphNodeFactory, IsPropertyReflector isPropertyReflector) {
        this.colorGraphNodeFactory = colorGraphNodeFactory;
        this.isPropertyReflector = isPropertyReflector;
    }

    LinkedHashMap<String, PropertyClustering> getPropertyIndex() {
        LinkedHashMap<String, PropertyClustering> tmp = this.propIndex;
        this.propIndex = null;
        return tmp;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case GETPROP: 
            case OPTCHAIN_GETPROP: {
                this.registerPropertyUse(n, n.getFirstChild().getColor());
                break;
            }
            case OBJECTLIT: {
                this.handleObjectLit(n);
                break;
            }
            case CALL: {
                this.handleCall(n);
                break;
            }
            case CLASS: {
                this.handleClass(n);
                break;
            }
            case OBJECT_PATTERN: {
                this.handleObjectPattern(n);
                break;
            }
            case FUNCTION: {
                this.handleFunction(n);
                break;
            }
        }
    }

    private void handleObjectLit(Node n) {
        if (n.getParent().isCall() && NodeUtil.isObjectDefinePropertiesDefinition(n.getParent())) {
            return;
        }
        Color owner = n.getColor();
        this.traverseObjectlitLike(n, m -> owner);
    }

    private void handleCall(Node call) {
        Node target = call.getFirstChild();
        if (!target.isQualifiedName()) {
            return;
        }
        if (this.isPropertyReflector.test(target)) {
            this.handlePropertyReflectorCall(call);
        } else if (NodeUtil.isObjectDefinePropertiesDefinition(call)) {
            this.handleObjectDefineProperties(call);
        }
    }

    private void handleClass(Node classNode) {
        Color classType = classNode.getColor();
        this.traverseObjectlitLike(NodeUtil.getClassMembers(classNode), m -> {
            if (m.isStaticMember()) {
                return classType;
            }
            if (m.isMemberFieldDef()) {
                ImmutableSet<Color> classInstanceType = classType.getInstanceColors();
                return classInstanceType.isEmpty() ? StandardColors.UNKNOWN : Color.createUnion(classInstanceType);
            }
            Preconditions.checkState(m.isMemberFunctionDef() || m.isGetterDef() || m.isSetterDef(), m);
            ImmutableSet<Color> classPrototypeType = classType.getPrototypes();
            return classPrototypeType.isEmpty() ? StandardColors.UNKNOWN : Color.createUnion(classPrototypeType);
        });
        this.colorGraphNodeFactory.createNode(classType);
    }

    private void handleFunction(Node fnNode) {
        Color fnType = fnNode.getColor();
        if (fnType != null && !fnType.getInstanceColors().isEmpty()) {
            this.colorGraphNodeFactory.createNode(fnType);
        }
    }

    private void handleObjectPattern(Node pattern) {
        Color owner = pattern.getColor();
        this.traverseObjectlitLike(pattern, m -> owner);
    }

    private void handlePropertyReflectorCall(Node call) {
        Node name = call.getSecondChild();
        if (name == null || !name.isStringLit()) {
            return;
        }
        Node obj = name.getNext();
        Color objColor = obj == null ? null : obj.getColor();
        this.registerPropertyUse(name, objColor);
    }

    private void handleObjectDefineProperties(Node call) {
        Node typeObj = call.getSecondChild();
        Node objectLiteral = typeObj.getNext();
        if (!objectLiteral.isObjectLit()) {
            return;
        }
        Color type = typeObj.getColor();
        this.traverseObjectlitLike(objectLiteral, m -> type);
    }

    private void traverseObjectlitLike(Node n, Function<Node, Color> memberOwnerFn) {
        Preconditions.checkState(n.isObjectLit() || n.isObjectPattern() || n.isClassMembers());
        block4: for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            switch (child.getToken()) {
                case COMPUTED_PROP: 
                case COMPUTED_FIELD_DEF: 
                case OBJECT_REST: 
                case OBJECT_SPREAD: {
                    continue block4;
                }
                case STRING_KEY: 
                case MEMBER_FUNCTION_DEF: 
                case MEMBER_FIELD_DEF: 
                case GETTER_DEF: 
                case SETTER_DEF: {
                    if (child.isQuotedString()) continue block4;
                    this.registerPropertyUse(child, memberOwnerFn.apply(child));
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unexpected child of " + (Object)((Object)n.getToken()) + ": " + child.toStringTree());
                }
            }
        }
    }

    private void registerPropertyUse(Node site, Color owner) {
        PropertyClustering prop = this.propIndex.computeIfAbsent(site.getString(), PropertyClustering::new);
        ColorGraphNode flatOwner = this.colorGraphNodeFactory.createNode(owner);
        flatOwner.getAssociatedProps().put(prop, ColorGraphNode.PropAssociation.AST);
        prop.getClusters().add(flatOwner);
        prop.getUseSites().put(site, flatOwner);
        if (site.isFromExterns() || owner != null && owner.getPropertiesKeepOriginalName()) {
            prop.registerOriginalNameType(flatOwner);
        }
    }

    @FunctionalInterface
    static interface IsPropertyReflector {
        public boolean test(Node var1);
    }
}

