/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.javascript.jscomp.disambiguate.ColorGraphNode;
import com.google.javascript.jscomp.disambiguate.Invalidation;
import com.google.javascript.jscomp.graph.StandardUnionFind;
import com.google.javascript.jscomp.jarjar.com.google.common.base.MoreObjects;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.errorprone.annotations.DoNotCall;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;

final class PropertyClustering {
    private final String name;
    private final LinkedHashMap<Node, ColorGraphNode> useSites = new LinkedHashMap();
    private final StandardUnionFind<ColorGraphNode> clusters = new StandardUnionFind();
    @Nullable
    private ColorGraphNode originalNameClusterRep;
    @Nullable
    private Invalidation lastInvalidation;

    PropertyClustering(String name) {
        this.name = Preconditions.checkNotNull(name);
    }

    String getName() {
        return this.name;
    }

    LinkedHashMap<Node, ColorGraphNode> getUseSites() {
        return this.useSites;
    }

    StandardUnionFind<ColorGraphNode> getClusters() {
        return this.clusters;
    }

    @Nullable
    ColorGraphNode getOriginalNameClusterRep() {
        Preconditions.checkState(!this.isInvalidated());
        return this.originalNameClusterRep == null ? null : this.clusters.find(this.originalNameClusterRep);
    }

    boolean isInvalidated() {
        return this.lastInvalidation != null;
    }

    void invalidate(Invalidation invalidation) {
        this.lastInvalidation = Preconditions.checkNotNull(invalidation);
    }

    Invalidation getLastInvalidation() {
        Preconditions.checkState(this.isInvalidated());
        return this.lastInvalidation;
    }

    void registerOriginalNameType(ColorGraphNode type) {
        Preconditions.checkState(!this.isInvalidated());
        if (this.originalNameClusterRep == null) {
            this.originalNameClusterRep = type;
        }
        this.clusters.union(this.originalNameClusterRep, type);
    }

    @DoNotCall
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).toString();
    }
}

