/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Predicate;

public final class CheckPathsBetweenNodes<N, E> {
    private final Predicate<N> nodePredicate;
    private final Predicate<DiGraph.DiGraphEdge<N, E>> edgePredicate;
    private final boolean inclusive;
    private static final Annotation BACK_EDGE = new Annotation(){};
    private static final Annotation VISITED_EDGE = new Annotation(){};
    private static final Annotation WHITE = null;
    private static final Annotation GRAY = new Annotation(){};
    private static final Annotation BLACK = new Annotation(){};
    private final DiGraph<N, E> graph;
    private final DiGraph.DiGraphNode<N, E> start;
    private final DiGraph.DiGraphNode<N, E> end;

    public CheckPathsBetweenNodes(DiGraph<N, E> graph, DiGraph.DiGraphNode<N, E> a, DiGraph.DiGraphNode<N, E> b, Predicate<N> nodePredicate, Predicate<DiGraph.DiGraphEdge<N, E>> edgePredicate, boolean inclusive) {
        this.graph = graph;
        this.start = a;
        this.end = b;
        this.nodePredicate = nodePredicate;
        this.edgePredicate = edgePredicate;
        this.inclusive = inclusive;
    }

    public CheckPathsBetweenNodes(DiGraph<N, E> graph, DiGraph.DiGraphNode<N, E> a, DiGraph.DiGraphNode<N, E> b, Predicate<N> nodePredicate, Predicate<DiGraph.DiGraphEdge<N, E>> edgePredicate) {
        this(graph, a, b, nodePredicate, edgePredicate, true);
    }

    public boolean allPathsSatisfyPredicate() {
        this.setUp();
        boolean result = this.checkAllPathsWithoutBackEdges(this.start, this.end);
        this.tearDown();
        return result;
    }

    public boolean somePathsSatisfyPredicate() {
        this.setUp();
        boolean result = this.checkSomePathsWithoutBackEdges(this.start, this.end);
        this.tearDown();
        return result;
    }

    private void setUp() {
        this.graph.pushNodeAnnotations();
        this.graph.pushEdgeAnnotations();
        this.discoverBackEdges(this.start);
    }

    private void tearDown() {
        this.graph.popNodeAnnotations();
        this.graph.popEdgeAnnotations();
    }

    private void discoverBackEdges(DiGraph.DiGraphNode<N, E> u) {
        u.setAnnotation(GRAY);
        for (DiGraph.DiGraphEdge<N, E> e : u.getOutEdges()) {
            if (this.ignoreEdge(e)) continue;
            DiGraph.DiGraphNode<N, E> v = e.getDestination();
            if (v.getAnnotation() == WHITE) {
                this.discoverBackEdges(v);
                continue;
            }
            if (v.getAnnotation() != GRAY) continue;
            e.setAnnotation(BACK_EDGE);
        }
        u.setAnnotation(BLACK);
    }

    private boolean ignoreEdge(DiGraph.DiGraphEdge<N, E> e) {
        return !this.edgePredicate.apply(e);
    }

    private boolean checkAllPathsWithoutBackEdges(DiGraph.DiGraphNode<N, E> a, DiGraph.DiGraphNode<N, E> b) {
        if (this.nodePredicate.apply(a.getValue()) && (this.inclusive || a != this.start && a != this.end)) {
            return true;
        }
        if (a == b) {
            return false;
        }
        for (DiGraph.DiGraphEdge<N, E> e : a.getOutEdges()) {
            DiGraph.DiGraphNode<N, E> next;
            if (e.getAnnotation() == VISITED_EDGE) continue;
            e.setAnnotation(VISITED_EDGE);
            if (this.ignoreEdge(e) || e.getAnnotation() == BACK_EDGE || this.checkAllPathsWithoutBackEdges(next = e.getDestination(), b)) continue;
            return false;
        }
        return true;
    }

    private boolean checkSomePathsWithoutBackEdges(DiGraph.DiGraphNode<N, E> a, DiGraph.DiGraphNode<N, E> b) {
        if (this.nodePredicate.apply(a.getValue()) && (this.inclusive || a != this.start && a != this.end)) {
            return true;
        }
        if (a == b) {
            return false;
        }
        for (DiGraph.DiGraphEdge<N, E> e : a.getOutEdges()) {
            DiGraph.DiGraphNode<N, E> next;
            if (e.getAnnotation() == VISITED_EDGE) continue;
            e.setAnnotation(VISITED_EDGE);
            if (this.ignoreEdge(e) || e.getAnnotation() == BACK_EDGE || !this.checkSomePathsWithoutBackEdges(next = e.getDestination(), b)) continue;
            return true;
        }
        return false;
    }
}

