/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.instrumentation;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.instrumentation.CoverageUtil;
import com.google.javascript.jscomp.instrumentation.FileInstrumentationData;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@GwtIncompatible(value="FileInstrumentationData")
public class BranchCoverageInstrumentationCallback
extends NodeTraversal.AbstractPostOrderCallback {
    private final AbstractCompiler compiler;
    private final Map<String, FileInstrumentationData> instrumentationData;
    private static final String BRANCH_ARRAY_NAME_PREFIX = "JSCompiler_lcov_branch_data_";

    private static String createArrayName(NodeTraversal traversal) {
        return BRANCH_ARRAY_NAME_PREFIX + CoverageUtil.createIdentifierFromText(traversal.getSourceName());
    }

    public BranchCoverageInstrumentationCallback(AbstractCompiler compiler, Map<String, FileInstrumentationData> instrumentationData) {
        this.compiler = compiler;
        this.instrumentationData = instrumentationData;
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        String fileName = traversal.getSourceName();
        if (!Objects.equals(fileName, node.getSourceFileName())) {
            return;
        }
        if (node.isScript() && this.instrumentationData.get(fileName) != null) {
            Node toAddTo = node.hasChildren() && node.getFirstChild().isModuleBody() ? node.getFirstChild() : node;
            toAddTo.addChildrenToFront(this.newHeaderNode(traversal, toAddTo).removeChildren());
            this.compiler.reportChangeToEnclosingScope(node);
            this.instrumentBranchCoverage(traversal, this.instrumentationData.get(fileName));
        }
        if (node.isIf()) {
            ControlFlowGraph<Node> cfg = traversal.getControlFlowGraph();
            boolean hasDefaultBlock = false;
            for (DiGraph.DiGraphEdge diGraphEdge : cfg.getOutEdges(node)) {
                if (diGraphEdge.getValue() != ControlFlowGraph.Branch.ON_FALSE) continue;
                Node destination = (Node)diGraphEdge.getDestination().getValue();
                if (destination == null || !destination.isBlock() || destination.getParent() == null || !destination.getParent().isIf()) break;
                hasDefaultBlock = true;
                break;
            }
            if (!hasDefaultBlock) {
                this.addDefaultBlock(node);
            }
            this.instrumentationData.computeIfAbsent(fileName, k -> new FileInstrumentationData((String)k, BranchCoverageInstrumentationCallback.createArrayName(traversal)));
            this.processBranchInfo(node, this.instrumentationData.get(fileName), this.getChildrenBlocks(node));
        } else if (NodeUtil.isLoopStructure(node)) {
            List<Node> blocks = this.getChildrenBlocks(node);
            ControlFlowGraph<Node> cfg = traversal.getControlFlowGraph();
            for (DiGraph.DiGraphEdge diGraphEdge : cfg.getOutEdges(node)) {
                if (diGraphEdge.getValue() != ControlFlowGraph.Branch.ON_FALSE) continue;
                Node destination = (Node)diGraphEdge.getDestination().getValue();
                if (destination != null && destination.isBlock()) {
                    blocks.add(destination);
                    continue;
                }
                Node exitBlock = IR.block();
                if (destination != null && destination.getParent().isBlock()) {
                    exitBlock.insertBefore(destination);
                } else {
                    exitBlock.insertAfter((Node)diGraphEdge.getSource().getValue());
                }
                blocks.add(exitBlock);
            }
            this.instrumentationData.computeIfAbsent(fileName, k -> new FileInstrumentationData((String)k, BranchCoverageInstrumentationCallback.createArrayName(traversal)));
            this.processBranchInfo(node, this.instrumentationData.get(fileName), blocks);
        }
    }

    private List<Node> getChildrenBlocks(Node node) {
        ArrayList<Node> blocks = new ArrayList<Node>();
        for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isBlock()) continue;
            blocks.add(child);
        }
        return blocks;
    }

    private void instrumentBranchCoverage(NodeTraversal traversal, FileInstrumentationData data) {
        int maxLine = data.maxBranchPresentLine();
        int branchCoverageOffset = 0;
        for (int lineIdx = 1; lineIdx <= maxLine; ++lineIdx) {
            Integer numBranches = data.getNumBranches(lineIdx);
            if (numBranches == null) continue;
            for (int branchIdx = 1; branchIdx <= numBranches; ++branchIdx) {
                Node block = data.getBranchNode(lineIdx, branchIdx);
                block.addChildToFront(this.newBranchInstrumentationNode(traversal, block, branchCoverageOffset + branchIdx - 1));
                this.compiler.reportChangeToEnclosingScope(block);
            }
            branchCoverageOffset += numBranches.intValue();
        }
    }

    private Node newBranchInstrumentationNode(NodeTraversal traversal, Node node, int idx) {
        String arrayName = BranchCoverageInstrumentationCallback.createArrayName(traversal);
        Node getElemNode = IR.getelem(IR.name(arrayName), IR.number(idx));
        Node exprNode = IR.exprResult(IR.assign(getElemNode, IR.trueNode()));
        String fileName = traversal.getSourceName();
        this.instrumentationData.computeIfAbsent(fileName, k -> new FileInstrumentationData((String)k, arrayName));
        return exprNode.srcrefTreeIfMissing(node);
    }

    private void processBranchInfo(Node branchNode, FileInstrumentationData data, List<Node> blocks) {
        int lineNumber = branchNode.getLineno();
        data.setBranchPresent(lineNumber);
        int numBranches = 0;
        for (Node child : blocks) {
            data.putBranchNode(lineNumber, numBranches + 1, child);
            ++numBranches;
        }
        data.addBranches(lineNumber, numBranches);
    }

    private Node addDefaultBlock(Node node) {
        Node defaultBlock = IR.block();
        node.addChildToBack(defaultBlock);
        return defaultBlock.srcrefTreeIfMissing(node);
    }

    private Node newHeaderNode(NodeTraversal traversal, Node srcref) {
        String fileName = traversal.getSourceName();
        FileInstrumentationData data = this.instrumentationData.get(fileName);
        Preconditions.checkNotNull(data);
        String objName = "__jscov";
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(this.newArrayDeclarationNode(traversal));
        nodes.add(IR.exprResult(IR.call(IR.getprop(IR.getelem(IR.name(objName), IR.string("branchesTaken")), "push"), IR.name(BranchCoverageInstrumentationCallback.createArrayName(traversal)))));
        nodes.add(IR.exprResult(IR.call(IR.getprop(IR.getelem(IR.name(objName), IR.string("branchPresent")), "push"), IR.string(data.getBranchPresentAsHexString()))));
        nodes.add(this.newBranchesInLineNode("JSCompiler_lcov_branchesInLine", data));
        nodes.add(IR.exprResult(IR.call(IR.getprop(IR.getelem(IR.name(objName), IR.string("branchesInLine")), "push"), IR.name("JSCompiler_lcov_branchesInLine"))));
        nodes.add(IR.exprResult(IR.call(IR.getprop(IR.getelem(IR.name(objName), IR.string("fileNames")), "push"), IR.string(fileName))));
        return IR.block(nodes).srcrefTreeIfMissing(srcref);
    }

    private Node newArrayDeclarationNode(NodeTraversal traversal) {
        return IR.var(IR.name(BranchCoverageInstrumentationCallback.createArrayName(traversal)), IR.arraylit(new Node[0]));
    }

    private Node newBranchesInLineNode(String name, FileInstrumentationData data) {
        ArrayList<Node> assignments = new ArrayList<Node>();
        assignments.add(IR.var(IR.name(name), IR.arraylit(new Node[0])));
        int lineWithBranch = 0;
        for (int lineIdx = 1; lineIdx <= data.maxBranchPresentLine(); ++lineIdx) {
            Integer numBranches = data.getNumBranches(lineIdx);
            if (numBranches == null || numBranches <= 0) continue;
            Node assignment = IR.exprResult(IR.assign(IR.getelem(IR.name(name), IR.number(lineWithBranch++)), IR.number(numBranches.intValue())));
            assignments.add(assignment.srcrefTreeIfMissing(assignment));
        }
        return IR.block(assignments);
    }
}

