/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.instrumentation;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.instrumentation.BranchCoverageInstrumentationCallback;
import com.google.javascript.jscomp.instrumentation.CoverageInstrumentationCallback;
import com.google.javascript.jscomp.instrumentation.FileInstrumentationData;
import com.google.javascript.jscomp.instrumentation.ProductionCoverageInstrumentationCallback;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.Map;

@GwtIncompatible(value="FileInstrumentationData")
public class CoverageInstrumentationPass
implements CompilerPass {
    final AbstractCompiler compiler;
    private final Map<String, FileInstrumentationData> instrumentationData;
    private final CoverageReach reach;
    private final CompilerOptions.InstrumentOption instrumentOption;
    private final String productionInstrumentationArrayName;
    public static final String JS_INSTRUMENTATION_OBJECT_NAME = "__jscov";

    public CoverageInstrumentationPass(AbstractCompiler compiler, CoverageReach reach, CompilerOptions.InstrumentOption instrumentOption, String productionInstrumentationArrayName) {
        this.compiler = compiler;
        this.reach = reach;
        this.instrumentOption = instrumentOption;
        this.productionInstrumentationArrayName = productionInstrumentationArrayName;
        this.instrumentationData = new LinkedHashMap<String, FileInstrumentationData>();
    }

    @Deprecated
    public CoverageInstrumentationPass(AbstractCompiler compiler, CoverageReach reach) {
        this(compiler, reach, CompilerOptions.InstrumentOption.LINE_ONLY, "");
    }

    private void addHeaderCode(Node script) {
        script.addChildToFront(this.createConditionalObjectDecl(JS_INSTRUMENTATION_OBJECT_NAME, script));
        script.addChildToFront(this.compiler.parseSyntheticCode("coverage_instrumentation_header", "if (!self.window) { self.window = self; self.window.top = self; }").removeFirstChild().srcrefTreeIfMissing(script));
    }

    private void addProductionHeaderCode(Node script, String arrayName) {
        Node arrayLit = IR.arraylit(new Node[0]);
        Node name = IR.name(arrayName);
        Node varNode = IR.var(name, arrayLit);
        script.addChildToFront(varNode.srcrefTreeIfMissing(script));
    }

    private void checkIfArrayNameExternDeclared(Node externsNode, String arrayName) {
        if (!NodeUtil.collectExternVariableNames(this.compiler, externsNode).contains(arrayName)) {
            throw new AssertionError((Object)"The array name passed to --production_instrumentation_array_name was not declared as an extern. This will result in undefined behaviour");
        }
    }

    @Override
    public void process(Node externsNode, Node rootNode) {
        if (rootNode.hasChildren()) {
            if (this.instrumentOption == CompilerOptions.InstrumentOption.BRANCH_ONLY) {
                NodeTraversal.traverse(this.compiler, rootNode, new BranchCoverageInstrumentationCallback(this.compiler, this.instrumentationData));
            } else if (this.instrumentOption == CompilerOptions.InstrumentOption.PRODUCTION) {
                ProductionCoverageInstrumentationCallback productionCoverageInstrumentationCallback = new ProductionCoverageInstrumentationCallback(this.compiler, this.productionInstrumentationArrayName);
                NodeTraversal.traverse(this.compiler, rootNode, productionCoverageInstrumentationCallback);
                this.checkIfArrayNameExternDeclared(externsNode, this.productionInstrumentationArrayName);
                VariableMap instrumentationMapping = productionCoverageInstrumentationCallback.getInstrumentationMapping();
                this.compiler.setInstrumentationMapping(instrumentationMapping);
            } else {
                NodeTraversal.traverse(this.compiler, rootNode, new CoverageInstrumentationCallback(this.instrumentationData, this.reach));
            }
            Node firstScript = rootNode.getFirstChild();
            Preconditions.checkState(firstScript.isScript());
            if (firstScript.hasChildren() && firstScript.getFirstChild().isModuleBody()) {
                firstScript = firstScript.getFirstChild();
            }
            if (this.instrumentOption == CompilerOptions.InstrumentOption.PRODUCTION) {
                this.addProductionHeaderCode(firstScript, this.productionInstrumentationArrayName);
            } else {
                this.addHeaderCode(firstScript);
            }
        }
    }

    private Node createConditionalObjectDecl(String name, Node srcref) {
        Node jscovData;
        switch (this.instrumentOption) {
            case BRANCH_ONLY: {
                jscovData = IR.objectlit(IR.quotedStringKey("fileNames", IR.arraylit(new Node[0])), IR.quotedStringKey("branchPresent", IR.arraylit(new Node[0])), IR.quotedStringKey("branchesInLine", IR.arraylit(new Node[0])), IR.quotedStringKey("branchesTaken", IR.arraylit(new Node[0])));
                break;
            }
            case LINE_ONLY: {
                jscovData = IR.objectlit(IR.quotedStringKey("fileNames", IR.arraylit(new Node[0])), IR.quotedStringKey("instrumentedLines", IR.arraylit(new Node[0])), IR.quotedStringKey("executedLines", IR.arraylit(new Node[0])));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected option: " + (Object)((Object)this.instrumentOption)));
            }
        }
        Node var = IR.var(IR.name(name), IR.or(IR.getelem(IR.getprop(IR.name("window"), "top"), IR.string(JS_INSTRUMENTATION_OBJECT_NAME)), IR.assign(IR.getelem(IR.getprop(IR.name("window"), "top"), IR.string(JS_INSTRUMENTATION_OBJECT_NAME)), jscovData)));
        return var.srcrefTreeIfMissing(srcref);
    }

    public static enum CoverageReach {
        ALL,
        CONDITIONAL;

    }
}

