/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.jarjar.com.google.common.collect;

import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtCompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Ordering;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ParametricNullness;
import com.google.javascript.jscomp.jarjar.javax.annotation.CheckForNull;
import java.io.Serializable;
import java.util.Comparator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class ComparatorOrdering<T>
extends Ordering<T>
implements Serializable {
    final Comparator<T> comparator;
    private static final long serialVersionUID = 0L;

    ComparatorOrdering(Comparator<T> comparator) {
        this.comparator = Preconditions.checkNotNull(comparator);
    }

    @Override
    public int compare(@ParametricNullness T a, @ParametricNullness T b) {
        return this.comparator.compare(a, b);
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ComparatorOrdering) {
            ComparatorOrdering that = (ComparatorOrdering)object;
            return this.comparator.equals(that.comparator);
        }
        return false;
    }

    public int hashCode() {
        return this.comparator.hashCode();
    }

    public String toString() {
        return this.comparator.toString();
    }
}

