/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.spi;

import com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.CmdLineException;
import com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.CmdLineParser;
import com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.OptionDef;
import com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.spi.Getter;
import com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.spi.OneArgumentOptionHandler;
import com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.spi.OptionHandler;
import com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.spi.Parameters;
import com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.spi.Setter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelimitedOptionHandler<T>
extends OptionHandler<T> {
    protected final String delimiter;
    protected final OneArgumentOptionHandler<? extends T> individualOptionHandler;

    public DelimitedOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super T> setter, String delimiter, OneArgumentOptionHandler<? extends T> individualOptionHandler) {
        super(parser, option, setter);
        this.delimiter = delimiter;
        this.individualOptionHandler = individualOptionHandler;
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        String[] delimitedStrs;
        String full = params.getParameter(0);
        for (String delimitedStr : delimitedStrs = full.split(this.delimiter)) {
            this.setter.addValue(this.individualOptionHandler.parse(delimitedStr));
        }
        return 1;
    }

    @Override
    public String getDefaultMetaVariable() {
        String tMetaVar = this.individualOptionHandler.getDefaultMetaVariable();
        if (tMetaVar == null || tMetaVar.trim().isEmpty()) {
            return tMetaVar;
        }
        return "<" + tMetaVar + this.delimiter + tMetaVar + this.delimiter + "...>";
    }

    @Override
    public String printDefaultValue() {
        if (this.setter instanceof Getter) {
            Getter getter = (Getter)((Object)this.setter);
            List defaultValues = getter.getValueList();
            StringBuilder buf = new StringBuilder();
            for (Object v : defaultValues) {
                if (buf.length() > 0) {
                    buf.append(this.delimiter);
                }
                buf.append(this.print(v));
            }
            return buf.toString();
        }
        return null;
    }
}

